/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.win32.access.impl;

import com.aelitis.azureus.util.MapUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.PlatformManagerPingCallback;
import org.gudy.azureus2.platform.win32.access.AEWin32Access;
import org.gudy.azureus2.platform.win32.access.AEWin32AccessException;
import org.gudy.azureus2.platform.win32.access.AEWin32AccessListener;
import org.gudy.azureus2.platform.win32.access.impl.AEWin32AccessCallback;
import org.gudy.azureus2.platform.win32.access.impl.AEWin32AccessInterface;

public class AEWin32AccessImpl
implements AEWin32Access,
AEWin32AccessCallback {
    protected static AEWin32AccessImpl singleton;
    private boolean fully_initialise;
    private int trace_id_next = new Random().nextInt();
    private List listeners = new ArrayList();

    public static synchronized AEWin32Access getSingleton(boolean fully_initialise) {
        if (singleton == null) {
            singleton = new AEWin32AccessImpl(fully_initialise);
        }
        return singleton;
    }

    protected AEWin32AccessImpl(boolean _fully_initialise) {
        this.fully_initialise = _fully_initialise;
        if (this.isEnabled()) {
            AEWin32AccessInterface.load(this, this.fully_initialise);
        }
    }

    @Override
    public boolean isEnabled() {
        return AEWin32AccessInterface.isEnabled(this.fully_initialise);
    }

    @Override
    public long windowsMessage(int msg, int param1, long param2) {
        int type = -1;
        if (msg == 22) {
            type = 1;
        } else if (msg == 536) {
            if (param1 == 0) {
                type = 2;
            } else if (param1 == 7) {
                type = 3;
            }
        }
        int result = -1;
        if (type != -1) {
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    int temp = ((AEWin32AccessListener)this.listeners.get(i)).eventOccurred(type);
                    if (temp != result) {
                        if (result != -1) {
                            Debug.out("Incompatible results received: " + result + "/" + temp);
                        }
                        result = temp;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        if (result == 1) {
            if ((param2 & 1L) != 0L) {
                return 1112363332L;
            }
            Debug.out("Ignoring suspend deny request as not permitted");
        }
        return result;
    }

    @Override
    public long generalMessage(String str) {
        return 0L;
    }

    @Override
    public String getVersion() {
        return AEWin32AccessInterface.getVersion();
    }

    @Override
    public String readStringValue(int type, String subkey, String value_name) throws AEWin32AccessException {
        return AEWin32AccessInterface.readStringValue(type, subkey, value_name);
    }

    @Override
    public void writeStringValue(int type, String subkey, String value_name, String value_value) throws AEWin32AccessException {
        AEWin32AccessInterface.writeStringValue(type, subkey, value_name, value_value);
    }

    @Override
    public int readWordValue(int type, String subkey, String value_name) throws AEWin32AccessException {
        return AEWin32AccessInterface.readWordValue(type, subkey, value_name);
    }

    @Override
    public void writeWordValue(int type, String subkey, String value_name, int value_value) throws AEWin32AccessException {
        AEWin32AccessInterface.writeWordValue(type, subkey, value_name, value_value);
    }

    @Override
    public void deleteKey(int type, String subkey) throws AEWin32AccessException {
        this.deleteKey(type, subkey, false);
    }

    @Override
    public void deleteKey(int type, String subkey, boolean recursive) throws AEWin32AccessException {
        AEWin32AccessInterface.deleteKey(type, subkey, recursive);
    }

    @Override
    public void deleteValue(int type, String subkey, String value_name) throws AEWin32AccessException {
        AEWin32AccessInterface.deleteValue(type, subkey, value_name);
    }

    @Override
    public String getUserAppData() throws AEWin32AccessException {
        String app_data_key = "software\\microsoft\\windows\\currentversion\\explorer\\shell folders";
        String app_data_name = "appdata";
        return this.readStringValue(4, app_data_key, app_data_name);
    }

    @Override
    public String getCommonAppData() throws AEWin32AccessException {
        String app_data_key = "software\\microsoft\\windows\\currentversion\\explorer\\shell folders";
        String app_data_name = "Common AppData";
        return this.readStringValue(3, app_data_key, app_data_name);
    }

    @Override
    public String getLocalAppData() throws AEWin32AccessException {
        String app_data_key = "software\\microsoft\\windows\\currentversion\\explorer\\shell folders";
        String app_data_name = "Local AppData";
        return this.readStringValue(4, app_data_key, app_data_name);
    }

    @Override
    public String getUserDocumentsDir() throws AEWin32AccessException {
        String app_data_key = "software\\microsoft\\windows\\currentversion\\explorer\\shell folders";
        String app_data_name = "personal";
        return this.readStringValue(4, app_data_key, app_data_name);
    }

    @Override
    public String getUserMusicDir() throws AEWin32AccessException {
        String app_data_key = "software\\microsoft\\windows\\currentversion\\explorer\\shell folders";
        String app_data_name = "my music";
        try {
            return this.readStringValue(4, app_data_key, app_data_name);
        }
        catch (AEWin32AccessException e) {
            String s = this.getUserDocumentsDir();
            if (s != null) {
                s = String.valueOf(s) + "\\My Music";
            }
            return s;
        }
    }

    @Override
    public String getUserVideoDir() throws AEWin32AccessException {
        String app_data_key = "software\\microsoft\\windows\\currentversion\\explorer\\shell folders";
        String app_data_name = "my video";
        try {
            return this.readStringValue(4, app_data_key, app_data_name);
        }
        catch (AEWin32AccessException e) {
            String s = this.getUserDocumentsDir();
            if (s != null) {
                s = String.valueOf(s) + "\\My Video";
            }
            return s;
        }
    }

    @Override
    public String getProgramFilesDir() throws AEWin32AccessException {
        String app_data_key = "software\\microsoft\\windows\\currentversion";
        String app_data_name = "ProgramFilesDir";
        return this.readStringValue(3, app_data_key, app_data_name);
    }

    @Override
    public String getApplicationInstallDir(String app_name) throws AEWin32AccessException {
        String res = "";
        try {
            res = this.readStringValue(4, "software\\" + app_name, null);
        }
        catch (AEWin32AccessException e) {
            res = this.readStringValue(3, "software\\" + app_name, null);
        }
        return res;
    }

    @Override
    public void createProcess(String command_line, boolean inherit_handles) throws AEWin32AccessException {
        AEWin32AccessInterface.createProcess(command_line, inherit_handles);
    }

    @Override
    public void moveToRecycleBin(String file_name) throws AEWin32AccessException {
        AEWin32AccessInterface.moveToRecycleBin(file_name);
    }

    @Override
    public void copyFilePermissions(String from_file_name, String to_file_name) throws AEWin32AccessException {
        AEWin32AccessInterface.copyPermission(from_file_name, to_file_name);
    }

    @Override
    public boolean testNativeAvailability(String name) throws AEWin32AccessException {
        return AEWin32AccessInterface.testNativeAvailability(name);
    }

    @Override
    public int shellExecute(String operation, String file, String parameters, String directory, int SW_const) throws AEWin32AccessException {
        return AEWin32AccessInterface.shellExecute(operation, file, parameters, directory, SW_const);
    }

    @Override
    public int shellExecuteAndWait(String file, String params) throws AEWin32AccessException {
        return AEWin32AccessInterface.shellExecuteAndWait(file, params);
    }

    @Override
    public void traceRoute(InetAddress source_address, InetAddress target_address, PlatformManagerPingCallback callback) throws AEWin32AccessException {
        this.traceRoute(source_address, target_address, false, callback);
    }

    @Override
    public void ping(InetAddress source_address, InetAddress target_address, PlatformManagerPingCallback callback) throws AEWin32AccessException {
        if (Constants.compareVersions(this.getVersion(), "1.15") < 0) {
            throw new AEWin32AccessException("Sorry, ping is broken in versions < 1.15");
        }
        this.traceRoute(source_address, target_address, true, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void traceRoute(InetAddress source_address, InetAddress target_address, boolean ping_mode, PlatformManagerPingCallback callback) throws AEWin32AccessException {
        int trace_id;
        AEWin32AccessImpl aEWin32AccessImpl = this;
        synchronized (aEWin32AccessImpl) {
            trace_id = this.trace_id_next++;
        }
        traceRouteCallback cb = new traceRouteCallback(ping_mode, callback);
        AEWin32AccessInterface.traceRoute(trace_id, this.addressToInt(source_address), this.addressToInt(target_address), ping_mode ? 1 : 0, cb);
    }

    private int addressToInt(InetAddress address) {
        byte[] bytes = address.getAddress();
        int resp = bytes[0] << 24 & 0xFF000000 | bytes[1] << 16 & 0xFF0000 | bytes[2] << 8 & 0xFF00 | bytes[3] & 0xFF;
        return resp;
    }

    private InetAddress intToAddress(int address) {
        byte[] bytes = new byte[]{(byte)(address >> 24), (byte)(address >> 16), (byte)(address >> 8), (byte)address};
        try {
            InetAddress res = InetAddress.getByAddress(bytes);
            return res;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public void addListener(AEWin32AccessListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(AEWin32AccessListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<File, Map> getAllDrives() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isUSBDrive(Map driveInfo) {
        if (driveInfo == null) {
            return false;
        }
        boolean removeable = MapUtils.getMapBoolean(driveInfo, "Removable", false);
        long driveType = MapUtils.getMapLong(driveInfo, "DriveType", 0L);
        long busType = MapUtils.getMapLong(driveInfo, "BusType", 0L);
        long mediaType = MapUtils.getMapLong(driveInfo, "MediaType", -1L);
        return removeable && driveType == 2L && busType == 7L && (mediaType == 11L || mediaType == -1L);
    }

    @Override
    public void setThreadExecutionState(int state) {
        AEWin32AccessInterface.setThreadExecutionState(state);
    }

    protected class traceRouteCallback
    implements AEWin32AccessCallback {
        private boolean ping_mode;
        private PlatformManagerPingCallback cb;

        protected traceRouteCallback(boolean _ping_mode, PlatformManagerPingCallback _cb) {
            this.ping_mode = _ping_mode;
            this.cb = _cb;
        }

        @Override
        public long windowsMessage(int msg, int param1, long param2) {
            return 0L;
        }

        @Override
        public long generalMessage(String msg) {
            InetAddress address;
            StringTokenizer tok = new StringTokenizer(msg, ",");
            int ttl = Integer.parseInt(tok.nextToken().trim());
            int time = -1;
            if (tok.hasMoreTokens()) {
                int i_addr = Integer.parseInt(tok.nextToken().trim());
                address = AEWin32AccessImpl.this.intToAddress(i_addr);
                time = Integer.parseInt(tok.nextToken().trim());
            } else {
                address = null;
            }
            return this.cb.reportNode(this.ping_mode ? -1 : ttl, address, time) ? 1 : 0;
        }
    }
}

