/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.win32;

import com.aelitis.azureus.core.AzureusCore;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerListener;
import org.gudy.azureus2.platform.PlatformManagerPingCallback;
import org.gudy.azureus2.platform.win32.access.AEWin32Access;
import org.gudy.azureus2.platform.win32.access.AEWin32AccessListener;
import org.gudy.azureus2.platform.win32.access.AEWin32Manager;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateInstallerListener;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.plugins.utils.StaticUtilities;

public class PlatformManagerImpl
implements PlatformManager,
AEWin32AccessListener,
AEDiagnosticsEvidenceGenerator {
    public static final int RT_NONE = 0;
    public static final int RT_AZ = 1;
    public static final int RT_OTHER = 2;
    public static String DLL_NAME = "aereg";
    public static final String VUZE_ASSOC = "Vuze";
    public static final String NEW_MAIN_ASSOC = "Azureus";
    public static final String OLD_MAIN_ASS0C = "BitTorrent";
    private static boolean initialising;
    private static boolean init_tried;
    private static PlatformManagerImpl singleton;
    private static AEMonitor class_mon;
    private final Set capabilitySet = new HashSet();
    private List listeners = new ArrayList();
    private final AEWin32Access access = AEWin32Manager.getAccessor(true);
    private final String app_name;
    private final String app_exe_name;
    private File az_exe;
    private boolean az_exe_checked;
    private boolean prevent_computer_sleep;
    private AEThread2 prevent_sleep_thread;

    static {
        class_mon = new AEMonitor("PlatformManager");
        if (System.getProperty("aereg", null) != null) {
            DLL_NAME = System.getProperty("aereg");
        } else if (System.getProperty("os.arch", "").contains("64")) {
            DLL_NAME = String.valueOf(DLL_NAME) + "64";
        }
    }

    public static PlatformManagerImpl getSingleton() throws PlatformManagerException {
        try {
            block13: {
                class_mon.enter();
                if (singleton != null) {
                    PlatformManagerImpl platformManagerImpl = singleton;
                    return platformManagerImpl;
                }
                try {
                    if (initialising) {
                        System.err.println("PlatformManager: recursive entry during initialisation");
                    }
                    initialising = true;
                    if (init_tried) break block13;
                    init_tried = true;
                    try {
                        singleton = new PlatformManagerImpl();
                        singleton.applyPatches();
                    }
                    catch (PlatformManagerException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        if (e instanceof PlatformManagerException) {
                            throw (PlatformManagerException)e;
                        }
                        throw new PlatformManagerException("Win32Platform: failed to initialise", e);
                    }
                }
                finally {
                    initialising = false;
                }
            }
            PlatformManagerImpl platformManagerImpl = singleton;
            return platformManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected PlatformManagerImpl() throws PlatformManagerException {
        int pos;
        this.access.addListener(this);
        this.app_name = SystemProperties.getApplicationName();
        String mod_name = System.getProperty("exe4j.moduleName", null);
        String exe_name = null;
        if (mod_name != null && new File(mod_name).exists() && mod_name.toLowerCase().endsWith(".exe") && (pos = mod_name.lastIndexOf(File.separator)) != -1) {
            exe_name = mod_name.substring(pos + 1);
        }
        if (exe_name == null) {
            exe_name = String.valueOf(this.app_name) + ".exe";
        }
        this.app_exe_name = exe_name;
        this.initializeCapabilities();
    }

    private void initializeCapabilities() {
        if (this.access.isEnabled()) {
            this.capabilitySet.add(PlatformManagerCapabilities.CreateCommandLineProcess);
            this.capabilitySet.add(PlatformManagerCapabilities.GetUserDataDirectory);
            this.capabilitySet.add(PlatformManagerCapabilities.RecoverableFileDelete);
            this.capabilitySet.add(PlatformManagerCapabilities.RegisterFileAssociations);
            this.capabilitySet.add(PlatformManagerCapabilities.ShowFileInBrowser);
            this.capabilitySet.add(PlatformManagerCapabilities.GetVersion);
            this.capabilitySet.add(PlatformManagerCapabilities.SetTCPTOSEnabled);
            this.capabilitySet.add(PlatformManagerCapabilities.ComputerIDAvailability);
            String plugin_version = this.access.getVersion();
            if (Constants.compareVersions(plugin_version, "1.11") >= 0 && !Constants.isWindows9598ME) {
                this.capabilitySet.add(PlatformManagerCapabilities.CopyFilePermissions);
            }
            if (Constants.compareVersions(plugin_version, "1.12") >= 0) {
                this.capabilitySet.add(PlatformManagerCapabilities.TestNativeAvailability);
            }
            if (Constants.compareVersions(plugin_version, "1.14") >= 0) {
                this.capabilitySet.add(PlatformManagerCapabilities.TraceRouteAvailability);
            }
            if (Constants.compareVersions(plugin_version, "1.15") >= 0) {
                this.capabilitySet.add(PlatformManagerCapabilities.PingAvailability);
            }
            try {
                this.getUserDataDirectory();
                if (Constants.compareVersions(plugin_version, "1.19") >= 0) {
                    this.capabilitySet.add(PlatformManagerCapabilities.AccessExplicitVMOptions);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.capabilitySet.add(PlatformManagerCapabilities.RunAtLogin);
            this.capabilitySet.add(PlatformManagerCapabilities.PreventComputerSleep);
        } else {
            this.capabilitySet.add(PlatformManagerCapabilities.GetVersion);
        }
    }

    protected void applyPatches() {
        try {
            File exe_loc = this.getApplicationEXELocation();
            String az_exe_string = exe_loc.getAbsolutePath();
            String current = this.access.readStringValue(1, "Azureus\\DefaultIcon", "");
            String target = String.valueOf(az_exe_string) + "," + this.getIconIndex();
            if (current.indexOf(this.app_exe_name) != -1 && !current.equals(target)) {
                this.writeStringToHKCRandHKCU("Azureus\\DefaultIcon", "", target);
            }
        }
        catch (Throwable exe_loc) {
            // empty catch block
        }
        if (this.hasCapability(PlatformManagerCapabilities.CopyFilePermissions) && !COConfigurationManager.getBooleanParameter("platform.win32.permfixdone2", false)) {
            try {
                try {
                    String str = SystemProperties.getApplicationPath();
                    if (str.endsWith(File.separator)) {
                        str = str.substring(0, str.length() - 1);
                    }
                    this.fixPermissions(new File(str), new File(str));
                }
                catch (Throwable throwable) {
                    COConfigurationManager.setParameter("platform.win32.permfixdone2", true);
                }
            }
            finally {
                COConfigurationManager.setParameter("platform.win32.permfixdone2", true);
            }
        }
    }

    protected void fixPermissions(File parent, File dir) throws PlatformManagerException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isFile()) {
                this.copyFilePermissions(parent.getAbsolutePath(), file.getAbsolutePath());
            }
            ++i;
        }
    }

    protected int getIconIndex() throws PlatformManagerException {
        return 0;
    }

    @Override
    public String getVersion() {
        return this.access.getVersion();
    }

    protected File getApplicationEXELocation() throws PlatformManagerException {
        if (this.az_exe == null) {
            try {
                String az_home = SystemProperties.getApplicationPath();
                this.az_exe = new File(String.valueOf(az_home) + File.separator + this.app_exe_name).getAbsoluteFile();
                if (!this.az_exe.exists()) {
                    try {
                        az_home = this.access.getApplicationInstallDir(this.app_name);
                        this.az_exe = new File(String.valueOf(az_home) + File.separator + this.app_exe_name).getAbsoluteFile();
                        if (!this.az_exe.exists()) {
                            throw new PlatformManagerException(String.valueOf(this.app_exe_name) + " not found in " + az_home + ", please re-install");
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (!this.az_exe.exists()) {
                    String msg = String.valueOf(this.app_exe_name) + " not found in " + az_home + " - can't check file associations. Please re-install " + this.app_name;
                    this.az_exe = null;
                    if (!this.az_exe_checked) {
                        Logger.log(new LogAlert(false, 1, msg));
                    }
                    throw new PlatformManagerException(msg);
                }
            }
            finally {
                this.az_exe_checked = true;
            }
        }
        return this.az_exe;
    }

    @Override
    public int getPlatformType() {
        return 1;
    }

    @Override
    public String getUserDataDirectory() throws PlatformManagerException {
        try {
            return String.valueOf(this.access.getUserAppData()) + SystemProperties.SEP + this.app_name + SystemProperties.SEP;
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to read registry details", e);
        }
    }

    @Override
    public String getComputerName() {
        String host = System.getenv("COMPUTERNAME");
        if (host != null && host.length() > 0) {
            return host;
        }
        return null;
    }

    @Override
    public File getLocation(long location_id) throws PlatformManagerException {
        if (location_id == 1L) {
            return new File(this.getUserDataDirectory());
        }
        if (location_id == 2L) {
            try {
                return new File(this.access.getUserMusicDir());
            }
            catch (Throwable e) {
                throw new PlatformManagerException("Failed to read registry details", e);
            }
        }
        if (location_id == 3L) {
            try {
                return new File(this.access.getUserDocumentsDir());
            }
            catch (Throwable e) {
                throw new PlatformManagerException("Failed to read registry details", e);
            }
        }
        if (location_id == 4L) {
            try {
                return new File(this.access.getUserVideoDir());
            }
            catch (Throwable e) {
                throw new PlatformManagerException("Failed to read registry details", e);
            }
        }
        return null;
    }

    private String getJVMOptionRedirect() {
        return "-include-options ${APPDATA}\\" + SystemProperties.getApplicationName() + "\\java.vmoptions";
    }

    private File[] getJVMOptionFiles() {
        try {
            File exe = this.getApplicationEXELocation();
            File shared_options = new File(exe.getParent(), String.valueOf(exe.getName()) + ".vmoptions");
            File local_options = new File(SystemProperties.getUserPath(), "java.vmoptions");
            return new File[]{shared_options, local_options};
        }
        catch (Throwable e) {
            return new File[0];
        }
    }

    private File checkAndGetLocalVMOptionFile() throws PlatformManagerException {
        String vendor = System.getProperty("java.vendor", "<unknown>");
        if (!vendor.toLowerCase().startsWith("sun ") && !vendor.toLowerCase().startsWith("oracle ")) {
            throw new PlatformManagerException(MessageText.getString("platform.jvmopt.sunonly", new String[]{vendor}));
        }
        File[] option_files = this.getJVMOptionFiles();
        if (option_files.length != 2) {
            throw new PlatformManagerException(MessageText.getString("platform.jvmopt.configerror"));
        }
        File shared_options = option_files[0];
        if (shared_options.exists()) {
            try {
                String s_options = FileUtil.readFileAsString(shared_options, -1);
                if (s_options.contains(this.getJVMOptionRedirect())) {
                    File local_options = option_files[1];
                    return local_options;
                }
                throw new PlatformManagerException(MessageText.getString("platform.jvmopt.nolink"));
            }
            catch (Throwable e) {
                throw new PlatformManagerException(MessageText.getString("platform.jvmopt.accesserror", new String[]{Debug.getNestedExceptionMessage(e)}));
            }
        }
        throw new PlatformManagerException(MessageText.getString("platform.jvmopt.nolinkfile"));
    }

    @Override
    public File getVMOptionFile() throws PlatformManagerException {
        this.checkCapability(PlatformManagerCapabilities.AccessExplicitVMOptions);
        File local_options = this.checkAndGetLocalVMOptionFile();
        if (!local_options.exists()) {
            try {
                local_options.createNewFile();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return local_options;
    }

    @Override
    public String[] getExplicitVMOptions() throws PlatformManagerException {
        this.checkCapability(PlatformManagerCapabilities.AccessExplicitVMOptions);
        File local_options = this.checkAndGetLocalVMOptionFile();
        try {
            ArrayList<String> list = new ArrayList<String>();
            if (local_options.exists()) {
                LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(local_options), "UTF-8"));
                try {
                    String line;
                    while ((line = lnr.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0) continue;
                        list.add(line);
                    }
                }
                finally {
                    lnr.close();
                }
            }
            return list.toArray(new String[list.size()]);
        }
        catch (Throwable e) {
            throw new PlatformManagerException(MessageText.getString("platform.jvmopt.accesserror", new String[]{Debug.getNestedExceptionMessage(e)}));
        }
    }

    @Override
    public void setExplicitVMOptions(String[] options) throws PlatformManagerException {
        block12: {
            this.checkCapability(PlatformManagerCapabilities.AccessExplicitVMOptions);
            File local_options = this.checkAndGetLocalVMOptionFile();
            try {
                if (!local_options.exists()) break block12;
                File backup = new File(local_options.getParentFile(), String.valueOf(local_options.getName()) + ".bak");
                if (backup.exists()) {
                    backup.delete();
                }
                if (!local_options.renameTo(backup)) {
                    throw new Exception("Failed to move " + local_options + " to " + backup);
                }
                boolean ok = false;
                try {
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(local_options), "UTF-8"));
                    try {
                        String[] stringArray = options;
                        int n = options.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String option = stringArray[n2];
                            pw.println(option);
                            ++n2;
                        }
                        ok = true;
                    }
                    finally {
                        pw.close();
                    }
                }
                finally {
                    if (!ok) {
                        local_options.delete();
                        backup.renameTo(local_options);
                    }
                }
            }
            catch (Throwable e) {
                throw new PlatformManagerException(MessageText.getString("platform.jvmopt.accesserror", new String[]{Debug.getNestedExceptionMessage(e)}));
            }
        }
    }

    @Override
    public boolean getRunAtLogin() throws PlatformManagerException {
        File exe = this.getApplicationEXELocation();
        if (exe != null && exe.exists()) {
            try {
                String value = this.access.readStringValue(4, "Software\\Microsoft\\Windows\\CurrentVersion\\Run", this.app_name);
                return value.equals(exe.getAbsolutePath());
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void setRunAtLogin(boolean run) throws PlatformManagerException {
        File exe = this.getApplicationEXELocation();
        if (exe != null && exe.exists()) {
            try {
                String key = "Software\\Microsoft\\Windows\\CurrentVersion\\Run";
                if (run) {
                    this.access.writeStringValue(4, key, this.app_name, exe.getAbsolutePath());
                } else {
                    this.access.deleteValue(4, key, this.app_name);
                }
            }
            catch (Throwable e) {
                throw new PlatformManagerException("Failed to write 'run at login' key", e);
            }
        }
    }

    @Override
    public int getShutdownTypes() {
        int result = 5;
        if (this.canHibernate()) {
            result |= 2;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getPreventComputerSleep() {
        PlatformManagerImpl platformManagerImpl = this;
        synchronized (platformManagerImpl) {
            return this.prevent_computer_sleep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPreventComputerSleep(boolean prevent_it) {
        PlatformManagerImpl platformManagerImpl = this;
        synchronized (platformManagerImpl) {
            if (this.prevent_computer_sleep == prevent_it) {
                return;
            }
            this.prevent_computer_sleep = prevent_it;
            if (prevent_it && this.prevent_sleep_thread == null) {
                this.prevent_sleep_thread = new AEThread2("SleepPreventer"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            PlatformManagerImpl platformManagerImpl = PlatformManagerImpl.this;
                            synchronized (platformManagerImpl) {
                                if (!PlatformManagerImpl.this.prevent_computer_sleep) {
                                    if (PlatformManagerImpl.this.prevent_sleep_thread == this) {
                                        PlatformManagerImpl.this.prevent_sleep_thread = null;
                                    }
                                    break;
                                }
                            }
                            try {
                                PlatformManagerImpl.this.access.setThreadExecutionState(1);
                                Thread.sleep(30000L);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                                break;
                            }
                        }
                    }
                };
                this.prevent_sleep_thread.start();
            }
        }
    }

    private boolean canHibernate() {
        try {
            String line;
            if (Constants.isWindows7OrHigher) {
                int enabled = this.access.readWordValue(3, "System\\CurrentControlSet\\Control\\Power", "HibernateEnabled");
                return enabled != 0;
            }
            Process p = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", "reg query \"HKLM\\System\\CurrentControlSet\\Control\\Session Manager\\Power\" /v Heuristics"});
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(p.getInputStream()));
            do {
                if ((line = lnr.readLine()) != null) continue;
            } while (!(line = line.trim()).startsWith("Heuristics"));
            String[] bits = line.split("[\\s]+");
            byte[] value = ByteFormatter.decodeString(bits[2].trim());
            return (value[6] & 1) != 0;
        }
        finally {
            return false;
        }
    }

    @Override
    public void startup(final AzureusCore azureus_core) throws PlatformManagerException {
        AEDiagnostics.addEvidenceGenerator(this);
        if (!this.hasCapability(PlatformManagerCapabilities.AccessExplicitVMOptions)) {
            return;
        }
        if (COConfigurationManager.getBooleanParameter("platform.win32.vmo.migrated", false)) {
            try {
                File last_good;
                File local_options = this.checkAndGetLocalVMOptionFile();
                if (local_options.exists() && (!(last_good = new File(local_options.getParentFile(), String.valueOf(local_options.getName()) + ".lastgood")).exists() || local_options.lastModified() > last_good.lastModified())) {
                    FileUtil.copyFile(local_options, last_good);
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        } else {
            final int fail_count = COConfigurationManager.getIntParameter("platform.win32.vmo.migrated.fails", 0);
            if (fail_count >= 3) {
                Debug.out("Not attempting vmoption migration due to previous failures, please perform a full install to fix this");
                return;
            }
            PluginInterface pi = azureus_core.getPluginManager().getPluginInterfaceByID("azupdater");
            if (pi != null && Constants.compareVersions(pi.getPluginVersion(), "1.8.15") >= 0) {
                new AEThread2("win32.vmo", true){

                    @Override
                    public void run() {
                        try {
                            String redirect = PlatformManagerImpl.this.getJVMOptionRedirect();
                            File[] option_files = PlatformManagerImpl.this.getJVMOptionFiles();
                            if (option_files.length != 2) {
                                return;
                            }
                            File shared_options = option_files[0];
                            File old_shared_options = new File(shared_options.getParentFile(), String.valueOf(shared_options.getName()) + ".old");
                            File local_options = option_files[1];
                            if (shared_options.exists()) {
                                String options = FileUtil.readFileAsString(shared_options, -1);
                                if (!options.contains(redirect)) {
                                    if (!options.contains("-include-options")) {
                                        if (FileUtil.canReallyWriteToAppDirectory()) {
                                            if (old_shared_options.exists()) {
                                                old_shared_options.delete();
                                            }
                                            if (shared_options.renameTo(old_shared_options)) {
                                                if (!local_options.exists() && !FileUtil.copyFile(old_shared_options, local_options)) {
                                                    Debug.out("Failed to copy " + old_shared_options + " to " + local_options);
                                                }
                                                if (!FileUtil.writeStringAsFile(shared_options, String.valueOf(redirect) + "\r\n")) {
                                                    Debug.out("Failed to write to " + shared_options);
                                                }
                                            } else {
                                                Debug.out("Rename of " + shared_options + " to " + old_shared_options + " failed");
                                            }
                                        } else {
                                            UpdateInstaller installer = PlatformManagerImpl.this.getInstaller(azureus_core);
                                            if (installer == null) {
                                                return;
                                            }
                                            if (!PlatformManagerImpl.this.informUpdateRequired()) {
                                                return;
                                            }
                                            if (old_shared_options.exists()) {
                                                installer.addRemoveAction(old_shared_options.getAbsolutePath());
                                            }
                                            installer.addMoveAction(shared_options.getAbsolutePath(), old_shared_options.getAbsolutePath());
                                            if (!local_options.exists()) {
                                                installer.addResource("local_options", new ByteArrayInputStream(options.getBytes("UTF-8")));
                                                installer.addMoveAction("local_options", local_options.getAbsolutePath());
                                            }
                                            installer.addResource("redirect", new ByteArrayInputStream((String.valueOf(redirect) + "\r\n").getBytes("UTF-8")));
                                            installer.addMoveAction("redirect", shared_options.getAbsolutePath());
                                            final AESemaphore sem = new AESemaphore("vmopt");
                                            final UpdateException[] error = new UpdateException[1];
                                            installer.installNow(new UpdateInstallerListener(){

                                                @Override
                                                public void reportProgress(String str) {
                                                }

                                                @Override
                                                public void complete() {
                                                    sem.release();
                                                }

                                                @Override
                                                public void failed(UpdateException e) {
                                                    error[0] = e;
                                                    sem.release();
                                                }
                                            });
                                            sem.reserve();
                                            if (error[0] != null) {
                                                throw error[0];
                                            }
                                        }
                                    }
                                } else if (old_shared_options.exists() && !local_options.exists() && !FileUtil.copyFile(old_shared_options, local_options)) {
                                    Debug.out("Failed to copy " + old_shared_options + " to " + local_options);
                                }
                            } else if (FileUtil.canReallyWriteToAppDirectory()) {
                                if (!FileUtil.writeStringAsFile(shared_options, String.valueOf(redirect) + "\r\n")) {
                                    Debug.out("Failed to write to " + shared_options);
                                }
                            } else {
                                UpdateInstaller installer = PlatformManagerImpl.this.getInstaller(azureus_core);
                                if (installer == null) {
                                    return;
                                }
                                if (!PlatformManagerImpl.this.informUpdateRequired()) {
                                    return;
                                }
                                installer.addResource("redirect", new ByteArrayInputStream((String.valueOf(redirect) + "\r\n").getBytes("UTF-8")));
                                installer.addMoveAction("redirect", shared_options.getAbsolutePath());
                                final AESemaphore sem = new AESemaphore("vmopt");
                                final UpdateException[] error = new UpdateException[1];
                                installer.installNow(new UpdateInstallerListener(){

                                    @Override
                                    public void reportProgress(String str) {
                                    }

                                    @Override
                                    public void complete() {
                                        sem.release();
                                    }

                                    @Override
                                    public void failed(UpdateException e) {
                                        error[0] = e;
                                        sem.release();
                                    }
                                });
                                sem.reserve();
                                if (error[0] != null) {
                                    throw error[0];
                                }
                            }
                            COConfigurationManager.setParameter("platform.win32.vmo.migrated", true);
                        }
                        catch (Throwable e) {
                            COConfigurationManager.setParameter("platform.win32.vmo.migrated.fails", fail_count + 1);
                            Debug.out("vmoption migration failed", e);
                        }
                    }
                }.start();
            }
        }
    }

    private UpdateInstaller getInstaller(AzureusCore azureus_core) throws Exception {
        PluginInterface pi = azureus_core.getPluginManager().getDefaultPluginInterface();
        UpdateManager update_manager = pi.getUpdateManager();
        final ArrayList<UpdateCheckInstance> l_instances = new ArrayList<UpdateCheckInstance>();
        update_manager.addListener(new UpdateManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void checkInstanceCreated(UpdateCheckInstance instance) {
                List list = l_instances;
                synchronized (list) {
                    l_instances.add(instance);
                }
            }
        });
        UpdateCheckInstance[] instances = update_manager.getCheckInstances();
        l_instances.addAll(Arrays.asList(instances));
        long start = SystemTime.getMonotonousTime();
        while (SystemTime.getMonotonousTime() - start < 300000L) {
            try {
                Thread.sleep(5000L);
            }
            catch (Throwable e) {
                Debug.out(e);
                return null;
            }
            if (l_instances.size() <= 0) continue;
            boolean all_done = true;
            for (UpdateCheckInstance instance : l_instances) {
                if (instance.isCompleteOrCancelled()) continue;
                all_done = false;
                break;
            }
            if (!all_done) continue;
        }
        if (update_manager.getInstallers().length > 0) {
            return null;
        }
        UpdateInstaller installer = pi.getUpdateManager().createInstaller();
        return installer;
    }

    private boolean informUpdateRequired() {
        UIManager ui_manager = StaticUtilities.getUIManager(120000L);
        long res = ui_manager.showMessageBox("update.now.title", "update.now.desc", 3L);
        return res == 1L;
    }

    @Override
    public void shutdown(int type) throws PlatformManagerException {
        block8: {
            String windir = System.getenv("windir");
            boolean vista_or_higher = Constants.isWindowsVistaOrHigher;
            try {
                if (type == 4) {
                    Runtime.getRuntime().exec(new String[]{String.valueOf(windir) + "\\system32\\rundll32.exe", "powrprof.dll,SetSuspendState Sleep"});
                    break block8;
                }
                if (type == 2) {
                    if (vista_or_higher) {
                        Runtime.getRuntime().exec(new String[]{"shutdown", "-h"});
                    } else {
                        Runtime.getRuntime().exec(new String[]{String.valueOf(windir) + "system32\\rundll32.exe", "powrprof.dll,SetSuspendState Hibernate"});
                    }
                    break block8;
                }
                if (type == 1) {
                    Runtime.getRuntime().exec(new String[]{"shutdown", "-s"});
                    break block8;
                }
                throw new PlatformManagerException("Unsupported capability called on platform manager");
            }
            catch (PlatformManagerException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new PlatformManagerException("shutdown failed", e);
            }
        }
    }

    @Override
    public String getApplicationCommandLine() {
        try {
            return this.getApplicationEXELocation().toString();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public boolean isApplicationRegistered() throws PlatformManagerException {
        boolean vuze_reg;
        boolean reg;
        File exe_loc = this.getApplicationEXELocation();
        if (exe_loc.exists()) {
            this.checkExeKey(exe_loc);
        }
        String app_path = SystemProperties.getApplicationPath();
        try {
            this.registerMagnet(false);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        try {
            if (this.getAdditionalFileTypeRegistrationDetails("DHT", ".dht") == 0) {
                this.registerDHT();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        try {
            this.registerBC();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        if (this.isAdditionalFileTypeRegistered(OLD_MAIN_ASS0C, ".torrent")) {
            this.unregisterAdditionalFileType(OLD_MAIN_ASS0C, ".torrent");
            this.registerAdditionalFileType(NEW_MAIN_ASSOC, String.valueOf(Constants.APP_NAME) + " Download", ".torrent", "application/x-bittorrent");
        }
        if (!(reg = this.isAdditionalFileTypeRegistered(NEW_MAIN_ASSOC, ".torrent")) && !COConfigurationManager.getBooleanParameter("platform.win32.autoregdone", false)) {
            this.registerAdditionalFileType(NEW_MAIN_ASSOC, String.valueOf(Constants.APP_NAME) + " Download", ".torrent", "application/x-bittorrent");
            COConfigurationManager.setParameter("platform.win32.autoregdone", true);
            reg = true;
        }
        if (!(vuze_reg = this.isAdditionalFileTypeRegistered(VUZE_ASSOC, ".vuze"))) {
            this.registerAdditionalFileType(VUZE_ASSOC, "Vuze File", ".vuze", "application/x-vuze");
        }
        return reg;
    }

    protected void checkExeKey(File exe) {
        this.checkExeKey(4, exe);
        this.checkExeKey(3, exe);
    }

    protected void checkExeKey(int hkey, File exe) {
        String exe_str = exe.getAbsolutePath();
        String path_str = exe.getParent();
        String execReg = null;
        String parentReg = null;
        try {
            execReg = this.access.readStringValue(hkey, "software\\" + this.app_name, "exec");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            parentReg = this.access.readStringValue(hkey, "software\\" + this.app_name, "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (execReg == null || !execReg.equals(exe_str)) {
                this.access.writeStringValue(hkey, "software\\" + this.app_name, "exec", exe_str);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (parentReg == null || !parentReg.equals(path_str)) {
                this.access.writeStringValue(hkey, "software\\" + this.app_name, "", path_str);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean isAdditionalFileTypeRegistered(String name, String type) throws PlatformManagerException {
        return this.getAdditionalFileTypeRegistrationDetails(name, type) == 1;
    }

    /*
     * Loose catch block
     */
    public int getAdditionalFileTypeRegistrationDetails(String name, String type) throws PlatformManagerException {
        block10: {
            String az_exe_str;
            try {
                az_exe_str = this.getApplicationEXELocation().toString();
            }
            catch (Throwable e) {
                return 0;
            }
            String test1 = this.access.readStringValue(1, String.valueOf(name) + "\\shell\\open\\command", "");
            if (!test1.equals("\"" + az_exe_str + "\" \"%1\"")) {
                return test1.length() == 0 ? 0 : 2;
            }
            String test2 = this.access.readStringValue(1, type, "");
            if (test2.equals(NEW_MAIN_ASSOC)) break block10;
            return test2.length() == 0 ? 0 : 2;
            {
                catch (Throwable e) {
                    if (e.getMessage() == null || e.getMessage().indexOf("RegOpenKey failed") == -1) {
                        Debug.printStackTrace(e);
                    }
                    return 0;
                }
            }
        }
        try {
            String always_open_with = this.access.readStringValue(4, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + type, "Application");
            if (always_open_with.length() > 0) {
                return 2;
            }
        }
        catch (Throwable throwable) {}
        return 1;
    }

    @Override
    public void registerApplication() throws PlatformManagerException {
        this.registerMagnet(true);
        this.registerDHT();
        this.registerAdditionalFileType(NEW_MAIN_ASSOC, String.valueOf(Constants.APP_NAME) + " Download", ".torrent", "application/x-bittorrent");
        this.registerAdditionalFileType(VUZE_ASSOC, "Vuze File", ".vuze", "application/x-vuze");
    }

    protected void registerMagnet(boolean force) {
        try {
            String az_exe_string = this.getApplicationEXELocation().toString();
            boolean magnet_exe_managing = false;
            try {
                String existing = this.access.readStringValue(1, "magnet\\shell\\open\\command", "");
                magnet_exe_managing = existing.toLowerCase().indexOf("\\magnet.exe") != -1;
            }
            catch (Throwable existing) {
                // empty catch block
            }
            if (!magnet_exe_managing && (force || this.getAdditionalFileTypeRegistrationDetails("Magnet", ".magnet") == 0)) {
                try {
                    this.registerAdditionalFileType("Magnet", "URL:Magnet Protocol", ".magnet", "application/x-magnet", true);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            int[] nArray = new int[]{3, 4};
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int type = nArray[n2];
                try {
                    this.createKey(type, "Software\\Magnet");
                    this.createKey(type, "Software\\Magnet\\Handlers");
                    this.createKey(type, "Software\\Magnet\\Handlers\\Azureus");
                    this.access.writeStringValue(type, "Software\\Magnet\\Handlers\\Azureus", "DefaultIcon", "\"" + az_exe_string + "\"," + this.getIconIndex());
                    this.access.writeStringValue(type, "Software\\Magnet\\Handlers\\Azureus", "Description", "Download with Vuze");
                    this.access.writeStringValue(type, "Software\\Magnet\\Handlers\\Azureus", "ShellExecute", "\"" + az_exe_string + "\" \"%URL\"");
                    this.access.writeWordValue(type, "Software\\Magnet\\Handlers\\Azureus\\Type", "urn:btih", 0);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected boolean createKey(int type, String key) {
        try {
            this.access.readStringValue(type, key, "");
            return true;
        }
        catch (Throwable e) {
            try {
                this.access.writeStringValue(type, key, "", "");
                return true;
            }
            catch (Throwable f) {
                return false;
            }
        }
    }

    protected void registerDHT() {
        try {
            this.registerAdditionalFileType("DHT", "DHT URI", ".dht", "application/x-dht", true);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected void registerBC() {
        try {
            this.registerAdditionalFileType("BC", "BC URI", ".bcuri", "application/x-bc-uri", true);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        try {
            this.registerAdditionalFileType("BCTP", "BCTP URI", ".bctpuri", "application/x-bctp-uri", true);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public void registerAdditionalFileType(String name, String description, String type, String content_type) throws PlatformManagerException {
        this.registerAdditionalFileType(name, description, type, content_type, false);
    }

    public void registerAdditionalFileType(String name, String description, String type, String content_type, boolean url_protocol) throws PlatformManagerException {
        try {
            String az_exe_string = this.getApplicationEXELocation().toString();
            this.unregisterAdditionalFileType(name, type);
            this.writeStringToHKCRandHKCU(type, "", name);
            this.writeStringToHKCRandHKCU(type, "Content Type", content_type);
            this.writeStringToHKCRandHKCU("MIME\\Database\\Content Type\\" + content_type, "Extension", type);
            this.writeStringToHKCRandHKCU(name, "", description);
            this.writeStringToHKCRandHKCU(String.valueOf(name) + "\\shell", "", "open");
            this.writeStringToHKCRandHKCU(String.valueOf(name) + "\\DefaultIcon", "", "\"" + az_exe_string + "\"," + this.getIconIndex());
            this.writeStringToHKCRandHKCU(String.valueOf(name) + "\\shell\\open\\command", "", "\"" + az_exe_string + "\" \"%1\"");
            this.writeStringToHKCRandHKCU(name, "Content Type", content_type);
            if (url_protocol) {
                this.writeStringToHKCRandHKCU(name, "URL Protocol", "");
            }
        }
        catch (PlatformManagerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to write registry details", e);
        }
    }

    private void writeStringToHKCRandHKCU(String subkey, String name, String value) {
        block4: {
            try {
                this.access.writeStringValue(1, subkey, name, value);
            }
            catch (Throwable e) {
                if (Constants.isWindowsVistaOrHigher) break block4;
                Debug.out(e);
            }
        }
        try {
            this.access.writeStringValue(4, "Software\\Classes\\" + subkey, name, value);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    @Override
    public void unregisterAdditionalFileType(String name, String type) throws PlatformManagerException {
        try {
            try {
                this.access.deleteValue(4, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + type, "Application");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.access.deleteKey(1, type);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.access.deleteKey(1, name, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.access.deleteKey(4, "Software\\Classes\\" + type);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.access.deleteKey(4, "Software\\Classes\\" + name, true);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to delete registry details", e);
        }
    }

    @Override
    public void createProcess(String command_line, boolean inherit_handles) throws PlatformManagerException {
        try {
            this.access.createProcess(command_line, inherit_handles);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to create process", e);
        }
    }

    @Override
    public void performRecoverableFileDelete(String file_name) throws PlatformManagerException {
        try {
            this.access.moveToRecycleBin(file_name);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to move file", e);
        }
    }

    @Override
    public void setTCPTOSEnabled(boolean enabled) throws PlatformManagerException {
        try {
            this.access.writeWordValue(3, "System\\CurrentControlSet\\Services\\Tcpip\\Parameters", "DisableUserTOSSetting", enabled ? 0 : 1);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to write registry details", e);
        }
    }

    @Override
    public void copyFilePermissions(String from_file_name, String to_file_name) throws PlatformManagerException {
        try {
            this.access.copyFilePermissions(from_file_name, to_file_name);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to copy file permissions", e);
        }
    }

    @Override
    public void showFile(String file_name) throws PlatformManagerException {
        try {
            File file = new File(file_name);
            this.access.createProcess("explorer.exe " + (file.isDirectory() ? "/e," : "/e,/select,") + "\"" + file_name + "\"", false);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to show file " + file_name, e);
        }
    }

    @Override
    public boolean testNativeAvailability(String name) throws PlatformManagerException {
        if (!this.hasCapability(PlatformManagerCapabilities.TestNativeAvailability)) {
            throw new PlatformManagerException("Unsupported capability called on platform manager");
        }
        try {
            return this.access.testNativeAvailability(name);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to test availability", e);
        }
    }

    @Override
    public void traceRoute(InetAddress interface_address, InetAddress target, PlatformManagerPingCallback callback) throws PlatformManagerException {
        if (!this.hasCapability(PlatformManagerCapabilities.TraceRouteAvailability)) {
            throw new PlatformManagerException("Unsupported capability called on platform manager");
        }
        try {
            this.access.traceRoute(interface_address, target, callback);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to trace route", e);
        }
    }

    @Override
    public void ping(InetAddress interface_address, InetAddress target, PlatformManagerPingCallback callback) throws PlatformManagerException {
        if (!this.hasCapability(PlatformManagerCapabilities.PingAvailability)) {
            throw new PlatformManagerException("Unsupported capability called on platform manager");
        }
        try {
            this.access.ping(interface_address, target, callback);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to trace route", e);
        }
    }

    public int shellExecute(String operation, String file, String parameters, String directory, int SW_const) throws PlatformManagerException {
        try {
            return this.access.shellExecute(operation, file, parameters, directory, SW_const);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to shellExecute", e);
        }
    }

    @Override
    public int getMaxOpenFiles() throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public boolean hasCapability(PlatformManagerCapabilities capability) {
        return this.capabilitySet.contains(capability);
    }

    private void checkCapability(PlatformManagerCapabilities capability) throws PlatformManagerException {
        if (!this.hasCapability(capability)) {
            throw new PlatformManagerException("Capability " + capability + " not supported");
        }
    }

    @Override
    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int eventOccurred(int type) {
        int t_type = -1;
        int res = -1;
        if (type == 1) {
            t_type = 1;
        } else if (type == 2) {
            t_type = 2;
            PlatformManagerImpl platformManagerImpl = this;
            synchronized (platformManagerImpl) {
                if (this.prevent_computer_sleep) {
                    res = 1;
                }
            }
        } else if (type == 3) {
            t_type = 3;
        }
        if (t_type != -1) {
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    int my_res = ((PlatformManagerListener)this.listeners.get(i)).eventOccurred(t_type);
                    if (my_res == 1) {
                        res = 1;
                    } else if (my_res != -1) {
                        if (res != -1 && my_res != res) {
                            Debug.out("Incompatible result codes: " + res + "/" + my_res);
                        } else {
                            res = my_res;
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
        return res;
    }

    @Override
    public void addListener(PlatformManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(PlatformManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void requestUserAttention(int type, Object data) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public Class<?> loadClass(ClassLoader loader, String class_name) throws PlatformManagerException {
        try {
            return loader.loadClass(class_name);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("load of '" + class_name + "' failed", e);
        }
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println("Platform");
        try {
            writer.indent();
            try {
                String[] options = this.getExplicitVMOptions();
                writer.println("VM Options");
                try {
                    writer.indent();
                    String[] stringArray = options;
                    int n = options.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String option = stringArray[n2];
                        writer.println(option);
                        ++n2;
                    }
                }
                finally {
                    writer.exdent();
                }
            }
            catch (Throwable e) {
                writer.println("VM options not available: " + Debug.getNestedExceptionMessage(e));
            }
        }
        finally {
            writer.exdent();
        }
    }
}

