/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNATChecker;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNatCheckerListener;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerSimplePeer;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.HostNameToIPResolverListener;
import org.gudy.azureus2.core3.util.SystemTime;

public class TRTrackerServerPeerImpl
implements TRTrackerServerPeer,
TRTrackerServerSimplePeer,
HostNameToIPResolverListener,
TRTrackerServerNatCheckerListener {
    private HashWrapper peer_id;
    private int key_hash_code;
    private byte[] ip;
    private boolean ip_override;
    private short tcp_port;
    private short udp_port;
    private short http_port;
    private byte crypto_level;
    private byte az_ver;
    private String ip_str;
    private byte[] ip_bytes;
    private byte NAT_status = 0;
    private long timeout;
    private long uploaded;
    private long downloaded;
    private long amount_left;
    private long last_contact_time;
    private boolean download_completed;
    private boolean biased;
    private short up_speed;
    private DHTNetworkPosition network_position;
    private Object user_data;

    protected TRTrackerServerPeerImpl(HashWrapper _peer_id, int _key_hash_code, byte[] _ip, boolean _ip_override, int _tcp_port, int _udp_port, int _http_port, byte _crypto_level, byte _az_ver, long _last_contact_time, boolean _download_completed, byte _last_nat_status, int _up_speed, DHTNetworkPosition _network_position) {
        this.peer_id = _peer_id;
        this.key_hash_code = _key_hash_code;
        this.ip = _ip;
        this.ip_override = _ip_override;
        this.tcp_port = (short)_tcp_port;
        this.udp_port = (short)_udp_port;
        this.http_port = (short)_http_port;
        this.crypto_level = _crypto_level;
        this.az_ver = _az_ver;
        this.last_contact_time = _last_contact_time;
        this.download_completed = _download_completed;
        this.NAT_status = _last_nat_status;
        this.up_speed = (short)(_up_speed > Short.MAX_VALUE ? Short.MAX_VALUE : (short)_up_speed);
        this.network_position = _network_position;
        this.resolveAndCheckNAT();
    }

    protected TRTrackerServerPeerImpl(HashWrapper _peer_id, int _key_hash_code, byte[] _ip, boolean _ip_override, short _tcp_port, short _udp_port, short _http_port, byte _crypto_level, byte _az_ver, String _ip_str, byte[] _ip_bytes, byte _NAT_status, long _timeout, long _uploaded, long _downloaded, long _amount_left, long _last_contact_time, boolean _download_completed, boolean _biased, short _up_speed) {
        this.peer_id = _peer_id;
        this.key_hash_code = _key_hash_code;
        this.ip = _ip;
        this.ip_override = _ip_override;
        this.tcp_port = _tcp_port;
        this.udp_port = _udp_port;
        this.http_port = _http_port;
        this.crypto_level = _crypto_level;
        this.az_ver = _az_ver;
        this.ip_str = _ip_str;
        this.ip_bytes = _ip_bytes;
        this.NAT_status = _NAT_status;
        this.timeout = _timeout;
        this.uploaded = _uploaded;
        this.downloaded = _downloaded;
        this.amount_left = _amount_left;
        this.last_contact_time = _last_contact_time;
        this.download_completed = _download_completed;
        this.biased = _biased;
        this.up_speed = _up_speed;
    }

    protected boolean update(byte[] _ip, int _port, int _udp_port, int _http_port, byte _crypto_level, byte _az_ver, int _up_speed, DHTNetworkPosition _network_position) {
        this.udp_port = (short)_udp_port;
        this.http_port = (short)_http_port;
        this.crypto_level = _crypto_level;
        this.az_ver = _az_ver;
        this.up_speed = (short)(_up_speed > Short.MAX_VALUE ? Short.MAX_VALUE : (short)_up_speed);
        this.network_position = _network_position;
        boolean res = false;
        if (_port != this.getTCPPort()) {
            this.tcp_port = (short)_port;
            res = true;
        }
        if (!Arrays.equals(_ip, this.ip)) {
            this.ip = _ip;
            res = true;
        }
        if (res) {
            this.resolveAndCheckNAT();
        }
        return res;
    }

    @Override
    public void NATCheckComplete(boolean ok) {
        this.NAT_status = ok ? (byte)3 : (byte)4;
    }

    protected void setNATStatus(byte status) {
        this.NAT_status = status;
    }

    @Override
    public byte getNATStatus() {
        return this.NAT_status;
    }

    protected boolean isNATStatusBad() {
        return this.NAT_status == 4 || this.NAT_status == 5;
    }

    protected void resolveAndCheckNAT() {
        this.ip_str = new String(this.ip);
        this.ip_bytes = null;
        HostNameToIPResolver.addResolverRequest(this.ip_str, this);
        if (this.tcp_port == 0) {
            this.NAT_status = (byte)5;
        } else if (this.NAT_status == 0) {
            this.NAT_status = (byte)2;
            if (!TRTrackerServerNATChecker.getSingleton().addNATCheckRequest(this.ip_str, this.getTCPPort(), this)) {
                this.NAT_status = 1;
            }
        }
    }

    @Override
    public void hostNameResolutionComplete(InetAddress address) {
        if (address != null) {
            this.ip_str = address.getHostAddress();
            this.ip_bytes = address.getAddress();
        }
    }

    protected long getLastContactTime() {
        return this.last_contact_time;
    }

    protected boolean getDownloadCompleted() {
        return this.download_completed;
    }

    protected void setDownloadCompleted() {
        this.download_completed = true;
    }

    @Override
    public boolean isBiased() {
        return this.biased;
    }

    @Override
    public void setBiased(boolean _biased) {
        this.biased = _biased;
    }

    @Override
    public HashWrapper getPeerId() {
        return this.peer_id;
    }

    @Override
    public byte[] getPeerID() {
        return this.peer_id.getBytes();
    }

    protected int getKeyHashCode() {
        return this.key_hash_code;
    }

    @Override
    public byte[] getIPAsRead() {
        return this.ip;
    }

    @Override
    public String getIPRaw() {
        return new String(this.ip);
    }

    @Override
    public String getIP() {
        return this.ip_str;
    }

    protected boolean isIPOverride() {
        return this.ip_override;
    }

    @Override
    public byte[] getIPAddressBytes() {
        return this.ip_bytes;
    }

    @Override
    public int getTCPPort() {
        return this.tcp_port & 0xFFFF;
    }

    @Override
    public int getUDPPort() {
        return this.udp_port & 0xFFFF;
    }

    @Override
    public int getHTTPPort() {
        return this.http_port & 0xFFFF;
    }

    @Override
    public byte getCryptoLevel() {
        return this.crypto_level;
    }

    @Override
    public byte getAZVer() {
        return this.az_ver;
    }

    @Override
    public int getUpSpeed() {
        return this.up_speed & 0xFFFF;
    }

    @Override
    public DHTNetworkPosition getNetworkPosition() {
        return this.network_position;
    }

    protected void setTimeout(long _now, long _timeout) {
        this.last_contact_time = _now;
        this.timeout = _timeout;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    @Override
    public int getSecsToLive() {
        return (int)((this.timeout - SystemTime.getCurrentTime()) / 1000L);
    }

    protected void setStats(long _uploaded, long _downloaded, long _amount_left) {
        this.uploaded = _uploaded;
        this.downloaded = _downloaded;
        this.amount_left = _amount_left;
    }

    @Override
    public long getUploaded() {
        return this.uploaded;
    }

    @Override
    public long getDownloaded() {
        return this.downloaded;
    }

    @Override
    public long getAmountLeft() {
        return this.amount_left;
    }

    @Override
    public boolean isSeed() {
        return this.amount_left == 0L;
    }

    @Override
    public void setUserData(Object key, Object data) {
        if (this.user_data == null) {
            this.user_data = new Object[]{key, data};
        } else if (this.user_data instanceof Object[]) {
            Object[] x = (Object[])this.user_data;
            if (x[0] == key) {
                x[1] = data;
            } else {
                HashMap<Object, Object> map;
                this.user_data = map = new HashMap<Object, Object>();
                map.put(x[0], x[1]);
                map.put(key, data);
            }
        } else {
            ((Map)this.user_data).put(key, data);
        }
    }

    @Override
    public Object getUserData(Object key) {
        if (this.user_data == null) {
            return null;
        }
        if (this.user_data instanceof Object[]) {
            Object[] x = (Object[])this.user_data;
            if (x[0] == key) {
                return x[1];
            }
            return null;
        }
        return ((Map)this.user_data).get(key);
    }

    @Override
    public Map export() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("peer_id", this.peer_id.getBytes());
        map.put("key_hash_code", new Long(this.key_hash_code));
        map.put("ip", this.ip);
        map.put("ip_override", new Long(this.ip_override ? 1 : 0));
        map.put("tcp_port", new Long(this.tcp_port));
        map.put("udp_port", new Long(this.udp_port));
        map.put("http_port", new Long(this.http_port));
        map.put("crypto_level", new Long(this.crypto_level));
        map.put("az_ver", new Long(this.az_ver));
        map.put("ip_str", this.ip_str);
        if (this.ip_bytes != null) {
            map.put("ip_bytes", this.ip_bytes);
        }
        map.put("NAT_status", new Long(this.NAT_status));
        map.put("timeout", new Long(this.timeout));
        map.put("uploaded", new Long(this.uploaded));
        map.put("downloaded", new Long(this.downloaded));
        map.put("amount_left", new Long(this.amount_left));
        map.put("last_contact_time", new Long(this.last_contact_time));
        map.put("download_completed", new Long(this.download_completed ? 1 : 0));
        map.put("biased", new Long(this.biased ? 1 : 0));
        map.put("up_speed", new Long(this.up_speed));
        return map;
    }

    public static TRTrackerServerPeerImpl importPeer(Map map) {
        try {
            HashWrapper peer_id = new HashWrapper((byte[])map.get("peer_id"));
            int key_hash_code = ((Long)map.get("key_hash_code")).intValue();
            byte[] ip = (byte[])map.get("ip");
            boolean ip_override = ((Long)map.get("ip_override")).intValue() == 1;
            short tcp_port = ((Long)map.get("tcp_port")).shortValue();
            short udp_port = ((Long)map.get("udp_port")).shortValue();
            short http_port = ((Long)map.get("http_port")).shortValue();
            byte crypto_level = ((Long)map.get("crypto_level")).byteValue();
            byte az_ver = ((Long)map.get("az_ver")).byteValue();
            String ip_str = new String((byte[])map.get("ip_str"));
            byte[] ip_bytes = (byte[])map.get("ip_bytes");
            byte NAT_status = ((Long)map.get("NAT_status")).byteValue();
            long timeout = (Long)map.get("timeout");
            long uploaded = (Long)map.get("uploaded");
            long downloaded = (Long)map.get("downloaded");
            long amount_left = (Long)map.get("amount_left");
            long last_contact_time = (Long)map.get("last_contact_time");
            boolean download_completed = ((Long)map.get("download_completed")).intValue() == 1;
            boolean biased = ((Long)map.get("biased")).intValue() == 1;
            short up_speed = ((Long)map.get("up_speed")).shortValue();
            return new TRTrackerServerPeerImpl(peer_id, key_hash_code, ip, ip_override, tcp_port, udp_port, http_port, crypto_level, az_ver, ip_str, ip_bytes, NAT_status, timeout, uploaded, downloaded, amount_left, last_contact_time, download_completed, biased, up_speed);
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected String getString() {
        return String.valueOf(new String(this.ip)) + ":" + this.getTCPPort() + "(" + new String(this.peer_id.getHash()) + ")";
    }
}

