/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp;

import com.aelitis.net.udp.uc.PRUDPPacketReply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PRUDPPacketReplyScrape
extends PRUDPPacketReply {
    protected static final int BYTES_PER_ENTRY = 32;
    protected byte[][] hashes;
    protected int[] complete;
    protected int[] incomplete;
    protected int[] downloaded;

    public PRUDPPacketReplyScrape(int trans_id) {
        super(2, trans_id);
    }

    protected PRUDPPacketReplyScrape(DataInputStream is, int trans_id) throws IOException {
        super(2, trans_id);
        this.hashes = new byte[is.available() / 32][];
        this.complete = new int[this.hashes.length];
        this.incomplete = new int[this.hashes.length];
        this.downloaded = new int[this.hashes.length];
        int i = 0;
        while (i < this.hashes.length) {
            this.hashes[i] = new byte[20];
            is.read(this.hashes[i]);
            this.complete[i] = is.readInt();
            this.downloaded[i] = is.readInt();
            this.incomplete[i] = is.readInt();
            ++i;
        }
    }

    public void setDetails(byte[][] _hashes, int[] _complete, int[] _downloaded, int[] _incomplete) {
        this.hashes = _hashes;
        this.complete = _complete;
        this.downloaded = _downloaded;
        this.incomplete = _incomplete;
    }

    public byte[][] getHashes() {
        return this.hashes;
    }

    public int[] getComplete() {
        return this.complete;
    }

    public int[] getDownloaded() {
        return this.downloaded;
    }

    public int[] getIncomplete() {
        return this.incomplete;
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        if (this.hashes != null) {
            int i = 0;
            while (i < this.hashes.length) {
                os.write(this.hashes[i]);
                os.writeInt(this.complete[i]);
                os.writeInt(this.downloaded[i]);
                os.writeInt(this.incomplete[i]);
                ++i;
            }
        }
    }

    @Override
    public String getString() {
        return super.getString().concat("[hashes=").concat(String.valueOf(this.hashes.length)).concat("]");
    }
}

