/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.host.impl;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrent.TOTorrentListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TRHostExternalTorrent
implements TOTorrent {
    private byte[] name;
    private byte[] hash;
    private HashWrapper hash_wrapper;
    private URL announce_url;
    protected Map additional_properties = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("TRHostExternalTorrent");

    protected TRHostExternalTorrent(byte[] _hash, URL _announce_url) {
        this.hash = _hash;
        this.hash_wrapper = new HashWrapper(this.hash);
        this.announce_url = _announce_url;
        this.name = ByteFormatter.nicePrint(this.hash, true).getBytes();
        try {
            LocaleTorrentUtil.setDefaultTorrentEncoding(this);
        }
        catch (LocaleUtilEncodingException e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public byte[] getName() {
        return this.name;
    }

    @Override
    public String getUTF8Name() {
        return null;
    }

    @Override
    public boolean isSimpleTorrent() {
        return true;
    }

    @Override
    public byte[] getComment() {
        return null;
    }

    @Override
    public void setComment(String comment) {
    }

    @Override
    public long getCreationDate() {
        return 0L;
    }

    @Override
    public void setCreationDate(long date) {
    }

    @Override
    public byte[] getCreatedBy() {
        return null;
    }

    @Override
    public void setCreatedBy(byte[] cb) {
    }

    @Override
    public boolean isCreated() {
        return false;
    }

    @Override
    public boolean isDecentralised() {
        return TorrentUtils.isDecentralised(this.getAnnounceURL());
    }

    @Override
    public URL getAnnounceURL() {
        return this.announce_url;
    }

    @Override
    public boolean setAnnounceURL(URL url) {
        return false;
    }

    @Override
    public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
        return new TOTorrentAnnounceURLGroup(){

            @Override
            public TOTorrentAnnounceURLSet[] getAnnounceURLSets() {
                return new TOTorrentAnnounceURLSet[0];
            }

            @Override
            public void setAnnounceURLSets(TOTorrentAnnounceURLSet[] sets) {
            }

            @Override
            public TOTorrentAnnounceURLSet createAnnounceURLSet(URL[] urls) {
                return new TOTorrentAnnounceURLSet(){

                    @Override
                    public URL[] getAnnounceURLs() {
                        return new URL[0];
                    }

                    @Override
                    public void setAnnounceURLs(URL[] urls) {
                    }
                };
            }
        };
    }

    public void addTorrentAnnounceURLSet(URL[] urls) {
    }

    @Override
    public byte[][] getPieces() {
        return new byte[0][];
    }

    @Override
    public void setPieces(byte[][] b) {
    }

    @Override
    public int getNumberOfPieces() {
        return 0;
    }

    @Override
    public long getPieceLength() {
        return -1L;
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public int getFileCount() {
        return 0;
    }

    @Override
    public TOTorrentFile[] getFiles() {
        return new TOTorrentFile[0];
    }

    @Override
    public byte[] getHash() throws TOTorrentException {
        return this.hash;
    }

    @Override
    public HashWrapper getHashWrapper() throws TOTorrentException {
        return this.hash_wrapper;
    }

    @Override
    public void setHashOverride(byte[] hash) throws TOTorrentException {
        throw new TOTorrentException("Not supported", 8);
    }

    @Override
    public boolean getPrivate() {
        return false;
    }

    @Override
    public void setPrivate(boolean _private) throws TOTorrentException {
    }

    @Override
    public boolean hasSameHashAs(TOTorrent other) {
        try {
            byte[] other_hash = other.getHash();
            return Arrays.equals(this.hash, other_hash);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    @Override
    public void setAdditionalStringProperty(String name, String value) {
        try {
            this.additional_properties.put(name, value.getBytes("UTF8"));
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public String getAdditionalStringProperty(String name) {
        Object obj;
        block5: {
            block4: {
                try {
                    obj = this.additional_properties.get(name);
                    if (obj != null) break block4;
                    return null;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    return null;
                }
            }
            if (obj instanceof byte[]) break block5;
            Debug.out("property '" + name + "' is not a byte[]: " + obj);
            return null;
        }
        return new String((byte[])obj, "UTF8");
    }

    @Override
    public void setAdditionalByteArrayProperty(String name, byte[] value) {
        this.additional_properties.put(name, value);
    }

    @Override
    public byte[] getAdditionalByteArrayProperty(String name) {
        return (byte[])this.additional_properties.get(name);
    }

    @Override
    public void setAdditionalLongProperty(String name, Long value) {
        this.additional_properties.put(name, value);
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (value instanceof String) {
            this.setAdditionalStringProperty(name, (String)value);
        } else {
            this.additional_properties.put(name, value);
        }
    }

    @Override
    public Long getAdditionalLongProperty(String name) {
        return (Long)this.additional_properties.get(name);
    }

    @Override
    public void setAdditionalListProperty(String name, List value) {
        this.additional_properties.put(name, value);
    }

    @Override
    public List getAdditionalListProperty(String name) {
        return (List)this.additional_properties.get(name);
    }

    @Override
    public void setAdditionalMapProperty(String name, Map value) {
        this.additional_properties.put(name, value);
    }

    @Override
    public Map getAdditionalMapProperty(String name) {
        return (Map)this.additional_properties.get(name);
    }

    @Override
    public Object getAdditionalProperty(String name) {
        return this.additional_properties.get(name);
    }

    @Override
    public void removeAdditionalProperty(String name) {
        this.additional_properties.remove(name);
    }

    @Override
    public void removeAdditionalProperties() {
        this.additional_properties.clear();
    }

    @Override
    public void serialiseToBEncodedFile(File file) throws TOTorrentException {
        throw new TOTorrentException("External Torrent", 5);
    }

    @Override
    public Map serialiseToMap() throws TOTorrentException {
        throw new TOTorrentException("External Torrent", 5);
    }

    @Override
    public void serialiseToXMLFile(File file) throws TOTorrentException {
        throw new TOTorrentException("External Torrent", 5);
    }

    @Override
    public void addListener(TOTorrentListener l) {
    }

    @Override
    public void removeListener(TOTorrentListener l) {
    }

    @Override
    public AEMonitor getMonitor() {
        return this.this_mon;
    }

    @Override
    public void print() {
    }
}

