/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerDataProvider;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerFactoryImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerHelper;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.dht.TRTrackerDHTAnnouncerImpl;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;

public class TRTrackerAnnouncerMuxer
extends TRTrackerAnnouncerImpl {
    private static final int ACT_CHECK_INIT_DELAY = 2500;
    private static final int ACT_CHECK_INTERIM_DELAY = 10000;
    private static final int ACT_CHECK_IDLE_DELAY = 30000;
    private static final int ACT_CHECK_SEEDING_SHORT_DELAY = 60000;
    private static final int ACT_CHECK_SEEDING_LONG_DELAY = 180000;
    private TRTrackerAnnouncerFactory.DataProvider f_provider;
    private boolean is_manual;
    private long create_time = SystemTime.getMonotonousTime();
    private CopyOnWriteList<TRTrackerAnnouncerHelper> announcers = new CopyOnWriteList();
    private Set<TRTrackerAnnouncerHelper> activated = new HashSet<TRTrackerAnnouncerHelper>();
    private long last_activation_time;
    private Set<String> failed_urls = new HashSet<String>();
    private volatile TimerEvent event;
    private TRTrackerAnnouncerDataProvider provider;
    private String ip_override;
    private boolean complete;
    private boolean stopped;
    private boolean destroyed;
    private String[] current_networks;
    private TRTrackerAnnouncerHelper last_best_active;
    private long last_best_active_set_time;
    private Map<String, StatusSummary> recent_responses = new HashMap<String, StatusSummary>();
    private TRTrackerAnnouncerResponse last_response_informed;

    protected TRTrackerAnnouncerMuxer(TOTorrent _torrent, TRTrackerAnnouncerFactory.DataProvider _f_provider, boolean _manual) throws TRTrackerAnnouncerException {
        super(_torrent);
        try {
            this.last_response_informed = new TRTrackerAnnouncerResponseImpl(null, _torrent.getHashWrapper(), 0, 60L, "Initialising");
        }
        catch (TOTorrentException e) {
            Logger.log(new LogEvent((Object)_torrent, LOGID, "Torrent hash retrieval fails", (Throwable)e));
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: URL encode fails");
        }
        this.is_manual = _manual;
        this.f_provider = _f_provider;
        this.split(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void split(boolean first_time) throws TRTrackerAnnouncerException {
        String[] networks = this.f_provider == null ? null : this.f_provider.getNetworks();
        boolean force_recreate = false;
        if (!first_time && this.current_networks != networks) {
            if (this.current_networks == null || networks == null) {
                force_recreate = true;
            } else if (networks.length != this.current_networks.length) {
                force_recreate = true;
            } else {
                String[] stringArray = this.current_networks;
                int n = this.current_networks.length;
                int n2 = 0;
                while (n2 < n) {
                    String net1 = stringArray[n2];
                    boolean match = false;
                    String[] stringArray2 = networks;
                    int n3 = networks.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String net2 = stringArray2[n4];
                        if (net1 == net2) {
                            match = true;
                        }
                        ++n4;
                    }
                    if (!match) {
                        force_recreate = true;
                        break;
                    }
                    ++n2;
                }
            }
        }
        this.current_networks = networks;
        TRTrackerAnnouncer to_activate = null;
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            if (this.stopped || this.destroyed) {
                return;
            }
            TOTorrent torrent = this.getTorrent();
            TOTorrentAnnounceURLSet[] sets = torrent.getAnnounceURLGroup().getAnnounceURLSets();
            if (sets.length == 0) {
                sets = new TOTorrentAnnounceURLSet[]{torrent.getAnnounceURLGroup().createAnnounceURLSet(new URL[]{torrent.getAnnounceURL()})};
            } else {
                Object u;
                int j;
                boolean found_decentralised = false;
                boolean modified = false;
                int i = 0;
                while (i < sets.length) {
                    TOTorrentAnnounceURLSet set = sets[i];
                    URL[] urls = (URL[])set.getAnnounceURLs().clone();
                    j = 0;
                    while (j < urls.length) {
                        u = urls[j];
                        if (u != null && TorrentUtils.isDecentralised((URL)u)) {
                            if (found_decentralised) {
                                modified = true;
                                urls[j] = null;
                            } else {
                                found_decentralised = true;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                if (modified) {
                    ArrayList<TOTorrentAnnounceURLSet> s_list = new ArrayList<TOTorrentAnnounceURLSet>();
                    u = sets;
                    j = sets.length;
                    int urls = 0;
                    while (urls < j) {
                        TOTorrentAnnounceURLSet set = u[urls];
                        URL[] urls2 = set.getAnnounceURLs();
                        ArrayList<URL> arrayList = new ArrayList<URL>(urls2.length);
                        URL[] uRLArray = urls2;
                        int n = urls2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            URL u2 = uRLArray[n2];
                            if (u2 != null) {
                                arrayList.add(u2);
                            }
                            ++n2;
                        }
                        if (arrayList.size() > 0) {
                            s_list.add(torrent.getAnnounceURLGroup().createAnnounceURLSet(arrayList.toArray(new URL[arrayList.size()])));
                        }
                        ++urls;
                    }
                    sets = s_list.toArray(new TOTorrentAnnounceURLSet[s_list.size()]);
                }
            }
            ArrayList<TOTorrentAnnounceURLSet[]> new_sets = new ArrayList<TOTorrentAnnounceURLSet[]>();
            if (this.is_manual || sets.length < 2) {
                new_sets.add(sets);
            } else {
                ArrayList<TOTorrentAnnounceURLSet> list = new ArrayList<TOTorrentAnnounceURLSet>(Arrays.asList(sets));
                while (list.size() > 0) {
                    TOTorrentAnnounceURLSet set1 = (TOTorrentAnnounceURLSet)list.remove(0);
                    boolean done = false;
                    URL[] urls1 = set1.getAnnounceURLs();
                    if (urls1.length == 1) {
                        void var16_40;
                        URL url1 = urls1[0];
                        String prot1 = url1.getProtocol().toLowerCase();
                        String host1 = url1.getHost();
                        boolean bl = false;
                        while (var16_40 < list.size()) {
                            TOTorrentAnnounceURLSet set2 = (TOTorrentAnnounceURLSet)list.get((int)var16_40);
                            URL[] urls2 = set2.getAnnounceURLs();
                            if (urls2.length == 1) {
                                URL url2 = urls2[0];
                                String prot2 = url2.getProtocol().toLowerCase();
                                String host2 = url2.getHost();
                                if (host1.equals(host2) && (prot1.equals("udp") && prot2.startsWith("http") || prot2.equals("udp") && prot1.startsWith("http"))) {
                                    list.remove((int)var16_40);
                                    new_sets.add(new TOTorrentAnnounceURLSet[]{set1, set2});
                                    done = true;
                                }
                            }
                            ++var16_40;
                        }
                    }
                    if (done) continue;
                    new_sets.add(new TOTorrentAnnounceURLSet[]{set1});
                }
            }
            Iterator ns_it = new_sets.iterator();
            ArrayList<TRTrackerAnnouncerHelper> existing_announcers = new ArrayList<TRTrackerAnnouncerHelper>(this.announcers.getList());
            ArrayList<TRTrackerAnnouncer> new_announcers = new ArrayList<TRTrackerAnnouncer>();
            if (!force_recreate) {
                block14: while (ns_it.hasNext()) {
                    TOTorrentAnnounceURLSet[] ns = (TOTorrentAnnounceURLSet[])ns_it.next();
                    Iterator a_it = existing_announcers.iterator();
                    while (a_it.hasNext()) {
                        TRTrackerAnnouncerHelper a3 = (TRTrackerAnnouncerHelper)a_it.next();
                        TOTorrentAnnounceURLSet[] os = a3.getAnnounceSets();
                        if (!this.same(ns, os)) continue;
                        ns_it.remove();
                        a_it.remove();
                        new_announcers.add(a3);
                        continue block14;
                    }
                }
            }
            TRTrackerAnnouncer existing_dht_announcer = null;
            TOTorrentAnnounceURLSet[] new_dht_set = null;
            ns_it = new_sets.iterator();
            while (ns_it.hasNext()) {
                TOTorrentAnnounceURLSet[] x = (TOTorrentAnnounceURLSet[])ns_it.next();
                if (!TorrentUtils.isDecentralised(x[0].getAnnounceURLs()[0])) continue;
                new_dht_set = x;
                ns_it.remove();
                break;
            }
            Iterator an_it = existing_announcers.iterator();
            while (an_it.hasNext()) {
                TRTrackerAnnouncerHelper a2 = (TRTrackerAnnouncerHelper)an_it.next();
                TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = a2.getAnnounceSets();
                if (!TorrentUtils.isDecentralised(tOTorrentAnnounceURLSetArray[0].getAnnounceURLs()[0])) continue;
                existing_dht_announcer = a2;
                an_it.remove();
                break;
            }
            if (existing_dht_announcer != null && new_dht_set != null) {
                new_announcers.add(existing_dht_announcer);
            } else if (existing_dht_announcer != null) {
                this.activated.remove(existing_dht_announcer);
                existing_dht_announcer.destroy();
            } else if (new_dht_set != null) {
                TRTrackerAnnouncerHelper a = this.create(torrent, networks, new_dht_set);
                new_announcers.add(a);
            }
            for (TOTorrentAnnounceURLSet[] s : new_sets) {
                TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper = this.create(torrent, networks, s);
                new_announcers.add(tRTrackerAnnouncerHelper);
            }
            Iterator<TRTrackerAnnouncerHelper> a_it = this.announcers.iterator();
            while (a_it.hasNext()) {
                TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper = a_it.next();
                if (new_announcers.contains(tRTrackerAnnouncerHelper)) continue;
                a_it.remove();
                try {
                    URL url;
                    if (!this.activated.contains(tRTrackerAnnouncerHelper) || !torrent.getPrivate() || !(tRTrackerAnnouncerHelper instanceof TRTrackerBTAnnouncerImpl) || (url = tRTrackerAnnouncerHelper.getTrackerURL()) == null) continue;
                    this.forceStop((TRTrackerBTAnnouncerImpl)tRTrackerAnnouncerHelper, networks, url);
                }
                finally {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(this.getTorrent(), LOGID, "Deactivating " + this.getString(tRTrackerAnnouncerHelper.getAnnounceSets())));
                    }
                    this.activated.remove(tRTrackerAnnouncerHelper);
                    tRTrackerAnnouncerHelper.destroy();
                }
            }
            for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper : new_announcers) {
                if (this.announcers.contains(tRTrackerAnnouncerHelper)) continue;
                this.announcers.add(tRTrackerAnnouncerHelper);
            }
            if (!this.is_manual && this.announcers.size() > 0) {
                if (this.activated.size() == 0) {
                    TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper = this.announcers.get(0);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(this.getTorrent(), LOGID, "Activating " + this.getString(tRTrackerAnnouncerHelper.getAnnounceSets())));
                    }
                    this.activated.add(tRTrackerAnnouncerHelper);
                    this.last_activation_time = SystemTime.getMonotonousTime();
                    if (this.provider != null) {
                        to_activate = tRTrackerAnnouncerHelper;
                    }
                }
                this.setupActivationCheck(2500);
            }
        }
        if (to_activate != null) {
            if (this.complete) {
                to_activate.complete(true);
            } else {
                to_activate.update(false);
            }
        }
    }

    protected void setupActivationCheck(int delay) {
        if (this.announcers.size() > this.activated.size()) {
            this.event = SimpleTimer.addEvent("TRMuxer:check", SystemTime.getOffsetTime(delay), new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent event2) {
                    TRTrackerAnnouncerMuxer.this.checkActivation(false);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkActivation(boolean force) {
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            int next_check_delay;
            if (this.destroyed || this.stopped || this.announcers.size() <= this.activated.size()) {
                return;
            }
            if (this.provider == null) {
                next_check_delay = 2500;
            } else {
                boolean seeding;
                boolean activate = force;
                boolean bl = seeding = this.provider.getRemaining() == 0L;
                if (seeding && this.activated.size() > 0) {
                    int connected = this.provider.getConnectedConnectionCount();
                    if (connected < 1) {
                        activate = SystemTime.getMonotonousTime() - this.last_activation_time >= 60000L;
                        next_check_delay = 60000;
                    } else {
                        next_check_delay = connected < 3 ? 180000 : 0;
                    }
                } else {
                    int allowed = this.provider.getMaxNewConnectionsAllowed("");
                    int pending = this.provider.getPendingConnectionCount();
                    int connected = this.provider.getConnectedConnectionCount();
                    int online = 0;
                    for (TRTrackerAnnouncerHelper a : this.activated) {
                        TRTrackerAnnouncerResponse response = a.getLastResponse();
                        if (response == null || response.getStatus() != 2) continue;
                        ++online;
                    }
                    if (online == 0) {
                        activate = true;
                        next_check_delay = 2500;
                    } else {
                        int potential = connected + pending;
                        if (potential < 10) {
                            activate = true;
                            next_check_delay = 2500;
                        } else if (allowed < 0 || allowed >= 5 && pending < 3 * allowed / 4) {
                            activate = true;
                            next_check_delay = 10000;
                        } else {
                            next_check_delay = 30000;
                        }
                    }
                }
                if (activate) {
                    for (TRTrackerAnnouncerHelper a : this.announcers) {
                        if (this.activated.contains(a)) continue;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(this.getTorrent(), LOGID, "Activating " + this.getString(a.getAnnounceSets())));
                        }
                        this.activated.add(a);
                        this.last_activation_time = SystemTime.getMonotonousTime();
                        if (this.complete) {
                            a.complete(true);
                            break;
                        }
                        a.update(false);
                        break;
                    }
                }
            }
            if (next_check_delay > 0) {
                this.setupActivationCheck(next_check_delay);
            }
        }
    }

    private String getString(TOTorrentAnnounceURLSet[] sets) {
        StringBuffer str = new StringBuffer();
        str.append("[");
        int num1 = 0;
        TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            TOTorrentAnnounceURLSet s = tOTorrentAnnounceURLSetArray[n2];
            if (num1++ > 0) {
                str.append(", ");
            }
            str.append("[");
            URL[] urls = s.getAnnounceURLs();
            int num2 = 0;
            URL[] uRLArray = urls;
            int n3 = urls.length;
            int n4 = 0;
            while (n4 < n3) {
                URL u = uRLArray[n4];
                if (num2++ > 0) {
                    str.append(", ");
                }
                str.append(u.toExternalForm());
                ++n4;
            }
            str.append("]");
            ++n2;
        }
        str.append("]");
        return str.toString();
    }

    private boolean same(TOTorrentAnnounceURLSet[] s1, TOTorrentAnnounceURLSet[] s2) {
        boolean res = this.sameSupport(s1, s2);
        return res;
    }

    private boolean sameSupport(TOTorrentAnnounceURLSet[] s1, TOTorrentAnnounceURLSet[] s2) {
        if (s1.length != s2.length) {
            return false;
        }
        int i = 0;
        while (i < s1.length) {
            URL[] u2;
            URL[] u1 = s1[i].getAnnounceURLs();
            if (u1.length != (u2 = s2[i].getAnnounceURLs()).length) {
                return false;
            }
            if (u1.length == 1) {
                return u1[0].toExternalForm().equals(u2[0].toExternalForm());
            }
            HashSet<String> set1 = new HashSet<String>();
            URL[] uRLArray = u1;
            int n = u1.length;
            int n2 = 0;
            while (n2 < n) {
                URL u = uRLArray[n2];
                set1.add(u.toExternalForm());
                ++n2;
            }
            HashSet<String> set2 = new HashSet<String>();
            URL[] uRLArray2 = u2;
            int n3 = u2.length;
            n = 0;
            while (n < n3) {
                URL u = uRLArray2[n];
                set2.add(u.toExternalForm());
                ++n;
            }
            if (!set1.equals(set2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void forceStop(final TRTrackerBTAnnouncerImpl announcer, final String[] networks, final URL url) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.getTorrent(), LOGID, "Force stopping " + url + " as private torrent"));
        }
        new AEThread2("TRMux:fs", true){

            @Override
            public void run() {
                try {
                    TRTrackerBTAnnouncerImpl an = new TRTrackerBTAnnouncerImpl(TRTrackerAnnouncerMuxer.this.getTorrent(), new TOTorrentAnnounceURLSet[0], networks, true, TRTrackerAnnouncerMuxer.this.getHelper());
                    an.cloneFrom(announcer);
                    an.setTrackerURL(url);
                    an.stop(false);
                    an.destroy();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }.start();
    }

    private TRTrackerAnnouncerHelper create(TOTorrent torrent, String[] networks, TOTorrentAnnounceURLSet[] sets) throws TRTrackerAnnouncerException {
        boolean decentralised = sets.length == 0 ? TorrentUtils.isDecentralised(torrent.getAnnounceURL()) : TorrentUtils.isDecentralised(sets[0].getAnnounceURLs()[0]);
        TRTrackerAnnouncerHelper announcer = decentralised ? new TRTrackerDHTAnnouncerImpl(torrent, networks, this.is_manual, this.getHelper()) : new TRTrackerBTAnnouncerImpl(torrent, sets, networks, this.is_manual, this.getHelper());
        TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            URL[] urls;
            TOTorrentAnnounceURLSet set = tOTorrentAnnounceURLSetArray[n2];
            URL[] uRLArray = urls = set.getAnnounceURLs();
            int n3 = urls.length;
            int n4 = 0;
            while (n4 < n3) {
                URL u = uRLArray[n4];
                String key = u.toExternalForm();
                StatusSummary summary = this.recent_responses.get(key);
                if (summary == null) {
                    summary = new StatusSummary(announcer, u);
                    this.recent_responses.put(key, summary);
                } else {
                    summary.setHelper(announcer);
                }
                ++n4;
            }
            ++n2;
        }
        if (this.provider != null) {
            announcer.setAnnounceDataProvider(this.provider);
        }
        if (this.ip_override != null) {
            announcer.setIPOverride(this.ip_override);
        }
        return announcer;
    }

    @Override
    public TRTrackerAnnouncerResponse getLastResponse() {
        TRTrackerAnnouncerResponse result = null;
        TRTrackerAnnouncerHelper best = this.getBestActive();
        if (best != null) {
            result = best.getLastResponse();
        }
        if (result == null) {
            result = this.last_response_informed;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void informResponse(TRTrackerAnnouncerHelper helper, TRTrackerAnnouncerResponse response) {
        URL url = response.getURL();
        if (url != null) {
            TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
            synchronized (tRTrackerAnnouncerMuxer) {
                String key = url.toExternalForm();
                StatusSummary summary = this.recent_responses.get(key);
                if (summary != null) {
                    summary.updateFrom(response);
                }
            }
        }
        this.last_response_informed = response;
        this.last_best_active_set_time = 0L;
        super.informResponse(helper, response);
        if (response.getStatus() != 2) {
            URL u = response.getURL();
            if (u != null) {
                String s = u.toExternalForm();
                Set<String> set = this.failed_urls;
                synchronized (set) {
                    if (this.failed_urls.contains(s)) {
                        return;
                    }
                    this.failed_urls.add(s);
                }
            }
            this.checkActivation(true);
        }
    }

    @Override
    public boolean isManual() {
        return this.is_manual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAnnounceDataProvider(TRTrackerAnnouncerDataProvider _provider) {
        List<TRTrackerAnnouncerHelper> to_set;
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            this.provider = _provider;
            to_set = this.announcers.getList();
        }
        for (TRTrackerAnnouncer tRTrackerAnnouncer : to_set) {
            tRTrackerAnnouncer.setAnnounceDataProvider(this.provider);
        }
    }

    protected TRTrackerAnnouncerHelper getBestActive() {
        long now = SystemTime.getMonotonousTime();
        if (now - this.last_best_active_set_time < 1000L) {
            return this.last_best_active;
        }
        this.last_best_active = this.getBestActiveSupport();
        this.last_best_active_set_time = now;
        return this.last_best_active;
    }

    protected TRTrackerAnnouncerHelper getBestActiveSupport() {
        List<TRTrackerAnnouncerHelper> x = this.announcers.getList();
        TRTrackerAnnouncerHelper error_resp = null;
        for (TRTrackerAnnouncerHelper announcer : x) {
            TRTrackerAnnouncerResponse response = announcer.getLastResponse();
            if (response == null) continue;
            int resp_status = response.getStatus();
            if (resp_status == 2) {
                return announcer;
            }
            if (error_resp != null || resp_status != 1) continue;
            error_resp = announcer;
        }
        if (error_resp != null) {
            return error_resp;
        }
        if (x.size() > 0) {
            return x.get(0);
        }
        return null;
    }

    @Override
    public URL getTrackerURL() {
        TRTrackerAnnouncerHelper active = this.getBestActive();
        if (active != null) {
            return active.getTrackerURL();
        }
        return null;
    }

    @Override
    public void setTrackerURL(URL url) {
        ArrayList<List<String>> groups = new ArrayList<List<String>>();
        ArrayList<String> group = new ArrayList<String>();
        group.add(url.toExternalForm());
        groups.add(group);
        TorrentUtils.listToAnnounceGroups(groups, this.getTorrent());
        this.resetTrackerUrl(false);
    }

    @Override
    public void resetTrackerUrl(boolean shuffle) {
        try {
            this.split(false);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
        for (TRTrackerAnnouncer tRTrackerAnnouncer : this.announcers) {
            tRTrackerAnnouncer.resetTrackerUrl(shuffle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIPOverride(String override) {
        List<TRTrackerAnnouncerHelper> to_set;
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            to_set = this.announcers.getList();
            this.ip_override = override;
        }
        for (TRTrackerAnnouncer tRTrackerAnnouncer : to_set) {
            tRTrackerAnnouncer.setIPOverride(override);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearIPOverride() {
        List<TRTrackerAnnouncerHelper> to_clear;
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            to_clear = this.announcers.getList();
            this.ip_override = null;
        }
        for (TRTrackerAnnouncer tRTrackerAnnouncer : to_clear) {
            tRTrackerAnnouncer.clearIPOverride();
        }
    }

    @Override
    public void setRefreshDelayOverrides(int percentage) {
        for (TRTrackerAnnouncer tRTrackerAnnouncer : this.announcers) {
            tRTrackerAnnouncer.setRefreshDelayOverrides(percentage);
        }
    }

    @Override
    public int getTimeUntilNextUpdate() {
        TRTrackerAnnouncerHelper active = this.getBestActive();
        if (active != null) {
            return active.getTimeUntilNextUpdate();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int getLastUpdateTime() {
        TRTrackerAnnouncerHelper active = this.getBestActive();
        if (active != null) {
            return active.getLastUpdateTime();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(boolean force) {
        List<TRTrackerAnnouncerHelper> to_update;
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            to_update = this.is_manual ? this.announcers.getList() : new ArrayList<TRTrackerAnnouncerHelper>(this.activated);
        }
        for (TRTrackerAnnouncer tRTrackerAnnouncer : to_update) {
            tRTrackerAnnouncer.update(force);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(boolean already_reported) {
        List<TRTrackerAnnouncerHelper> to_complete;
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            this.complete = true;
            to_complete = this.is_manual ? this.announcers.getList() : new ArrayList<TRTrackerAnnouncerHelper>(this.activated);
        }
        for (TRTrackerAnnouncer tRTrackerAnnouncer : to_complete) {
            tRTrackerAnnouncer.complete(already_reported);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean for_queue) {
        List<TRTrackerAnnouncerHelper> to_stop;
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            this.stopped = true;
            to_stop = this.is_manual ? this.announcers.getList() : new ArrayList<TRTrackerAnnouncerHelper>(this.activated);
            this.activated.clear();
        }
        for (TRTrackerAnnouncer tRTrackerAnnouncer : to_stop) {
            tRTrackerAnnouncer.stop(for_queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        List<TRTrackerAnnouncerHelper> to_destroy;
        TRTrackerAnnouncerFactoryImpl.destroy(this);
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            this.destroyed = true;
            to_destroy = this.announcers.getList();
        }
        for (TRTrackerAnnouncer tRTrackerAnnouncer : to_destroy) {
            tRTrackerAnnouncer.destroy();
        }
        TimerEvent timerEvent2 = this.event;
        if (timerEvent2 != null) {
            timerEvent2.cancel();
        }
    }

    @Override
    public int getStatus() {
        TRTrackerAnnouncer max_announcer = this.getBestAnnouncer();
        return max_announcer == null ? -1 : max_announcer.getStatus();
    }

    @Override
    public String getStatusString() {
        TRTrackerAnnouncer max_announcer = this.getBestAnnouncer();
        return max_announcer == null ? "" : max_announcer.getStatusString();
    }

    @Override
    public TRTrackerAnnouncer getBestAnnouncer() {
        int max = -1;
        TRTrackerAnnouncer max_announcer = null;
        for (TRTrackerAnnouncer tRTrackerAnnouncer : this.announcers) {
            int status = tRTrackerAnnouncer.getStatus();
            if (status <= max) continue;
            max_announcer = tRTrackerAnnouncer;
            max = status;
        }
        return max_announcer == null ? this : max_announcer;
    }

    @Override
    public void refreshListeners() {
        this.informURLRefresh();
    }

    @Override
    public void setAnnounceResult(DownloadAnnounceResult result) {
        for (TRTrackerAnnouncer tRTrackerAnnouncer : this.announcers) {
            if (!(tRTrackerAnnouncer instanceof TRTrackerDHTAnnouncerImpl)) continue;
            tRTrackerAnnouncer.setAnnounceResult(result);
            return;
        }
        List<TRTrackerAnnouncerHelper> list = this.announcers.getList();
        if (list.size() > 0) {
            list.get(0).setAnnounceResult(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int getPeerCacheLimit() {
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            if (this.activated.size() < this.announcers.size()) {
                return 0;
            }
        }
        if (SystemTime.getMonotonousTime() - this.create_time < 15000L) {
            return 0;
        }
        TRTrackerAnnouncerHelper active = this.getBestActive();
        if (active != null && this.provider != null && active.getStatus() == 2) {
            if (this.provider.getMaxNewConnectionsAllowed("") != 0 && this.provider.getPendingConnectionCount() == 0) {
                return 5;
            }
            return 0;
        }
        return 10;
    }

    @Override
    public TrackerPeerSource getTrackerPeerSource(TOTorrentAnnounceURLSet set) {
        URL[] urls = set.getAnnounceURLs();
        final String[] url_strs = new String[urls.length];
        int i = 0;
        while (i < urls.length) {
            url_strs[i] = urls[i].toExternalForm();
            ++i;
        }
        return new TrackerPeerSource(){
            private StatusSummary _summary;
            private boolean enabled;
            private long fixup_time;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private StatusSummary fixup() {
                long now = SystemTime.getMonotonousTime();
                if (now - this.fixup_time > 1000L) {
                    long most_recent = 0L;
                    StatusSummary summary = null;
                    TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = TRTrackerAnnouncerMuxer.this;
                    synchronized (tRTrackerAnnouncerMuxer) {
                        String[] stringArray = url_strs;
                        int n = url_strs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String str = stringArray[n2];
                            StatusSummary s = (StatusSummary)TRTrackerAnnouncerMuxer.this.recent_responses.get(str);
                            if (s != null && (summary == null || s.getTime() > most_recent)) {
                                summary = s;
                                most_recent = s.getTime();
                            }
                            ++n2;
                        }
                    }
                    if (TRTrackerAnnouncerMuxer.this.provider != null) {
                        this.enabled = TRTrackerAnnouncerMuxer.this.provider.isPeerSourceEnabled("Tracker");
                    }
                    if (summary != null) {
                        this._summary = summary;
                    }
                    this.fixup_time = now;
                }
                return this._summary;
            }

            @Override
            public int getType() {
                return 1;
            }

            @Override
            public String getName() {
                StatusSummary summary = this.fixup();
                if (summary != null) {
                    String str = summary.getURL().toExternalForm();
                    int pos = str.indexOf(63);
                    if (pos != -1) {
                        str = str.substring(0, pos);
                    }
                    return str;
                }
                return url_strs[0];
            }

            @Override
            public int getStatus() {
                StatusSummary summary = this.fixup();
                if (!this.enabled) {
                    return 1;
                }
                if (summary != null) {
                    return summary.getStatus();
                }
                return 3;
            }

            @Override
            public String getStatusString() {
                StatusSummary summary = this.fixup();
                if (summary != null && this.enabled) {
                    return summary.getStatusString();
                }
                return null;
            }

            @Override
            public int getSeedCount() {
                StatusSummary summary = this.fixup();
                if (summary != null) {
                    return summary.getSeedCount();
                }
                return -1;
            }

            @Override
            public int getLeecherCount() {
                StatusSummary summary = this.fixup();
                if (summary != null) {
                    return summary.getLeecherCount();
                }
                return -1;
            }

            @Override
            public int getCompletedCount() {
                StatusSummary summary = this.fixup();
                if (summary != null) {
                    return summary.getCompletedCount();
                }
                return -1;
            }

            @Override
            public int getPeers() {
                StatusSummary summary = this.fixup();
                if (summary != null) {
                    return summary.getPeers();
                }
                return -1;
            }

            @Override
            public int getLastUpdate() {
                StatusSummary summary = this.fixup();
                if (summary != null) {
                    long time = summary.getTime();
                    if (time == 0L) {
                        return 0;
                    }
                    long elapsed = SystemTime.getMonotonousTime() - time;
                    return (int)((SystemTime.getCurrentTime() - elapsed) / 1000L);
                }
                return 0;
            }

            @Override
            public int getSecondsToUpdate() {
                StatusSummary summary = this.fixup();
                if (summary != null) {
                    return summary.getSecondsToUpdate();
                }
                return -1;
            }

            @Override
            public int getInterval() {
                StatusSummary summary = this.fixup();
                if (summary != null) {
                    return summary.getInterval();
                }
                return -1;
            }

            @Override
            public int getMinInterval() {
                StatusSummary summary = this.fixup();
                if (summary != null && this.enabled) {
                    return summary.getMinInterval();
                }
                return -1;
            }

            @Override
            public boolean isUpdating() {
                StatusSummary summary = this.fixup();
                if (summary != null && this.enabled) {
                    return summary.isUpdating();
                }
                return false;
            }

            @Override
            public boolean canManuallyUpdate() {
                StatusSummary summary = this.fixup();
                if (summary == null) {
                    return false;
                }
                return summary.canManuallyUpdate();
            }

            @Override
            public void manualUpdate() {
                StatusSummary summary = this.fixup();
                if (summary != null) {
                    summary.manualUpdate();
                }
            }

            @Override
            public boolean canDelete() {
                return false;
            }

            @Override
            public void delete() {
                Debug.out("derp");
            }
        };
    }

    @Override
    public void generateEvidence(IndentWriter writer) {
        for (TRTrackerAnnouncer tRTrackerAnnouncer : this.announcers) {
            tRTrackerAnnouncer.generateEvidence(writer);
        }
    }

    private static class StatusSummary {
        private TRTrackerAnnouncerHelper helper;
        private long time;
        private URL url;
        private int status;
        private String status_str;
        private int seeds = -1;
        private int leechers = -1;
        private int peers = -1;
        private int completed = -1;
        private int interval;
        private int min_interval;

        protected StatusSummary(TRTrackerAnnouncerHelper _helper, URL _url) {
            this.helper = _helper;
            this.url = _url;
            this.status = 3;
        }

        protected void setHelper(TRTrackerAnnouncerHelper _helper) {
            this.helper = _helper;
        }

        protected void updateFrom(TRTrackerAnnouncerResponse response) {
            this.time = SystemTime.getMonotonousTime();
            int state = response.getStatus();
            if (state == 2) {
                this.status = 5;
                this.seeds = response.getScrapeCompleteCount();
                this.leechers = response.getScrapeIncompleteCount();
                this.completed = response.getScrapeDownloadedCount();
                this.peers = response.getPeers().length;
            } else {
                this.status = 6;
            }
            this.status_str = response.getStatusString();
            this.interval = (int)this.helper.getInterval();
            this.min_interval = (int)this.helper.getMinInterval();
        }

        public long getTime() {
            return this.time;
        }

        public URL getURL() {
            return this.url;
        }

        public int getStatus() {
            return this.status;
        }

        public String getStatusString() {
            return this.status_str;
        }

        public int getSeedCount() {
            return this.seeds;
        }

        public int getLeecherCount() {
            return this.leechers;
        }

        public int getCompletedCount() {
            return this.completed;
        }

        public int getPeers() {
            return this.peers;
        }

        public boolean isUpdating() {
            return this.helper.isUpdating();
        }

        public int getInterval() {
            return this.interval;
        }

        public int getMinInterval() {
            return this.min_interval;
        }

        public int getSecondsToUpdate() {
            return this.helper.getTimeUntilNextUpdate();
        }

        public boolean canManuallyUpdate() {
            return SystemTime.getCurrentTime() / 1000L - (long)this.helper.getLastUpdateTime() >= 60L;
        }

        public void manualUpdate() {
            this.helper.update(true);
        }
    }
}

