/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.util.SystemTime;

public class BannedIpImpl
implements BannedIp {
    protected long time;
    protected String torrent_name;
    protected String ip;

    protected BannedIpImpl(String _ip, String _torrent_name, boolean _temporary) {
        this.ip = _ip;
        this.torrent_name = _torrent_name;
        this.time = SystemTime.getCurrentTime();
        if (_temporary) {
            this.time = -this.time;
        }
    }

    protected BannedIpImpl(String _ip, String _torrent_name, long _time) {
        this.ip = _ip;
        this.torrent_name = _torrent_name;
        this.time = _time;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    public boolean isTemporary() {
        return this.time < 0L;
    }

    @Override
    public long getBanningTime() {
        return Math.abs(this.time);
    }

    @Override
    public String getTorrentName() {
        return this.torrent_name;
    }
}

