/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipchecker.natchecker;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipchecker.natchecker.NatCheckerServer;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public class NatChecker {
    private static final LogIDs LOGID = LogIDs.NET;
    public static final int NAT_OK = 1;
    public static final int NAT_KO = 2;
    public static final int NAT_UNABLE = 3;
    private int result;
    private String additional_info;
    private InetAddress ip_address;

    public NatChecker(AzureusCore azureus_core, InetAddress bind_ip, int port, boolean http_test) {
        block31: {
            NatCheckerServer server;
            this.additional_info = "";
            String check = "azureus_rand_" + String.valueOf(RandomUtils.nextInt(100000));
            if (port < 0 || port > 65535 || port == Constants.INSTANCE_PORT) {
                this.result = 3;
                this.additional_info = "Invalid port";
                return;
            }
            try {
                server = new NatCheckerServer(bind_ip, port, check, http_test);
            }
            catch (Throwable e) {
                this.result = 3;
                this.additional_info = "Can't initialise server: " + Debug.getNestedExceptionMessage(e);
                return;
            }
            PluginInterface pi_upnp = azureus_core.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
            UPnPMapping new_mapping = null;
            String upnp_str = null;
            if (pi_upnp != null) {
                UPnPPluginService[] services;
                UPnPPlugin upnp = (UPnPPlugin)pi_upnp.getPlugin();
                UPnPMapping mapping = upnp.getMapping(true, port);
                if (mapping == null) {
                    new_mapping = mapping = upnp.addMapping("NAT Tester", true, port, true);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                if ((services = upnp.getServices()).length > 0) {
                    upnp_str = "";
                    int i = 0;
                    while (i < services.length) {
                        UPnPPluginService service = services[i];
                        upnp_str = String.valueOf(upnp_str) + (i == 0 ? "" : ",") + service.getInfo();
                        ++i;
                    }
                }
            }
            try {
                try {
                    int len;
                    server.start();
                    String urlStr = "http://nettest.vuze.com/" + (http_test ? "httptest" : "nattest") + "?port=" + String.valueOf(port) + "&check=" + check;
                    if (upnp_str != null) {
                        urlStr = String.valueOf(urlStr) + "&upnp=" + URLEncoder.encode(upnp_str, "UTF8");
                    }
                    NetworkAdminASN net_asn = NetworkAdmin.getSingleton().getCurrentASN();
                    String as = net_asn.getAS();
                    String asn = net_asn.getASName();
                    if (as.length() > 0) {
                        urlStr = String.valueOf(urlStr) + "&as=" + URLEncoder.encode(as, "UTF8");
                        urlStr = String.valueOf(urlStr) + "&asn=" + URLEncoder.encode(asn, "UTF8");
                    }
                    urlStr = String.valueOf(urlStr) + "&locale=" + MessageText.getCurrentLocale().toString();
                    String ip_override = TRTrackerUtils.getPublicIPOverride();
                    if (ip_override != null) {
                        urlStr = String.valueOf(urlStr) + "&ip=" + ip_override;
                    }
                    URL url = new URL(urlStr);
                    Properties http_properties = new Properties();
                    http_properties.put("URL", url);
                    http_properties.put("Raw-Request", (Object)true);
                    try {
                        ClientIDManagerImpl.getSingleton().generateHTTPProperties(null, http_properties);
                    }
                    catch (ClientIDException e) {
                        throw new IOException(e.getMessage());
                    }
                    url = (URL)http_properties.get("URL");
                    HttpURLConnection con = (HttpURLConnection)url.openConnection();
                    con.connect();
                    ByteArrayOutputStream message = new ByteArrayOutputStream();
                    InputStream is = con.getInputStream();
                    byte[] data = new byte[1024];
                    int expected_length = -1;
                    while ((len = is.read(data)) > 0) {
                        message.write(data, 0, len);
                        if (expected_length == -1 && message.size() >= 4) {
                            byte[] bytes = message.toByteArray();
                            ByteBuffer bb = ByteBuffer.wrap(bytes);
                            expected_length = bb.getInt();
                            message = new ByteArrayOutputStream();
                            if (bytes.length > 4) {
                                message.write(bytes, 4, bytes.length - 4);
                            }
                        }
                        if (expected_length == -1 || message.size() != expected_length) continue;
                    }
                    Map<String, Object> map = BDecoder.decode(message.toByteArray());
                    int reply_result = ((Long)map.get("result")).intValue();
                    switch (reply_result) {
                        case 0: {
                            byte[] reason = (byte[])map.get("reason");
                            if (reason != null) {
                                Logger.log(new LogEvent(LOGID, 3, "NAT CHECK FAILED: " + new String(reason)));
                            }
                            this.result = 2;
                            this.additional_info = reason == null ? "Unknown" : new String(reason, "UTF8");
                            break;
                        }
                        case 1: {
                            this.result = 1;
                            byte[] reply = (byte[])map.get("reply");
                            if (reply == null) break;
                            this.additional_info = new String(reply, "UTF8");
                            break;
                        }
                        default: {
                            this.result = 3;
                            this.additional_info = "Invalid response";
                        }
                    }
                    byte[] ip_bytes = (byte[])map.get("ip_address");
                    if (ip_bytes == null) break block31;
                    try {
                        this.ip_address = InetAddress.getByAddress(ip_bytes);
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (Exception e) {
                    this.result = 3;
                    this.additional_info = "Error: " + Debug.getNestedExceptionMessage(e);
                    server.stopIt();
                    if (new_mapping != null) {
                        new_mapping.destroy();
                    }
                }
            }
            finally {
                server.stopIt();
                if (new_mapping != null) {
                    new_mapping.destroy();
                }
            }
        }
    }

    public int getResult() {
        return this.result;
    }

    public InetAddress getExternalAddress() {
        return this.ip_address;
    }

    public String getAdditionalInfo() {
        return this.additional_info;
    }
}

