/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.io.File;
import java.io.UnsupportedEncodingException;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.SHA1Hasher;

public class LocaleUtilDecoderFallback
implements LocaleUtilDecoder {
    public static String NAME = "Fallback";
    private static volatile int max_ok_name_length = 64;
    private static volatile boolean max_ok_name_length_determined;
    private static final String VALID_CHARS = "abcdefghijklmnopqrstuvwxyz1234567890_-.";
    private int index;

    protected LocaleUtilDecoderFallback(int _index) {
        this.index = _index;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String tryDecode(byte[] bytes, boolean lax) {
        return this.decode(bytes);
    }

    @Override
    public String decodeString(byte[] bytes) throws UnsupportedEncodingException {
        return this.decode(bytes);
    }

    protected String decode(byte[] data) {
        if (data == null) {
            return null;
        }
        StringBuffer res = new StringBuffer(data.length * 2);
        int i = 0;
        while (i < data.length) {
            byte c = data[i];
            if (VALID_CHARS.indexOf(Character.toLowerCase((char)c)) != -1) {
                res.append((char)c);
            } else {
                res.append("_");
                res.append(ByteFormatter.nicePrint(c));
            }
            ++i;
        }
        int len = res.length();
        if (len > max_ok_name_length) {
            if (!max_ok_name_length_determined && this.fileLengthOK(len)) {
                max_ok_name_length = len;
            } else {
                if (!max_ok_name_length_determined) {
                    int i2 = max_ok_name_length + 16;
                    while (i2 < len) {
                        if (!this.fileLengthOK(i2)) break;
                        max_ok_name_length = i2;
                        i2 += 16;
                    }
                    max_ok_name_length_determined = true;
                }
                String extension = null;
                int pos = res.lastIndexOf(".");
                if (pos != -1 && ((extension = res.substring(pos)).length() == 1 || extension.length() > 4)) {
                    extension = null;
                }
                byte[] hash = new SHA1Hasher().calculateHash(data);
                String hash_str = ByteFormatter.nicePrint(hash, true);
                res = new StringBuffer(res.substring(0, max_ok_name_length - hash_str.length() - (extension == null ? 0 : extension.length())));
                res.append(hash_str);
                if (extension != null) {
                    res.append(extension);
                }
            }
        }
        return res.toString();
    }

    protected boolean fileLengthOK(int len) {
        StringBuffer n = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            n.append("A");
            ++i;
        }
        try {
            File f = File.createTempFile(n.toString(), "");
            f.delete();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

