/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderCandidate;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderFallback;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderReal;
import org.gudy.azureus2.core3.util.Debug;

public class LocaleUtil {
    private static final String systemEncoding = System.getProperty("file.encoding");
    private static final String[] manual_charset = new String[]{systemEncoding, "Big5", "EUC-JP", "EUC-KR", "GB18030", "GB2312", "GBK", "ISO-2022-JP", "ISO-2022-KR", "Shift_JIS", "KOI8-R", "TIS-620", "UTF8", "windows-1251", "ISO-8859-1"};
    protected static final String[] generalCharsets = new String[]{"ISO-8859-1", "UTF8", systemEncoding};
    private static LocaleUtil singleton = new LocaleUtil();
    private LocaleUtilDecoder[] all_decoders;
    private LocaleUtilDecoder[] general_decoders;
    private LocaleUtilDecoder system_decoder;
    private LocaleUtilDecoder fallback_decoder;

    public static LocaleUtil getSingleton() {
        return singleton;
    }

    private LocaleUtil() {
        ArrayList<LocaleUtilDecoder> decoders = new ArrayList<LocaleUtilDecoder>();
        ArrayList<String> decoder_names = new ArrayList<String>();
        int i = 0;
        while (i < manual_charset.length) {
            try {
                String name = manual_charset[i];
                CharsetDecoder decoder = Charset.forName(name).newDecoder();
                if (decoder != null) {
                    LocaleUtilDecoderReal lu_decoder = new LocaleUtilDecoderReal(decoders.size(), decoder);
                    decoder_names.add(lu_decoder.getName());
                    if (i == 0) {
                        this.system_decoder = lu_decoder;
                    }
                    decoders.add(lu_decoder);
                } else if (i == 0) {
                    Debug.out("System decoder failed to be found!!!!");
                }
            }
            catch (Exception name) {
                // empty catch block
            }
            ++i;
        }
        this.general_decoders = new LocaleUtilDecoder[generalCharsets.length];
        i = 0;
        while (i < this.general_decoders.length) {
            int gi = decoder_names.indexOf(generalCharsets[i]);
            if (gi != -1) {
                this.general_decoders[i] = (LocaleUtilDecoder)decoders.get(gi);
            }
            ++i;
        }
        boolean show_all = COConfigurationManager.getBooleanParameter("File.Decoder.ShowAll");
        if (show_all) {
            SortedMap<String, Charset> m = Charset.availableCharsets();
            for (String charset_name : m.keySet()) {
                if (decoder_names.contains(charset_name)) continue;
                try {
                    CharsetDecoder decoder = Charset.forName(charset_name).newDecoder();
                    if (decoder == null) continue;
                    LocaleUtilDecoderReal lu_decoder = new LocaleUtilDecoderReal(decoders.size(), decoder);
                    decoders.add(lu_decoder);
                    decoder_names.add(lu_decoder.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.fallback_decoder = new LocaleUtilDecoderFallback(decoders.size());
        decoders.add(this.fallback_decoder);
        this.all_decoders = new LocaleUtilDecoder[decoders.size()];
        decoders.toArray(this.all_decoders);
    }

    public String getSystemEncoding() {
        return systemEncoding;
    }

    public LocaleUtilDecoder[] getDecoders() {
        return this.all_decoders;
    }

    public LocaleUtilDecoder[] getGeneralDecoders() {
        return this.general_decoders;
    }

    public LocaleUtilDecoder getFallBackDecoder() {
        return this.fallback_decoder;
    }

    public LocaleUtilDecoder getSystemDecoder() {
        return this.system_decoder;
    }

    protected LocaleUtilDecoderCandidate[] getCandidates(byte[] array) {
        LocaleUtilDecoderCandidate[] candidates = new LocaleUtilDecoderCandidate[this.all_decoders.length];
        boolean show_less_likely_conversions = COConfigurationManager.getBooleanParameter("File.Decoder.ShowLax");
        int i = 0;
        while (i < this.all_decoders.length) {
            candidates[i] = new LocaleUtilDecoderCandidate(i);
            try {
                LocaleUtilDecoder decoder = this.all_decoders[i];
                String str = decoder.tryDecode(array, show_less_likely_conversions);
                if (str != null) {
                    candidates[i].setDetails(decoder, str);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return candidates;
    }

    protected List getCandidateDecoders(byte[] array) {
        LocaleUtilDecoderCandidate[] candidates = this.getCandidates(array);
        ArrayList<LocaleUtilDecoder> decoders = new ArrayList<LocaleUtilDecoder>();
        int i = 0;
        while (i < candidates.length) {
            LocaleUtilDecoder d = candidates[i].getDecoder();
            if (d != null) {
                decoders.add(d);
            }
            ++i;
        }
        return decoders;
    }

    protected List getCandidatesAsList(byte[] array) {
        LocaleUtilDecoderCandidate[] candidates = this.getCandidates(array);
        ArrayList<LocaleUtilDecoderCandidate> candidatesList = new ArrayList<LocaleUtilDecoderCandidate>();
        int i = 0;
        while (i < candidates.length) {
            if (candidates[i].getDecoder() != null) {
                candidatesList.add(candidates[i]);
            }
            ++i;
        }
        return candidatesList;
    }
}

