/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class HelpFormatter {
    public static final int DEFAULT_WIDTH = 74;
    public static final int DEFAULT_LEFT_PAD = 1;
    public static final int DEFAULT_DESC_PAD = 3;
    public static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    public static final String DEFAULT_OPT_PREFIX = "-";
    public static final String DEFAULT_LONG_OPT_PREFIX = "--";
    public static final String DEFAULT_ARG_NAME = "arg";
    public int defaultWidth = 74;
    public int defaultLeftPad = 1;
    public int defaultDescPad = 3;
    public String defaultSyntaxPrefix = "usage: ";
    public String defaultNewLine = System.getProperty("line.separator");
    public String defaultOptPrefix = "-";
    public String defaultLongOptPrefix = "--";
    public String defaultArgName = "arg";

    public void printHelp(String cmdLineSyntax, Options options) {
        this.printHelp(this.defaultWidth, cmdLineSyntax, null, options, null, false);
    }

    public void printHelp(String cmdLineSyntax, Options options, boolean autoUsage) {
        this.printHelp(this.defaultWidth, cmdLineSyntax, null, options, null, autoUsage);
    }

    public void printHelp(String cmdLineSyntax, String header, Options options, String footer) {
        this.printHelp(cmdLineSyntax, header, options, footer, false);
    }

    public void printHelp(String cmdLineSyntax, String header, Options options, String footer, boolean autoUsage) {
        this.printHelp(this.defaultWidth, cmdLineSyntax, header, options, footer, autoUsage);
    }

    public void printHelp(int width, String cmdLineSyntax, String header, Options options, String footer) {
        this.printHelp(width, cmdLineSyntax, header, options, footer, false);
    }

    public void printHelp(int width, String cmdLineSyntax, String header, Options options, String footer, boolean autoUsage) {
        PrintWriter pw = new PrintWriter(System.out);
        this.printHelp(pw, width, cmdLineSyntax, header, options, this.defaultLeftPad, this.defaultDescPad, footer, autoUsage);
        pw.flush();
    }

    public void printHelp(PrintWriter pw, int width, String cmdLineSyntax, String header, Options options, int leftPad, int descPad, String footer) throws IllegalArgumentException {
        this.printHelp(pw, width, cmdLineSyntax, header, options, leftPad, descPad, footer, false);
    }

    public void printHelp(PrintWriter pw, int width, String cmdLineSyntax, String header, Options options, int leftPad, int descPad, String footer, boolean autoUsage) throws IllegalArgumentException {
        if (cmdLineSyntax == null || cmdLineSyntax.length() == 0) {
            throw new IllegalArgumentException("cmdLineSyntax not provided");
        }
        if (autoUsage) {
            this.printUsage(pw, width, cmdLineSyntax, options);
        } else {
            this.printUsage(pw, width, cmdLineSyntax);
        }
        if (header != null && header.trim().length() > 0) {
            this.printWrapped(pw, width, header);
        }
        this.printOptions(pw, width, options, leftPad, descPad);
        if (footer != null && footer.trim().length() > 0) {
            this.printWrapped(pw, width, footer);
        }
    }

    public void printUsage(PrintWriter pw, int width, String app, Options options) {
        StringBuffer buff = new StringBuffer(this.defaultSyntaxPrefix).append(app).append(" ");
        ArrayList<OptionGroup> list = new ArrayList<OptionGroup>();
        for (Option option : options.getOptions()) {
            OptionGroup group = options.getOptionGroup(option);
            if (group != null && !list.contains(group)) {
                list.add(group);
                Collection names = group.getNames();
                buff.append("[");
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    buff.append(iter.next());
                    if (!iter.hasNext()) continue;
                    buff.append(" | ");
                }
                buff.append("]");
                continue;
            }
            if (!option.isRequired()) {
                buff.append("[");
            }
            if (!" ".equals(option.getOpt())) {
                buff.append(DEFAULT_OPT_PREFIX).append(option.getOpt());
            } else {
                buff.append(DEFAULT_LONG_OPT_PREFIX).append(option.getLongOpt());
            }
            if (option.hasArg()) {
                buff.append(" ");
            }
            if (option.hasArg()) {
                buff.append(option.getArgName());
            }
            if (!option.isRequired()) {
                buff.append("]");
            }
            buff.append(" ");
        }
        this.printWrapped(pw, width, buff.toString().indexOf(32) + 1, buff.toString());
    }

    public void printUsage(PrintWriter pw, int width, String cmdLineSyntax) {
        int argPos = cmdLineSyntax.indexOf(32) + 1;
        this.printWrapped(pw, width, this.defaultSyntaxPrefix.length() + argPos, String.valueOf(this.defaultSyntaxPrefix) + cmdLineSyntax);
    }

    public void printOptions(PrintWriter pw, int width, Options options, int leftPad, int descPad) {
        StringBuffer sb = new StringBuffer();
        this.renderOptions(sb, width, options, leftPad, descPad);
        pw.println(sb.toString());
    }

    public void printWrapped(PrintWriter pw, int width, String text) {
        this.printWrapped(pw, width, 0, text);
    }

    public void printWrapped(PrintWriter pw, int width, int nextLineTabStop, String text) {
        StringBuffer sb = new StringBuffer(text.length());
        this.renderWrappedText(sb, width, nextLineTabStop, text);
        pw.println(sb.toString());
    }

    protected StringBuffer renderOptions(StringBuffer sb, int width, Options options, int leftPad, int descPad) {
        StringBuffer optBuf;
        String lpad = this.createPadding(leftPad);
        String dpad = this.createPadding(descPad);
        int max = 0;
        ArrayList<StringBuffer> prefixList = new ArrayList<StringBuffer>();
        List optList = options.helpOptions();
        Collections.sort(optList, new StringBufferComparator());
        for (Option option : optList) {
            optBuf = new StringBuffer(8);
            if (option.getOpt().equals(" ")) {
                optBuf.append(lpad).append("   " + this.defaultLongOptPrefix).append(option.getLongOpt());
            } else {
                optBuf.append(lpad).append(this.defaultOptPrefix).append(option.getOpt());
                if (option.hasLongOpt()) {
                    optBuf.append(',').append(this.defaultLongOptPrefix).append(option.getLongOpt());
                }
            }
            if (option.hasArg()) {
                if (option.hasArgName()) {
                    optBuf.append(" <").append(option.getArgName()).append('>');
                } else {
                    optBuf.append(' ');
                }
            }
            prefixList.add(optBuf);
            int n = max = optBuf.length() > max ? optBuf.length() : max;
        }
        int x = 0;
        Iterator i = optList.iterator();
        while (i.hasNext()) {
            Option option;
            option = (Option)i.next();
            if ((optBuf = new StringBuffer(prefixList.get(x++).toString())).length() < max) {
                optBuf.append(this.createPadding(max - optBuf.length()));
            }
            optBuf.append(dpad);
            int nextLineTabStop = max + descPad;
            this.renderWrappedText(sb, width, nextLineTabStop, optBuf.append(option.getDescription()).toString());
            if (!i.hasNext()) continue;
            sb.append(this.defaultNewLine);
        }
        return sb;
    }

    protected StringBuffer renderWrappedText(StringBuffer sb, int width, int nextLineTabStop, String text) {
        int pos = this.findWrapPos(text, width, 0);
        if (pos == -1) {
            sb.append(this.rtrim(text));
            return sb;
        }
        sb.append(this.rtrim(text.substring(0, pos))).append(this.defaultNewLine);
        String padding = this.createPadding(nextLineTabStop);
        while (true) {
            if ((pos = this.findWrapPos(text = String.valueOf(padding) + text.substring(pos).trim(), width, nextLineTabStop)) == -1) {
                sb.append(text);
                return sb;
            }
            sb.append(this.rtrim(text.substring(0, pos))).append(this.defaultNewLine);
        }
    }

    protected int findWrapPos(String text, int width, int startPos) {
        char c;
        int pos = -1;
        pos = text.indexOf(10, startPos);
        if (pos != -1 && pos <= width || (pos = text.indexOf(9, startPos)) != -1 && pos <= width) {
            return pos;
        }
        if (startPos + width >= text.length()) {
            return -1;
        }
        pos = startPos + width;
        while (pos >= startPos && (c = text.charAt(pos)) != ' ' && c != '\n' && c != '\r') {
            --pos;
        }
        if (pos > startPos) {
            return pos;
        }
        pos = startPos + width;
        while (pos <= text.length() && (c = text.charAt(pos)) != ' ' && c != '\n' && c != '\r') {
            ++pos;
        }
        return pos == text.length() ? -1 : pos;
    }

    protected String createPadding(int len) {
        StringBuffer sb = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    protected String rtrim(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        int pos = s.length();
        while (pos >= 0 && Character.isWhitespace(s.charAt(pos - 1))) {
            --pos;
        }
        return s.substring(0, pos);
    }

    private static class StringBufferComparator
    implements Comparator {
        private StringBufferComparator() {
        }

        public int compare(Object o1, Object o2) {
            String str1 = this.stripPrefix(o1.toString());
            String str2 = this.stripPrefix(o2.toString());
            return str1.compareTo(str2);
        }

        private String stripPrefix(String strOption) {
            int iStartIndex = strOption.lastIndexOf(45);
            if (iStartIndex == -1) {
                iStartIndex = 0;
            }
            return strOption.substring(iStartIndex);
        }
    }
}

