/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.utils;

import java.util.Arrays;
import lbms.plugins.mldht.kad.RPCCallBase;
import lbms.plugins.mldht.kad.RPCCallListener;
import lbms.plugins.mldht.kad.messages.MessageBase;

public class ResponseTimeoutFilter {
    public static final int NUM_SAMPLES = 256;
    public static final int QUANTILE_INDEX = 230;
    final long[] rttRingbuffer = new long[256];
    int bufferIndex;
    long targetTimeoutMillis;

    public ResponseTimeoutFilter() {
        this.reset();
    }

    public void reset() {
        this.targetTimeoutMillis = 10000L;
        Arrays.fill(this.rttRingbuffer, 10000L);
    }

    public void registerCall(RPCCallBase call) {
        call.addListener(new RPCCallListener(){

            @Override
            public void onTimeout(RPCCallBase c) {
            }

            @Override
            public void onStall(RPCCallBase c) {
            }

            @Override
            public void onResponse(RPCCallBase c, MessageBase rsp) {
                ResponseTimeoutFilter.this.update(c.getRTT());
            }
        });
    }

    private void update(long newRTT) {
        this.rttRingbuffer[this.bufferIndex++] = newRTT;
        this.bufferIndex %= 256;
        if ((this.bufferIndex & 0xF) == 0) {
            long[] sortableBuffer = (long[])this.rttRingbuffer.clone();
            Arrays.sort(sortableBuffer);
            this.targetTimeoutMillis = sortableBuffer[230];
        }
    }

    public long getStallTimeout() {
        long timeout = Math.max(1000L, this.targetTimeoutMillis);
        return timeout;
    }
}

