/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.utils;

import java.util.Arrays;

public final class BitVector {
    private final byte[] vector;
    private final int bits;

    public BitVector(BitVector toCopy) {
        this.bits = toCopy.bits;
        this.vector = (byte[])toCopy.vector.clone();
    }

    public BitVector(int numBits, byte[] rawData) {
        if (numBits > rawData.length * 8) {
            throw new IllegalArgumentException("raw data array too small to represent the requested number of bits");
        }
        this.bits = numBits;
        this.vector = (byte[])rawData.clone();
    }

    public BitVector(int numberOfBits) {
        this.bits = numberOfBits;
        this.vector = new byte[numberOfBits / 8 + (numberOfBits % 8 != 0 ? 1 : 0)];
    }

    public void set(int n) {
        int n2 = n / 8;
        this.vector[n2] = (byte)(this.vector[n2] | 1 << n % 8);
    }

    public boolean get(int n) {
        return (this.vector[n / 8] & 1 << n % 8) != 0;
    }

    public int rangeToInt(int bitOffset, int numOfBits) {
        int result = 0;
        int baseShift = numOfBits - 8 + bitOffset % 8;
        int byteIdx = bitOffset / 8;
        while (baseShift >= 0) {
            result |= this.vector[byteIdx] << baseShift;
            ++byteIdx;
            baseShift -= 8;
        }
        if (baseShift < 0) {
            result |= this.vector[byteIdx] >>> Math.abs(baseShift);
        }
        return result &= -1 >>> 32 - numOfBits;
    }

    public int size() {
        return this.bits;
    }

    public void clear() {
        Arrays.fill(this.vector, (byte)0);
    }

    public int bitcount() {
        int c = 0;
        int i = 0;
        while (i < this.bits) {
            if ((this.vector[i / 8] & 1 << i % 8) != 0) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    public static int unionAndCount(BitVector ... vectors) {
        if (vectors.length == 0) {
            return 0;
        }
        int c = 0;
        int bits = vectors[0].size();
        int union = 0;
        int i = 0;
        while (i < bits) {
            if (i % 8 == 0) {
                int idx = i / 8;
                union = 0;
                BitVector[] bitVectorArray = vectors;
                int n = vectors.length;
                int n2 = 0;
                while (n2 < n) {
                    BitVector v = bitVectorArray[n2];
                    union = (byte)(union | v.vector[idx]);
                    ++n2;
                }
            }
            if ((union & 1 << i % 8) != 0) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(2 * this.bits / 8);
        int i = 0;
        while (i < this.vector.length) {
            int nibble;
            if (i % 4 == 0 && i > 0) {
                b.append(' ');
            }
            b.append((char)((nibble = (this.vector[i] & 0xF0) >> 4) < 10 ? 48 + nibble : 65 + nibble - 10));
            nibble = this.vector[i] & 0xF;
            b.append((char)(nibble < 10 ? 48 + nibble : 65 + nibble - 10));
            ++i;
        }
        return b.toString();
    }

    public static int intersectAndCount(BitVector ... vectors) {
        int c = 0;
        int bits = vectors[0].size();
        int intersection = 0;
        int i = 0;
        while (i < bits) {
            if (i % 8 == 0) {
                int idx = i / 8;
                intersection = -1;
                BitVector[] bitVectorArray = vectors;
                int n = vectors.length;
                int n2 = 0;
                while (n2 < n) {
                    BitVector v = bitVectorArray[n2];
                    intersection = (byte)(intersection & v.vector[idx]);
                    ++n2;
                }
            }
            if ((intersection & 1 << i % 8) != 0) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    public byte[] getSerializedFormat() {
        return (byte[])this.vector.clone();
    }

    public static void main(String[] args) {
        BitVector bv = new BitVector(40, new byte[]{-16, -1, -1, -1, -1, -1, -1, -1, -1});
        System.out.println(bv.rangeToInt(7, 2));
    }
}

