/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad;

import java.util.Collection;
import java.util.Collections;
import lbms.plugins.mldht.kad.Key;

public class Prefix
extends Key {
    int depth = -1;

    public Prefix() {
    }

    public Prefix(Prefix p) {
        super(p);
        this.depth = p.depth;
    }

    public boolean isPrefixOf(Key k) {
        return Prefix.bitsEqual(this, k, this.depth);
    }

    public Prefix splitPrefixBranch(boolean highBranch) {
        Prefix branch = new Prefix(this);
        int branchDepdth = ++branch.depth;
        if (highBranch) {
            int n = branchDepdth / 8;
            branch.hash[n] = (byte)(branch.hash[n] | 128 >> branchDepdth % 8);
        } else {
            int n = branchDepdth / 8;
            branch.hash[n] = (byte)(branch.hash[n] & ~(128 >> branchDepdth % 8));
        }
        return branch;
    }

    public Prefix getParentPrefix() {
        if (this.depth == -1) {
            return this;
        }
        Prefix parent = new Prefix(this);
        int oldDepth = parent.depth--;
        int n = oldDepth / 8;
        parent.hash[n] = (byte)(parent.hash[n] & ~(128 >> oldDepth % 8));
        return parent;
    }

    public boolean isSiblingOf(Prefix otherPrefix) {
        if (this.depth != otherPrefix.depth) {
            return false;
        }
        return Prefix.bitsEqual(this, otherPrefix, this.depth - 1);
    }

    private static boolean bitsEqual(Key k1, Key k2, int n) {
        if (n < 0) {
            return true;
        }
        int i = 0;
        while (i < n / 8) {
            if (k1.hash[i] != k2.hash[i]) {
                return false;
            }
            ++i;
        }
        int mask = 65408 >> n % 8 & 0xFF;
        return (k1.hash[n / 8] & mask) == (k2.hash[n / 8] & mask);
    }

    private static void copyBits(Key source, Key destination, int depth) {
        if (depth < 0) {
            return;
        }
        byte[] data = destination.hash;
        int i = 0;
        while (i < depth / 8) {
            data[i] = source.hash[i];
            ++i;
        }
        int idx = depth / 8;
        int mask = 65408 >> depth % 8;
        int n = idx;
        data[n] = (byte)(data[n] & ~mask);
        int n2 = idx;
        data[n2] = (byte)(data[n2] | source.hash[idx] & mask);
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public String toString() {
        if (this.depth == -1) {
            return "all";
        }
        StringBuilder builder = new StringBuilder(20);
        int i = 0;
        while (i <= this.depth) {
            builder.append((this.hash[i / 8] & 128 >> i % 8) != 0 ? (char)'1' : '0');
            ++i;
        }
        builder.append("...");
        return builder.toString();
    }

    public Key createRandomKeyFromPrefix() {
        Key key = Key.createRandomKey();
        Prefix.copyBits(this, key, this.depth);
        return key;
    }

    public static Prefix getCommonPrefix(Collection<Key> keys) {
        Key first = Collections.min(keys);
        Key last = Collections.max(keys);
        Prefix prefix = new Prefix();
        byte[] newHash = prefix.hash;
        int i = 0;
        block0: while (i < 20) {
            if (first.hash[i] == last.hash[i]) {
                newHash[i] = first.hash[i];
                prefix.depth += 8;
            } else {
                newHash[i] = (byte)(first.hash[i] & last.hash[i]);
                int j = 0;
                while (j < 8) {
                    int mask = 128 >> j;
                    if (((first.hash[i] ^ last.hash[i]) & mask) != 0) {
                        newHash[i] = (byte)(newHash[i] & ~(255 >> j));
                        break block0;
                    }
                    ++prefix.depth;
                    ++j;
                }
            }
            ++i;
        }
        return prefix;
    }

    public static void main(String[] args) {
        Prefix p = new Prefix();
        p.hash[0] = 48;
        p.depth = 3;
        Key k = new Key();
        k.hash[0] = 55;
        System.out.println(p);
        System.out.println(p.isPrefixOf(k));
    }
}

