/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.KBucket;
import lbms.plugins.mldht.kad.KBucketEntry;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.Node;
import lbms.plugins.mldht.kad.RPCServer;
import lbms.plugins.mldht.kad.utils.PackUtil;

public class KClosestNodesSearch {
    private Key targetKey;
    private List<KBucketEntry> entries;
    private int max_entries;
    private DHT owner;
    private Comparator<KBucketEntry> comp;

    public KClosestNodesSearch(Key key, int max_entries, DHT owner) {
        this.targetKey = key;
        this.owner = owner;
        this.max_entries = max_entries;
        this.comp = new KBucketEntry.DistanceOrder(key);
        this.entries = new ArrayList<KBucketEntry>(max_entries + 8);
    }

    public Key getSearchTarget() {
        return this.targetKey;
    }

    public int getNumEntries() {
        return this.entries.size();
    }

    public void fill() {
        this.fill(false);
    }

    private boolean insertBucket(KBucket bucket) {
        Key farthest = this.entries.size() > 0 ? this.entries.get(this.entries.size() - 1).getID() : null;
        List<KBucketEntry> bucketEntries = bucket.getEntries();
        int i = 0;
        int n = bucketEntries.size();
        while (i < n) {
            KBucketEntry e = bucketEntries.get(i);
            if (!e.isBad()) {
                this.entries.add(e);
            }
            ++i;
        }
        Collections.sort(this.entries, this.comp);
        i = this.entries.size() - 1;
        while (i >= this.max_entries) {
            this.entries.remove(i);
            --i;
        }
        return this.entries.size() > 0 && farthest == this.entries.get(this.entries.size() - 1).getID();
    }

    public void fill(boolean includeOurself) {
        RPCServer srv;
        boolean reachedMin;
        List<Node.RoutingTableEntry> table = this.owner.getNode().getBuckets();
        int center = Node.findIdxForId(table, this.targetKey);
        boolean reachedMax = reachedMin = this.insertBucket(table.get(center).getBucket());
        int i = 1;
        while (!reachedMax && !reachedMin) {
            reachedMin = reachedMin || center - i < 0 || this.insertBucket(table.get(center - i).getBucket());
            reachedMax = reachedMax || center + i >= table.size() || this.insertBucket(table.get(center + i).getBucket());
            ++i;
        }
        if (includeOurself && (srv = this.owner.getRandomServer()) != null && srv.getPublicAddress() != null && this.entries.size() < this.max_entries) {
            InetSocketAddress sockAddr = new InetSocketAddress(srv.getPublicAddress(), srv.getPort());
            this.entries.add(new KBucketEntry(sockAddr, srv.getDerivedID()));
        }
    }

    public boolean isFull() {
        return this.entries.size() >= this.max_entries;
    }

    public byte[] pack() {
        if (this.entries.size() == 0) {
            return null;
        }
        int entryLength = this.owner.getType().NODES_ENTRY_LENGTH;
        byte[] buffer = new byte[this.entries.size() * entryLength];
        int max_items = buffer.length / 26;
        int j = 0;
        for (KBucketEntry e : this.entries) {
            if (j >= max_items) break;
            PackUtil.PackBucketEntry(e, buffer, j * entryLength, this.owner.getType());
            ++j;
        }
        return buffer;
    }

    public List<KBucketEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }
}

