/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad;

import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import lbms.plugins.mldht.kad.utils.BitVector;

public class BloomFilterBEP33
implements Comparable<BloomFilterBEP33>,
Cloneable {
    private static final int m = 2048;
    private static final int k = 2;
    MessageDigest sha1;
    BitVector filter;

    public BloomFilterBEP33() {
        this.filter = new BitVector(2048);
        try {
            this.sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public BloomFilterBEP33(byte[] serializedFilter) {
        this.filter = new BitVector(2048, serializedFilter);
    }

    public void insert(InetAddress addr) {
        byte[] hash = this.sha1.digest(addr.getAddress());
        int index1 = hash[0] & 0xFF | (hash[1] & 0xFF) << 8;
        int index2 = hash[2] & 0xFF | (hash[3] & 0xFF) << 8;
        this.filter.set(index1 %= 2048);
        this.filter.set(index2 %= 2048);
    }

    protected BloomFilterBEP33 clone() {
        BloomFilterBEP33 newFilter = null;
        try {
            newFilter = (BloomFilterBEP33)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        newFilter.filter = new BitVector(this.filter);
        return newFilter;
    }

    @Override
    public int compareTo(BloomFilterBEP33 o) {
        return this.size() - o.size();
    }

    public int size() {
        double c = this.filter.bitcount();
        double size = Math.log1p(-c / 2048.0) / (2.0 * BloomFilterBEP33.logB());
        return (int)size;
    }

    public static int unionSize(Collection<BloomFilterBEP33> filters) {
        BitVector[] vectors = new BitVector[filters.size()];
        int i = 0;
        for (BloomFilterBEP33 f : filters) {
            vectors[i++] = f.filter;
        }
        double c = BitVector.unionAndCount(vectors);
        return (int)(Math.log1p(-c / 2048.0) / (2.0 * BloomFilterBEP33.logB()));
    }

    public byte[] serialize() {
        return this.filter.getSerializedFormat();
    }

    private static double logB() {
        return Math.log1p(-4.8828125E-4);
    }

    public static void main(String[] args) throws Exception {
        BloomFilterBEP33 bf = new BloomFilterBEP33();
        int i = 0;
        while (i < 1000) {
            byte[] byArray = new byte[16];
            byArray[0] = 32;
            byArray[1] = 1;
            byArray[2] = 13;
            byArray[3] = -72;
            byArray[14] = (byte)(i >> 8 & 0xFF);
            byArray[15] = (byte)(i & 0xFF);
            bf.insert(InetAddress.getByAddress(byArray));
            ++i;
        }
        i = 0;
        while (i < 256) {
            byte[] byArray = new byte[4];
            byArray[0] = -64;
            byArray[2] = 2;
            byArray[3] = (byte)i;
            bf.insert(InetAddress.getByAddress(byArray));
            ++i;
        }
        System.out.println(bf.filter.toString());
        System.out.println(bf.filter.bitcount());
        System.out.println(bf.size());
    }
}

