/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.azureus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lbms.plugins.mldht.azureus.DHTAnnounceResult;
import lbms.plugins.mldht.azureus.DHTScrapeResult;
import lbms.plugins.mldht.azureus.MlDHTPlugin;
import lbms.plugins.mldht.azureus.TrackedTorrent;
import lbms.plugins.mldht.kad.AnnounceResponseHandler;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.PeerAddressDBItem;
import lbms.plugins.mldht.kad.ScrapeResponseHandler;
import lbms.plugins.mldht.kad.tasks.PeerLookupTask;
import lbms.plugins.mldht.kad.tasks.Task;
import lbms.plugins.mldht.kad.tasks.TaskListener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;

public class Tracker {
    public static final int MAX_CONCURRENT_ANNOUNCES = 8;
    public static final int MAX_CONCURRENT_SCRAPES = 1;
    public static final int TRACKER_UPDATE_INTERVAL = 10000;
    public static final int SHORT_DELAY = 60000;
    public static final int VERY_SHORT_DELAY = 5000;
    public static final int MIN_ANNOUNCE_INTERVAL = 300000;
    public static final int MAX_ANNOUNCE_INTERVAL = 1200000;
    public static final int MIN_SCRAPE_INTERVAL = 1200000;
    public static final int MAX_SCRAPE_INTERVAL = 600000;
    public static final String PEER_SOURCE_NAME = "DHT";
    private List<Download> currentAnnounces = new LinkedList<Download>();
    private List<Download> currentScrapes = new LinkedList<Download>();
    private MlDHTPlugin plugin;
    private boolean running;
    private Random random = new Random();
    private ScheduledFuture<?> timer;
    private TorrentAttribute ta_networks;
    private TorrentAttribute ta_peer_sources;
    private ListenerBundle listener = new ListenerBundle();
    private Map<Download, TrackedTorrent> trackedTorrents = new HashMap<Download, TrackedTorrent>();
    private Queue<TrackedTorrent> scrapeQueue = new DelayQueue<TrackedTorrent>();
    private Queue<TrackedTorrent> announceQueue = new DelayQueue<TrackedTorrent>();
    private AsyncDispatcher dispatcher = new AsyncDispatcher();

    protected Tracker(MlDHTPlugin plugin) {
        this.plugin = plugin;
        this.ta_networks = plugin.getPluginInterface().getTorrentManager().getAttribute("Networks");
        this.ta_peer_sources = plugin.getPluginInterface().getTorrentManager().getAttribute("PeerSources");
    }

    protected void start() {
        if (this.running) {
            return;
        }
        DHT.logInfo("Tracker: starting...");
        this.timer = DHT.getScheduler().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Tracker.this.checkQueues();
            }
        }, 100000L, 10000L, TimeUnit.MILLISECONDS);
        this.plugin.getPluginInterface().getDownloadManager().addListener(this.listener);
        this.running = true;
    }

    protected void stop() {
        Download[] downloads;
        if (!this.running) {
            return;
        }
        DHT.logInfo("Tracker: stopping...");
        if (this.timer != null) {
            this.timer.cancel(false);
        }
        this.announceQueue.clear();
        this.trackedTorrents.clear();
        this.plugin.getPluginInterface().getDownloadManager().removeListener(this.listener);
        Download[] downloadArray = downloads = this.plugin.getPluginInterface().getDownloadManager().getDownloads();
        int n = downloads.length;
        int n2 = 0;
        while (n2 < n) {
            Download dl = downloadArray[n2];
            this.listener.cleanup(dl);
            ++n2;
        }
        this.running = false;
    }

    protected void announceDownload(final Download dl) {
        if (this.running) {
            if (dl.getTorrent() == null) {
                return;
            }
            if (dl.getTorrent().isPrivate()) {
                DHT.logDebug("Announce for [" + dl.getName() + "] forbidden because Torrent is private.");
                return;
            }
            if (this.trackedTorrents.containsKey(dl) && this.trackedTorrents.get(dl).isAnnouncing()) {
                DHT.logDebug("Announce for [" + dl.getName() + "] was denied since there is already one running.");
                return;
            }
            DHT.logInfo("DHT Starting Announce for " + dl.getName());
            final long startTime = System.currentTimeMillis();
            final TrackedTorrent tor = this.trackedTorrents.get(dl);
            if (tor != null) {
                tor.setAnnouncing(true);
                tor.setLastAnnounceStart(startTime);
            }
            final boolean scrapeOnly = dl.getState() == 9;
            new TaskListener(){
                Set<PeerAddressDBItem> items = new HashSet<PeerAddressDBItem>();
                ScrapeResponseHandler scrapeHandler = new ScrapeResponseHandler();
                AnnounceResponseHandler announceHandler;
                AtomicInteger pendingCount;
                {
                    this.announceHandler = bl || trackedTorrent == null || trackedTorrent.getAnnounceCount() > 1 ? null : new AnnounceResponseHandler(){
                        private Set<PeerAddressDBItem> interim_items = new HashSet<PeerAddressDBItem>();

                        @Override
                        public void itemsUpdated(PeerLookupTask task2) {
                            if (this.interim_items.size() >= 200) {
                                return;
                            }
                            this.interim_items.addAll(task2.getReturnedItems());
                            DHTAnnounceResult res = new DHTAnnounceResult(download, this.interim_items, 0);
                            download.setAnnounceResult(res);
                        }
                    };
                    this.pendingCount = new AtomicInteger();
                    (bl ? Tracker.this.currentScrapes : Tracker.this.currentAnnounces).add(download);
                    DHT.DHTtype[] dHTtypeArray = DHT.DHTtype.values();
                    int n = dHTtypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DHT.DHTtype type = dHTtypeArray[n2];
                        DHT dht = Tracker.this.plugin.getDHT(type);
                        PeerLookupTask lookupTask = dht.createPeerLookup(download.getTorrent().getHash());
                        if (lookupTask != null) {
                            this.pendingCount.incrementAndGet();
                            lookupTask.setScrapeHandler(this.scrapeHandler);
                            lookupTask.setAnounceHandler(this.announceHandler);
                            lookupTask.setScrapeOnly(bl);
                            lookupTask.addListener(this);
                            lookupTask.setInfo(download.getName());
                            lookupTask.setNoSeeds(download.isComplete(true));
                            dht.getTaskManager().addTask(lookupTask);
                        }
                        ++n2;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void finished(Task t) {
                    DHT.logDebug("DHT Task done: " + t.getClass().getSimpleName());
                    if (t instanceof PeerLookupTask) {
                        PeerLookupTask peerLookup = (PeerLookupTask)t;
                        Set<PeerAddressDBItem> set = this.items;
                        synchronized (set) {
                            this.items.addAll(peerLookup.getReturnedItems());
                        }
                        if (!dl.getFlag(512L) && !scrapeOnly) {
                            t.getRPC().getDHT().announce(peerLookup, dl.isComplete(true), Tracker.this.plugin.getPluginInterface().getPluginconfig().getUnsafeIntParameter("TCP.Listen.Port"));
                        }
                        if (this.pendingCount.decrementAndGet() > 0) {
                            return;
                        }
                        this.allFinished(peerLookup.getInfoHash().getHash());
                    }
                }

                private void allFinished(byte[] hash) {
                    Object res;
                    this.scrapeHandler.process();
                    Tracker.this.currentAnnounces.remove(dl);
                    Tracker.this.currentScrapes.remove(dl);
                    if (tor != null) {
                        tor.setAnnouncing(false);
                    }
                    Tracker.this.scheduleTorrent(dl, false);
                    if (!scrapeOnly && this.items.size() > 0) {
                        res = new DHTAnnounceResult(dl, this.items, tor != null ? (int)tor.getDelay(TimeUnit.SECONDS) : 0);
                        ((DHTAnnounceResult)res).setScrapePeers(this.scrapeHandler.getScrapedPeers());
                        ((DHTAnnounceResult)res).setScrapeSeeds(this.scrapeHandler.getScrapedSeeds());
                        dl.setAnnounceResult((DownloadAnnounceResult)res);
                    }
                    if (scrapeOnly && (this.scrapeHandler.getScrapedPeers() > 0 || this.scrapeHandler.getScrapedSeeds() > 0)) {
                        res = new DHTScrapeResult(dl, this.scrapeHandler.getScrapedSeeds(), this.scrapeHandler.getScrapedPeers());
                        ((DHTScrapeResult)res).setScrapeStartTime(startTime);
                        dl.setScrapeResult((DownloadScrapeResult)res);
                    }
                    DHT.logInfo("DHT Announce finished for " + dl.getName() + " found " + this.items.size() + " Peers.");
                }
            };
        }
    }

    private void scheduleTorrent(final Download dl, boolean shortDelay) {
        if (!this.running) {
            return;
        }
        if (this.trackedTorrents.containsKey(dl)) {
            int delay;
            Queue<TrackedTorrent> targetQueue;
            TrackedTorrent t = this.trackedTorrents.get(dl);
            if (t.scrapeOnly()) {
                targetQueue = this.scrapeQueue;
                this.announceQueue.remove(t);
                delay = shortDelay ? 60000 + this.random.nextInt(60000) : 1200000 + this.random.nextInt(600000);
            } else {
                targetQueue = this.announceQueue;
                this.scrapeQueue.remove(t);
                delay = shortDelay ? (dl.getFlag(512L) ? 0 : (t.getAnnounceCount() == 0 && !dl.isComplete(true) ? 5000 + this.random.nextInt(5000) : 60000 + this.random.nextInt(60000))) : 300000 + this.random.nextInt(1200000);
            }
            if (targetQueue.contains(t)) {
                if (shortDelay) {
                    targetQueue.remove(t);
                } else {
                    return;
                }
            }
            t.setDelay(delay);
            DHT.logInfo("Tracker: scheduled " + (t.scrapeOnly() ? "scrape" : "announce") + " in " + t.getDelay(TimeUnit.SECONDS) + "sec for: " + dl.getName());
            if (delay == 0) {
                this.dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        Tracker.this.announceDownload(dl);
                    }
                });
            } else {
                targetQueue.add(t);
            }
        }
    }

    private void checkQueues() {
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                Tracker.this.checkQueuesSupport();
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private void checkQueuesSupport() {
        if (this.running) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            dl = t.getDownload();
            if (this.trackedTorrents.containsKey(dl) && this.trackedTorrents.get(dl).isAnnouncing()) {
                this.scheduleTorrent(dl, false);
                continue;
            }
            this.announceDownload(dl);
lbl8:
            // 3 sources

            ** while (this.currentAnnounces.size() < 8 && (t = this.announceQueue.poll()) != null)
        }
lbl9:
        // 3 sources

        while (this.currentScrapes.size() < 1 && (t = this.scrapeQueue.poll()) != null) {
            dl = t.getDownload();
            if (this.trackedTorrents.containsKey(dl) && this.trackedTorrents.get(dl).isAnnouncing()) {
                this.scheduleTorrent(dl, false);
                continue;
            }
            this.announceDownload(dl);
        }
    }

    private void checkDownload(Download dl) {
        int i;
        if (!this.running || dl.getTorrent() == null || dl.getTorrent().isPrivate()) {
            return;
        }
        String[] sources = dl.getListAttribute(this.ta_peer_sources);
        String[] networks = dl.getListAttribute(this.ta_networks);
        boolean ok = false;
        if (networks != null) {
            i = 0;
            while (i < networks.length) {
                if (networks[i].equalsIgnoreCase("Public")) {
                    ok = true;
                    break;
                }
                ++i;
            }
        }
        if (!ok) {
            this.removeTrackedTorrent(dl, "Network is not public anymore");
            return;
        }
        ok = false;
        i = 0;
        while (i < sources.length) {
            if (sources[i].equalsIgnoreCase(PEER_SOURCE_NAME)) {
                ok = true;
                break;
            }
            ++i;
        }
        if (!ok) {
            this.removeTrackedTorrent(dl, "Peer source was disabled");
            return;
        }
        TrackedTorrent tor = this.trackedTorrents.get(dl);
        if (dl.getState() == 4 || dl.getState() == 5) {
            if (!dl.getFlag(512L) && this.plugin.getPluginInterface().getPluginconfig().getPluginBooleanParameter("backupOnly")) {
                DownloadAnnounceResult result = dl.getLastAnnounceResult();
                if (result == null || result.getResponseType() == 2) {
                    this.addTrackedTorrent(dl, "BackupTracker");
                } else {
                    this.removeTrackedTorrent(dl, "BackupTracker no longer needed");
                }
                return;
            }
            this.addTrackedTorrent(dl, "Normal");
        } else if (dl.getState() == 9) {
            DownloadScrapeResult scrResult = dl.getLastScrapeResult();
            if (scrResult.getResponseType() == 2 || tor != null && scrResult.getScrapeStartTime() == tor.getLastAnnounceStart()) {
                this.addTrackedTorrent(dl, "BackupScraper");
            } else {
                this.removeTrackedTorrent(dl, "BackupScraper no longer needed");
            }
        } else {
            this.removeTrackedTorrent(dl, "Has stopped Downloading/Seeding");
        }
    }

    private void addTrackedTorrent(Download dl, String reason) {
        if (!this.trackedTorrents.containsKey(dl)) {
            DHT.logInfo("Tracker: starting to track Torrent reason: " + reason + ", Torrent; " + dl.getName());
            this.trackedTorrents.put(dl, new TrackedTorrent(dl));
            this.scheduleTorrent(dl, true);
        }
    }

    private void removeTrackedTorrent(Download dl, String reason) {
        if (this.trackedTorrents.containsKey(dl)) {
            DHT.logInfo("Tracker: stop tracking of Torrent reason: " + reason + ", Torrent; " + dl.getName());
            TrackedTorrent tracked = this.trackedTorrents.get(dl);
            this.announceQueue.remove(tracked);
            this.scrapeQueue.remove(tracked);
            this.trackedTorrents.remove(dl);
        }
    }

    public List<TrackedTorrent> getTrackedTorrentList() {
        return new ArrayList<TrackedTorrent>(this.trackedTorrents.values());
    }

    private class ListenerBundle
    implements DownloadListener,
    DownloadAttributeListener,
    DownloadTrackerListener,
    DownloadManagerListener {
        private ListenerBundle() {
        }

        public void cleanup(Download download) {
            download.removeAttributeListener(this, Tracker.this.ta_networks, 1);
            download.removeAttributeListener(this, Tracker.this.ta_peer_sources, 1);
            download.removeListener(this);
            download.removeTrackerListener(this);
        }

        @Override
        public void positionChanged(Download download, int oldPosition, int newPosition) {
        }

        @Override
        public void stateChanged(Download download, int old_state, int new_state) {
            Tracker.this.checkDownload(download);
        }

        @Override
        public void attributeEventOccurred(Download download, TorrentAttribute attribute, int event_type) {
            if (event_type == 1 && (attribute == Tracker.this.ta_networks || attribute == Tracker.this.ta_peer_sources)) {
                Tracker.this.checkDownload(download);
            }
        }

        @Override
        public void announceResult(DownloadAnnounceResult result) {
            Tracker.this.checkDownload(result.getDownload());
        }

        @Override
        public void scrapeResult(DownloadScrapeResult result) {
            Tracker.this.checkDownload(result.getDownload());
        }

        @Override
        public void downloadAdded(Download download) {
            download.addAttributeListener(this, Tracker.this.ta_networks, 1);
            download.addAttributeListener(this, Tracker.this.ta_peer_sources, 1);
            download.addListener(this);
            download.addTrackerListener(this);
            Tracker.this.checkDownload(download);
        }

        @Override
        public void downloadRemoved(Download download) {
            this.cleanup(download);
            Tracker.this.removeTrackedTorrent(download, "Download was removed");
        }
    }
}

