/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.azureus;

import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.Map;
import lbms.plugins.mldht.DHTConfiguration;
import lbms.plugins.mldht.azureus.AlternativeContactHandler;
import lbms.plugins.mldht.azureus.Tracker;
import lbms.plugins.mldht.azureus.UIHelper;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.DHTConstants;
import lbms.plugins.mldht.kad.DHTLogger;
import lbms.plugins.mldht.kad.RPCServerListener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.UnloadablePlugin;
import org.gudy.azureus2.plugins.dht.mainline.MainlineDHTProvider;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.logging.Logger;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;

public class MlDHTPlugin
implements UnloadablePlugin,
PluginListener {
    private PluginInterface pluginInterface;
    private Map<DHT.DHTtype, DHT> dhts;
    private Tracker tracker;
    private BasicPluginConfigModel config_model;
    private BasicPluginViewModel view_model;
    private Logger logger;
    private LoggerChannel logChannel;
    private LoggerChannelListener logListener;
    private UIManagerListener uiListener;
    private LocaleUtilities locale_utils;
    private AlternativeContactHandler alt_contact_handler;
    private volatile boolean unloaded;
    private UIHelper uiHelper;
    private Object mlDHTProvider;
    private static MlDHTPlugin singleton;
    private AsyncDispatcher dispatcher = new AsyncDispatcher("MLDHT:disp", 2500);

    @Override
    public void initialize(final PluginInterface pluginInterface) throws PluginException {
        if (singleton != null) {
            throw new IllegalStateException("Plugin already initialized");
        }
        singleton = this;
        this.pluginInterface = pluginInterface;
        UIManager ui_manager = pluginInterface.getUIManager();
        this.locale_utils = pluginInterface.getUtilities().getLocaleUtilities();
        this.config_model = ui_manager.createBasicPluginConfigModel("plugins", "plugin.mldht");
        this.config_model.addBooleanParameter2("enable", "mldht.enable", true);
        this.config_model.addIntParameter2("port", "mldht.port", 49001);
        DHT.DHTtype[] dHTtypeArray = DHT.DHTtype.values();
        int n = dHTtypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DHT.DHTtype type = dHTtypeArray[n2];
            this.config_model.addBooleanParameter2("autoopen." + type.shortName, ("mldht.autoopen." + type.shortName).toLowerCase(), false);
            ++n2;
        }
        this.config_model.addBooleanParameter2("backupOnly", "mldht.backupOnly", false);
        this.config_model.addBooleanParameter2("onlyPeerBootstrap", "mldht.onlyPeerBootstrap", false);
        this.config_model.addBooleanParameter2("alwaysRestoreID", "mldht.restoreID", true);
        this.config_model.addBooleanParameter2("showStatusEntry", "mldht.showStatusEntry", true);
        this.config_model.addBooleanParameter2("multihoming", "mldht.multihoming", false);
        this.view_model = ui_manager.createBasicPluginViewModel("Mainline DHT Log");
        this.view_model.getActivity().setVisible(false);
        this.view_model.getProgress().setVisible(false);
        this.view_model.getStatus().setText("Stopped");
        this.logger = pluginInterface.getLogger();
        this.logChannel = this.logger.getTimeStampedChannel("Mainline DHT");
        this.logListener = new LoggerChannelListener(){

            @Override
            public void messageLogged(int type, String content2) {
                MlDHTPlugin.this.view_model.getLogArea().appendText(String.valueOf(content2) + "\n");
            }

            @Override
            public void messageLogged(String str, Throwable error) {
                if (str.length() > 0) {
                    MlDHTPlugin.this.view_model.getLogArea().appendText(String.valueOf(str) + "\n");
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                error.printStackTrace(pw);
                pw.flush();
                MlDHTPlugin.this.view_model.getLogArea().appendText(String.valueOf(sw.toString()) + "\n");
            }
        };
        this.logChannel.addListener(this.logListener);
        String version = pluginInterface.getPluginVersion();
        int parsedVersion = -1;
        if (version != null) {
            if ((version = version.replaceAll("[^0-9]", "")).length() > 9) {
                version = version.substring(0, 8);
            }
            parsedVersion = Integer.parseInt(version);
        }
        DHTConstants.setVersion(parsedVersion);
        this.dhts = DHT.createDHTs();
        DHT.setLogger(new DHTLogger(){

            @Override
            public void log(String message) {
                MlDHTPlugin.this.logChannel.log(message);
            }

            @Override
            public void log(Throwable e) {
                MlDHTPlugin.this.logChannel.log(e);
            }
        });
        try {
            this.mlDHTProvider = new MainlineDHTProvider(){

                @Override
                public int getDHTPort() {
                    return pluginInterface.getPluginconfig().getPluginIntParameter("port");
                }

                @Override
                public void notifyOfIncomingPort(String ip_addr, int port) {
                    for (DHT dht : MlDHTPlugin.this.dhts.values()) {
                        dht.addDHTNode(ip_addr, port);
                    }
                }
            };
            pluginInterface.getMainlineDHTManager().setProvider((MainlineDHTProvider)this.mlDHTProvider);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.tracker = new Tracker(this);
        this.uiListener = new UIManagerListener(){

            @Override
            public void UIAttached(UIInstance instance) {
                if (MlDHTPlugin.this.uiHelper == null && instance.getUIType() == 1) {
                    try {
                        Class<?> cla = this.getClass().getClassLoader().loadClass("lbms.plugins.mldht.azureus.gui.SWTHelper");
                        MlDHTPlugin.this.uiHelper = (UIHelper)cla.getConstructor(MlDHTPlugin.class).newInstance(MlDHTPlugin.this);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                if (MlDHTPlugin.this.uiHelper != null) {
                    MlDHTPlugin.this.uiHelper.UIAttached(instance);
                }
            }

            @Override
            public void UIDetached(UIInstance instance) {
                if (MlDHTPlugin.this.uiHelper != null) {
                    MlDHTPlugin.this.uiHelper.UIDetached(instance);
                }
            }
        };
        ui_manager.addUIListener(this.uiListener);
        TableContextMenuItem incompleteMenuItem = ui_manager.getTableManager().addContextMenuItem("MyTorrents", "tablemenu.main.item");
        TableContextMenuItem completeMenuItem = ui_manager.getTableManager().addContextMenuItem("MySeeders", "tablemenu.main.item");
        incompleteMenuItem.setStyle(5);
        completeMenuItem.setStyle(5);
        TableContextMenuItem incAnnounceItem = ui_manager.getTableManager().addContextMenuItem(incompleteMenuItem, "tablemenu.announce.item");
        TableContextMenuItem comAnnounceItem = ui_manager.getTableManager().addContextMenuItem(completeMenuItem, "tablemenu.announce.item");
        MenuItemListener announceItemListener = new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                TableRow row = (TableRow)target;
                Download dl = (Download)row.getDataSource();
                MlDHTPlugin.this.tracker.announceDownload(dl);
            }
        };
        incAnnounceItem.addListener(announceItemListener);
        comAnnounceItem.addListener(announceItemListener);
        pluginInterface.addListener(this);
    }

    public static MlDHTPlugin getSingleton() {
        return singleton;
    }

    public PluginInterface getPluginInterface() {
        return this.pluginInterface;
    }

    public DHT getDHT(DHT.DHTtype type) {
        return this.dhts.get((Object)type);
    }

    public Tracker getTracker() {
        return this.tracker;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getMessageText(String key) {
        return this.locale_utils.getLocalisedMessageText(key);
    }

    public void showConfig() {
        this.pluginInterface.getUIManager().showConfigSection("plugin.mldht");
    }

    public boolean isPluginAutoOpen(String dhtType) {
        return this.pluginInterface.getPluginconfig().getPluginBooleanParameter("autoopen." + dhtType, false);
    }

    private void registerUPnPMapping(int port) {
        try {
            PluginInterface pi_upnp = this.pluginInterface.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
            if (pi_upnp != null) {
                ((UPnPPlugin)pi_upnp.getPlugin()).addMapping(this.pluginInterface.getPluginName(), false, port, true);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void unload() throws PluginException {
        this.unloaded = true;
        if (this.uiHelper != null) {
            this.uiHelper.onPluginUnload();
        }
        this.stopDHT();
        if (this.pluginInterface != null) {
            try {
                this.pluginInterface.getMainlineDHTManager().setProvider(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.pluginInterface.getUIManager().removeUIListener(this.uiListener);
            this.pluginInterface.removeListener(this);
        }
        if (this.view_model != null) {
            this.view_model.destroy();
        }
        if (this.config_model != null) {
            this.config_model.destroy();
        }
        if (this.logChannel != null) {
            this.logChannel.removeListener(this.logListener);
        }
        DHT.initStatics();
        this.dhts = null;
        singleton = null;
    }

    @Override
    public void closedownComplete() {
    }

    @Override
    public void closedownInitiated() {
        this.stopDHT();
    }

    @Override
    public void initializationComplete() {
        this.registerUPnPMapping(this.pluginInterface.getPluginconfig().getPluginIntParameter("port"));
        if (this.pluginInterface.getPluginconfig().getPluginBooleanParameter("enable")) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MlDHTPlugin.this.startDHT();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            });
            t.setPriority(1);
            t.start();
        }
    }

    public void startDHT() {
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                if (MlDHTPlugin.this.unloaded) {
                    return;
                }
                DHTConfiguration config = new DHTConfiguration(){

                    @Override
                    public boolean noRouterBootstrap() {
                        return MlDHTPlugin.this.pluginInterface.getPluginconfig().getPluginBooleanParameter("onlyPeerBootstrap");
                    }

                    @Override
                    public boolean isPersistingID() {
                        return MlDHTPlugin.this.pluginInterface.getPluginconfig().getPluginBooleanParameter("alwaysRestoreID");
                    }

                    @Override
                    public File getNodeCachePath() {
                        return MlDHTPlugin.this.pluginInterface.getPluginconfig().getPluginUserFile("dht.cache");
                    }

                    @Override
                    public int getListeningPort() {
                        return MlDHTPlugin.this.pluginInterface.getPluginconfig().getPluginIntParameter("port");
                    }

                    @Override
                    public boolean allowMultiHoming() {
                        return MlDHTPlugin.this.pluginInterface.getPluginconfig().getPluginBooleanParameter("multihoming");
                    }
                };
                try {
                    MlDHTPlugin.this.alt_contact_handler = new AlternativeContactHandler();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                RPCServerListener serverListener = new RPCServerListener(){

                    @Override
                    public void replyReceived(InetSocketAddress from_node) {
                        if (MlDHTPlugin.this.alt_contact_handler != null) {
                            try {
                                MlDHTPlugin.this.alt_contact_handler.nodeAlive(from_node);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                };
                MlDHTPlugin.this.view_model.getStatus().setText("Initializing");
                try {
                    for (Map.Entry e : MlDHTPlugin.this.dhts.entrySet()) {
                        ((DHT)e.getValue()).start(config, serverListener);
                        ((DHT)e.getValue()).bootstrap();
                    }
                    MlDHTPlugin.this.tracker.start();
                    MlDHTPlugin.this.view_model.getStatus().setText("Running");
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void stopDHT() {
        final AESemaphore sem = new AESemaphore("MLDHT:Stopper");
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                try {
                    if (MlDHTPlugin.this.tracker != null) {
                        MlDHTPlugin.this.tracker.stop();
                    }
                    if (MlDHTPlugin.this.dhts != null) {
                        for (DHT dht : MlDHTPlugin.this.dhts.values()) {
                            dht.stop();
                        }
                    }
                    if (MlDHTPlugin.this.alt_contact_handler != null) {
                        MlDHTPlugin.this.alt_contact_handler.destroy();
                    }
                    if (MlDHTPlugin.this.view_model != null) {
                        MlDHTPlugin.this.view_model.getStatus().setText("Stopped");
                    }
                }
                finally {
                    sem.release();
                }
            }
        });
        if (!sem.reserve(30000L)) {
            Debug.out("Timeout waiting for DHT to stop");
        }
    }
}

