/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.azureus;

import com.aelitis.azureus.core.dht.transport.DHTTransportAlternativeContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportAlternativeNetwork;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class AlternativeContactHandler {
    private DHTTransportAlternativeNetworkImpl ipv4_net = new DHTTransportAlternativeNetworkImpl(1);
    private DHTTransportAlternativeNetworkImpl ipv6_net = new DHTTransportAlternativeNetworkImpl(2);

    protected AlternativeContactHandler() {
        DHTUDPUtils.registerAlternativeNetwork(this.ipv4_net);
        DHTUDPUtils.registerAlternativeNetwork(this.ipv6_net);
    }

    protected void nodeAlive(InetSocketAddress address) {
        if (address.getAddress() instanceof Inet4Address) {
            this.ipv4_net.addAddress(address);
        } else {
            this.ipv6_net.addAddress(address);
        }
    }

    protected void destroy() {
        DHTUDPUtils.unregisterAlternativeNetwork(this.ipv4_net);
        DHTUDPUtils.unregisterAlternativeNetwork(this.ipv6_net);
    }

    private static class DHTTransportAlternativeNetworkImpl
    implements DHTTransportAlternativeNetwork {
        private static final int ADDRESS_HISTORY_MAX = 32;
        private int network;
        private LinkedList<Object[]> address_history = new LinkedList();

        private DHTTransportAlternativeNetworkImpl(int net) {
            this.network = net;
        }

        @Override
        public int getNetworkType() {
            return this.network;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addAddress(InetSocketAddress address) {
            LinkedList<Object[]> linkedList = this.address_history;
            synchronized (linkedList) {
                this.address_history.addFirst(new Object[]{address, new Long(SystemTime.getMonotonousTime())});
                if (this.address_history.size() > 32) {
                    this.address_history.removeLast();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<DHTTransportAlternativeContact> getContacts(int max) {
            ArrayList<DHTTransportAlternativeContact> result = new ArrayList<DHTTransportAlternativeContact>(max);
            LinkedList<Object[]> linkedList = this.address_history;
            synchronized (linkedList) {
                for (Object[] entry : this.address_history) {
                    result.add(new DHTTransportAlternativeContactImpl((InetSocketAddress)entry[0], (Long)entry[1]));
                    if (result.size() == max) break;
                }
            }
            return result;
        }

        private class DHTTransportAlternativeContactImpl
        implements DHTTransportAlternativeContact {
            private final InetSocketAddress address;
            private final int seen_secs;
            private final int id;

            private DHTTransportAlternativeContactImpl(InetSocketAddress _address, long seen) {
                int _id;
                this.address = _address;
                this.seen_secs = (int)(seen / 1000L);
                try {
                    _id = Arrays.hashCode(BEncoder.encode(this.getProperties()));
                }
                catch (Throwable e) {
                    Debug.out(e);
                    _id = 0;
                }
                this.id = _id;
            }

            @Override
            public int getNetworkType() {
                return DHTTransportAlternativeNetworkImpl.this.network;
            }

            @Override
            public int getVersion() {
                return 1;
            }

            @Override
            public int getID() {
                return this.id;
            }

            @Override
            public int getLastAlive() {
                return this.seen_secs;
            }

            @Override
            public int getAge() {
                return (int)(SystemTime.getMonotonousTime() / 1000L) - this.seen_secs;
            }

            @Override
            public Map<String, Object> getProperties() {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                try {
                    properties.put("a", this.address.getAddress().getAddress());
                    properties.put("p", new Long(this.address.getPort()));
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                return properties;
            }
        }
    }
}

