/*
 * Decompiled with CFR 0.152.
 */
package com.vuze.client.plugins.utp.loc.v2;

import com.vuze.client.plugins.utp.UTPProviderCallback;
import com.vuze.client.plugins.utp.UTPProviderException;
import com.vuze.client.plugins.utp.loc.UTPSocket;
import com.vuze.client.plugins.utp.loc.UTPTranslated;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;

public class UTPTranslatedV2
implements UTPTranslated {
    private static final boolean ASSERTS = false;
    public static final int INT_MAX = Integer.MAX_VALUE;
    public static final int UINT_MAX = -1;
    public static final long UINT_MAX_L = 0xFFFFFFFFL;
    public static final long INT64_MAX = Long.MAX_VALUE;
    public static final int UTP_UDP_DONTFRAG = 2;
    public static final int UTP_ECONNREFUSED = 0;
    public static final int UTP_ECONNRESET = 1;
    public static final int UTP_ETIMEDOUT = 2;
    public static final int UTP_ON_FIREWALL = 0;
    public static final int UTP_ON_ACCEPT = 1;
    public static final int UTP_ON_CONNECT = 2;
    public static final int UTP_ON_ERROR = 3;
    public static final int UTP_ON_READ = 4;
    public static final int UTP_ON_OVERHEAD_STATISTICS = 5;
    public static final int UTP_ON_STATE_CHANGE = 6;
    public static final int UTP_GET_READ_BUFFER_SIZE = 7;
    public static final int UTP_ON_DELAY_SAMPLE = 8;
    public static final int UTP_GET_UDP_MTU = 9;
    public static final int UTP_GET_UDP_OVERHEAD = 10;
    public static final int UTP_GET_MILLISECONDS = 11;
    public static final int UTP_GET_MICROSECONDS = 12;
    public static final int UTP_GET_RANDOM = 13;
    public static final int UTP_LOG = 14;
    public static final int UTP_SENDTO = 15;
    public static final int UTP_LOG_NORMAL = 16;
    public static final int UTP_LOG_MTU = 17;
    public static final int UTP_LOG_DEBUG = 18;
    public static final int UTP_SNDBUF = 19;
    public static final int UTP_RCVBUF = 20;
    public static final int UTP_TARGET_DELAY = 21;
    public static final int UTP_ARRAY_SIZE = 22;
    private static _utp_callback_arguments utp_callback_arguments = new _utp_callback_arguments();
    public static final int ETHERNET_MTU = 1500;
    public static final int IPV4_HEADER_SIZE = 20;
    public static final int IPV6_HEADER_SIZE = 40;
    public static final int UDP_HEADER_SIZE = 8;
    public static final int GRE_HEADER_SIZE = 24;
    public static final int PPPOE_HEADER_SIZE = 8;
    public static final int MPPE_HEADER_SIZE = 2;
    public static final int FUDGE_HEADER_SIZE = 36;
    public static final int TEREDO_MTU = 1280;
    public static final int UDP_IPV4_OVERHEAD = 28;
    public static final int UDP_IPV6_OVERHEAD = 48;
    public static final int UDP_TEREDO_OVERHEAD = 76;
    public static final int UDP_IPV4_MTU = 1402;
    public static final int UDP_IPV6_MTU = 1382;
    public static final int UDP_TEREDO_MTU = 1272;
    private final boolean TEST_MODE;
    private final UTPProviderCallback callback;
    private final UTPTranslated.UTPFunctionTable fn_table;
    private final UTPTranslated.SendToProc send_to_proc;
    private final UTPTranslated.UTPGotIncomingConnection incoming_connection_proc;
    private final utp_context global_ctx;
    private final utp_callback_t utp_default_callbacks = new utp_callback_t(){

        @Override
        public long callback(_utp_callback_arguments args) {
            switch (args.callback_type) {
                case 9: {
                    return args.address.getAddress() instanceof Inet6Address ? 1272 : 1402;
                }
                case 10: {
                    return args.address.getAddress() instanceof Inet6Address ? 76 : 28;
                }
                case 11: {
                    return UTPTranslatedV2.this.callback.getMilliseconds();
                }
                case 12: {
                    return UTPTranslatedV2.this.callback.getMicroseconds();
                }
                case 13: {
                    return UTPTranslatedV2.this.callback.getRandom();
                }
                case 1: {
                    UTPTranslatedV2.this.incoming_connection_proc.got_incoming_connection(null, args.socket);
                    break;
                }
                case 3: {
                    UTPTranslatedV2.this.fn_table.on_error(args.socket.userdata, args.error_code);
                    break;
                }
                case 4: {
                    UTPTranslatedV2.this.fn_table.on_read(args.socket.userdata, args.bbuf, args.len);
                    break;
                }
                case 5: {
                    UTPTranslatedV2.this.fn_table.on_overhead(args.socket.userdata, args.send != 0, args.len, args.type);
                    break;
                }
                case 6: {
                    UTPTranslatedV2.this.fn_table.on_state(args.socket.userdata, args.state);
                    break;
                }
                case 7: {
                    return UTPTranslatedV2.this.fn_table.get_rb_size(args.socket.userdata);
                }
                case 15: {
                    UTPTranslatedV2.this.send_to_proc.send_to_proc(null, args.buf, args.address);
                    break;
                }
                default: {
                    Debug.out("Default not supported!");
                }
            }
            return -1L;
        }
    };
    public static final int UTP_IOV_MAX = 1024;
    public static final int CCONTROL_TARGET = 100000;
    public static final int payload_bandwidth = 0;
    public static final int connect_overhead = 1;
    public static final int close_overhead = 2;
    public static final int ack_overhead = 3;
    public static final int header_overhead = 4;
    public static final int retransmit_overhead = 5;
    public static final int TIMEOUT_CHECK_INTERVAL = 500;
    public static final int MAX_CWND_INCREASE_BYTES_PER_RTT = 3000;
    public static final int CUR_DELAY_SIZE = 3;
    public static final int DELAY_BASE_HISTORY = 13;
    public static final int MAX_WINDOW_DECAY = 100;
    public static final int REORDER_BUFFER_SIZE = 32;
    public static final int REORDER_BUFFER_MAX_SIZE = 1024;
    public static final int OUTGOING_BUFFER_MAX_SIZE = 1024;
    public static final int PACKET_SIZE = 1435;
    public static final int MIN_WINDOW_SIZE = 10;
    public static final int DUPLICATE_ACKS_BEFORE_RESEND = 3;
    public static final int ACK_NR_ALLOWED_WINDOW = 3;
    public static final int RST_INFO_TIMEOUT = 10000;
    public static final int RST_INFO_LIMIT = 1000;
    public static final int KEEPALIVE_INTERVAL = 29000;
    public static final int SEQ_NR_MASK = 65535;
    public static final int ACK_NR_MASK = 65535;
    public static final long TIMESTAMP_MASK = 0xFFFFFFFFL;
    public static final int PACKET_SIZE_EMPTY_BUCKET = 0;
    public static final int PACKET_SIZE_EMPTY = 23;
    public static final int PACKET_SIZE_SMALL_BUCKET = 1;
    public static final int PACKET_SIZE_SMALL = 373;
    public static final int PACKET_SIZE_MID_BUCKET = 2;
    public static final int PACKET_SIZE_MID = 723;
    public static final int PACKET_SIZE_BIG_BUCKET = 3;
    public static final int PACKET_SIZE_BIG = 1400;
    public static final int PACKET_SIZE_HUGE_BUCKET = 4;
    public static final int sizeof_PacketFormatV1 = 20;
    public static final int sizeof_PacketFormatAckV1 = 26;
    public static final int sizeof_PacketFormatExtensionsV1 = 30;
    public static final int ST_DATA = 0;
    public static final int ST_FIN = 1;
    public static final int ST_STATE = 2;
    public static final int ST_RESET = 3;
    public static final int ST_SYN = 4;
    public static final int ST_NUM_STATES = 5;
    static final String[] flagnames = new String[]{"ST_DATA", "ST_FIN", "ST_STATE", "ST_RESET", "ST_SYN"};
    private static final int CS_UNINITIALIZED = 0;
    private static final int CS_IDLE = 1;
    private static final int CS_SYN_SENT = 2;
    private static final int CS_SYN_RECV = 3;
    private static final int CS_CONNECTED = 4;
    private static final int CS_CONNECTED_FULL = 5;
    private static final int CS_GOT_FIN = 6;
    private static final int CS_DESTROY_DELAY = 7;
    private static final int CS_FIN_SENT = 8;
    private static final int CS_RESET = 9;
    private static final int CS_DESTROY = 10;
    static final String[] statenames = new String[]{"UNINITIALIZED", "IDLE", "SYN_SENT", "SYN_RECV", "CONNECTED", "CONNECTED_FULL", "GOT_FIN", "DESTROY_DELAY", "FIN_SENT", "RESET", "DESTROY"};

    static void _assert(boolean b) {
        if (!b) {
            Debug.out("derp");
        }
    }

    static void _assert(int i) {
        if (i == 0) {
            Debug.out("derp");
        }
    }

    static void _assert(Object o) {
        if (o == null) {
            Debug.out("derp");
        }
    }

    public static long uint32(long l) {
        return l & 0xFFFFFFFFFFFFFFFFL;
    }

    int utp_call_on_firewall(utp_context ctx, InetSocketAddress address) {
        if (ctx.callbacks[0] == null) {
            return 0;
        }
        _utp_callback_arguments args = utp_callback_arguments;
        args.callback_type = 0;
        args.context = ctx;
        args.socket = null;
        args.address = address;
        return (int)ctx.callbacks[0].callback(args);
    }

    void utp_call_on_accept(utp_context ctx, UTPSocketImpl socket, InetSocketAddress address) {
        if (ctx.callbacks[1] == null) {
            return;
        }
        _utp_callback_arguments args = utp_callback_arguments;
        args.callback_type = 1;
        args.context = ctx;
        args.socket = socket;
        args.address = address;
        ctx.callbacks[1].callback(args);
    }

    void utp_call_on_connect(utp_context ctx, UTPSocketImpl socket) {
        if (ctx.callbacks[2] == null) {
            return;
        }
        _utp_callback_arguments args = utp_callback_arguments;
        args.callback_type = 2;
        args.context = ctx;
        args.socket = socket;
        ctx.callbacks[2].callback(args);
    }

    void utp_call_on_error(utp_context ctx, UTPSocketImpl socket, int error_code) {
        if (ctx.callbacks[3] == null) {
            return;
        }
        _utp_callback_arguments args = utp_callback_arguments;
        args.callback_type = 3;
        args.context = ctx;
        args.socket = socket;
        args.error_code = error_code;
        ctx.callbacks[3].callback(args);
    }

    void utp_call_on_read(utp_context ctx, UTPSocketImpl socket, ByteBuffer buf, int len) {
        if (ctx.callbacks[4] == null) {
            return;
        }
        _utp_callback_arguments args = utp_callback_arguments;
        args.callback_type = 4;
        args.context = ctx;
        args.socket = socket;
        args.bbuf = buf;
        args.len = len;
        ctx.callbacks[4].callback(args);
    }

    void utp_call_on_overhead_statistics(utp_context ctx, UTPSocketImpl socket, int send, int len, int type) {
        if (ctx.callbacks[5] == null) {
            return;
        }
        _utp_callback_arguments args = utp_callback_arguments;
        args.callback_type = 5;
        args.context = ctx;
        args.socket = socket;
        args.send = send;
        args.len = len;
        args.type = type;
        ctx.callbacks[5].callback(args);
    }

    void utp_call_on_delay_sample(utp_context ctx, UTPSocketImpl socket, int sample_ms) {
        if (ctx.callbacks[8] == null) {
            return;
        }
        _utp_callback_arguments args = utp_callback_arguments;
        args.callback_type = 8;
        args.context = ctx;
        args.socket = socket;
        args.sample_ms = sample_ms;
        ctx.callbacks[8].callback(args);
    }

    void utp_call_on_state_change(utp_context ctx, UTPSocketImpl socket, int state) {
        if (ctx.callbacks[6] == null) {
            return;
        }
        _utp_callback_arguments args = utp_callback_arguments;
        args.callback_type = 6;
        args.context = ctx;
        args.socket = socket;
        args.state = state;
        ctx.callbacks[6].callback(args);
    }

    short utp_call_get_udp_mtu(utp_context ctx, UTPSocketImpl socket, InetSocketAddress address) {
        if (ctx.callbacks[9] == null) {
            return 0;
        }
        _utp_callback_arguments args = utp_callback_arguments;
        args.callback_type = 9;
        args.context = ctx;
        args.socket = socket;
        args.address = address;
        return (short)ctx.callbacks[9].callback(args);
    }

    short utp_call_get_udp_overhead(utp_context ctx, UTPSocketImpl socket, InetSocketAddress address) {
        if (ctx.callbacks[10] == null) {
            return 0;
        }
        _utp_callback_arguments args = utp_callback_arguments;
        args.callback_type = 10;
        args.context = ctx;
        args.socket = socket;
        args.address = address;
        return (short)ctx.callbacks[10].callback(args);
    }

    long utp_call_get_milliseconds(utp_context ctx, UTPSocketImpl socket) {
        if (ctx.callbacks[11] == null) {
            return 0L;
        }
        _utp_callback_arguments args = utp_callback_arguments;
        args.callback_type = 11;
        args.context = ctx;
        args.socket = socket;
        return ctx.callbacks[11].callback(args);
    }

    long utp_call_get_microseconds(utp_context ctx, UTPSocketImpl socket) {
        if (ctx.callbacks[12] == null) {
            return 0L;
        }
        _utp_callback_arguments args = utp_callback_arguments;
        args.callback_type = 12;
        args.context = ctx;
        args.socket = socket;
        return ctx.callbacks[12].callback(args);
    }

    int utp_call_get_random(utp_context ctx, UTPSocketImpl socket) {
        if (ctx.callbacks[13] == null) {
            return 0;
        }
        _utp_callback_arguments args = utp_callback_arguments;
        args.callback_type = 13;
        args.context = ctx;
        args.socket = socket;
        return (int)ctx.callbacks[13].callback(args);
    }

    int utp_call_get_read_buffer_size(utp_context ctx, UTPSocketImpl socket) {
        if (ctx.callbacks[7] == null) {
            return 0;
        }
        _utp_callback_arguments args = utp_callback_arguments;
        args.callback_type = 7;
        args.context = ctx;
        args.socket = socket;
        return (int)ctx.callbacks[7].callback(args);
    }

    void utp_call_log(utp_context ctx, UTPSocketImpl socket, byte[] buf) {
        if (ctx.callbacks[14] == null) {
            return;
        }
        _utp_callback_arguments args = utp_callback_arguments;
        args.callback_type = 14;
        args.context = ctx;
        args.socket = socket;
        args.buf = buf;
        ctx.callbacks[14].callback(args);
    }

    void utp_call_sendto(utp_context ctx, UTPSocketImpl socket, byte[] buf, int len, InetSocketAddress address, int flags) {
        if (ctx.callbacks[15] == null) {
            return;
        }
        _utp_callback_arguments args = utp_callback_arguments;
        args.callback_type = 15;
        args.context = ctx;
        args.socket = socket;
        args.buf = buf;
        args.len = len;
        args.address = address;
        args.flags = flags;
        ctx.callbacks[15].callback(args);
    }

    public UTPTranslatedV2(UTPProviderCallback _callback, UTPTranslated.UTPFunctionTable _fn_table, UTPTranslated.SendToProc _send_to_proc, UTPTranslated.UTPGotIncomingConnection _icp, boolean _test_mode) {
        this.callback = _callback;
        this.fn_table = _fn_table;
        this.send_to_proc = _send_to_proc;
        this.incoming_connection_proc = _icp;
        this.TEST_MODE = _test_mode;
        this.global_ctx = new utp_context();
    }

    public static final int DIV_ROUND_UP(int num, int denom) {
        return (num + denom - 1) / denom;
    }

    public static PacketFormatDeserialised deserialise(byte[] data, int len, boolean test_only) {
        PacketFormatDeserialised res = new PacketFormatDeserialised(data, len, test_only);
        if (res.header == null) {
            return null;
        }
        return res;
    }

    boolean wrapping_compare_less(int lhs, int rhs, long mask) {
        long dist_up = (long)(rhs - lhs) & mask;
        long dist_down = (long)(lhs - rhs) & mask;
        return dist_up < dist_down;
    }

    void send_to_addr(utp_context ctx, byte[] p, InetSocketAddress addr) {
        this.send_to_addr(ctx, p, addr, 0);
    }

    void send_to_addr(utp_context ctx, byte[] p, InetSocketAddress addr, int flags) {
        int len = p.length;
        this.utp_register_sent_packet(ctx, len);
        this.utp_call_sendto(ctx, null, p, len, addr, flags);
    }

    void utp_register_sent_packet(utp_context ctx, int length) {
        if (length <= 723) {
            if (length <= 23) {
                ctx.context_stats._nraw_send[0] = ctx.context_stats._nraw_send[0] + 1;
            } else if (length <= 373) {
                ctx.context_stats._nraw_send[1] = ctx.context_stats._nraw_send[1] + 1;
            } else {
                ctx.context_stats._nraw_send[2] = ctx.context_stats._nraw_send[2] + 1;
            }
        } else if (length <= 1400) {
            ctx.context_stats._nraw_send[3] = ctx.context_stats._nraw_send[3] + 1;
        } else {
            ctx.context_stats._nraw_send[4] = ctx.context_stats._nraw_send[4] + 1;
        }
    }

    void utp_register_recv_packet(UTPSocketImpl conn, int len) {
        if (len <= 723) {
            if (len <= 23) {
                conn.ctx.context_stats._nraw_recv[0] = conn.ctx.context_stats._nraw_recv[0] + 1;
            } else if (len <= 373) {
                conn.ctx.context_stats._nraw_recv[1] = conn.ctx.context_stats._nraw_recv[1] + 1;
            } else {
                conn.ctx.context_stats._nraw_recv[2] = conn.ctx.context_stats._nraw_recv[2] + 1;
            }
        } else if (len <= 1400) {
            conn.ctx.context_stats._nraw_recv[3] = conn.ctx.context_stats._nraw_recv[3] + 1;
        } else {
            conn.ctx.context_stats._nraw_recv[4] = conn.ctx.context_stats._nraw_recv[4] + 1;
        }
    }

    void send_rst(utp_context ctx, InetSocketAddress addr, int conn_id_send, short ack_nr, short seq_nr) {
        PacketFormatV1 pf1;
        PacketFormatV1 pfb = pf1 = new PacketFormatV1();
        pf1.set_version(1);
        pf1.set_type(3);
        pf1.ext = 0;
        pf1.connid = (short)conn_id_send;
        pf1.ack_nr = ack_nr;
        pf1.seq_nr = seq_nr;
        pf1.windowsize = 0;
        this.send_to_addr(ctx, ((PacketFormatBase)pfb).serialise(), addr);
    }

    int utp_process_incoming(UTPSocketImpl conn, PacketFormatDeserialised deserialised, int len) {
        return this.utp_process_incoming(conn, deserialised, len, false);
    }

    int utp_process_incoming(UTPSocketImpl conn, PacketFormatDeserialised deserialised, int len, boolean syn) {
        int actual_delay;
        int their_delay;
        this.utp_register_recv_packet(conn, len);
        conn.ctx.current_ms = this.utp_call_get_milliseconds(conn.ctx, conn);
        PacketFormatV1 pf1 = deserialised.header;
        short pk_seq_nr = pf1.seq_nr;
        short pk_ack_nr = pf1.ack_nr;
        byte pk_flags = pf1.type();
        if (pk_flags >= 5) {
            return 0;
        }
        long time = this.utp_call_get_microseconds(conn.ctx, conn);
        int curr_window = Math.max(conn.cur_window_packets.i + 3, 3);
        if ((pk_flags != 4 || conn.state != 3) && (this.wrapping_compare_less(conn.seq_nr.i - 1, pk_ack_nr, 65535L) || this.wrapping_compare_less(pk_ack_nr, conn.seq_nr.i - 1 - curr_window, 65535L))) {
            return 0;
        }
        byte[] selack_bytes = null;
        for (PacketFormatExtensionDeserialised ext_record : deserialised.exts) {
            byte extension = ext_record.ext;
            switch (extension) {
                case 1: {
                    selack_bytes = ext_record.ext_data;
                    break;
                }
                case 2: {
                    conn.extensions = ext_record.ext_data;
                }
            }
        }
        if (conn.state == 2) {
            conn.ack_nr.set((short)(pk_seq_nr - 1 & 0xFFFF));
        }
        conn.last_got_packet = conn.ctx.current_ms;
        if (syn) {
            return 0;
        }
        int seqnr = pk_seq_nr - conn.ack_nr.i - 1 & 0xFFFF;
        if (seqnr >= 1024) {
            if (seqnr >= 64512 && pk_flags != 2) {
                conn.schedule_ack();
            }
            return 0;
        }
        int acks = pk_ack_nr - (conn.seq_nr.i - 1 - conn.cur_window_packets.i) & 0xFFFF;
        if (acks > conn.cur_window_packets.i) {
            acks = 0;
        }
        if (conn.cur_window_packets.i > 0) {
            if (pk_ack_nr == (conn.seq_nr.i - conn.cur_window_packets.i - 1 & 0xFFFF) && conn.cur_window_packets.i > 0 && pk_flags == 2) {
                conn.duplicate_ack = (byte)(conn.duplicate_ack + 1);
                if (conn.duplicate_ack == 3 && conn.mtu_probe_seq != 0) {
                    if (pk_ack_nr == (conn.mtu_probe_seq - 1 & 0xFFFF)) {
                        conn.mtu_ceiling = conn.mtu_probe_size - 1;
                        conn.mtu_search_update();
                    } else {
                        conn.mtu_probe_size = 0;
                        conn.mtu_probe_seq = 0;
                    }
                }
            } else {
                conn.duplicate_ack = 0;
            }
        }
        int acked_bytes = 0;
        long min_rtt = Long.MAX_VALUE;
        long now = this.utp_call_get_microseconds(conn.ctx, conn);
        int i = 0;
        while (i < acks) {
            int seq = conn.seq_nr.i - conn.cur_window_packets.i + i & 0xFFFF;
            OutgoingPacket pkt = conn.outbuf.get(seq);
            if (pkt != null && pkt.transmissions != 0) {
                acked_bytes += pkt.payload;
                if (conn.mtu_probe_seq != 0 && seq == conn.mtu_probe_seq) {
                    conn.mtu_floor = conn.mtu_probe_size;
                    conn.mtu_search_update();
                }
                min_rtt = pkt.time_sent < now ? Math.min(min_rtt, now - pkt.time_sent) : Math.min(min_rtt, 50000L);
            }
            ++i;
        }
        if (selack_bytes != null) {
            long[] min_rtt_updated = new long[]{min_rtt};
            acked_bytes += conn.selective_ack_bytes(pk_ack_nr + 2 & 0xFFFF, selack_bytes, selack_bytes.length, min_rtt_updated);
            min_rtt = min_rtt_updated[0];
        }
        long p = pf1.tv_usec;
        conn.last_measured_delay = conn.ctx.current_ms;
        conn.reply_micro = their_delay = (int)(p == 0L ? 0L : time - p);
        int prev_delay_base = conn.their_hist.delay_base;
        if (their_delay != 0) {
            conn.their_hist.add_sample(their_delay, conn.ctx.current_ms);
        }
        if (prev_delay_base != 0 && this.wrapping_compare_less(conn.their_hist.delay_base, prev_delay_base, 0xFFFFFFFFL) && prev_delay_base - conn.their_hist.delay_base <= 10000) {
            conn.our_hist.shift(prev_delay_base - conn.their_hist.delay_base);
        }
        if ((actual_delay = (int)(UTPTranslatedV2.uint32(pf1.reply_micro) == Integer.MAX_VALUE ? 0L : UTPTranslatedV2.uint32(pf1.reply_micro))) != 0) {
            conn.our_hist.add_sample(actual_delay, conn.ctx.current_ms);
            if (conn.average_delay_base == 0) {
                conn.average_delay_base = actual_delay;
            }
            long average_delay_sample = 0L;
            long dist_down = (long)(conn.average_delay_base - actual_delay) & 0xFFFFFFFFL;
            long dist_up = (long)(actual_delay - conn.average_delay_base) & 0xFFFFFFFFL;
            average_delay_sample = dist_down > dist_up ? dist_up : -dist_down;
            conn.current_delay_sum += average_delay_sample;
            ++conn.current_delay_samples;
            if (conn.ctx.current_ms > conn.average_sample_time) {
                int prev_average_delay = conn.average_delay;
                conn.average_delay = (int)(conn.current_delay_sum / (long)conn.current_delay_samples);
                conn.average_sample_time += 5000L;
                conn.current_delay_sum = 0L;
                conn.current_delay_samples = 0;
                int min_sample = Math.min(prev_average_delay, conn.average_delay);
                int max_sample = Math.max(prev_average_delay, conn.average_delay);
                int adjust = 0;
                if (min_sample > 0) {
                    adjust = -min_sample;
                } else if (max_sample < 0) {
                    adjust = -max_sample;
                }
                if (adjust != 0) {
                    conn.average_delay_base -= adjust;
                    conn.average_delay += adjust;
                    prev_average_delay += adjust;
                }
                int drift = conn.average_delay - prev_average_delay;
                conn.clock_drift = (conn.clock_drift * 7 + drift) / 8;
                conn.clock_drift_raw = drift;
            }
        }
        if (conn.our_hist.get_value() > min_rtt) {
            conn.our_hist.shift((int)(conn.our_hist.get_value() - min_rtt));
        }
        if (actual_delay != 0 && acked_bytes >= 1) {
            conn.apply_ccontrol(acked_bytes, actual_delay, min_rtt);
        }
        if (acks <= conn.cur_window_packets.i) {
            conn.max_window_user = pf1.windowsize & Integer.MAX_VALUE;
            if (conn.max_window_user == 0) {
                conn.zerowindow_time = conn.ctx.current_ms + 15000L;
            }
            if (pk_flags == 0 && conn.state == 3) {
                conn.state = 4;
            }
            if (pk_flags == 2 && conn.state == 2) {
                conn.state = 4;
                if (conn.ctx.callbacks[2] != null) {
                    this.utp_call_on_connect(conn.ctx, conn);
                } else {
                    this.utp_call_on_state_change(conn.ctx, conn, 1);
                }
            } else if (conn.state == 8 && conn.cur_window_packets.i == acks) {
                conn.state = 10;
            }
            if (this.wrapping_compare_less(conn.fast_resend_seq_nr.i, pk_ack_nr + 1 & 0xFFFF, 65535L)) {
                conn.fast_resend_seq_nr.set((short)(pk_ack_nr + 1 & 0xFFFF));
            }
            int i2 = 0;
            while (i2 < acks) {
                int ack_status = conn.ack_packet(new UnsignedShort((short)(conn.seq_nr.i - conn.cur_window_packets.i)));
                if (ack_status == 2) break;
                conn.cur_window_packets.dec();
                ++i2;
            }
            while (conn.cur_window_packets.i > 0 && conn.outbuf.get(conn.seq_nr.i - conn.cur_window_packets.i) == null) {
                conn.cur_window_packets.dec();
            }
            if (conn.cur_window_packets.i == 1) {
                OutgoingPacket pkt = conn.outbuf.get(conn.seq_nr.i - 1);
                if (pkt.transmissions == 0) {
                    conn.send_packet(pkt);
                }
            }
            if (conn.fast_timeout) {
                if ((conn.seq_nr.i - conn.cur_window_packets.i & 0xFFFF) != conn.fast_resend_seq_nr.i) {
                    conn.fast_timeout = false;
                } else {
                    OutgoingPacket pkt = conn.outbuf.get(conn.seq_nr.i - conn.cur_window_packets.i);
                    if (pkt != null && pkt.transmissions > 0) {
                        conn.fast_resend_seq_nr.inc();
                        conn.send_packet(pkt);
                    }
                }
            }
        }
        if (selack_bytes != null) {
            conn.selective_ack(pk_ack_nr + 2, selack_bytes, selack_bytes.length);
        }
        if (conn.state == 5 && !conn.is_full()) {
            conn.state = 4;
            this.utp_call_on_state_change(conn.ctx, conn, 2);
        }
        if (pk_flags == 2) {
            return 0;
        }
        if (conn.state != 4 && conn.state != 5 && conn.state != 8) {
            return 0;
        }
        if (pk_flags == 1 && !conn.got_fin) {
            conn.got_fin = true;
            conn.eof_pkt.set(pk_seq_nr);
        }
        ByteBuffer packet_payload = deserialised.payload;
        if (seqnr == 0) {
            int count = packet_payload.remaining();
            if (count > 0 && conn.state != 8) {
                this.utp_call_on_read(conn.ctx, conn, packet_payload, count);
            }
            conn.ack_nr.inc();
            while (true) {
                ByteBuffer pending;
                if (conn.got_fin && conn.eof_pkt.i == conn.ack_nr.i) {
                    if (conn.state != 8) {
                        conn.state = 6;
                        conn.rto_timeout = conn.ctx.current_ms + (long)Math.min(conn.rto * 3, 60);
                        this.utp_call_on_state_change(conn.ctx, conn, 3);
                    }
                    conn.send_ack();
                    conn.reorder_count.set(0);
                }
                if (conn.reorder_count.i == 0 || (pending = conn.inbuf.get(conn.ack_nr.i + 1)) == null) break;
                conn.inbuf.put(conn.ack_nr.i + 1, null);
                count = pending.remaining();
                if (count > 0 && conn.state != 8) {
                    this.utp_call_on_read(conn.ctx, conn, pending, count);
                }
                conn.ack_nr.inc();
                conn.reorder_count.dec();
            }
            conn.schedule_ack();
        } else {
            if (conn.got_fin && pk_seq_nr > conn.eof_pkt.i) {
                return 0;
            }
            if (seqnr > 1023) {
                return 0;
            }
            conn.inbuf.ensure_size(pk_seq_nr + 1, seqnr + 1);
            if (conn.inbuf.get(pk_seq_nr) != null) {
                return 0;
            }
            conn.inbuf.put(pk_seq_nr, packet_payload);
            conn.reorder_count.inc();
            conn.schedule_ack();
        }
        return packet_payload.remaining();
    }

    byte UTP_Version(PacketFormatV1 pf) {
        return pf.type() < 5 && pf.ext < 3 ? pf.version() : (byte)0;
    }

    void utp_initialize_socket(UTPSocketImpl conn, InetSocketAddress addr, boolean need_seed_gen, int conn_seed, int conn_id_recv, int conn_id_send) {
        if (need_seed_gen) {
            do {
                conn_seed = this.utp_call_get_random(conn.ctx, conn);
            } while (conn.ctx.utp_sockets.get(new UTPSocketKey(addr, conn_seed &= 0xFFFF)) != null);
            conn_id_recv += conn_seed;
            conn_id_send += conn_seed;
        }
        conn.state = 1;
        conn.conn_seed = conn_seed;
        conn.conn_id_recv = conn_id_recv;
        conn.conn_id_send = conn_id_send;
        conn.addr = addr;
        conn.last_got_packet = conn.ctx.current_ms = this.utp_call_get_milliseconds(conn.ctx, null);
        conn.last_sent_packet = conn.ctx.current_ms;
        conn.last_measured_delay = conn.ctx.current_ms + 0x70000000L;
        conn.average_sample_time = conn.ctx.current_ms + 5000L;
        conn.last_rwin_decay = conn.ctx.current_ms - 100L;
        conn.our_hist.clear(conn.ctx.current_ms);
        conn.their_hist.clear(conn.ctx.current_ms);
        conn.rtt_hist.clear(conn.ctx.current_ms);
        conn.mtu_reset();
        conn.mtu_last = conn.mtu_ceiling;
        conn.ctx.utp_sockets.put(new UTPSocketKey(conn.addr, conn.conn_id_recv), new UTPSocketKeyData(conn));
        conn.max_window = conn.get_packet_size();
    }

    UTPSocketImpl utp_create_socket(utp_context ctx) {
        if (ctx == null) {
            return null;
        }
        UTPSocketImpl conn = new UTPSocketImpl();
        conn.state = 0;
        conn.ctx = ctx;
        conn.userdata = null;
        conn.reorder_count.set(0);
        conn.duplicate_ack = 0;
        conn.timeout_seq_nr.set(0);
        conn.last_rcv_win = 0;
        conn.got_fin = false;
        conn.fast_timeout = false;
        conn.rtt = 0;
        conn.retransmit_timeout = 0;
        conn.rto_timeout = 0L;
        conn.zerowindow_time = 0L;
        conn.average_delay = 0;
        conn.current_delay_samples = 0;
        conn.cur_window = 0;
        conn.eof_pkt.set(0);
        conn.last_maxed_out_window = 0L;
        conn.mtu_probe_seq = 0;
        conn.mtu_probe_size = 0;
        conn.current_delay_sum = 0L;
        conn.average_delay_base = 0;
        conn.retransmit_count = 0;
        conn.rto = 3000;
        conn.rtt_var = 800;
        conn.seq_nr.set(1);
        conn.ack_nr.set(0);
        conn.max_window_user = 365925;
        conn.cur_window_packets.set(0);
        conn.fast_resend_seq_nr.set(conn.seq_nr.i);
        conn.target_delay = ctx.target_delay;
        conn.reply_micro = 0;
        conn.opt_sndbuf = ctx.opt_sndbuf;
        conn.opt_rcvbuf = ctx.opt_rcvbuf;
        conn.slow_start = true;
        conn.ssthresh = conn.opt_sndbuf;
        conn.clock_drift = 0;
        conn.clock_drift_raw = 0;
        conn.outbuf.mask = 15;
        conn.inbuf.mask = 15;
        conn.outbuf.elements = new Object[16];
        conn.inbuf.elements = new Object[16];
        return conn;
    }

    int utp_context_set_option(utp_context ctx, int opt, int val) {
        if (ctx == null) {
            return -1;
        }
        switch (opt) {
            case 16: {
                ctx.log_normal = val != 0;
                return 0;
            }
            case 17: {
                ctx.log_mtu = val != 0;
                return 0;
            }
            case 18: {
                ctx.log_debug = val != 0;
                return 0;
            }
            case 21: {
                ctx.target_delay = val;
                return 0;
            }
            case 19: {
                ctx.opt_sndbuf = val;
                return 0;
            }
            case 20: {
                ctx.opt_rcvbuf = val;
                return 0;
            }
        }
        return -1;
    }

    int utp_context_get_option(utp_context ctx, int opt) {
        if (ctx == null) {
            return -1;
        }
        switch (opt) {
            case 16: {
                return ctx.log_normal ? 1 : 0;
            }
            case 17: {
                return ctx.log_mtu ? 1 : 0;
            }
            case 18: {
                return ctx.log_debug ? 1 : 0;
            }
            case 21: {
                return ctx.target_delay;
            }
            case 19: {
                return ctx.opt_sndbuf;
            }
            case 20: {
                return ctx.opt_rcvbuf;
            }
        }
        return -1;
    }

    int utp_setsockopt(UTPSocketImpl conn, int opt, int val) {
        if (conn == null) {
            return -1;
        }
        switch (opt) {
            case 19: {
                conn.opt_sndbuf = val;
                return 0;
            }
            case 20: {
                conn.opt_rcvbuf = val;
                return 0;
            }
            case 21: {
                conn.target_delay = val;
                return 0;
            }
        }
        return -1;
    }

    int utp_getsockopt(UTPSocketImpl conn, int opt) {
        if (conn == null) {
            return -1;
        }
        switch (opt) {
            case 19: {
                return conn.opt_sndbuf;
            }
            case 20: {
                return conn.opt_rcvbuf;
            }
            case 21: {
                return conn.target_delay;
            }
        }
        return -1;
    }

    int utp_connect(UTPSocketImpl conn, InetSocketAddress addr) {
        if (conn == null) {
            return -1;
        }
        if (conn.state != 0) {
            conn.state = 10;
            return -1;
        }
        this.utp_initialize_socket(conn, addr, true, 0, 0, 1);
        conn.state = 2;
        conn.ctx.current_ms = this.utp_call_get_milliseconds(conn.ctx, conn);
        conn.retransmit_timeout = 3000;
        conn.rto_timeout = conn.ctx.current_ms + (long)conn.retransmit_timeout;
        conn.last_rcv_win = conn.get_rcv_window();
        conn.seq_nr.set(this.utp_call_get_random(conn.ctx, conn));
        int header_size = 20;
        OutgoingPacket pkt = new OutgoingPacket();
        PacketFormatExtensionsV1 p1 = new PacketFormatExtensionsV1();
        pkt.packet_header = p1;
        p1.set_version(1);
        p1.set_type(4);
        p1.ext = 0;
        p1.connid = (short)conn.conn_id_recv;
        p1.windowsize = conn.last_rcv_win;
        p1.seq_nr = (short)conn.seq_nr.i;
        pkt.transmissions = 0;
        pkt.length = header_size;
        pkt.payload = 0;
        conn.outbuf.ensure_size(conn.seq_nr.i, conn.cur_window_packets.i);
        conn.outbuf.put(conn.seq_nr.i, pkt);
        conn.seq_nr.inc();
        conn.cur_window_packets.inc();
        conn.send_packet(pkt);
        return 0;
    }

    int utp_process_udp(utp_context ctx, byte[] buffer, int len, InetSocketAddress addr) {
        UTPSocketKeyData keyData;
        if (ctx == null) {
            return 0;
        }
        if (buffer == null) {
            return 0;
        }
        PacketFormatDeserialised deserialised = UTPTranslatedV2.deserialise(buffer, len, false);
        if (deserialised == null) {
            return 0;
        }
        PacketFormatV1 pf1 = deserialised.header;
        byte version = this.UTP_Version(pf1);
        int id = pf1.connid & 0xFFFF;
        if (version != 1) {
            return 0;
        }
        byte flags = pf1.type();
        if (flags == 3) {
            UTPSocketKeyData keyData2 = ctx.utp_sockets.get(new UTPSocketKey(addr, id));
            if (keyData2 != null || (keyData2 = ctx.utp_sockets.get(new UTPSocketKey(addr, id + 1))) != null && ((UTPSocketKeyData)keyData2).socket.conn_id_send == id || (keyData2 = ctx.utp_sockets.get(new UTPSocketKey(addr, id - 1))) != null && ((UTPSocketKeyData)keyData2).socket.conn_id_send == id) {
                UTPSocketImpl conn = keyData2.socket;
                conn.state = conn.state == 8 ? 10 : 9;
                this.utp_call_on_overhead_statistics(conn.ctx, conn, 0, len + conn.get_udp_overhead(), 2);
                int err = conn.state == 2 ? 0 : 1;
                this.utp_call_on_error(conn.ctx, conn, err);
            }
            return 1;
        }
        if (flags != 4) {
            UTPSocketImpl conn = null;
            keyData = ctx.utp_sockets.get(new UTPSocketKey(addr, id));
            if (keyData != null) {
                conn = keyData.socket;
            }
            if (conn != null) {
                int read = this.utp_process_incoming(conn, deserialised, len);
                this.utp_call_on_overhead_statistics(conn.ctx, conn, 0, len - read + conn.get_udp_overhead(), 4);
                return 1;
            }
        }
        short seq_nr = pf1.seq_nr;
        if (flags != 4) {
            ctx.current_ms = this.utp_call_get_milliseconds(ctx, null);
            int i = 0;
            while (i < ctx.rst_info.size()) {
                RST_Info info = ctx.rst_info.get(i);
                if (info.connid == id && info.addr == addr && info.ack_nr == seq_nr) {
                    info.timestamp = ctx.current_ms;
                    return 1;
                }
                ++i;
            }
            if (ctx.rst_info.size() > 1000) {
                return 1;
            }
            RST_Info r = new RST_Info();
            ctx.rst_info.add(r);
            r.addr = addr;
            r.connid = id;
            r.ack_nr = seq_nr;
            r.timestamp = ctx.current_ms;
            this.send_rst(ctx, addr, id, seq_nr, (short)this.utp_call_get_random(ctx, null));
            return 1;
        }
        if (ctx.callbacks[1] != null) {
            keyData = ctx.utp_sockets.get(new UTPSocketKey(addr, id + 1));
            if (keyData != null) {
                return 1;
            }
            if (ctx.utp_sockets.size() > 3000) {
                return 1;
            }
            if (this.utp_call_on_firewall(ctx, addr) != 0) {
                return 1;
            }
            UTPSocketImpl conn = this.utp_create_socket(ctx);
            this.utp_initialize_socket(conn, addr, false, id, id + 1, id);
            conn.ack_nr.set(seq_nr);
            conn.seq_nr.set(this.utp_call_get_random(ctx, null));
            conn.fast_resend_seq_nr.set(conn.seq_nr.i);
            conn.state = 3;
            this.utp_call_on_accept(ctx, conn, addr);
            int read = this.utp_process_incoming(conn, deserialised, len, true);
            conn.send_ack(true);
            this.utp_call_on_overhead_statistics(conn.ctx, conn, 0, len - read + conn.get_udp_overhead(), 4);
            this.utp_call_on_overhead_statistics(conn.ctx, conn, 1, conn.get_overhead(), 3);
        }
        return 1;
    }

    int utp_writev(UTPSocketImpl conn, ByteBuffer[] iovec_input, int num_iovecs) {
        if (conn == null) {
            return -1;
        }
        if (iovec_input == null) {
            return -1;
        }
        if (num_iovecs == 0) {
            return -1;
        }
        if (num_iovecs > 1024) {
            num_iovecs = 1024;
        }
        int bytes = 0;
        int sent = 0;
        int i = 0;
        while (i < num_iovecs) {
            bytes += iovec_input[i].remaining();
            ++i;
        }
        if (conn.state != 4) {
            return 0;
        }
        conn.ctx.current_ms = this.utp_call_get_milliseconds(conn.ctx, conn);
        int packet_size = conn.get_packet_size();
        int num_to_send = Math.min(bytes, packet_size);
        while (!conn.is_full(num_to_send)) {
            sent += num_to_send;
            conn.write_outgoing_packet(num_to_send, 0, iovec_input, num_iovecs);
            num_to_send = Math.min(bytes -= num_to_send, packet_size);
            if (num_to_send != 0) continue;
            return sent;
        }
        boolean full = conn.is_full();
        if (full) {
            conn.state = 5;
        }
        return sent;
    }

    void utp_read_drained(UTPSocketImpl conn) {
        if (conn == null) {
            return;
        }
        if (conn.state == 0) {
            return;
        }
        int rcvwin = conn.get_rcv_window();
        if (rcvwin > conn.last_rcv_win) {
            if (conn.last_rcv_win == 0) {
                conn.send_ack();
            } else {
                conn.ctx.current_ms = this.utp_call_get_milliseconds(conn.ctx, conn);
                conn.schedule_ack();
            }
        }
    }

    void utp_issue_deferred_acks(utp_context ctx) {
        if (ctx == null) {
            return;
        }
        if (ctx.ack_sockets.size() > 0) {
            ArrayList<UTPSocketImpl> temp = new ArrayList<UTPSocketImpl>(ctx.ack_sockets);
            for (UTPSocketImpl conn : temp) {
                conn.send_ack();
            }
        }
    }

    void utp_check_timeouts(utp_context ctx) {
        if (ctx == null) {
            return;
        }
        ctx.current_ms = this.utp_call_get_milliseconds(ctx, null);
        if (ctx.current_ms - ctx.last_check < 500L) {
            return;
        }
        ctx.last_check = ctx.current_ms;
        if (ctx.rst_info.size() > 0) {
            Iterator rst_it = ctx.rst_info.iterator();
            while (rst_it.hasNext()) {
                RST_Info info = (RST_Info)rst_it.next();
                if ((int)(ctx.current_ms - info.timestamp) < 10000) continue;
                rst_it.remove();
            }
        }
        if (ctx.utp_sockets.size() > 0) {
            Iterator<UTPSocketKeyData> socket_it = ctx.utp_sockets.values().iterator();
            ArrayList<UTPSocketImpl> to_free = new ArrayList<UTPSocketImpl>();
            while (socket_it.hasNext()) {
                UTPSocketImpl socket = socket_it.next().socket;
                socket.check_timeouts();
                if (socket.state != 10) continue;
                to_free.add(socket);
            }
            for (UTPSocketImpl s : to_free) {
                s.UTP_Free();
            }
        }
    }

    void utp_close(UTPSocketImpl conn) {
        if (conn == null) {
            return;
        }
        assert (conn.state != 0 && conn.state != 7 && conn.state != 8 && conn.state != 10);
        switch (conn.state) {
            case 4: 
            case 5: {
                conn.state = 8;
                conn.write_outgoing_packet(0, 1, null, 0);
                break;
            }
            case 2: {
                conn.rto_timeout = this.utp_call_get_milliseconds(conn.ctx, conn) + (long)Math.min(conn.rto * 2, 60);
            }
            case 6: {
                conn.state = 7;
                break;
            }
            default: {
                conn.state = 10;
            }
        }
    }

    @Override
    public void UTP_CheckTimeouts() {
        this.utp_check_timeouts(this.global_ctx);
    }

    @Override
    public void UTP_IncomingIdle() {
        this.utp_issue_deferred_acks(this.global_ctx);
    }

    @Override
    public boolean isValidPacket(byte[] buffer, int len) {
        PacketFormatDeserialised deserialised = UTPTranslatedV2.deserialise(buffer, len, true);
        return deserialised != null;
    }

    @Override
    public UTPSocket UTP_Create() throws UTPProviderException {
        return this.utp_create_socket(this.global_ctx);
    }

    @Override
    public void UTP_SetUserData(UTPSocket conn, Object user_data) throws UTPProviderException {
        ((UTPSocketImpl)conn).userdata = user_data;
    }

    @Override
    public void UTP_Connect(UTPSocket conn, InetSocketAddress address) throws UTPProviderException {
        UTPSocketImpl socket = (UTPSocketImpl)conn;
        if (this.utp_connect(socket, address) != 0) {
            this.utp_close(socket);
            throw new UTPProviderException("Connect failed");
        }
    }

    @Override
    public boolean UTP_IsIncomingUTP(UTPTranslated.UTPGotIncomingConnection incoming_proc, UTPTranslated.SendToProc send_to_proc, Object send_to_userdata, byte[] buffer, int len, InetSocketAddress addr) {
        return this.utp_process_udp(this.global_ctx, buffer, len, addr) != 0;
    }

    @Override
    public void UTP_GetPeerName(UTPSocket conn, InetSocketAddress[] addr_out) {
        addr_out[0] = ((UTPSocketImpl)conn).addr;
    }

    @Override
    public int UTP_GetSocketConnectionID(UTPSocket _conn) {
        UTPSocketImpl conn = (UTPSocketImpl)_conn;
        return conn.conn_id_recv;
    }

    @Override
    public boolean UTP_Write(UTPSocket conn, int bytes) {
        Debug.out("Not Supported");
        return false;
    }

    @Override
    public boolean UTP_Write(UTPSocket conn, ByteBuffer[] buffers, int start, int len) throws UTPProviderException {
        ByteBuffer[] b;
        if (start == 0) {
            b = buffers;
        } else {
            b = new ByteBuffer[len];
            System.arraycopy(buffers, start, b, 0, len);
        }
        int res = this.utp_writev((UTPSocketImpl)conn, b, len);
        if (res < 0) {
            throw new UTPProviderException("Write failed");
        }
        return res > 0;
    }

    @Override
    public void UTP_RBDrained(UTPSocket conn) {
        this.utp_read_drained((UTPSocketImpl)conn);
    }

    @Override
    public void UTP_Close(UTPSocket conn) {
        this.utp_close((UTPSocketImpl)conn);
    }

    @Override
    public UTPSocket UTP_Create(UTPTranslated.SendToProc send_to_proc, Object send_to_userdata, InetSocketAddress addr) throws UTPProviderException {
        throw new UTPProviderException("Not Supported");
    }

    @Override
    public void UTP_Connect(UTPSocket conn) throws UTPProviderException {
        throw new UTPProviderException("Not Supported");
    }

    @Override
    public void UTP_SetCallbacks(UTPSocket conn, UTPTranslated.UTPFunctionTable funcs, Object userdata) throws UTPProviderException {
        throw new UTPProviderException("Not Supported");
    }

    private int convertOption(int po) {
        if (po == 1) {
            return 20;
        }
        if (po == 2) {
            return 19;
        }
        Debug.out("derp");
        return 0;
    }

    @Override
    public void UTP_SetOption(int provider_option, int value) {
        int existing;
        boolean is_buff_opt;
        int option = this.convertOption(provider_option);
        boolean bl = is_buff_opt = option == 19 || option == 20;
        if (is_buff_opt) {
            value *= 1024;
        }
        if ((existing = this.utp_context_get_option(this.global_ctx, option)) == value) {
            return;
        }
        this.utp_context_set_option(this.global_ctx, option, value);
        if (is_buff_opt) {
            for (UTPSocketKeyData data : this.global_ctx.utp_sockets.values()) {
                UTPSocketImpl socket = data.socket;
                if (this.utp_getsockopt(socket, option) != existing) continue;
                this.utp_setsockopt(socket, option, value);
            }
        }
    }

    @Override
    public int UTP_GetOption(int provider_option) {
        int option = this.convertOption(provider_option);
        int value = this.utp_context_get_option(this.global_ctx, option);
        if (option == 19 || option == 20) {
            value /= 1024;
        }
        return value;
    }

    class DelayHist {
        int delay_base;
        int[] cur_delay_hist = new int[3];
        int cur_delay_idx;
        int[] delay_base_hist = new int[13];
        int delay_base_idx;
        long delay_base_time;
        boolean delay_base_initialized;

        DelayHist() {
        }

        void clear(long current_ms) {
            this.delay_base_initialized = false;
            this.delay_base = 0;
            this.cur_delay_idx = 0;
            this.delay_base_idx = 0;
            this.delay_base_time = current_ms;
            int i = 0;
            while (i < 3) {
                this.cur_delay_hist[i] = 0;
                ++i;
            }
            i = 0;
            while (i < 13) {
                this.delay_base_hist[i] = 0;
                ++i;
            }
        }

        void shift(int offset) {
            int i = 0;
            while (i < 13) {
                int n = i++;
                this.delay_base_hist[n] = this.delay_base_hist[n] + offset;
            }
            this.delay_base += offset;
        }

        void add_sample(int sample, long current_ms) {
            int delay;
            if (!this.delay_base_initialized) {
                int i = 0;
                while (i < 13) {
                    this.delay_base_hist[i] = sample;
                    ++i;
                }
                this.delay_base = sample;
                this.delay_base_initialized = true;
            }
            if (UTPTranslatedV2.this.wrapping_compare_less(sample, this.delay_base_hist[this.delay_base_idx], 0xFFFFFFFFL)) {
                this.delay_base_hist[this.delay_base_idx] = sample;
            }
            if (UTPTranslatedV2.this.wrapping_compare_less(sample, this.delay_base, 0xFFFFFFFFL)) {
                this.delay_base = sample;
            }
            this.cur_delay_hist[this.cur_delay_idx] = delay = (int)((long)sample & 0xFFFFFFFFL - (long)this.delay_base & 0xFFFFFFFFL);
            this.cur_delay_idx = (this.cur_delay_idx + 1) % 3;
            if (current_ms - this.delay_base_time > 60000L) {
                this.delay_base_time = current_ms;
                this.delay_base_idx = (this.delay_base_idx + 1) % 13;
                this.delay_base_hist[this.delay_base_idx] = sample;
                this.delay_base = this.delay_base_hist[0];
                int i = 0;
                while (i < 13) {
                    if (UTPTranslatedV2.this.wrapping_compare_less(this.delay_base_hist[i], this.delay_base, 0xFFFFFFFFL)) {
                        this.delay_base = this.delay_base_hist[i];
                    }
                    ++i;
                }
            }
        }

        long get_value() {
            long value = 0xFFFFFFFFL;
            int i = 0;
            while (i < 3) {
                value = Math.min((long)this.cur_delay_hist[i] & 0xFFFFFFFFL, value);
                ++i;
            }
            return UTPTranslatedV2.uint32(value);
        }
    }

    static class OutgoingPacket {
        int length;
        int payload;
        long time_sent;
        int transmissions;
        boolean need_resend;
        PacketFormatBase packet_header;
        byte[] packet_payload;

        OutgoingPacket() {
        }
    }

    static abstract class PacketFormatBase {
        PacketFormatBase() {
        }

        public abstract byte[] serialise();
    }

    static abstract class PacketFormatBaseV1
    extends PacketFormatBase {
        PacketFormatBaseV1() {
        }
    }

    static class PacketFormatDeserialised {
        PacketFormatV1 header;
        List<PacketFormatExtensionDeserialised> exts;
        ByteBuffer payload;

        PacketFormatDeserialised(byte[] data, int len, boolean test_only) {
            boolean is_v1;
            if (len < 20) {
                return;
            }
            byte type = (byte)(data[0] >> 4);
            byte version = (byte)(data[0] & 0xF);
            byte ext = data[1];
            boolean bl = is_v1 = version == 1 && type < 5 && ext < 3;
            if (!is_v1) {
                return;
            }
            this.header = new PacketFormatV1(data);
            int pos = 20;
            this.exts = new ArrayList<PacketFormatExtensionDeserialised>();
            while (ext != 0) {
                byte ext_len;
                if (len - pos < 2) {
                    this.header = null;
                    return;
                }
                byte ext_next = data[pos++];
                if (len - pos < (ext_len = data[pos++])) {
                    this.header = null;
                    return;
                }
                if (test_only) {
                    pos += ext_len;
                    ext = ext_next;
                    continue;
                }
                byte[] ext_data = new byte[ext_len];
                System.arraycopy(data, pos, ext_data, 0, ext_len);
                pos += ext_len;
                PacketFormatExtensionDeserialised x = new PacketFormatExtensionDeserialised(ext, ext_data);
                this.exts.add(x);
                ext = ext_next;
            }
            if (!test_only) {
                this.payload = pos < len ? ByteBuffer.wrap(data, pos, len - pos) : ByteBuffer.allocate(0);
            }
        }
    }

    static class PacketFormatExtensionDeserialised {
        byte ext;
        byte[] ext_data;

        PacketFormatExtensionDeserialised(byte _ext, byte[] _ext_data) {
            this.ext = _ext;
            this.ext_data = _ext_data;
        }
    }

    static class PacketFormatExtensionsV1
    extends PacketFormatV1 {
        byte ext_next;
        byte ext_len;
        byte[] extensions = new byte[8];

        PacketFormatExtensionsV1() {
        }

        PacketFormatExtensionsV1(byte[] data) {
            super(data);
        }

        @Override
        public byte[] serialise() {
            if (this.ext == 0) {
                return super.serialise();
            }
            return this.serialise(new byte[this.ext == 1 ? 26 : 30]);
        }

        @Override
        public byte[] serialise(byte[] buffer) {
            super.serialise(buffer);
            if (this.ext != 0) {
                int pos = 20;
                buffer[pos++] = this.ext_next;
                buffer[pos++] = this.ext_len;
                System.arraycopy(this.extensions, 0, buffer, pos, this.ext == 1 ? 4 : 8);
            }
            return buffer;
        }
    }

    static class PacketFormatV1
    extends PacketFormatBaseV1 {
        byte version;
        byte type;
        byte ext;
        short connid;
        int tv_usec;
        int reply_micro;
        int windowsize;
        short seq_nr;
        short ack_nr;

        PacketFormatV1() {
        }

        PacketFormatV1(byte[] data) {
            this.type = (byte)(data[0] >> 4);
            this.version = (byte)(data[0] & 0xF);
            this.ext = data[1];
            int pos = 2;
            this.connid = (short)(data[pos++] << 8 & 0xFF00 | data[pos++] & 0xFF);
            this.tv_usec = data[pos++] << 24 & 0xFF000000 | data[pos++] << 16 & 0xFF0000 | data[pos++] << 8 & 0xFF00 | data[pos++] & 0xFF;
            this.reply_micro = data[pos++] << 24 & 0xFF000000 | data[pos++] << 16 & 0xFF0000 | data[pos++] << 8 & 0xFF00 | data[pos++] & 0xFF;
            this.windowsize = data[pos++] << 24 & 0xFF000000 | data[pos++] << 16 & 0xFF0000 | data[pos++] << 8 & 0xFF00 | data[pos++] & 0xFF;
            this.seq_nr = (short)(data[pos++] << 8 & 0xFF00 | data[pos++] & 0xFF);
            this.ack_nr = (short)(data[pos++] << 8 & 0xFF00 | data[pos++] & 0xFF);
        }

        protected void set_version(int v) {
            this.version = (byte)v;
        }

        protected void set_type(int t) {
            this.type = (byte)t;
        }

        protected byte version() {
            return this.version;
        }

        protected byte type() {
            return this.type;
        }

        @Override
        public byte[] serialise() {
            return this.serialise(new byte[20]);
        }

        public byte[] serialise(byte[] buffer) {
            int pos = 0;
            buffer[pos++] = (byte)(this.type << 4 | this.version & 0xF);
            buffer[pos++] = this.ext;
            buffer[pos++] = (byte)(this.connid >> 8);
            buffer[pos++] = (byte)this.connid;
            buffer[pos++] = (byte)(this.tv_usec >> 24);
            buffer[pos++] = (byte)(this.tv_usec >> 16);
            buffer[pos++] = (byte)(this.tv_usec >> 8);
            buffer[pos++] = (byte)this.tv_usec;
            buffer[pos++] = (byte)(this.reply_micro >> 24);
            buffer[pos++] = (byte)(this.reply_micro >> 16);
            buffer[pos++] = (byte)(this.reply_micro >> 8);
            buffer[pos++] = (byte)this.reply_micro;
            buffer[pos++] = (byte)(this.windowsize >> 24);
            buffer[pos++] = (byte)(this.windowsize >> 16);
            buffer[pos++] = (byte)(this.windowsize >> 8);
            buffer[pos++] = (byte)this.windowsize;
            buffer[pos++] = (byte)(this.seq_nr >> 8);
            buffer[pos++] = (byte)this.seq_nr;
            buffer[pos++] = (byte)(this.ack_nr >> 8);
            buffer[pos++] = (byte)this.ack_nr;
            return buffer;
        }
    }

    class RST_Info {
        InetSocketAddress addr;
        int connid;
        short ack_nr;
        long timestamp;

        RST_Info() {
        }
    }

    static class SizableCircularBuffer<T> {
        int mask;
        Object[] elements;

        SizableCircularBuffer() {
        }

        T get(int i) {
            return (T)(this.elements != null ? this.elements[i & this.mask] : null);
        }

        void put(int i, T data) {
            this.elements[i & this.mask] = data;
        }

        void ensure_size(int item, int index) {
            if (index > this.mask) {
                this.grow(item, index);
            }
        }

        int size() {
            return this.mask + 1;
        }

        void grow(int item, int index) {
            int size = this.mask + 1;
            while (index >= (size *= 2)) {
            }
            Object[] buf = new Object[size];
            --size;
            int i = 0;
            while (i <= this.mask) {
                buf[item - index + i & size] = this.get(item - index + i);
                ++i;
            }
            this.mask = size;
            this.elements = buf;
        }
    }

    class UTPSocketImpl
    implements UTPSocket {
        InetSocketAddress addr;
        utp_context ctx;
        short retransmit_count;
        final UnsignedShort reorder_count = new UnsignedShort();
        byte duplicate_ack;
        final UnsignedShort cur_window_packets = new UnsignedShort();
        int cur_window;
        int max_window;
        int opt_sndbuf;
        int opt_rcvbuf;
        int target_delay;
        boolean got_fin;
        boolean fast_timeout;
        int max_window_user;
        int state;
        long last_rwin_decay;
        final UnsignedShort eof_pkt = new UnsignedShort();
        final UnsignedShort ack_nr = new UnsignedShort();
        final UnsignedShort seq_nr = new UnsignedShort();
        final UnsignedShort timeout_seq_nr = new UnsignedShort();
        final UnsignedShort fast_resend_seq_nr = new UnsignedShort();
        int reply_micro;
        long last_got_packet;
        long last_sent_packet;
        long last_measured_delay;
        long last_maxed_out_window;
        Object userdata;
        int rtt;
        int rtt_var;
        int rto;
        DelayHist rtt_hist;
        int retransmit_timeout;
        long rto_timeout;
        long zerowindow_time;
        int conn_seed;
        int conn_id_recv;
        int conn_id_send;
        int last_rcv_win;
        DelayHist our_hist;
        DelayHist their_hist;
        byte[] extensions;
        long mtu_discover_time;
        int mtu_ceiling;
        int mtu_floor;
        int mtu_last;
        int mtu_probe_seq;
        int mtu_probe_size;
        int average_delay;
        long current_delay_sum;
        int current_delay_samples;
        int average_delay_base;
        long average_sample_time;
        int clock_drift;
        int clock_drift_raw;
        SizableCircularBuffer<ByteBuffer> inbuf;
        SizableCircularBuffer<OutgoingPacket> outbuf;
        boolean slow_start;
        int ssthresh;
        public static final int MAX_EACK = 128;

        UTPSocketImpl() {
            this.rtt_hist = new DelayHist();
            this.our_hist = new DelayHist();
            this.their_hist = new DelayHist();
            this.extensions = new byte[8];
            this.inbuf = new SizableCircularBuffer();
            this.outbuf = new SizableCircularBuffer();
        }

        int get_rcv_window() {
            int numbuf = UTPTranslatedV2.this.utp_call_get_read_buffer_size(this.ctx, this);
            return this.opt_rcvbuf > numbuf ? this.opt_rcvbuf - numbuf : 0;
        }

        boolean can_decay_win(long msec) {
            return msec - this.last_rwin_decay >= 100L;
        }

        void maybe_decay_win(long current_ms) {
            if (this.can_decay_win(current_ms)) {
                this.max_window = (int)((double)this.max_window * 0.5);
                this.last_rwin_decay = current_ms;
                if (this.max_window < 10) {
                    this.max_window = 10;
                }
                this.slow_start = false;
                this.ssthresh = this.max_window;
            }
        }

        int get_header_size() {
            return 20;
        }

        int get_udp_mtu() {
            return UTPTranslatedV2.this.utp_call_get_udp_mtu(this.ctx, this, this.addr);
        }

        int get_udp_overhead() {
            return UTPTranslatedV2.this.utp_call_get_udp_overhead(this.ctx, this, this.addr);
        }

        int get_overhead() {
            return this.get_udp_overhead() + this.get_header_size();
        }

        void removeSocketFromAckList(UTPSocketImpl conn) {
            conn.ctx.ack_sockets.remove(conn);
        }

        void schedule_ack() {
            if (!this.ctx.ack_sockets.contains(this)) {
                this.ctx.ack_sockets.add(this);
            }
        }

        void send_data(PacketFormatBase packet_header, byte[] packet_payload, int type) {
            this.send_data(packet_header, packet_payload, type, 0);
        }

        void send_data(PacketFormatBase packet_header, byte[] packet_payload, int type, int flags) {
            byte[] serialised_data;
            long time = UTPTranslatedV2.this.utp_call_get_microseconds(this.ctx, this);
            PacketFormatV1 b1 = (PacketFormatV1)packet_header;
            b1.tv_usec = (int)time;
            b1.reply_micro = this.reply_micro;
            this.last_sent_packet = this.ctx.current_ms;
            byte[] header_data = packet_header.serialise();
            if (packet_payload == null) {
                serialised_data = header_data;
            } else {
                byte[] temp = new byte[header_data.length + packet_payload.length];
                System.arraycopy(header_data, 0, temp, 0, header_data.length);
                System.arraycopy(packet_payload, 0, temp, header_data.length, packet_payload.length);
                serialised_data = temp;
            }
            int length = serialised_data.length;
            if (this.ctx.callbacks[5] != null) {
                int n;
                if (type == 0) {
                    type = 4;
                    n = this.get_overhead();
                } else {
                    n = length + this.get_udp_overhead();
                }
                UTPTranslatedV2.this.utp_call_on_overhead_statistics(this.ctx, this, 1, n, type);
            }
            UTPTranslatedV2.this.send_to_addr(this.ctx, serialised_data, this.addr, flags);
            this.removeSocketFromAckList(this);
        }

        void send_ack() {
            this.send_ack(false);
        }

        void send_ack(boolean synack) {
            PacketFormatExtensionsV1 pfa1;
            PacketFormatExtensionsV1 base = pfa1 = new PacketFormatExtensionsV1();
            this.last_rcv_win = this.get_rcv_window();
            pfa1.set_version(1);
            pfa1.set_type(2);
            pfa1.ext = 0;
            pfa1.connid = (short)this.conn_id_send;
            pfa1.ack_nr = (short)this.ack_nr.i;
            pfa1.seq_nr = (short)this.seq_nr.i;
            pfa1.windowsize = this.last_rcv_win;
            if (this.reorder_count.i != 0 && this.state < 6) {
                pfa1.ext = 1;
                pfa1.ext_next = 0;
                pfa1.ext_len = (byte)4;
                int m = 0;
                int window = Math.min(30, this.inbuf.size());
                int i = 0;
                while (i < window) {
                    if (this.inbuf.get(this.ack_nr.i + i + 2) != null) {
                        m |= 1 << i;
                    }
                    ++i;
                }
                pfa1.extensions[0] = (byte)m;
                pfa1.extensions[1] = (byte)(m >> 8);
                pfa1.extensions[2] = (byte)(m >> 16);
                pfa1.extensions[3] = (byte)(m >> 24);
            }
            this.send_data(base, null, 3);
            this.removeSocketFromAckList(this);
        }

        void send_keep_alive() {
            this.ack_nr.dec();
            this.send_ack();
            this.ack_nr.inc();
        }

        void send_packet(OutgoingPacket pkt) {
            long cur_time = UTPTranslatedV2.this.utp_call_get_milliseconds(this.ctx, this);
            if (pkt.transmissions == 0 || pkt.need_resend) {
                this.cur_window += pkt.payload;
            }
            pkt.need_resend = false;
            PacketFormatV1 p1 = (PacketFormatV1)pkt.packet_header;
            p1.ack_nr = (short)this.ack_nr.i;
            pkt.time_sent = UTPTranslatedV2.this.utp_call_get_microseconds(this.ctx, this);
            boolean use_as_mtu_probe = false;
            if (this.mtu_discover_time < cur_time) {
                this.mtu_reset();
            }
            if (this.mtu_floor < this.mtu_ceiling && pkt.length > this.mtu_floor && pkt.length <= this.mtu_ceiling && this.mtu_probe_seq == 0 && this.seq_nr.i != 1 && pkt.transmissions == 0) {
                this.mtu_probe_seq = this.seq_nr.i - 1 & 0xFFFF;
                this.mtu_probe_size = pkt.length;
                use_as_mtu_probe = true;
            }
            ++pkt.transmissions;
            this.send_data(pkt.packet_header, pkt.packet_payload, this.state == 2 ? 1 : (pkt.transmissions == 1 ? 0 : 5), use_as_mtu_probe ? 2 : 0);
        }

        boolean is_full() {
            return this.is_full(-1);
        }

        boolean is_full(int bytes) {
            int packet_size = this.get_packet_size();
            if (bytes < 0) {
                bytes = packet_size;
            } else if (bytes > packet_size) {
                bytes = packet_size;
            }
            int max_send = Math.min(this.max_window, Math.min(this.opt_sndbuf, this.max_window_user));
            if (this.cur_window_packets.i >= 1023) {
                this.last_maxed_out_window = this.ctx.current_ms;
                return true;
            }
            if (this.cur_window + bytes > max_send) {
                this.last_maxed_out_window = this.ctx.current_ms;
                return true;
            }
            return false;
        }

        boolean flush_packets() {
            int packet_size = this.get_packet_size();
            UnsignedShort i = new UnsignedShort(this.seq_nr.i - this.cur_window_packets.i);
            while (i.i != this.seq_nr.i) {
                OutgoingPacket pkt = this.outbuf.get(i.i);
                if (pkt != null && (pkt.transmissions <= 0 || pkt.need_resend)) {
                    if (this.is_full()) {
                        return true;
                    }
                    if (i.i != (this.seq_nr.i - 1 & 0xFFFF) || this.cur_window_packets.i == 1 || pkt.payload >= packet_size) {
                        this.send_packet(pkt);
                    }
                }
                i.inc();
            }
            return false;
        }

        void write_outgoing_packet(int payload, int flags, ByteBuffer[] iovec, int num_iovecs) {
            int added;
            if (this.cur_window_packets.i == 0) {
                this.retransmit_timeout = this.rto;
                this.rto_timeout = this.ctx.current_ms + (long)this.retransmit_timeout;
            }
            int packet_size = this.get_packet_size();
            do {
                added = 0;
                OutgoingPacket pkt = null;
                if (this.cur_window_packets.i > 0) {
                    pkt = this.outbuf.get(this.seq_nr.i - 1);
                }
                int header_size = this.get_header_size();
                boolean append = true;
                if (payload != 0 && pkt != null && pkt.transmissions == 0 && pkt.payload < packet_size) {
                    added = Math.min(payload + pkt.payload, Math.max(packet_size, pkt.payload)) - pkt.payload;
                    byte[] old_payload = pkt.packet_payload;
                    byte[] new_payload = new byte[old_payload.length + added];
                    System.arraycopy(old_payload, 0, new_payload, 0, old_payload.length);
                    pkt.packet_payload = new_payload;
                    this.outbuf.put(this.seq_nr.i - 1, pkt);
                    append = false;
                } else {
                    added = payload;
                    pkt = new OutgoingPacket();
                    pkt.packet_header = new PacketFormatV1();
                    pkt.packet_payload = new byte[added];
                    pkt.payload = 0;
                    pkt.transmissions = 0;
                    pkt.need_resend = false;
                }
                if (added > 0) {
                    byte[] packet_payload = pkt.packet_payload;
                    int p = pkt.payload;
                    int needed = added;
                    int i = 0;
                    while (i < num_iovecs && needed > 0) {
                        if (iovec[i].remaining() != 0) {
                            int num = Math.min(needed, iovec[i].remaining());
                            iovec[i].get(packet_payload, p, num);
                            p += num;
                            needed -= num;
                        }
                        ++i;
                    }
                }
                pkt.payload += added;
                pkt.length = header_size + pkt.payload;
                this.last_rcv_win = this.get_rcv_window();
                PacketFormatV1 p1 = (PacketFormatV1)pkt.packet_header;
                p1.set_version(1);
                p1.set_type(flags);
                p1.ext = 0;
                p1.connid = (short)this.conn_id_send;
                p1.windowsize = this.last_rcv_win;
                p1.ack_nr = (short)this.ack_nr.i;
                if (!append) continue;
                this.outbuf.ensure_size(this.seq_nr.i, this.cur_window_packets.i);
                this.outbuf.put(this.seq_nr.i, pkt);
                p1.seq_nr = (short)this.seq_nr.i;
                this.seq_nr.inc();
                this.cur_window_packets.inc();
            } while ((payload -= added) > 0);
            this.flush_packets();
        }

        void check_timeouts() {
            if (this.state != 10) {
                this.flush_packets();
            }
            switch (this.state) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    if ((int)(this.ctx.current_ms - this.zerowindow_time) >= 0 && this.max_window_user == 0) {
                        this.max_window_user = 1435;
                    }
                    if ((int)(this.ctx.current_ms - this.rto_timeout) >= 0 && this.rto_timeout > 0L) {
                        int new_timeout;
                        boolean ignore_loss = false;
                        if (this.cur_window_packets.i == 1 && (this.seq_nr.i - 1 & 0xFFFF) == this.mtu_probe_seq && this.mtu_probe_seq != 0) {
                            this.mtu_ceiling = this.mtu_probe_size - 1;
                            this.mtu_search_update();
                            ignore_loss = true;
                        }
                        this.mtu_probe_size = 0;
                        this.mtu_probe_seq = 0;
                        int n = new_timeout = ignore_loss ? this.retransmit_timeout : this.retransmit_timeout * 2;
                        if (this.state == 3) {
                            this.state = 10;
                            UTPTranslatedV2.this.utp_call_on_error(this.ctx, this, 2);
                            return;
                        }
                        if (this.retransmit_count >= 4 || this.state == 2 && this.retransmit_count >= 2) {
                            this.state = this.state == 8 ? 10 : 9;
                            UTPTranslatedV2.this.utp_call_on_error(this.ctx, this, 2);
                            return;
                        }
                        this.retransmit_timeout = new_timeout;
                        this.rto_timeout = this.ctx.current_ms + (long)new_timeout;
                        if (!ignore_loss) {
                            this.duplicate_ack = 0;
                            int packet_size = this.get_packet_size();
                            if (this.cur_window_packets.i == 0 && this.max_window > packet_size) {
                                this.max_window = Math.max(this.max_window * 2 / 3, packet_size);
                            } else {
                                this.max_window = packet_size;
                                this.slow_start = true;
                            }
                        }
                        int i = 0;
                        while (i < this.cur_window_packets.i) {
                            OutgoingPacket pkt = this.outbuf.get(this.seq_nr.i - i - 1);
                            if (pkt != null && pkt.transmissions != 0 && !pkt.need_resend) {
                                pkt.need_resend = true;
                                this.cur_window -= pkt.payload;
                            }
                            ++i;
                        }
                        if (this.cur_window_packets.i > 0) {
                            this.retransmit_count = (short)(this.retransmit_count + 1);
                            this.fast_timeout = true;
                            this.timeout_seq_nr.set(this.seq_nr.i);
                            OutgoingPacket pkt = this.outbuf.get(this.seq_nr.i - this.cur_window_packets.i);
                            this.send_packet(pkt);
                        }
                    }
                    if (this.state == 5 && !this.is_full()) {
                        this.state = 4;
                        UTPTranslatedV2.this.utp_call_on_state_change(this.ctx, this, 2);
                    }
                    if (this.state < 4 || this.state >= 6 || (int)(this.ctx.current_ms - this.last_sent_packet) < 29000) break;
                    this.send_keep_alive();
                    break;
                }
                case 6: 
                case 7: {
                    if ((int)(this.ctx.current_ms - this.rto_timeout) < 0) break;
                    int n = this.state = this.state == 7 ? 10 : 9;
                    if (this.cur_window_packets.i <= 0) break;
                    UTPTranslatedV2.this.utp_call_on_error(this.ctx, this, 1);
                    break;
                }
            }
        }

        void mtu_search_update() {
            this.mtu_last = (this.mtu_floor + this.mtu_ceiling) / 2;
            this.mtu_probe_size = 0;
            this.mtu_probe_seq = 0;
            if (this.mtu_ceiling - this.mtu_floor <= 16) {
                this.mtu_last = this.mtu_floor;
                this.mtu_ceiling = this.mtu_floor;
                this.mtu_discover_time = UTPTranslatedV2.this.utp_call_get_milliseconds(this.ctx, this) + 1800000L;
            }
        }

        void mtu_reset() {
            this.mtu_ceiling = this.get_udp_mtu();
            this.mtu_floor = 576;
            this.mtu_discover_time = UTPTranslatedV2.this.utp_call_get_milliseconds(this.ctx, this) + 1800000L;
        }

        int ack_packet(UnsignedShort seq) {
            OutgoingPacket pkt = this.outbuf.get(seq.i);
            if (pkt == null) {
                return 1;
            }
            if (pkt.transmissions == 0) {
                return 2;
            }
            this.outbuf.put(seq.i, null);
            if (pkt.transmissions == 1) {
                int ertt = (int)((UTPTranslatedV2.this.utp_call_get_microseconds(this.ctx, this) - pkt.time_sent) / 1000L);
                if (this.rtt == 0) {
                    this.rtt = ertt;
                    this.rtt_var = ertt / 2;
                } else {
                    int delta = this.rtt - ertt;
                    this.rtt_var += (Math.abs(delta) - this.rtt_var) / 4;
                    this.rtt = this.rtt - this.rtt / 8 + ertt / 8;
                    this.rtt_hist.add_sample(ertt, this.ctx.current_ms);
                }
                this.rto = Math.max(this.rtt + this.rtt_var * 4, 1000);
            }
            this.retransmit_timeout = this.rto;
            this.rto_timeout = this.ctx.current_ms + (long)this.rto;
            if (!pkt.need_resend) {
                this.cur_window -= pkt.payload;
            }
            this.retransmit_count = 0;
            return 0;
        }

        int selective_ack_bytes(int base, byte[] mask, int len, long[] min_rtt) {
            if (this.cur_window_packets.i == 0) {
                return 0;
            }
            int acked_bytes = 0;
            int bits = len * 8 - 1;
            long now = UTPTranslatedV2.this.utp_call_get_microseconds(this.ctx, this);
            do {
                OutgoingPacket pkt;
                int v;
                if ((this.seq_nr.i - (v = base + bits) - 1 & 0xFFFF) >= (this.cur_window_packets.i - 1 & 0xFFFF) || (pkt = this.outbuf.get(v)) == null || pkt.transmissions == 0 || bits < 0 || (mask[bits >> 3] & 1 << (bits & 7)) == 0) continue;
                acked_bytes += pkt.payload;
                min_rtt[0] = pkt.time_sent < now ? Math.min(min_rtt[0], now - pkt.time_sent) : Math.min(min_rtt[0], 50000L);
            } while (--bits >= -1);
            return acked_bytes;
        }

        void selective_ack(int base, byte[] mask, int len) {
            if (this.cur_window_packets.i == 0) {
                return;
            }
            int bits = len * 8 - 1;
            int count = 0;
            int[] resends = new int[128];
            int nr = 0;
            do {
                OutgoingPacket pkt;
                boolean bit_set;
                int v;
                if ((this.seq_nr.i - (v = base + bits) - 1 & 0xFFFF) >= (short)(this.cur_window_packets.i - 1)) continue;
                boolean bl = bit_set = bits >= 0 && (mask[bits >> 3] & 1 << (bits & 7)) != 0;
                if (bit_set) {
                    ++count;
                }
                if ((pkt = this.outbuf.get(v)) == null || pkt.transmissions == 0) continue;
                if (bit_set) {
                    this.ack_packet(new UnsignedShort(v));
                    continue;
                }
                if ((v - this.fast_resend_seq_nr.i & 0xFFFF) > 1024 || count < 3) continue;
                if (nr >= 126) {
                    System.arraycopy(resends, 64, resends, 0, 64);
                    nr -= 64;
                }
                resends[nr++] = v;
            } while (--bits >= -1);
            if ((base - 1 - this.fast_resend_seq_nr.i & 0xFFFF) <= 1024 && count >= 3) {
                resends[nr++] = base - 1 & 0xFFFF;
            }
            boolean back_off = false;
            int i = 0;
            while (nr > 0) {
                int v;
                OutgoingPacket pkt;
                if ((pkt = this.outbuf.get(v = resends[--nr])) == null) continue;
                back_off = true;
                this.send_packet(pkt);
                this.fast_resend_seq_nr.set((short)(v + 1));
                if (++i >= 4) break;
            }
            if (back_off) {
                this.maybe_decay_win(this.ctx.current_ms);
            }
            this.duplicate_ack = (byte)count;
        }

        void apply_ccontrol(int bytes_acked, int actual_delay, long min_rtt) {
            double delay_factor;
            int our_delay = (int)Math.min(this.our_hist.get_value(), UTPTranslatedV2.uint32(min_rtt));
            UTPTranslatedV2.this.utp_call_on_delay_sample(this.ctx, this, our_delay / 1000);
            int target = this.target_delay;
            if (target <= 0) {
                target = 100000;
            }
            int penalty = 0;
            if (this.clock_drift < -200000) {
                penalty = (-this.clock_drift - 200000) / 7;
                our_delay += penalty;
            }
            double off_target = target - our_delay;
            double window_factor = (double)Math.min(bytes_acked, this.max_window) / (double)Math.max(this.max_window, bytes_acked);
            double scaled_gain = 3000.0 * window_factor * (delay_factor = off_target / (double)target);
            if (scaled_gain > 0.0 && this.ctx.current_ms - this.last_maxed_out_window > 1000L) {
                scaled_gain = 0.0;
            }
            int ledbat_cwnd = (int)((double)this.max_window + scaled_gain < 10.0 ? 10.0 : (double)this.max_window + scaled_gain);
            if (this.slow_start) {
                int ss_cwnd = (int)((double)this.max_window + window_factor * (double)this.get_packet_size());
                if (ss_cwnd > this.ssthresh) {
                    this.slow_start = false;
                } else if ((double)our_delay > (double)target * 0.9) {
                    this.slow_start = false;
                    this.ssthresh = this.max_window;
                } else {
                    this.max_window = Math.max(ss_cwnd, ledbat_cwnd);
                }
            } else {
                this.max_window = ledbat_cwnd;
            }
            this.max_window = Math.min(this.max_window, Math.max(10, this.opt_sndbuf));
        }

        int get_packet_size() {
            int header_size = 20;
            int mtu = this.mtu_last != 0 ? this.mtu_last : this.mtu_ceiling;
            return mtu - header_size;
        }

        void UTP_Free() {
            UTPTranslatedV2.this.utp_call_on_state_change(this.ctx, this, 4);
            UTPSocketKeyData kd = this.ctx.utp_sockets.remove(new UTPSocketKey(this.addr, this.conn_id_recv));
            this.removeSocketFromAckList(this);
        }
    }

    private static class UTPSocketKey {
        private InetSocketAddress address;
        private int recv_id;

        private UTPSocketKey(InetSocketAddress _address, int _recv_id) {
            this.address = _address;
            this.recv_id = _recv_id;
        }

        public boolean equals(Object _other) {
            UTPSocketKey other = (UTPSocketKey)_other;
            return this.recv_id == other.recv_id && this.address.equals(other.address);
        }

        public int hashCode() {
            return this.recv_id ^ this.address.hashCode();
        }
    }

    private static class UTPSocketKeyData {
        private UTPSocketImpl socket;

        private UTPSocketKeyData(UTPSocketImpl _socket) {
            this.socket = _socket;
        }
    }

    private static final class UnsignedInteger {
        final long MASK = 0xFFFFFFFFL;
        long l;

        UnsignedInteger() {
            this.l = 0L;
        }

        UnsignedInteger(long num) {
            this.l = num & 0xFFFFFFFFL;
        }

        final void set(long num) {
            this.l = num & 0xFFFFFFFFL;
        }

        final void set(UnsignedInteger num) {
            this.l = num.l;
        }

        final long minus(UnsignedInteger other) {
            return this.l - other.l & 0xFFFFFFFFL;
        }

        final long minus(long num) {
            return this.l - (num & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        }

        final long plus(long num) {
            return this.l + (num & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        }
    }

    private static final class UnsignedShort {
        int i;

        UnsignedShort() {
            this.i = 0;
        }

        UnsignedShort(int _i) {
            this.i = _i & 0xFFFF;
        }

        final void set(int num) {
            this.i = num & 0xFFFF;
        }

        final void inc() {
            this.i = this.i + 1 & 0xFFFF;
        }

        final void dec() {
            this.i = this.i - 1 & 0xFFFF;
        }
    }

    private static class _utp_callback_arguments {
        utp_context context;
        UTPSocketImpl socket;
        int len;
        int flags;
        int callback_type;
        byte[] buf;
        ByteBuffer bbuf;
        InetSocketAddress address;
        int send;
        int sample_ms;
        int error_code;
        int state;
        int type;

        private _utp_callback_arguments() {
        }
    }

    static interface utp_callback_t {
        public long callback(_utp_callback_arguments var1);
    }

    private class utp_context {
        Object userdata = null;
        utp_callback_t[] callbacks;
        long current_ms = 0L;
        utp_context_stats context_stats;
        LinkedHashSet<UTPSocketImpl> ack_sockets;
        LinkedList<RST_Info> rst_info;
        Map<UTPSocketKey, UTPSocketKeyData> utp_sockets;
        int target_delay;
        int opt_sndbuf;
        int opt_rcvbuf;
        long last_check;
        boolean log_normal = false;
        boolean log_mtu = false;
        boolean log_debug = false;

        private utp_context() {
            this.context_stats = new utp_context_stats();
            this.callbacks = new utp_callback_t[22];
            this.target_delay = 100000;
            this.ack_sockets = new LinkedHashSet();
            this.rst_info = new LinkedList();
            this.utp_sockets = new HashMap<UTPSocketKey, UTPSocketKeyData>();
            this.callbacks[1] = UTPTranslatedV2.this.utp_default_callbacks;
            this.callbacks[3] = UTPTranslatedV2.this.utp_default_callbacks;
            this.callbacks[4] = UTPTranslatedV2.this.utp_default_callbacks;
            this.callbacks[5] = UTPTranslatedV2.this.utp_default_callbacks;
            this.callbacks[6] = UTPTranslatedV2.this.utp_default_callbacks;
            this.callbacks[7] = UTPTranslatedV2.this.utp_default_callbacks;
            this.callbacks[15] = UTPTranslatedV2.this.utp_default_callbacks;
            this.callbacks[9] = UTPTranslatedV2.this.utp_default_callbacks;
            this.callbacks[10] = UTPTranslatedV2.this.utp_default_callbacks;
            this.callbacks[11] = UTPTranslatedV2.this.utp_default_callbacks;
            this.callbacks[12] = UTPTranslatedV2.this.utp_default_callbacks;
            this.callbacks[13] = UTPTranslatedV2.this.utp_default_callbacks;
            this.opt_sndbuf = 0x100000;
            this.opt_rcvbuf = 0x100000;
            this.last_check = 0L;
        }
    }

    class utp_context_stats {
        int[] _nraw_recv = new int[5];
        int[] _nraw_send = new int[5];

        utp_context_stats() {
        }
    }

    class utp_socket_stats {
        long nbytes_recv;
        long nbytes_xmit;
        int rexmit;
        int fastrexmit;
        int nxmit;
        int nrecv;
        int nduprecv;
        int mtu_guess;

        utp_socket_stats() {
        }
    }
}

