/*
 * Decompiled with CFR 0.152.
 */
package com.vuze.client.plugins.utp;

import com.aelitis.azureus.core.networkmanager.impl.utp.UTPConnectionManager;
import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerFactory;
import com.aelitis.net.udp.uc.PRUDPPrimordialHandler;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;

public class UTPPlugin
implements Plugin,
PRUDPPrimordialHandler {
    private PluginInterface plugin_interface;
    private boolean logging_enabled;
    private LoggerChannel log;
    private BooleanParameter enabled_param;
    private UPnPMapping upnp_mapping;
    private PRUDPPacketHandler handler;
    private UTPConnectionManager manager;

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel("uTP");
        this.log.setDiagnostic();
        this.log.setForce(true);
        this.plugin_interface.getUtilities().getLocaleUtilities().integrateLocalisedMessageBundle("com.vuze.client.plugins.utp.internat.Messages");
        BasicPluginConfigModel config = this.plugin_interface.getUIManager().createBasicPluginConfigModel("plugins", "utp.name");
        this.enabled_param = config.addBooleanParameter2("utp.enabled", "utp.enabled", true);
        this.enabled_param.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                UTPPlugin.this.checkEnabledState();
            }
        });
        final BooleanParameter logging_param = config.addBooleanParameter2("utp.logging.enabled", "utp.logging.enabled", false);
        logging_param.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                UTPPlugin.this.logging_enabled = logging_param.getValue();
            }
        });
        this.enabled_param.addEnabledOnSelection(logging_param);
        this.logging_enabled = logging_param.getValue();
        this.manager = new UTPConnectionManager(this);
        final BooleanParameter prefer_utp_param = config.addBooleanParameter2("utp.prefer_utp", "utp.prefer_utp", true);
        prefer_utp_param.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                UTPPlugin.this.manager.preferUTP(prefer_utp_param.getValue());
            }
        });
        this.manager.preferUTP(prefer_utp_param.getValue());
        this.enabled_param.addEnabledOnSelection(prefer_utp_param);
        if (this.manager.getProviderVersion() > 1) {
            final IntParameter recv_buff_size = config.addIntParameter2("utp.recv.buff", "utp.recv.buff", 1024, 0, 5120);
            IntParameter send_buff_size = config.addIntParameter2("utp.send.buff", "utp.send.buff", 1024, 0, 5120);
            recv_buff_size.addListener(new ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    UTPPlugin.this.manager.setReceiveBufferSize(recv_buff_size.getValue());
                }
            });
            send_buff_size.addListener(new ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    UTPPlugin.this.manager.setSendBufferSize(recv_buff_size.getValue());
                }
            });
            this.manager.setReceiveBufferSize(recv_buff_size.getValue());
            this.manager.setSendBufferSize(send_buff_size.getValue());
            this.enabled_param.addEnabledOnSelection(recv_buff_size);
            this.enabled_param.addEnabledOnSelection(send_buff_size);
        }
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                COConfigurationManager.addAndFireParameterListeners(new String[]{"TCP.Listen.Port", "TCP.Listen.Port.Enable"}, new org.gudy.azureus2.core3.config.ParameterListener(){

                    @Override
                    public void parameterChanged(String name) {
                        UTPPlugin.this.checkEnabledState();
                    }
                });
            }

            @Override
            public void closedownInitiated() {
            }

            @Override
            public void closedownComplete() {
            }
        });
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    private void checkEnabledState() {
        boolean plugin_enabled = this.enabled_param.getValue();
        boolean tcp_enabled = COConfigurationManager.getBooleanParameter("TCP.Listen.Port.Enable");
        if (tcp_enabled && plugin_enabled) {
            this.log("Plugin is enabled: version=" + this.plugin_interface.getPluginVersion());
            if (this.upnp_mapping != null) {
                this.upnp_mapping.destroy();
            }
            int port = COConfigurationManager.getIntParameter("TCP.Listen.Port");
            PluginInterface pi_upnp = this.plugin_interface.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
            if (pi_upnp == null) {
                this.log("UPnP plugin not found, can't map port");
            } else {
                this.upnp_mapping = ((UPnPPlugin)pi_upnp.getPlugin()).addMapping(this.plugin_interface.getPluginName(), false, port, true);
                this.log("UPnP mapping registered for port " + port);
            }
            if (this.handler == null || port != this.handler.getPort()) {
                if (this.handler != null) {
                    this.handler.removePrimordialHandler(this);
                }
                this.handler = PRUDPPacketHandlerFactory.getHandler(port);
                this.handler.addPrimordialHandler(this);
            }
            this.manager.activate(this.handler);
        } else {
            this.log("Plugin is disabled");
            if (this.handler != null) {
                this.handler.removePrimordialHandler(this);
                this.handler = null;
            }
            if (this.upnp_mapping != null) {
                this.upnp_mapping.destroy();
                this.upnp_mapping = null;
            }
            this.manager.deactivate();
        }
    }

    @Override
    public boolean packetReceived(DatagramPacket packet) {
        return this.manager.receive((InetSocketAddress)packet.getSocketAddress(), packet.getData(), packet.getLength());
    }

    public boolean send(InetSocketAddress to, byte[] buffer, int length) {
        if (length != buffer.length) {
            Debug.out("optimise this");
            byte[] temp = new byte[length];
            System.arraycopy(buffer, 0, temp, 0, length);
            buffer = temp;
        }
        try {
            this.handler.primordialSend(buffer, to);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public void log(String str) {
        if (this.logging_enabled) {
            this.log.log(str);
        }
    }

    public void log(String str, Throwable e) {
        this.log.log(str, e);
        Debug.out(e);
    }
}

