/*
 * Decompiled with CFR 0.152.
 */
package com.vuze.android.core.az;

import android.os.Build;
import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.util.InitialisationFunctions;
import com.vuze.android.core.az.ConsoleDebugCommand;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.PluginAdapter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginManagerDefaults;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.ui.common.UIConst;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.update.CorePatchChecker;
import org.gudy.azureus2.update.UpdaterUpdateChecker;

public class VuzeManager {
    private static final String UI_NAME = "ac";
    private static final boolean RCM_ENABLE = true;
    private static final boolean LONG_TERM_STATS_ENABLE = false;
    private static final boolean SPEED_MANAGER_ENABLE = false;
    private static final boolean TAG_MANAGER_ENABLE = true;
    private static final boolean IP_FILTER_ENABLE = false;
    private static final boolean UPNPAV_PUBLISH_TO_LAN = true;
    private static final String[] plugin_resources = new String[]{"com/vuze/android/core/az/plugins/aercm-res_0.5.14.vuze", "com/vuze/android/core/az/plugins/azupnpav-res_0.5.6.vuze", "com/vuze/android/core/az/plugins/azutp-res_0.5.6.vuze", "com/vuze/android/core/az/plugins/mlDHT-res_1.5.8.vuze", "com/vuze/android/core/az/plugins/xmwebui-res_0.6.2.vuze"};
    private static boolean is_closing;
    private AzureusCore azureus_core;

    public static boolean isShuttingDown() {
        return is_closing;
    }

    public VuzeManager(File core_root) {
        try {
            System.setProperty("android.os.build.version.release", Build.VERSION.RELEASE);
            System.setProperty("android.os.build.version.sdk_int", String.valueOf(Build.VERSION.SDK_INT));
        }
        catch (Throwable e) {
            System.err.println("Not running in an Android environment, not setting associated system properties");
        }
        core_root.mkdirs();
        System.setProperty("azureus.config.path", core_root.getAbsolutePath());
        System.setProperty("azureus.install.path", core_root.getAbsolutePath());
        System.setProperty("azureus.time.use.raw.provider", "1");
        System.setProperty("az.factory.platformmanager.impl", "com.vuze.android.core.az.PlatformManagerImpl");
        System.setProperty("az.factory.dnsutils.impl", "com.vuze.android.core.az.DNSProvider");
        System.setProperty("az.factory.internat.bundle", "org.gudy.azureus2.ui.none.internat.MessagesBundle");
        System.setProperty("az.factory.subscriptionmanager.impl", "");
        System.setProperty("az.factory.devicemanager.impl", "");
        System.setProperty("az.thread.pool.naming.enable", "false");
        System.setProperty("az.xmwebui.skip.ssl.hack", "true");
        System.setProperty("az.logging.save.debug", "false");
        System.setProperty("az.logging.keep.ui.history", "false");
        COConfigurationManager.initialise();
        COConfigurationManager.setParameter("ui", UI_NAME);
        COConfigurationManager.setParameter("Save Torrent Files", true);
        new File(COConfigurationManager.getStringParameter("Default save path")).mkdirs();
        new File(COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory")).mkdirs();
        boolean ENABLE_LOGGING = false;
        COConfigurationManager.setParameter("Logger.Enabled", ENABLE_LOGGING);
        COConfigurationManager.setParameter("Logging Enable", ENABLE_LOGGING);
        COConfigurationManager.setParameter("Logging Dir", "C:\\temp");
        COConfigurationManager.setParameter("Start In Low Resource Mode", true);
        COConfigurationManager.setParameter("DHT.protocol.version.min", 51);
        COConfigurationManager.setParameter("Auto Upload Speed Enabled", false);
        COConfigurationManager.setParameter("Auto Upload Speed Seeding Enabled", false);
        COConfigurationManager.setIntDefault("Max Upload Speed KBs", 25);
        COConfigurationManager.setIntDefault("Max Download Speed KBs", 0);
        COConfigurationManager.setParameter("tagmanager.enable", true);
        COConfigurationManager.setParameter("speedmanager.enable", false);
        COConfigurationManager.setParameter("long.term.stats.enable", false);
        COConfigurationManager.setParameter("rcm.overall.enabled", true);
        COConfigurationManager.setParameter("Ip Filter Enabled", false);
        COConfigurationManager.setParameter("Ip Filter Banning Persistent", false);
        COConfigurationManager.setParameter("Plugin.azupnpav.upnpmediaserver.enable_publish", true);
        COConfigurationManager.setParameter("dht.net.cvs_v4.enable", false);
        COConfigurationManager.setParameter("dht.net.main_v6.enable", false);
        COConfigurationManager.setParameter("network.tcp.read.select.time", 500);
        COConfigurationManager.setParameter("network.tcp.read.select.min.time", 500);
        COConfigurationManager.setParameter("network.tcp.write.select.time", 500);
        COConfigurationManager.setParameter("network.tcp.write.select.min.time", 500);
        COConfigurationManager.setParameter("network.tcp.connect.select.time", 500);
        COConfigurationManager.setParameter("network.tcp.connect.select.min.time", 500);
        COConfigurationManager.setParameter("network.udp.poll.time", 100);
        COConfigurationManager.setParameter("network.utp.poll.time", 100);
        COConfigurationManager.setParameter("network.control.read.idle.time", 100);
        COConfigurationManager.setParameter("network.control.write.idle.time", 100);
        COConfigurationManager.setParameter("diskmanager.perf.cache.enable", true);
        COConfigurationManager.setParameter("diskmanager.perf.cache.size", 2);
        COConfigurationManager.setParameter("diskmanager.perf.cache.enable.read", false);
        COConfigurationManager.setParameter("diskmanager.perf.read.maxthreads", 2);
        COConfigurationManager.setParameter("diskmanager.perf.read.maxmb", 2);
        COConfigurationManager.setParameter("diskmanager.perf.write.maxthreads", 2);
        COConfigurationManager.setParameter("diskmanager.perf.write.maxmb", 2);
        COConfigurationManager.setParameter("peermanager.schedule.time", 500);
        PluginManagerDefaults defaults = PluginManager.getDefaults();
        defaults.setDefaultPluginEnabled("Buddy", false);
        defaults.setDefaultPluginEnabled("Share Hoster", false);
        defaults.setDefaultPluginEnabled("RSS", false);
        defaults.setDefaultPluginEnabled("Network Status", false);
        this.preinstallPlugins();
        ConsoleInput.registerPluginCommand(ConsoleDebugCommand.class);
        this.azureus_core = AzureusCoreFactory.create();
        this.azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            @Override
            public void started(AzureusCore azureus_core) {
                PluginManager pm = azureus_core.getPluginManager();
                PluginInterface pi = pm.getPluginInterfaceByClass(CorePatchChecker.class);
                if (pi != null) {
                    pi.getPluginState().setDisabled(true);
                }
                if ((pi = pm.getPluginInterfaceByClass(UpdaterUpdateChecker.class)) != null) {
                    pi.getPluginState().setDisabled(true);
                }
                pm.getDefaultPluginInterface().addListener(new PluginAdapter(){

                    @Override
                    public void initializationComplete() {
                        VuzeManager.this.initComplete();
                    }

                    @Override
                    public void closedownInitiated() {
                    }

                    @Override
                    public void closedownComplete() {
                    }
                });
            }

            @Override
            public void componentCreated(AzureusCore core, AzureusCoreComponent component) {
                if (component instanceof GlobalManager) {
                    InitialisationFunctions.earlyInitialisation(core);
                }
            }

            @Override
            public void stopping(AzureusCore core) {
                is_closing = true;
            }
        });
        new AEThread2("CoreInit"){

            @Override
            public void run() {
                VuzeManager.this.azureus_core.start();
                COConfigurationManager.setParameter("Telnet_iPort", 57006);
                COConfigurationManager.setParameter("Telnet_sAllowedHosts", "127.0.0.1,192.168.1.5");
                UIConst.UIS = new HashMap();
                UIConst.setAzureusCore(VuzeManager.this.azureus_core);
                UIConst.startUI("telnet", null);
            }
        }.start();
    }

    private void preinstallPlugins() {
        String[] stringArray = plugin_resources;
        int n = plugin_resources.length;
        int n2 = 0;
        while (n2 < n) {
            block29: {
                String resource = stringArray[n2];
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(resource);
                try {
                    try {
                        VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
                        VuzeFile vf = vfh.loadVuzeFile(is);
                        VuzeFileComponent[] comps = vf.getComponents();
                        int j = 0;
                        while (j < comps.length) {
                            block27: {
                                VuzeFileComponent comp2 = comps[j];
                                if (comp2.getType() == 8) {
                                    try {
                                        Map content2 = comp2.getContent();
                                        String id = new String((byte[])content2.get("id"), "UTF-8");
                                        String version = new String((byte[])content2.get("version"), "UTF-8");
                                        boolean jar = (Long)content2.get("is_jar") == 1L;
                                        byte[] plugin_file = (byte[])content2.get("file");
                                        File plugin_dir = new File(new File(SystemProperties.getUserPath(), "plugins"), id);
                                        plugin_dir.mkdirs();
                                        if (jar) {
                                            FileUtil.copyFile((InputStream)new ByteArrayInputStream(plugin_file), new File(plugin_dir, String.valueOf(id) + "_" + version + ".jar"));
                                            break block27;
                                        }
                                        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(plugin_file));
                                        block20: while (true) {
                                            block21: while (true) {
                                                ZipEntry entry;
                                                if ((entry = zis.getNextEntry()) == null) {
                                                    break block27;
                                                }
                                                if (entry.isDirectory()) continue;
                                                String name = entry.getName();
                                                FileOutputStream entry_os = null;
                                                File entry_file = null;
                                                if (!name.endsWith("/")) {
                                                    entry_file = new File(plugin_dir, name.replace('/', File.separatorChar));
                                                    entry_file.getParentFile().mkdirs();
                                                    entry_os = new FileOutputStream(entry_file);
                                                }
                                                try {
                                                    byte[] buffer = new byte[65536];
                                                    while (true) {
                                                        int len;
                                                        if ((len = zis.read(buffer)) <= 0) continue block21;
                                                        if (entry_os == null) continue;
                                                        entry_os.write(buffer, 0, len);
                                                    }
                                                }
                                                finally {
                                                    if (entry_os == null) continue block20;
                                                    entry_os.close();
                                                    continue;
                                                }
                                                break;
                                            }
                                            break;
                                        }
                                        finally {
                                            zis.close();
                                        }
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    catch (Throwable e) {
                        Debug.out("Failed to load .vuze file: " + resource, e);
                        try {
                            is.close();
                        }
                        catch (Throwable e2) {
                            Debug.out(e2);
                        }
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            ++n2;
        }
    }

    private void initComplete() {
    }

    private void checkUpdates() {
        PluginManager pm = this.azureus_core.getPluginManager();
        UpdateManager update_manager = pm.getDefaultPluginInterface().getUpdateManager();
        final UpdateCheckInstance checker = update_manager.createUpdateCheckInstance();
        checker.addListener(new UpdateCheckInstanceListener(){

            @Override
            public void cancelled(UpdateCheckInstance instance) {
            }

            @Override
            public void complete(UpdateCheckInstance instance) {
                Update[] updates = instance.getUpdates();
                int i = 0;
                while (i < updates.length) {
                    Update update = updates[i];
                    System.out.println("Update available for '" + update.getName() + "', new version = " + update.getNewVersion());
                    String[] descs = update.getDescription();
                    int j = 0;
                    while (j < descs.length) {
                        System.out.println("\t" + descs[j]);
                        ++j;
                    }
                    ++i;
                }
                checker.cancel();
            }
        });
        checker.start();
    }

    public AzureusCore getCore() {
        return this.azureus_core;
    }
}

