/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.plugins.rcmplugin;

import com.aelitis.azureus.core.content.RelatedContent;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.utils.search.SearchResult;

public class SearchRelatedContent
extends RelatedContent {
    private int rank;
    private boolean unread = true;
    protected static final byte NET_NONE = 0;
    protected static final byte NET_PUBLIC = 1;
    protected static final byte NET_I2P = 2;
    protected static final byte NET_TOR = 4;

    protected SearchRelatedContent(SearchResult sr) {
        super(sr.getProperty(22) instanceof Long ? ((Long)sr.getProperty(22)).intValue() : 0, (String)sr.getProperty(1), (byte[])sr.getProperty(21), null, (byte[])sr.getProperty(50001), (byte[])sr.getProperty(50002), (String[])sr.getProperty(50003), SearchRelatedContent.convertNetworks((String[])sr.getProperty(50004)), (Long)sr.getProperty(3), SearchRelatedContent.getDate(sr), SearchRelatedContent.getSeedsLeechers(sr), (byte)-1);
        Long l_rank = (Long)sr.getProperty(17);
        if (l_rank != null) {
            this.rank = l_rank.intValue();
        }
    }

    protected void updateFrom(RelatedContent other) {
        String[] old_tags = this.getTags();
        String[] new_tags = other.getTags();
        if (!(old_tags.length == 0 && new_tags.length == 0 || old_tags.length > 0 && new_tags.length == 0)) {
            if (old_tags.length == 0 && new_tags.length > 0) {
                this.setTags(new_tags);
            } else {
                HashSet<String> tags = new HashSet<String>(Arrays.asList(old_tags));
                tags.addAll(Arrays.asList(new_tags));
                if (tags.size() > old_tags.length) {
                    this.setTags(tags.toArray(new String[tags.size()]));
                }
            }
        }
    }

    private static int getDate(SearchResult sr) {
        Date date = (Date)sr.getProperty(2);
        if (date == null) {
            return 0;
        }
        return (int)(date.getTime() / 3600000L);
    }

    private static int getSeedsLeechers(SearchResult sr) {
        int seeds = ((Long)sr.getProperty(5)).intValue();
        int leechers = ((Long)sr.getProperty(4)).intValue();
        return seeds << 16 | leechers;
    }

    @Override
    public int getRank() {
        return this.rank;
    }

    @Override
    public int getLevel() {
        return 0;
    }

    @Override
    public boolean isUnread() {
        return this.unread;
    }

    @Override
    public void setUnread(boolean _unread) {
        this.unread = _unread;
    }

    @Override
    public Download getRelatedToDownload() {
        return null;
    }

    @Override
    public int getLastSeenSecs() {
        return 0;
    }

    @Override
    public void delete() {
    }

    protected static byte convertNetworks(String[] networks) {
        byte nets = 0;
        int i = 0;
        while (i < networks.length) {
            String n = networks[i];
            if (n.equalsIgnoreCase("Public")) {
                nets = (byte)(nets | 1);
            } else if (n.equalsIgnoreCase("I2P")) {
                nets = (byte)(nets | 2);
            } else if (n.equalsIgnoreCase("Tor")) {
                nets = (byte)(nets | 4);
            }
            ++i;
        }
        return nets;
    }
}

