/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.services;

import com.aelitis.net.upnp.UPnPAction;
import com.aelitis.net.upnp.UPnPActionArgument;
import com.aelitis.net.upnp.UPnPActionInvocation;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.impl.services.UPnPServiceImpl;
import com.aelitis.net.upnp.services.UPnPOfflineDownloader;

public class UPnPSSOfflineDownloaderImpl
implements UPnPOfflineDownloader {
    private UPnPServiceImpl service;

    protected UPnPSSOfflineDownloaderImpl(UPnPServiceImpl _service) {
        this.service = _service;
    }

    @Override
    public UPnPService getGenericService() {
        return this.service;
    }

    @Override
    public long getFreeSpace(String client_id) throws UPnPException {
        UPnPAction act = this.service.getAction("GetFreeSpace");
        if (act == null) {
            throw new UPnPException("GetFreeSpace not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        inv.addArgument("NewClientID", client_id);
        UPnPActionArgument[] args = inv.invoke();
        int i = 0;
        while (i < args.length) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewFreeSpace")) {
                return Long.parseLong(arg.getValue());
            }
            ++i;
        }
        throw new UPnPException("result not found");
    }

    @Override
    public void activate(String client_id) throws UPnPException {
        UPnPAction act = this.service.getAction("Activate");
        if (act == null) {
            throw new UPnPException("Activate not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        inv.addArgument("NewClientID", client_id);
        UPnPActionArgument[] args = inv.invoke();
        int i = 0;
        while (i < args.length) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewStatus")) {
                return;
            }
            ++i;
        }
        throw new UPnPException("status not found");
    }

    @Override
    public String[] setDownloads(String client_id, String hash_list) throws UPnPException {
        UPnPAction act = this.service.getAction("SetDownloads");
        if (act == null) {
            throw new UPnPException("SetDownloads not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        inv.addArgument("NewClientID", client_id);
        inv.addArgument("NewTorrentHashList", hash_list);
        UPnPActionArgument[] args = inv.invoke();
        String result = null;
        String status = null;
        int i = 0;
        while (i < args.length) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewSetDownloadsResultList")) {
                result = arg.getValue();
            } else if (name.equalsIgnoreCase("NewStatus")) {
                status = arg.getValue();
            }
            ++i;
        }
        if (result != null && status != null) {
            return new String[]{result, status};
        }
        throw new UPnPException("result or status not found");
    }

    @Override
    public String addDownload(String client_id, String hash, String torrent) throws UPnPException {
        UPnPAction act = this.service.getAction("AddDownload");
        if (act == null) {
            throw new UPnPException("AddDownload not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        inv.addArgument("NewClientID", client_id);
        inv.addArgument("NewTorrentHash", hash);
        inv.addArgument("NewTorrentData", torrent);
        UPnPActionArgument[] args = inv.invoke();
        int i = 0;
        while (i < args.length) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewStatus")) {
                return arg.getValue();
            }
            ++i;
        }
        throw new UPnPException("result not found");
    }

    @Override
    public String addDownloadChunked(String client_id, String hash, String chunk, int offset, int total_size) throws UPnPException {
        UPnPAction act = this.service.getAction("AddDownloadChunked");
        if (act == null) {
            throw new UPnPException("AddDownloadChunked not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        inv.addArgument("NewClientID", client_id);
        inv.addArgument("NewTorrentHash", hash);
        inv.addArgument("NewTorrentData", chunk);
        inv.addArgument("NewChunkOffset", String.valueOf(offset));
        inv.addArgument("NewTotalLength", String.valueOf(total_size));
        UPnPActionArgument[] args = inv.invoke();
        int i = 0;
        while (i < args.length) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewStatus")) {
                return arg.getValue();
            }
            ++i;
        }
        throw new UPnPException("result not found");
    }

    @Override
    public String[] updateDownload(String client_id, String hash, String required_map) throws UPnPException {
        UPnPAction act = this.service.getAction("UpdateDownload");
        if (act == null) {
            throw new UPnPException("UpdateDownload not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        inv.addArgument("NewClientID", client_id);
        inv.addArgument("NewTorrentHash", hash);
        inv.addArgument("NewPieceRequiredMap", required_map);
        UPnPActionArgument[] args = inv.invoke();
        String have = null;
        String status = null;
        int i = 0;
        while (i < args.length) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewPieceHaveMap")) {
                have = arg.getValue();
            } else if (name.equalsIgnoreCase("NewStatus")) {
                status = arg.getValue();
            }
            ++i;
        }
        if (have != null && status != null) {
            return new String[]{have, status};
        }
        throw new UPnPException("have or status not found");
    }

    @Override
    public String removeDownload(String client_id, String hash) throws UPnPException {
        UPnPAction act = this.service.getAction("RemoveDownload");
        if (act == null) {
            throw new UPnPException("RemoveDownload not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        inv.addArgument("NewClientID", client_id);
        inv.addArgument("NewTorrentHash", hash);
        UPnPActionArgument[] args = inv.invoke();
        String status = null;
        int i = 0;
        while (i < args.length) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewStatus")) {
                status = arg.getValue();
            }
            ++i;
        }
        if (status != null) {
            return status;
        }
        throw new UPnPException("status not found");
    }

    @Override
    public String[] startDownload(String client_id, String hash) throws UPnPException {
        UPnPAction act = this.service.getAction("StartDownload");
        if (act == null) {
            throw new UPnPException("StartDownload not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        inv.addArgument("NewClientID", client_id);
        inv.addArgument("NewTorrentHash", hash);
        UPnPActionArgument[] args = inv.invoke();
        String status = null;
        String data_port = null;
        int i = 0;
        while (i < args.length) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewStatus")) {
                status = arg.getValue();
            } else if (name.equalsIgnoreCase("NewDataPort")) {
                data_port = arg.getValue();
            }
            ++i;
        }
        if (status != null && data_port != null) {
            return new String[]{data_port, status};
        }
        throw new UPnPException("status or data port not found");
    }
}

