/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.utils;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class ImageBytesDownloader {
    static final Map<String, List<ImageDownloaderListener>> map = new HashMap<String, List<ImageDownloaderListener>>();
    static final AEMonitor mon_map = new AEMonitor("ImageDownloaderMap");

    public static void loadImage(final String url, ImageDownloaderListener l) {
        mon_map.enter();
        try {
            List<ImageDownloaderListener> list = map.get(url);
            if (list != null) {
                list.add(l);
                return;
            }
            list = new ArrayList<ImageDownloaderListener>(1);
            list.add(l);
            map.put(url, list);
        }
        finally {
            mon_map.exit();
        }
        try {
            ResourceDownloader rd = ResourceDownloaderFactoryImpl.getSingleton().create(new URL(url));
            rd.addListener(new ResourceDownloaderAdapter(){

                @Override
                public boolean completed(ResourceDownloader downloader, InputStream is) {
                    mon_map.enter();
                    try {
                        List<ImageDownloaderListener> list = map.get(url);
                        if (list != null) {
                            try {
                                if (is != null && is.available() > 0) {
                                    byte[] newImageBytes = new byte[is.available()];
                                    is.read(newImageBytes);
                                    for (ImageDownloaderListener l : list) {
                                        try {
                                            l.imageDownloaded(newImageBytes);
                                        }
                                        catch (Exception e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                            }
                            catch (Exception e) {
                                Debug.out(e);
                            }
                        }
                        map.remove(url);
                    }
                    finally {
                        mon_map.exit();
                    }
                    return false;
                }
            });
            rd.asyncDownload();
        }
        catch (Exception e) {
            Debug.out(url, e);
        }
    }

    public static interface ImageDownloaderListener {
        public void imageDownloaded(byte[] var1);
    }
}

