/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.common.table.impl;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableCountChangeListener;
import com.aelitis.azureus.ui.common.table.TableDataSourceChangedListener;
import com.aelitis.azureus.ui.common.table.TableExpansionChangeListener;
import com.aelitis.azureus.ui.common.table.TableGroupRowRunner;
import com.aelitis.azureus.ui.common.table.TableGroupRowVisibilityRunner;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRefreshListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.table.TableStructureModificationListener;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.common.table.TableViewFilterCheck;
import com.aelitis.azureus.ui.common.table.impl.DataSourceCallBackUtil;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.ui.tables.TableRowRefreshListener;

public abstract class TableViewImpl<DATASOURCETYPE>
implements TableView<DATASOURCETYPE>,
TableStructureModificationListener<DATASOURCETYPE> {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static final boolean DEBUG_SORTER = false;
    public static final boolean DEBUGADDREMOVE = System.getProperty("debug.swt.table.addremove", "0").equals("1");
    public static final boolean DEBUG_SELECTION = false;
    private static final String CFG_SORTDIRECTION = "config.style.table.defaultSortOrder";
    protected static final ConfigurationManager configMan = ConfigurationManager.getInstance();
    protected String tableID;
    protected String propertiesPrefix;
    private final Class<?> classPluginDataSourceType;
    private boolean bReallyAddingDataSources = false;
    private TableColumnCore sortColumn;
    private long lLastSortedOn;
    private AEMonitor listeners_mon = new AEMonitor("tablelisteners");
    private ArrayList<TableRowRefreshListener> rowRefreshListeners;
    private CopyOnWriteList<TableDataSourceChangedListener> listenersDataSourceChanged = new CopyOnWriteList();
    private CopyOnWriteList<TableSelectionListener> listenersSelection = new CopyOnWriteList();
    private CopyOnWriteList<TableLifeCycleListener> listenersLifeCycle = new CopyOnWriteList();
    private CopyOnWriteList<TableRefreshListener> listenersRefresh = new CopyOnWriteList();
    private CopyOnWriteList<TableCountChangeListener> listenersCountChange = new CopyOnWriteList(1);
    private CopyOnWriteList<TableExpansionChangeListener> listenersExpansionChange = new CopyOnWriteList(1);
    private Object parentDataSource;
    private Object rows_sync = new Object();
    private List<TableRowCore> sortedRows;
    private IdentityHashMap<DATASOURCETYPE, TableRowCore> mapDataSourceToRow;
    private IdentityHashMap<DATASOURCETYPE, String> listUnfilteredDataSources;
    private IdentityHashMap<DATASOURCETYPE, String> dataSourcesToAdd = new IdentityHashMap(4);
    private IdentityHashMap<DATASOURCETYPE, String> dataSourcesToRemove = new IdentityHashMap(4);
    protected filter<DATASOURCETYPE> filter;
    private DataSourceCallBackUtil.addDataSourceCallback processDataSourceQueueCallback = new DataSourceCallBackUtil.addDataSourceCallback(){

        @Override
        public void process() {
            TableViewImpl.this.processDataSourceQueue();
        }

        @Override
        public void debug(String str) {
            TableViewImpl.this.debug(str);
        }
    };
    private TableColumnCore[] basicItems;
    private TableColumnCore[] tableColumns;
    private TableColumnCore[] columnsOrdered;
    private List<TableRowCore> selectedRows = new ArrayList<TableRowCore>(1);
    private List<Object> listSelectedCoreDataSources;
    private boolean headerVisible = true;
    private boolean menuEnabled = true;
    private boolean provideIndexesOnRemove = false;

    public TableViewImpl(Class<?> pluginDataSourceType, String _sTableID, String _sPropertiesPrefix, TableColumnCore[] _basicItems) {
        this.classPluginDataSourceType = pluginDataSourceType;
        this.propertiesPrefix = _sPropertiesPrefix;
        this.tableID = _sTableID;
        this.basicItems = _basicItems;
        this.mapDataSourceToRow = new IdentityHashMap();
        this.sortedRows = new ArrayList<TableRowCore>();
        this.listUnfilteredDataSources = new IdentityHashMap();
        this.initializeColumnDefs();
    }

    private void initializeColumnDefs() {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        if (this.basicItems != null) {
            if (tcManager.getTableColumnCount(this.tableID) != this.basicItems.length) {
                tcManager.addColumns(this.basicItems);
            }
            this.basicItems = null;
        }
        this.tableColumns = tcManager.getAllTableColumnCoreAsArray(this.getDataSourceType(), this.tableID);
        tcManager.ensureIntegrety(this.classPluginDataSourceType, this.tableID);
    }

    @Override
    public void addSelectionListener(TableSelectionListener listener, boolean bFireSelection) {
        this.listenersSelection.add(listener);
        if (bFireSelection) {
            TableRowCore[] rows = this.getSelectedRows();
            listener.selected(rows);
            listener.focusChanged(this.getFocusedRow());
        }
    }

    @Override
    public void addTableDataSourceChangedListener(TableDataSourceChangedListener l, boolean trigger) {
        this.listenersDataSourceChanged.add(l);
        if (trigger) {
            l.tableDataSourceChanged(this.parentDataSource);
        }
    }

    @Override
    public void removeTableDataSourceChangedListener(TableDataSourceChangedListener l) {
        this.listenersDataSourceChanged.remove(l);
    }

    @Override
    public void setParentDataSource(Object newDataSource) {
        this.parentDataSource = newDataSource;
        Object[] listeners = this.listenersDataSourceChanged.toArray();
        int i = 0;
        while (i < listeners.length) {
            TableDataSourceChangedListener l = (TableDataSourceChangedListener)listeners[i];
            l.tableDataSourceChanged(newDataSource);
            ++i;
        }
    }

    @Override
    public Object getParentDataSource() {
        return this.parentDataSource;
    }

    public void triggerDefaultSelectedListeners(TableRowCore[] selectedRows, int keyMask) {
        for (TableSelectionListener l : this.listenersSelection) {
            l.defaultSelected(selectedRows, keyMask);
        }
    }

    protected void triggerLifeCycleListener(int eventType) {
        Object[] listeners = this.listenersLifeCycle.toArray();
        if (eventType == 0) {
            int i = 0;
            while (i < listeners.length) {
                TableLifeCycleListener l = (TableLifeCycleListener)listeners[i];
                try {
                    l.tableViewInitialized();
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < listeners.length) {
                TableLifeCycleListener l = (TableLifeCycleListener)listeners[i];
                try {
                    l.tableViewDestroyed();
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                ++i;
            }
        }
    }

    public void triggerSelectionListeners(TableRowCore[] rows) {
        if (rows == null || rows.length == 0) {
            return;
        }
        Object[] listeners = this.listenersSelection.toArray();
        int i = 0;
        while (i < listeners.length) {
            TableSelectionListener l = (TableSelectionListener)listeners[i];
            l.selected(rows);
            ++i;
        }
    }

    protected void triggerDeselectionListeners(TableRowCore[] rows) {
        if (rows == null) {
            return;
        }
        Object[] listeners = this.listenersSelection.toArray();
        int i = 0;
        while (i < listeners.length) {
            TableSelectionListener l = (TableSelectionListener)listeners[i];
            try {
                l.deselected(rows);
            }
            catch (Exception e) {
                Debug.out(e);
            }
            ++i;
        }
    }

    protected void triggerMouseEnterExitRow(TableRowCore row, boolean enter) {
        if (row == null) {
            return;
        }
        Object[] listeners = this.listenersSelection.toArray();
        int i = 0;
        while (i < listeners.length) {
            TableSelectionListener l = (TableSelectionListener)listeners[i];
            if (enter) {
                l.mouseEnter(row);
            } else {
                l.mouseExit(row);
            }
            ++i;
        }
    }

    protected void triggerFocusChangedListeners(TableRowCore row) {
        Object[] listeners = this.listenersSelection.toArray();
        int i = 0;
        while (i < listeners.length) {
            TableSelectionListener l = (TableSelectionListener)listeners[i];
            l.focusChanged(row);
            ++i;
        }
    }

    protected void triggerTableRefreshListeners() {
        Object[] listeners = this.listenersRefresh.toArray();
        int i = 0;
        while (i < listeners.length) {
            TableRefreshListener l = (TableRefreshListener)listeners[i];
            l.tableRefresh();
            ++i;
        }
    }

    @Override
    public void addLifeCycleListener(TableLifeCycleListener l) {
        this.listenersLifeCycle.add(l);
        if (!this.isDisposed()) {
            l.tableViewInitialized();
        }
    }

    @Override
    public void addRefreshListener(TableRefreshListener l, boolean trigger) {
        this.listenersRefresh.add(l);
        if (trigger) {
            l.tableRefresh();
        }
    }

    @Override
    public void addCountChangeListener(TableCountChangeListener listener) {
        this.listenersCountChange.add(listener);
    }

    @Override
    public void removeCountChangeListener(TableCountChangeListener listener) {
        this.listenersCountChange.remove(listener);
    }

    public void triggerListenerRowAdded(final TableRowCore[] rows) {
        if (this.listenersCountChange.size() == 0) {
            return;
        }
        this.getOffUIThread(new AERunnable(){

            @Override
            public void runSupport() {
                for (TableCountChangeListener l : TableViewImpl.this.listenersCountChange) {
                    TableRowCore[] tableRowCoreArray = rows;
                    int n = rows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableRowCore row = tableRowCoreArray[n2];
                        l.rowAdded(row);
                        ++n2;
                    }
                }
            }
        });
    }

    protected void triggerListenerRowRemoved(TableRowCore row) {
        for (TableCountChangeListener l : this.listenersCountChange) {
            l.rowRemoved(row);
        }
    }

    @Override
    public void addExpansionChangeListener(TableExpansionChangeListener listener) {
        this.listenersExpansionChange.add(listener);
    }

    @Override
    public void removeExpansionChangeListener(TableExpansionChangeListener listener) {
        this.listenersExpansionChange.remove(listener);
    }

    public void invokeExpansionChangeListeners(final TableRowCore row, final boolean expanded) {
        if (this.listenersExpansionChange.size() == 0) {
            return;
        }
        this.getOffUIThread(new AERunnable(){

            @Override
            public void runSupport() {
                Iterator iter = TableViewImpl.this.listenersExpansionChange.iterator();
                while (iter.hasNext()) {
                    try {
                        if (expanded) {
                            ((TableExpansionChangeListener)iter.next()).rowExpanded(row);
                            continue;
                        }
                        ((TableExpansionChangeListener)iter.next()).rowCollapsed(row);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    public void addRefreshListener(TableRowRefreshListener listener) {
        try {
            this.listeners_mon.enter();
            if (this.rowRefreshListeners == null) {
                this.rowRefreshListeners = new ArrayList(1);
            }
            this.rowRefreshListeners.add(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void removeRefreshListener(TableRowRefreshListener listener) {
        try {
            this.listeners_mon.enter();
            if (this.rowRefreshListeners == null) {
                return;
            }
            this.rowRefreshListeners.remove(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void invokeRefreshListeners(TableRowCore row) {
        Object[] listeners;
        try {
            this.listeners_mon.enter();
            if (this.rowRefreshListeners == null) {
                return;
            }
            listeners = this.rowRefreshListeners.toArray();
        }
        finally {
            this.listeners_mon.exit();
        }
        int i = 0;
        while (i < listeners.length) {
            try {
                TableRowRefreshListener l = (TableRowRefreshListener)listeners[i];
                l.rowRefresh(row);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public void runForAllRows(TableGroupRowRunner runner) {
        TableRowCore[] rows = this.getRows();
        if (runner.run(rows)) {
            return;
        }
        int i = 0;
        while (i < rows.length) {
            runner.run(rows[i]);
            ++i;
        }
    }

    @Override
    public void runForAllRows(TableGroupRowVisibilityRunner runner) {
        if (this.isDisposed()) {
            return;
        }
        TableRowCore[] rows = this.getRows();
        int i = 0;
        while (i < rows.length) {
            boolean isRowVisible = this.isRowVisible(rows[i]);
            runner.run(rows[i], isRowVisible);
            int numSubRows = rows[i].getSubItemCount();
            if (numSubRows > 0) {
                TableRowCore[] subRows;
                TableRowCore[] tableRowCoreArray = subRows = rows[i].getSubRowsWithNull();
                int n = subRows.length;
                int n2 = 0;
                while (n2 < n) {
                    TableRowCore subRow = tableRowCoreArray[n2];
                    if (subRow != null) {
                        runner.run(subRow, this.isRowVisible(subRow));
                    }
                    ++n2;
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runForSelectedRows(TableGroupRowRunner runner) {
        TableRowCore[] rows;
        if (this.isDisposed()) {
            return;
        }
        Object object = this.rows_sync;
        synchronized (object) {
            rows = this.selectedRows.toArray(new TableRowCore[0]);
        }
        boolean ran = runner.run(rows);
        if (!ran) {
            int i = 0;
            while (i < rows.length) {
                TableRowCore row = rows[i];
                runner.run(row);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUnfilteredDataSourceAdded(Object ds) {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.listUnfilteredDataSources.containsKey(ds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void refilter() {
        if (this.filter == null) {
            return;
        }
        if (this.filter.eventUpdate != null) {
            this.filter.eventUpdate.cancel();
        }
        this.filter.eventUpdate = null;
        Object object = this.rows_sync;
        synchronized (object) {
            void var6_7;
            Object[] unfilteredArray = this.listUnfilteredDataSources.keySet().toArray();
            if (DEBUGADDREMOVE) {
                this.debug("filter: unfilteredArray is " + unfilteredArray.length);
            }
            HashSet existing = new HashSet(this.getDataSources());
            ArrayList<Object> listRemoves = new ArrayList<Object>();
            ArrayList<Object> listAdds = new ArrayList<Object>();
            boolean bl = false;
            while (var6_7 < unfilteredArray.length) {
                boolean bHave = existing.contains(unfilteredArray[var6_7]);
                boolean isOurs = this.filter.checker.filterCheck(unfilteredArray[var6_7], this.filter.text, this.filter.regex);
                if (!isOurs) {
                    if (bHave) {
                        listRemoves.add(unfilteredArray[var6_7]);
                    }
                } else if (!bHave) {
                    listAdds.add(unfilteredArray[var6_7]);
                }
                ++var6_7;
            }
            if (listRemoves.size() > 0) {
                this.removeDataSources(listRemoves.toArray());
            }
            if (listAdds.size() > 0) {
                this.addDataSources(listAdds.toArray(), true);
            }
            for (Object e : listRemoves) {
                this.listUnfilteredDataSources.put(e, "");
            }
        }
        this.processDataSourceQueue();
    }

    public boolean isFiltered(DATASOURCETYPE ds) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.checker.filterCheck(ds, this.filter.text, this.filter.regex);
    }

    protected void debug(String s) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("table");
        diag_logger.log(String.valueOf(SystemTime.getCurrentTime()) + ":" + this.getTableID() + ": " + s);
        System.out.println(String.valueOf(Thread.currentThread().getName()) + "." + Integer.toHexString(this.hashCode()) + "] " + SystemTime.getCurrentTime() + ": " + this.getTableID() + ": " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processDataSourceQueue() {
        boolean hasRemove;
        boolean hasAdd;
        Object[] dataSourcesAdd = null;
        Object[] dataSourcesRemove = null;
        Object object = this.rows_sync;
        synchronized (object) {
            if (this.dataSourcesToAdd.size() > 0) {
                boolean removed_something = false;
                for (DATASOURCETYPE ds : this.dataSourcesToRemove.keySet()) {
                    if (this.dataSourcesToAdd.remove(ds) == null) continue;
                    removed_something = true;
                }
                if (removed_something && DEBUGADDREMOVE) {
                    this.debug("Saved time by not adding a row that was removed");
                }
                dataSourcesAdd = this.dataSourcesToAdd.keySet().toArray();
                this.dataSourcesToAdd.clear();
            }
            if (this.dataSourcesToRemove.size() > 0) {
                dataSourcesRemove = this.dataSourcesToRemove.keySet().toArray();
                if (DEBUGADDREMOVE && dataSourcesRemove.length > 1) {
                    this.debug("Streamlining removing " + dataSourcesRemove.length + " rows");
                }
                this.dataSourcesToRemove.clear();
            }
        }
        boolean bl = hasAdd = dataSourcesAdd != null && dataSourcesAdd.length > 0;
        if (hasAdd) {
            this.reallyAddDataSources(dataSourcesAdd);
            if (DEBUGADDREMOVE && dataSourcesAdd.length > 1) {
                this.debug("Streamlined adding " + dataSourcesAdd.length + " rows");
            }
        }
        boolean bl2 = hasRemove = dataSourcesRemove != null && dataSourcesRemove.length > 0;
        if (hasRemove) {
            this.reallyRemoveDataSources(dataSourcesRemove);
        }
        if (hasAdd || hasRemove) {
            this.tableMutated();
        }
    }

    @Override
    public void addDataSource(DATASOURCETYPE dataSource) {
        this.addDataSource(dataSource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDataSource(DATASOURCETYPE dataSource, boolean skipFilterCheck) {
        if (dataSource == null) {
            return;
        }
        Object object = this.rows_sync;
        synchronized (object) {
            this.listUnfilteredDataSources.put(dataSource, "");
        }
        if (DEBUGADDREMOVE) {
            this.debug("AddDS: " + dataSource + "; listUnfilteredDS: " + this.listUnfilteredDataSources.size() + " via " + Debug.getCompressedStackTrace(4));
        }
        if (!skipFilterCheck && this.filter != null && !this.filter.checker.filterCheck(dataSource, this.filter.text, this.filter.regex)) {
            return;
        }
        object = this.rows_sync;
        synchronized (object) {
            if (this.dataSourcesToRemove.remove(dataSource) != null && DEBUGADDREMOVE) {
                this.debug("AddDS: Removed from toRemove.  Total Removals Queued: " + this.dataSourcesToRemove.size());
            }
            if (this.dataSourcesToAdd.containsKey(dataSource)) {
                if (DEBUGADDREMOVE) {
                    this.debug("AddDS: Already There.  Total Additions Queued: " + this.dataSourcesToAdd.size());
                }
            } else {
                this.dataSourcesToAdd.put(dataSource, "");
                if (DEBUGADDREMOVE) {
                    this.debug("Queued 1 dataSource to add.  Total Additions Queued: " + this.dataSourcesToAdd.size() + "; already=" + this.sortedRows.size());
                }
                this.refreshenProcessDataSourcesTimer();
            }
        }
    }

    @Override
    public void addDataSources(DATASOURCETYPE[] dataSources) {
        this.addDataSources(dataSources, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSources(DATASOURCETYPE[] dataSources, boolean skipFilterCheck) {
        if (dataSources == null) {
            return;
        }
        if (DEBUGADDREMOVE) {
            this.debug("AddDS: " + dataSources.length);
        }
        Object object = this.rows_sync;
        synchronized (object) {
            DATASOURCETYPE[] DATASOURCETYPEArray = dataSources;
            int n = dataSources.length;
            int n2 = 0;
            while (n2 < n) {
                DATASOURCETYPE ds = DATASOURCETYPEArray[n2];
                if (ds != null) {
                    this.listUnfilteredDataSources.put(ds, null);
                }
                ++n2;
            }
        }
        object = this.rows_sync;
        synchronized (object) {
            int count = 0;
            int i = 0;
            while (i < dataSources.length) {
                DATASOURCETYPE dataSource = dataSources[i];
                if (dataSource != null && (skipFilterCheck || this.filter == null || this.filter.checker.filterCheck(dataSource, this.filter.text, this.filter.regex))) {
                    this.dataSourcesToRemove.remove(dataSource);
                    if (!this.dataSourcesToAdd.containsKey(dataSource)) {
                        ++count;
                        this.dataSourcesToAdd.put(dataSource, "");
                    }
                }
                ++i;
            }
            if (DEBUGADDREMOVE) {
                this.debug("Queued " + count + " of " + dataSources.length + " dataSources to add.  Total Qd: " + this.dataSourcesToAdd.size() + ";Unfiltered: " + this.listUnfilteredDataSources.size() + " via " + Debug.getCompressedStackTrace(5));
            }
        }
        this.refreshenProcessDataSourcesTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dataSourceExists(DATASOURCETYPE dataSource) {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.mapDataSourceToRow.containsKey(dataSource) || this.dataSourcesToAdd.containsKey(dataSource);
        }
    }

    @Override
    public void processDataSourceQueue() {
        this.getOffUIThread(new AERunnable(){

            @Override
            public void runSupport() {
                TableViewImpl.this._processDataSourceQueue();
            }
        });
    }

    public abstract void getOffUIThread(AERunnable var1);

    @Override
    public void processDataSourceQueueSync() {
        this._processDataSourceQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(boolean bIncludeQueue) {
        Object object = this.rows_sync;
        synchronized (object) {
            int size = this.sortedRows.size();
            if (bIncludeQueue) {
                if (this.dataSourcesToAdd != null) {
                    size += this.dataSourcesToAdd.size();
                }
                if (this.dataSourcesToRemove != null) {
                    size -= this.dataSourcesToRemove.size();
                }
            }
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore[] getRows() {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.sortedRows.toArray(new TableRowCore[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore getRow(DATASOURCETYPE dataSource) {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.mapDataSourceToRow.get(dataSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore getRow(int iPos) {
        Object object = this.rows_sync;
        synchronized (object) {
            if (iPos >= 0 && iPos < this.sortedRows.size()) {
                TableRowCore row = this.sortedRows.get(iPos);
                if (row.getIndex() != iPos) {
                    row.setTableItem(iPos);
                }
                return row;
            }
        }
        return null;
    }

    public TableRowCore getRowQuick(int iPos) {
        try {
            return this.sortedRows.get(iPos);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(TableRowCore row) {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.sortedRows.indexOf(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.mapDataSourceToRow.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<DATASOURCETYPE> getDataSources() {
        Object object = this.rows_sync;
        synchronized (object) {
            return new ArrayList<DATASOURCETYPE>(this.mapDataSourceToRow.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataSource(DATASOURCETYPE dataSource) {
        if (dataSource == null) {
            return;
        }
        Object object = this.rows_sync;
        synchronized (object) {
            this.listUnfilteredDataSources.remove(dataSource);
        }
        if (DEBUGADDREMOVE) {
            this.debug("RemDS: " + dataSource + "; listUnfilteredDS=" + this.listUnfilteredDataSources.size());
        }
        object = this.rows_sync;
        synchronized (object) {
            this.dataSourcesToAdd.remove(dataSource);
            this.dataSourcesToRemove.put(dataSource, "");
            if (DEBUGADDREMOVE) {
                this.debug("Queued 1 dataSource to remove.  Total Queued: " + this.dataSourcesToRemove.size());
            }
        }
        this.refreshenProcessDataSourcesTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataSources(DATASOURCETYPE[] dataSources) {
        if (dataSources == null || dataSources.length == 0) {
            return;
        }
        if (DEBUGADDREMOVE) {
            this.debug("RemDS: " + dataSources.length);
        }
        Object object = this.rows_sync;
        synchronized (object) {
            DATASOURCETYPE[] DATASOURCETYPEArray = dataSources;
            int n = dataSources.length;
            int n2 = 0;
            while (n2 < n) {
                DATASOURCETYPE ds = DATASOURCETYPEArray[n2];
                this.listUnfilteredDataSources.remove(ds);
                ++n2;
            }
        }
        object = this.rows_sync;
        synchronized (object) {
            int i = 0;
            while (i < dataSources.length) {
                DATASOURCETYPE dataSource = dataSources[i];
                this.dataSourcesToAdd.remove(dataSource);
                this.dataSourcesToRemove.put(dataSource, "");
                ++i;
            }
            if (DEBUGADDREMOVE) {
                this.debug("Queued " + dataSources.length + " dataSources to remove.  Total Qd: " + this.dataSourcesToRemove.size() + "; Unfiltered: " + this.listUnfilteredDataSources.size() + " via " + Debug.getCompressedStackTrace(4));
            }
        }
        this.refreshenProcessDataSourcesTimer();
    }

    private void refreshenProcessDataSourcesTimer() {
        if (this.bReallyAddingDataSources || this.processDataSourceQueueCallback == null) {
            return;
        }
        boolean processQueueImmediately = DataSourceCallBackUtil.addDataSourceAggregated(this.processDataSourceQueueCallback);
        if (processQueueImmediately) {
            this.processDataSourceQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reallyAddDataSources(Object[] dataSources) {
        if (this.isDisposed()) {
            return;
        }
        this.bReallyAddingDataSources = true;
        if (DEBUGADDREMOVE) {
            this.debug(">> Add " + dataSources.length + " rows;");
        }
        Object object = this.rows_sync;
        synchronized (object) {
            try {
                int i = 0;
                while (i < dataSources.length) {
                    Object ds = dataSources[i];
                    if (ds == null) {
                        if (DEBUGADDREMOVE) {
                            this.debug("-- Null DS for " + i);
                        }
                    } else if (this.mapDataSourceToRow.containsKey(ds)) {
                        if (DEBUGADDREMOVE) {
                            this.debug("-- " + i + " already added: " + ds.getClass());
                        }
                        dataSources[i] = null;
                    } else {
                        TableRowCore rowCore = this.createNewRow(ds);
                        this.mapDataSourceToRow.put(ds, rowCore);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LOGID, "Error while added row to Table " + this.getTableID(), e));
            }
        }
        if (DEBUGADDREMOVE) {
            this.debug("-- Add " + dataSources.length + " rows;");
        }
        this.addSortedDataSource(dataSources);
        this.bReallyAddingDataSources = false;
    }

    public abstract TableRowCore createNewRow(Object var1);

    @Override
    public void delete() {
        this.processDataSourceQueueCallback = null;
    }

    public Object getRowsSync() {
        return this.rows_sync;
    }

    public void setRowsSync(Object o) {
        this.rows_sync = o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println("Diagnostics for " + this + " (" + this.getTableID() + ")");
        Object object = this.rows_sync;
        synchronized (object) {
            writer.println("DataSources scheduled to Add/Remove: " + this.dataSourcesToAdd.size() + "/" + this.dataSourcesToRemove.size());
            writer.println("TableView: " + this.mapDataSourceToRow.size() + " datasources");
            for (DATASOURCETYPE key : this.mapDataSourceToRow.keySet()) {
                writer.println("  " + key + " -> " + this.mapDataSourceToRow.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllTableRows() {
        ArrayList<TableRowCore> itemsToRemove;
        Object object = this.rows_sync;
        synchronized (object) {
            itemsToRemove = new ArrayList<TableRowCore>(this.mapDataSourceToRow.values());
            this.mapDataSourceToRow.clear();
            this.sortedRows.clear();
            this.dataSourcesToAdd.clear();
            this.dataSourcesToRemove.clear();
            this.listUnfilteredDataSources.clear();
            this.selectedRows.clear();
            this.listSelectedCoreDataSources = null;
            if (DEBUGADDREMOVE) {
                this.debug("removeAll");
            }
        }
        for (TableRowCore row : itemsToRemove) {
            row.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reallyRemoveDataSources(Object[] dataSources) {
        long lStart = SystemTime.getCurrentTime();
        int rows_removed = 0;
        StringBuffer sbWillRemove = null;
        if (DEBUGADDREMOVE) {
            this.debug(">>> Remove rows.  Start w/" + this.getRowCount() + "ds;" + (SystemTime.getCurrentTime() - lStart) + "ms wait");
            sbWillRemove = new StringBuffer("Will soon remove row #");
        }
        ArrayList<TableRowCore> itemsToRemove = new ArrayList<TableRowCore>();
        ArrayList<Integer> indexesToRemove = new ArrayList<Integer>();
        int numRemovedHavingSelection = 0;
        Object object = this.rows_sync;
        synchronized (object) {
            int i = 0;
            while (i < dataSources.length) {
                TableRowCore item;
                if (dataSources[i] != null && (item = this.mapDataSourceToRow.get(dataSources[i])) != null) {
                    if (this.isProvideIndexesOnRemove()) {
                        int index = this.sortedRows.indexOf(item);
                        indexesToRemove.add(index);
                        if (DEBUGADDREMOVE) {
                            if (i != 0) {
                                sbWillRemove.append(", ");
                            }
                            sbWillRemove.append(index);
                        }
                    }
                    if (item.isSelected()) {
                        ++numRemovedHavingSelection;
                    }
                    itemsToRemove.add(item);
                    this.mapDataSourceToRow.remove(dataSources[i]);
                    this.triggerListenerRowRemoved(item);
                    this.sortedRows.remove(item);
                    this.selectedRows.remove(item);
                    ++rows_removed;
                }
                ++i;
            }
            if (rows_removed > 0) {
                this.listSelectedCoreDataSources = null;
            }
        }
        if (DEBUGADDREMOVE) {
            this.debug(sbWillRemove.toString());
            this.debug("#itemsToRemove=" + itemsToRemove.size());
        }
        this.uiRemoveRows(itemsToRemove.toArray(new TableRowCore[0]), indexesToRemove.toArray(new Integer[0]));
        for (TableRowCore row : itemsToRemove) {
            row.delete();
        }
        if (DEBUGADDREMOVE) {
            this.debug("<< Remove " + itemsToRemove.size() + " rows. now " + this.mapDataSourceToRow.size() + "ds");
        }
    }

    private void tableMutated() {
        TableViewFilterCheck checker;
        filter<DATASOURCETYPE> f = this.filter;
        if (f != null && (checker = f.checker) instanceof TableViewFilterCheck.TableViewFilterCheckEx) {
            ((TableViewFilterCheck.TableViewFilterCheckEx)checker).viewChanged(this);
        }
    }

    protected void fillRowGaps(boolean bForceDataRefresh) {
        this._sortColumn(bForceDataRefresh, true, false);
    }

    public void sortColumn(boolean bForceDataRefresh) {
        this._sortColumn(bForceDataRefresh, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _sortColumn(boolean bForceDataRefresh, boolean bFillGapsOnly, boolean bFollowSelected) {
        if (this.isDisposed()) {
            return;
        }
        if (this.sortColumn != null && !this.sortColumn.isVisible()) {
            this.sortColumn = null;
        }
        Object object = this.rows_sync;
        synchronized (object) {
            int iNumMoves = 0;
            boolean needsUpdate = false;
            Object object2 = this.rows_sync;
            synchronized (object2) {
                if (bForceDataRefresh && this.sortColumn != null) {
                    String sColumnID = this.sortColumn.getName();
                    for (TableRowCore row : this.sortedRows) {
                        TableCellCore cell = row.getSortColumnCell(sColumnID);
                        if (cell == null) continue;
                        cell.refresh(true);
                    }
                }
                if (!bFillGapsOnly && this.sortColumn != null && this.sortColumn.getLastSortValueChange() >= this.lLastSortedOn) {
                    this.lLastSortedOn = SystemTime.getCurrentTime();
                    Collections.sort(this.sortedRows, this.sortColumn);
                }
                int i = 0;
                while (i < this.sortedRows.size()) {
                    boolean visible;
                    TableRowCore row = this.sortedRows.get(i);
                    if (row.setTableItem(i, visible = row.isVisible())) {
                        if (visible) {
                            needsUpdate = true;
                        }
                        ++iNumMoves;
                    }
                    ++i;
                }
            }
            if (needsUpdate) {
                this.visibleRowsChanged();
            }
        }
    }

    public abstract void visibleRowsChanged();

    public abstract void uiRemoveRows(TableRowCore[] var1, Integer[] var2);

    public abstract int uiGuessMaxVisibleRows();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetLastSortedOn() {
        Object object = this.rows_sync;
        synchronized (object) {
            this.lLastSortedOn = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableCellCore[] getColumnCells(String sColumnName) {
        Object object = this.rows_sync;
        synchronized (object) {
            TableCellCore[] cells = new TableCellCore[this.sortedRows.size()];
            int i = 0;
            for (TableRowCore row : this.sortedRows) {
                cells[i++] = row.getTableCellCore(sColumnName);
            }
            return cells;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSortedDataSource(Object[] dataSources) {
        if (this.isDisposed()) {
            return;
        }
        TableRowCore[] selectedRows = this.getSelectedRows();
        boolean bWas0Rows = this.getRowCount() == 0;
        try {
            if (DEBUGADDREMOVE) {
                this.debug("-- Add " + dataSources.length + " rows to SWT");
            }
            long lStartTime = SystemTime.getCurrentTime();
            ArrayList<TableRowCore> rowsAdded = new ArrayList<TableRowCore>();
            int i = 0;
            while (i < dataSources.length) {
                Object dataSource = dataSources[i];
                if (dataSource != null) {
                    TableRowCore row;
                    Object object = this.rows_sync;
                    synchronized (object) {
                        row = this.mapDataSourceToRow.get(dataSource);
                    }
                    if (row != null && !row.isRowDisposed()) {
                        TableCellCore cell;
                        if (this.sortColumn != null && (cell = row.getSortColumnCell(null)) != null) {
                            try {
                                cell.invalidate();
                                cell.refresh(true);
                            }
                            catch (Exception e) {
                                Logger.log(new LogEvent(LOGID, "Minor error adding a row to table " + this.getTableID(), e));
                            }
                        }
                        object = this.rows_sync;
                        synchronized (object) {
                            try {
                                int index = 0;
                                if (this.sortedRows.size() > 0) {
                                    TableRowCore lastRow = this.sortedRows.get(this.sortedRows.size() - 1);
                                    if (this.sortColumn == null || this.sortColumn.compare(row, lastRow) >= 0) {
                                        index = this.sortedRows.size();
                                        this.sortedRows.add(row);
                                        if (DEBUGADDREMOVE) {
                                            this.debug("Adding new row to bottom");
                                        }
                                    } else {
                                        index = Collections.binarySearch(this.sortedRows, row, this.sortColumn);
                                        if (index < 0) {
                                            index = -1 * index - 1;
                                        }
                                        if (index > this.sortedRows.size()) {
                                            index = this.sortedRows.size();
                                        }
                                        if (DEBUGADDREMOVE) {
                                            this.debug("Adding new row at position " + index + " of " + (this.sortedRows.size() - 1));
                                        }
                                        this.sortedRows.add(index, row);
                                    }
                                } else {
                                    if (DEBUGADDREMOVE) {
                                        this.debug("Adding new row to bottom (1st Entry)");
                                    }
                                    index = this.sortedRows.size();
                                    this.sortedRows.add(row);
                                }
                                rowsAdded.add(row);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                Logger.log(new LogEvent(LOGID, "Error adding a row to table " + this.getTableID(), e));
                                try {
                                    if (!this.sortedRows.contains(row)) {
                                        this.sortedRows.add(row);
                                    }
                                }
                                catch (Exception e2) {
                                    Debug.out(e2);
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            this.triggerListenerRowAdded(rowsAdded.toArray(new TableRowCore[0]));
            if (DEBUGADDREMOVE) {
                this.debug("Adding took " + (SystemTime.getCurrentTime() - lStartTime) + "ms");
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Error while adding row to Table " + this.getTableID(), e));
        }
        this.refreshenProcessDataSourcesTimer();
        this.visibleRowsChanged();
        this.fillRowGaps(false);
        if (selectedRows.length > 0) {
            this.setSelectedRows(selectedRows);
        }
        if (DEBUGADDREMOVE) {
            this.debug("<< " + this.size(false));
        }
    }

    @Override
    public void cellInvalidate(TableColumnCore tableColumn, DATASOURCETYPE data_source) {
        this.cellInvalidate(tableColumn, data_source, true);
    }

    public void cellInvalidate(TableColumnCore tableColumn, final DATASOURCETYPE data_source, final boolean bMustRefresh) {
        final String sColumnName = tableColumn.getName();
        this.runForAllRows(new TableGroupRowRunner(){

            @Override
            public void run(TableRowCore row) {
                TableCellCore cell = row.getTableCellCore(sColumnName);
                if (cell != null && cell.getDataSource() != null && cell.getDataSource().equals(data_source)) {
                    cell.invalidate(bMustRefresh);
                }
            }
        });
    }

    @Override
    public void columnInvalidate(String sColumnName) {
        TableColumnCore tc = TableColumnManager.getInstance().getTableColumnCore(this.getTableID(), sColumnName);
        if (tc != null) {
            this.columnInvalidate(tc, tc.getType() == 3);
        }
    }

    public void columnInvalidate(TableColumnCore tableColumn, final boolean bMustRefresh) {
        final String sColumnName = tableColumn.getName();
        this.runForAllRows(new TableGroupRowRunner(){

            @Override
            public void run(TableRowCore row) {
                TableCellCore cell = row.getTableCellCore(sColumnName);
                if (cell != null) {
                    cell.invalidate(bMustRefresh);
                }
            }
        });
        this.resetLastSortedOn();
        tableColumn.setLastSortValueChange(SystemTime.getCurrentTime());
    }

    @Override
    public void columnInvalidate(TableColumnCore tableColumn) {
        this.columnInvalidate(tableColumn, true);
    }

    @Override
    public String getPropertiesPrefix() {
        return this.propertiesPrefix;
    }

    @Override
    public String getTableID() {
        return this.tableID;
    }

    @Override
    public Class<?> getDataSourceType() {
        return this.classPluginDataSourceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableStructureChanged(boolean columnAddedOrRemoved, Class forPluginDataSourceType) {
        Object[] unfilteredDS;
        if (forPluginDataSourceType != null && !forPluginDataSourceType.equals(this.getDataSourceType())) {
            return;
        }
        this.triggerLifeCycleListener(1);
        Object object = this.rows_sync;
        synchronized (object) {
            unfilteredDS = this.listUnfilteredDataSources.keySet().toArray();
        }
        if (DEBUGADDREMOVE) {
            this.debug("TSC: #Unfiltered=" + unfilteredDS.length);
        }
        this.removeAllTableRows();
        this.processDataSourceQueueSync();
        if (columnAddedOrRemoved) {
            this.tableColumns = TableColumnManager.getInstance().getAllTableColumnCoreAsArray(this.getDataSourceType(), this.tableID);
            ArrayList<TableColumnCore> listVisibleColumns = new ArrayList<TableColumnCore>();
            TableColumnCore[] tableColumnCoreArray = this.tableColumns;
            int n = this.tableColumns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumnCore column = tableColumnCoreArray[n2];
                if (column.isVisible()) {
                    listVisibleColumns.add(column);
                }
                ++n2;
            }
            Collections.sort(listVisibleColumns, new Comparator<TableColumnCore>(){

                @Override
                public int compare(TableColumnCore o1, TableColumnCore o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    int diff = o1.getPosition() - o2.getPosition();
                    return diff;
                }
            });
            this.columnsOrdered = listVisibleColumns.toArray(new TableColumnCore[0]);
        }
        this.refreshTable(false);
        this.triggerLifeCycleListener(0);
        if (this.listUnfilteredDataSources.size() == 0) {
            this.addDataSources(unfilteredDS);
        }
    }

    @Override
    public TableColumn getTableColumn(String sColumnName) {
        int i = 0;
        while (i < this.tableColumns.length) {
            TableColumnCore tc = this.tableColumns[i];
            if (tc.getName().equals(sColumnName)) {
                return tc;
            }
            ++i;
        }
        return null;
    }

    @Override
    public TableColumnCore[] getVisibleColumns() {
        return this.columnsOrdered;
    }

    @Override
    public TableColumnCore[] getAllColumns() {
        return this.tableColumns;
    }

    protected void setColumnsOrdered(TableColumnCore[] columnsOrdered) {
        this.columnsOrdered = columnsOrdered;
    }

    @Override
    public boolean isColumnVisible(TableColumn column) {
        if (column == null) {
            return false;
        }
        return column.isVisible();
    }

    @Override
    public void refreshTable(boolean bForceSort) {
        this.triggerTableRefreshListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getSelectedDataSourcesList() {
        Object object = this.rows_sync;
        synchronized (object) {
            if (this.listSelectedCoreDataSources != null) {
                return this.listSelectedCoreDataSources;
            }
            if (this.isDisposed() || this.selectedRows.size() == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> l = new ArrayList<Object>(this.selectedRows.size());
            for (TableRowCore row : this.selectedRows) {
                Object ds;
                if (row == null || row.isRowDisposed() || (ds = row.getDataSource(true)) == null) continue;
                l.add(ds);
            }
            this.listSelectedCoreDataSources = l;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getSelectedPluginDataSourcesList() {
        Object object = this.rows_sync;
        synchronized (object) {
            if (this.isDisposed() || this.selectedRows.size() == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> l = new ArrayList<Object>(this.selectedRows.size());
            for (TableRowCore row : this.selectedRows) {
                Object ds;
                if (row == null || row.isRowDisposed() || (ds = row.getDataSource(false)) == null) continue;
                l.add(ds);
            }
            return l;
        }
    }

    @Override
    public List<Object> getSelectedDataSources() {
        return new ArrayList<Object>(this.getSelectedDataSourcesList());
    }

    @Override
    public Object[] getSelectedDataSources(boolean bCoreDataSource) {
        if (bCoreDataSource) {
            return this.getSelectedDataSourcesList().toArray();
        }
        return this.getSelectedPluginDataSourcesList().toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore[] getSelectedRows() {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.selectedRows.toArray(new TableRowCore[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSelectedRowsSize() {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.selectedRows.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableRowCore> getSelectedRowsList() {
        Object object = this.rows_sync;
        synchronized (object) {
            ArrayList<TableRowCore> l = new ArrayList<TableRowCore>(this.selectedRows.size());
            for (TableRowCore row : this.selectedRows) {
                if (row == null || row.isRowDisposed()) continue;
                l.add(row);
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSelected(TableRow row) {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.selectedRows.contains(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore getFocusedRow() {
        Object object = this.rows_sync;
        synchronized (object) {
            block4: {
                if (this.selectedRows.size() != 0) break block4;
                return null;
            }
            return this.selectedRows.get(0);
        }
    }

    @Override
    public Object getFirstSelectedDataSource() {
        return this.getFirstSelectedDataSource(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFirstSelectedDataSource(boolean bCoreObject) {
        Object object = this.rows_sync;
        synchronized (object) {
            if (this.selectedRows.size() > 0) {
                return this.selectedRows.get(0).getDataSource(bCoreObject);
            }
        }
        return null;
    }

    public void tableInvalidate() {
        this.runForAllRows(new TableGroupRowVisibilityRunner(){

            @Override
            public void run(TableRowCore row, boolean bVisible) {
                row.invalidate();
                row.refresh(true, bVisible);
            }
        });
    }

    @Override
    public boolean getHeaderVisible() {
        return this.headerVisible;
    }

    @Override
    public void setHeaderVisible(boolean visible) {
        this.headerVisible = visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableColumnCore getSortColumn() {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.sortColumn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setSortColumn(TableColumnCore newSortColumn, boolean allowOrderChange) {
        if (newSortColumn == null) {
            return false;
        }
        Object object = this.rows_sync;
        synchronized (object) {
            boolean isSameColumn = newSortColumn.equals(this.sortColumn);
            if (allowOrderChange) {
                if (!isSameColumn) {
                    this.sortColumn = newSortColumn;
                    int iSortDirection = configMan.getIntParameter(CFG_SORTDIRECTION);
                    if (iSortDirection == 0) {
                        this.sortColumn.setSortAscending(true);
                    } else if (iSortDirection == 1) {
                        this.sortColumn.setSortAscending(false);
                    } else {
                        this.sortColumn.setSortAscending(!this.sortColumn.isSortAscending());
                    }
                    TableColumnManager.getInstance().setDefaultSortColumnName(this.tableID, this.sortColumn.getName(), true);
                } else {
                    this.sortColumn.setSortAscending(!this.sortColumn.isSortAscending());
                }
            } else {
                this.sortColumn = newSortColumn;
            }
            if (!isSameColumn) {
                String name = this.sortColumn.getName();
                for (TableRowCore row : this.sortedRows) {
                    row.setSortColumn(name);
                }
            }
            this.uiChangeColumnIndicator();
            this.resetLastSortedOn();
            this.sortColumn(!isSameColumn);
            return !isSameColumn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRowSelected(TableRowCore row, boolean selected, boolean trigger) {
        if (row == null || row.isRowDisposed()) {
            return;
        }
        if (this.isSingleSelection()) {
            this.setSelectedRows(new TableRowCore[]{row}, trigger);
        } else {
            ArrayList<TableRowCore> newSelectedRows;
            boolean somethingChanged = false;
            Object object = this.rows_sync;
            synchronized (object) {
                newSelectedRows = new ArrayList<TableRowCore>(this.selectedRows);
                if (selected) {
                    if (!newSelectedRows.contains(row)) {
                        newSelectedRows.add(row);
                        somethingChanged = true;
                    }
                } else {
                    somethingChanged = newSelectedRows.remove(row);
                }
            }
            if (somethingChanged) {
                this.setSelectedRows(newSelectedRows.toArray(new TableRowCore[0]), trigger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedRows(TableRowCore[] newSelectionArray, boolean trigger) {
        boolean somethingChanged;
        ArrayList<TableRowCore> listNewlySelected;
        if (this.isDisposed()) {
            return;
        }
        ArrayList<TableRowCore> oldSelectionList = new ArrayList<TableRowCore>();
        Object object = this.rows_sync;
        synchronized (object) {
            if (this.selectedRows.size() == 0 && newSelectionArray.length == 0) {
                return;
            }
            oldSelectionList.addAll(this.selectedRows);
            this.listSelectedCoreDataSources = null;
            this.selectedRows.clear();
            listNewlySelected = new ArrayList<TableRowCore>(1);
            TableRowCore[] tableRowCoreArray = newSelectionArray;
            int n = newSelectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableRowCore row = tableRowCoreArray[n2];
                if (row != null && !row.isRowDisposed()) {
                    boolean existed = false;
                    for (TableRowCore oldRow : oldSelectionList) {
                        if (oldRow != row) continue;
                        existed = true;
                        if (!this.selectedRows.contains(row)) {
                            this.selectedRows.add(row);
                        }
                        oldSelectionList.remove(row);
                        break;
                    }
                    if (!existed) {
                        if (!this.selectedRows.contains(row)) {
                            this.selectedRows.add(row);
                        }
                        if (!listNewlySelected.contains(row)) {
                            listNewlySelected.add(row);
                        }
                    }
                }
                ++n2;
            }
            somethingChanged = listNewlySelected.size() > 0 || oldSelectionList.size() > 0;
        }
        if (somethingChanged) {
            this.uiSelectionChanged(listNewlySelected.toArray(new TableRowCore[0]), oldSelectionList.toArray(new TableRowCore[0]));
        }
        if (trigger && somethingChanged) {
            if (listNewlySelected.size() > 0) {
                this.triggerSelectionListeners(listNewlySelected.toArray(new TableRowCore[0]));
            }
            if (oldSelectionList.size() > 0) {
                this.triggerDeselectionListeners(oldSelectionList.toArray(new TableRowCore[0]));
            }
            this.triggerTabViewsDataSourceChanged();
        }
    }

    public abstract boolean isSingleSelection();

    public abstract void uiSelectionChanged(TableRowCore[] var1, TableRowCore[] var2);

    @Override
    public void setSelectedRows(TableRowCore[] rows) {
        this.setSelectedRows(rows, true);
    }

    @Override
    public void selectAll() {
        this.setSelectedRows(this.getRows(), true);
    }

    public String getFilterText() {
        return this.filter == null ? "" : this.filter.text;
    }

    public boolean isMenuEnabled() {
        return this.menuEnabled;
    }

    public void setMenuEnabled(boolean menuEnabled) {
        this.menuEnabled = menuEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLastRow(TableRowCore row) {
        Object object = this.rows_sync;
        synchronized (object) {
            int size = this.sortedRows.size();
            return size == 0 ? false : this.sortedRows.get(size - 1) == row;
        }
    }

    public abstract void triggerTabViewsDataSourceChanged();

    protected abstract void uiChangeColumnIndicator();

    public boolean isProvideIndexesOnRemove() {
        return this.provideIndexesOnRemove;
    }

    public void setProvideIndexesOnRemove(boolean provideIndexesOnRemove) {
        this.provideIndexesOnRemove = provideIndexesOnRemove;
    }

    public boolean isTableSelected() {
        return SelectedContentManager.getCurrentlySelectedTableView() == this;
    }

    public static class filter<DATASOURCETYPE> {
        public TimerEvent eventUpdate;
        public String text = "";
        public long lastFilterTime;
        public boolean regex = false;
        public TableViewFilterCheck<DATASOURCETYPE> checker;
        public String nextText = "";
    }
}

