/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.xmwebui;

import com.aelitis.azureus.core.content.ContentException;
import com.aelitis.azureus.core.content.RelatedAttributeLookupListener;
import com.aelitis.azureus.core.content.RelatedContentManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.RandomUtils;

public class TagSearchInstance {
    long numActiveLookups = 0L;
    Map<String, List<String>> mapTags = new HashMap<String, List<String>>();
    private String sid;

    public TagSearchInstance() {
        byte[] bytes = new byte[16];
        RandomUtils.nextSecureBytes(bytes);
        this.sid = Base32.encode(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSearch(final String hashString, byte[] torrentHash, String[] networks) throws ContentException {
        RelatedContentManager rcm = RelatedContentManager.getSingleton();
        TagSearchInstance tagSearchInstance = this;
        synchronized (tagSearchInstance) {
            ++this.numActiveLookups;
        }
        try {
            rcm.lookupAttributes(torrentHash, networks, new RelatedAttributeLookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void tagFound(String tag, String network) {
                    Map<String, List<String>> map = TagSearchInstance.this.mapTags;
                    synchronized (map) {
                        List<String> list = TagSearchInstance.this.mapTags.get(hashString);
                        if (list == null) {
                            list = new ArrayList<String>();
                            TagSearchInstance.this.mapTags.put(hashString, list);
                        }
                        list.add(tag);
                    }
                }

                @Override
                public void lookupStart() {
                }

                @Override
                public void lookupFailed(ContentException error) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void lookupComplete() {
                    TagSearchInstance tagSearchInstance = TagSearchInstance.this;
                    synchronized (tagSearchInstance) {
                        --TagSearchInstance.this.numActiveLookups;
                    }
                }
            });
        }
        catch (Exception e) {
            TagSearchInstance tagSearchInstance2 = this;
            synchronized (tagSearchInstance2) {
                --this.numActiveLookups;
            }
        }
    }

    public String getID() {
        return this.sid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getResults(Map result) {
        result.put("id", this.sid);
        ArrayList torrentList = new ArrayList();
        result.put("torrents", torrentList);
        TagSearchInstance tagSearchInstance = this;
        synchronized (tagSearchInstance) {
            Map<String, List<String>> map = this.mapTags;
            synchronized (map) {
                for (String hash : this.mapTags.keySet()) {
                    HashMap<String, Object> map2 = new HashMap<String, Object>();
                    map2.put("hashString", hash);
                    map2.put("tags", new ArrayList(this.mapTags.get(hash)));
                    torrentList.add(map2);
                }
            }
            boolean all_complete = this.numActiveLookups == 0L;
            result.put("complete", all_complete);
            return all_complete;
        }
    }
}

