/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnpmediaserver;

import com.aelitis.azureus.core.content.AzureusContentFilter;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaServer;
import com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaServerContentDirectory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationListener;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageGenerator;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;

public class UPnPMediaServerHTTP
implements TrackerWebPageGenerator {
    private static final String NL = "\r\n";
    private UPnPMediaServer plugin;
    private int port;
    private TrackerWebContext web_context;

    protected UPnPMediaServerHTTP(UPnPMediaServer _plugin, int _port) {
        this.plugin = _plugin;
        this.port = _port;
        try {
            this.web_context = this.plugin.getPluginInterface().getTracker().createWebContext(this.port, 1);
            this.web_context.addAuthenticationListener(new TrackerAuthenticationListener(){

                @Override
                public boolean authenticate(URL resource, String user, String password) {
                    return UPnPMediaServerHTTP.this.plugin.doHTTPAuth(user, password);
                }

                @Override
                public byte[] authenticate(URL resource, String user) {
                    return null;
                }
            });
            this.web_context.addPageGenerator(this);
        }
        catch (Throwable e) {
            this.plugin.logAlert("Failed to create HTTP server on port " + this.port + ": " + Debug.getNestedExceptionMessage(e));
        }
    }

    @Override
    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        String host = (String)request2.getHeaders().get("host");
        if (host != null) {
            host = host.split(":")[0];
        }
        String url = request2.getURL();
        HashMap<String, String> args = new HashMap<String, String>();
        int pos = url.indexOf(63);
        if (pos != -1) {
            String[] bits;
            String[] stringArray = bits = url.substring(pos + 1).split("&");
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String bit = stringArray[n2];
                String[] x = bit.split("=");
                if (x.length == 1) {
                    args.put(bit, null);
                } else {
                    args.put(x[0], URLDecoder.decode(x[1], "UTF-8"));
                }
                ++n2;
            }
        }
        List<AzureusContentFilter> filters = this.plugin.receivedBrowse(request2, true);
        if (url.startsWith("/basic")) {
            return this.generateBasic(host, url.substring(6), args, filters, response);
        }
        return this.generateBasic(host, url, args, filters, response);
    }

    protected boolean generateBasic(String host, String url, Map<String, String> args, List<AzureusContentFilter> filters, TrackerWebPageResponse response) throws IOException {
        this.plugin.log("HTTP: " + url);
        if (url.startsWith("/") && url.length() > 1) {
            return this.useResource(url, new HashMap<String, String>(), response);
        }
        if (args.get("iid") != null) {
            UPnPMediaServerContentDirectory.contentItem item = (UPnPMediaServerContentDirectory.contentItem)this.plugin.getContentDirectory().getContentFromID(Integer.parseInt(args.get("iid")));
            if (item == null) {
                return false;
            }
            String name = item.getDisplayTitle();
            String stream_uri = item.getURI(host, -1);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("TITLE", this.escape(item.getName()));
            map.put("URL", stream_uri);
            if (name.endsWith(".flv")) {
                return this.useResource("/flv_player.html", map, response);
            }
            return this.useResource("/ts_player.html", map, response);
        }
        response.setContentType("text/html; charset=utf-8");
        OutputStream os = response.getOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
        pw.println("<head>");
        pw.println("<title>" + this.escape("HTTP Server for '" + this.plugin.getServiceName() + "'") + "</title>");
        pw.println("</head>");
        pw.println("<body>");
        String container_id = args.get("cid");
        UPnPMediaServerContentDirectory content_directory = this.plugin.getContentDirectory();
        UPnPMediaServerContentDirectory.contentContainer container = null;
        if (container_id != null) {
            container = content_directory.getContainerFromID(Integer.parseInt(container_id));
        }
        if (container == null) {
            container = content_directory.getRootContainer();
        }
        if (container == null) {
            return false;
        }
        pw.println(this.escape(container.getName()));
        List<UPnPMediaServerContentDirectory.content> kids = container.getChildren();
        this.plugin.sortContent(kids);
        HashMap<String, Object> filter_args = new HashMap<String, Object>();
        for (UPnPMediaServerContentDirectory.content kid : kids) {
            if (!this.plugin.isVisible(kid, filters, filter_args)) continue;
            if (kid instanceof UPnPMediaServerContentDirectory.contentContainer) {
                String kid_url = "/basic?cid=" + kid.getID();
                pw.println("<ul><a href=" + kid_url + ">" + this.escape(kid.getName()) + "</a></ul>");
                continue;
            }
            UPnPMediaServerContentDirectory.contentItem item = (UPnPMediaServerContentDirectory.contentItem)kid;
            String name = item.getDisplayTitle();
            if (name.endsWith(".flv") || name.endsWith(".ts")) {
                pw.println("<li><a href=/basic?iid=" + kid.getID() + ">" + this.escape(name) + "</a></li>");
                continue;
            }
            String kid_url = item.getURI(host, -1);
            pw.println("<li><a href=" + kid_url + ">" + this.escape(name) + "</a></li>");
        }
        pw.println("</body>");
        pw.flush();
        return true;
    }

    protected boolean useResource(String url, Map<String, String> substitutions, TrackerWebPageResponse response) throws IOException {
        if ((url = url.trim()).indexOf("..") == -1 && !url.endsWith("/")) {
            int pos = url.lastIndexOf("/");
            if (pos != -1) {
                url = url.substring(pos);
            }
            String resource = "/com/aelitis/azureus/plugins/upnpmediaserver/resources/http" + url;
            InputStream stream = this.getClass().getResourceAsStream(resource);
            if (stream != null) {
                if (substitutions.size() > 0) {
                    int len;
                    byte[] buffer = new byte[1024];
                    String content2 = "";
                    while ((len = stream.read(buffer)) > 0) {
                        content2 = String.valueOf(content2) + new String(buffer, 0, len, "UTF-8");
                    }
                    for (Map.Entry<String, String> entry : substitutions.entrySet()) {
                        content2 = content2.replaceAll("%" + entry.getKey() + "%", entry.getValue());
                    }
                    stream.close();
                    stream = new ByteArrayInputStream(content2.getBytes("UTF-8"));
                }
                try {
                    pos = url.lastIndexOf(46);
                    String file_type = pos == -1 ? "?" : url.substring(pos + 1);
                    response.useStream(file_type, stream);
                    return true;
                }
                finally {
                    stream.close();
                }
            }
        }
        return false;
    }

    protected String escape(String str) {
        return this.plugin.escapeXML(str);
    }

    protected void destroy() {
        if (this.web_context != null) {
            this.web_context.destroy();
        }
    }
}

