/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnpmediaserver;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;

public class UPnPMediaChannel {
    private static final int READ_TIMEOUT = 30000;
    private static final VirtualChannelSelector read_selector = new VirtualChannelSelector("UPnPMediaServer", 1, false);
    private static final VirtualChannelSelector write_selector = new VirtualChannelSelector("UPnPMediaServer", 4, false);
    private static final int BUFFER_LIMIT = 3;
    private static final int BLOCK_SIZE = 131072;
    private static final List<pendingWriteSelect> pending_write_resumes = new ArrayList<pendingWriteSelect>();
    static volatile boolean idle;
    private static Average data_write_speed;
    private static long data_write_total;
    private final Object read_lock = new Object();
    private final Object write_lock = new Object();
    private SocketChannel channel;
    private List<Byte> pending_read_bytes = new ArrayList<Byte>();
    private List<writeBuffer> write_buffers = new ArrayList<writeBuffer>();
    private IOException write_error;
    private channelListener listener;
    private long data_written;

    static {
        write_selector.setRandomiseKeys(true);
        new AEThread2("UPnPMediaChannel:writeSelector", true){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
                UPnPMediaChannel.selectLoop(write_selector, true);
            }
        }.start();
        new AEThread2("UPnPMediaChannel:readSelector", true){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
                UPnPMediaChannel.selectLoop(read_selector, false);
            }
        }.start();
        idle = true;
        data_write_speed = Average.getInstance(1000, 10);
    }

    protected static void setIdle(boolean i) {
        if (idle != i) {
            idle = i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void selectLoop(VirtualChannelSelector selector, boolean is_write) {
        while (true) {
            if (is_write) {
                long now = SystemTime.getMonotonousTime();
                List<pendingWriteSelect> list = pending_write_resumes;
                synchronized (list) {
                    Iterator<pendingWriteSelect> it = pending_write_resumes.iterator();
                    while (it.hasNext()) {
                        pendingWriteSelect pws = it.next();
                        if (now < pws.when) continue;
                        it.remove();
                        write_selector.resumeSelects(pws.channel);
                    }
                }
            }
            selector.select(idle ? 250 : 25);
        }
    }

    public static long getAverageUpSpeed() {
        return data_write_speed.getAverage();
    }

    public static long getTotalUp() {
        return data_write_total;
    }

    protected UPnPMediaChannel(Socket socket) throws IOException {
        this.channel = socket.getChannel();
        this.channel.configureBlocking(false);
        try {
            socket.setSendBufferSize(262144);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    protected void setListener(channelListener _listener) {
        this.listener = _listener;
    }

    public void read(byte[] buffer) throws IOException {
        this.read(ByteBuffer.wrap(buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(final ByteBuffer buffer) throws IOException {
        try {
            Object object = this.read_lock;
            synchronized (object) {
                Iterator<Byte> it = this.pending_read_bytes.iterator();
                while (it.hasNext() && buffer.hasRemaining()) {
                    buffer.put(it.next());
                    it.remove();
                }
                if (!buffer.hasRemaining()) {
                    return;
                }
                if (this.channel.read(buffer) < 0) {
                    throw new IOException("End of stream");
                }
                if (buffer.hasRemaining()) {
                    final IOException[] error = new IOException[1];
                    final AESemaphore sem = new AESemaphore("UPnPMediaChannel::read");
                    read_selector.register(this.channel, new VirtualChannelSelector.VirtualSelectorListener(){
                        private int consec_zlrs;

                        @Override
                        public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                            try {
                                int len = UPnPMediaChannel.this.channel.read(buffer);
                                if (!buffer.hasRemaining()) {
                                    read_selector.cancel(UPnPMediaChannel.this.channel);
                                    sem.release();
                                }
                                if (len < 0) {
                                    throw new IOException("End of stream");
                                }
                                if (len == 0) {
                                    if (UPnPMediaChannel.this.write_error != null) {
                                        throw UPnPMediaChannel.this.write_error;
                                    }
                                    ++this.consec_zlrs;
                                    if (this.consec_zlrs > 10) {
                                        throw new IOException("Too many consecutive zero length reads");
                                    }
                                } else {
                                    this.consec_zlrs = 0;
                                }
                                return len > 0;
                            }
                            catch (IOException e) {
                                error[0] = e;
                                read_selector.cancel(UPnPMediaChannel.this.channel);
                                sem.release();
                                return false;
                            }
                        }

                        @Override
                        public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                            error[0] = msg instanceof IOException ? (IOException)msg : new IOException(msg.getMessage());
                            read_selector.cancel(UPnPMediaChannel.this.channel);
                            sem.release();
                        }
                    }, null);
                    if (!sem.reserve(30000L)) {
                        throw new SocketTimeoutException("Read timeout");
                    }
                    if (error[0] != null) {
                        throw error[0];
                    }
                }
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public void write(long offset, byte[] buffer) throws IOException {
        this.writeSupport(new writeBuffer(offset, ByteBuffer.wrap(buffer)));
    }

    public void write(long offset, PooledByteBuffer buffer) throws IOException {
        this.writeSupport(new writeBuffer(offset, buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeSupport(writeBuffer buffer_thing) throws IOException {
        block28: {
            try {
                boolean add_to_pending = false;
                List<pendingWriteSelect> list = this.write_lock;
                synchronized (list) {
                    int permitted = 131072;
                    if (this.write_buffers.size() == 0) {
                        Object buffer_object = buffer_thing.buffer;
                        ByteBuffer buffer = buffer_object instanceof ByteBuffer ? (ByteBuffer)buffer_object : ((PooledByteBuffer)buffer_object).toByteBuffer();
                        if (this.listener != null) {
                            permitted = Math.min(permitted, this.listener.getAvailableBytes());
                        }
                        if (permitted > 0) {
                            int limit = buffer.limit();
                            if (buffer.remaining() > permitted) {
                                buffer.limit(buffer.position() + permitted);
                            }
                            try {
                                int pos = buffer.position();
                                int len = this.channel.write(buffer);
                                if (len > 0) {
                                    if (this.listener != null && buffer_thing.offset >= 0L) {
                                        this.listener.wrote(buffer_thing.offset + (long)pos, len);
                                    }
                                    this.data_written += (long)len;
                                    data_write_total += (long)len;
                                    data_write_speed.addValue(len);
                                }
                            }
                            finally {
                                buffer.limit(limit);
                            }
                            if (!buffer.hasRemaining()) {
                                if (buffer_object instanceof PooledByteBuffer) {
                                    ((PooledByteBuffer)buffer_object).returnToPool();
                                }
                                return;
                            }
                        }
                    }
                    this.write_buffers.add(buffer_thing);
                    if (this.write_error != null) {
                        throw this.write_error;
                    }
                    if (this.write_buffers.size() == 1) {
                        write_selector.register(this.channel, new VirtualChannelSelector.VirtualSelectorListener(){
                            private int consec_zlws;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                                long total_written = 0L;
                                while (true) {
                                    Object object;
                                    ByteBuffer buffer;
                                    writeBuffer current_buffer;
                                    int permitted = 131072;
                                    if (UPnPMediaChannel.this.listener != null) {
                                        permitted = Math.min(permitted, UPnPMediaChannel.this.listener.getAvailableBytes());
                                    }
                                    if (permitted <= 0) {
                                        write_selector.pauseSelects(UPnPMediaChannel.this.channel);
                                        List list = pending_write_resumes;
                                        synchronized (list) {
                                            pending_write_resumes.add(new pendingWriteSelect(UPnPMediaChannel.this.channel));
                                        }
                                        return true;
                                    }
                                    Object object2 = UPnPMediaChannel.this.write_lock;
                                    synchronized (object2) {
                                        block27: {
                                            if (UPnPMediaChannel.this.write_buffers.size() != 0) break block27;
                                            write_selector.cancel(UPnPMediaChannel.this.channel);
                                            return false;
                                        }
                                        current_buffer = (writeBuffer)UPnPMediaChannel.this.write_buffers.get(0);
                                        Object o = current_buffer.buffer;
                                        buffer = o instanceof ByteBuffer ? (ByteBuffer)o : ((PooledByteBuffer)o).toByteBuffer();
                                    }
                                    try {
                                        int limit = buffer.limit();
                                        if (buffer.remaining() > permitted) {
                                            buffer.limit(buffer.position() + permitted);
                                        }
                                        try {
                                            int pos = buffer.position();
                                            int len = UPnPMediaChannel.this.channel.write(buffer);
                                            if (len > 0) {
                                                if (UPnPMediaChannel.this.listener != null && current_buffer.offset >= 0L) {
                                                    UPnPMediaChannel.this.listener.wrote(current_buffer.offset + (long)pos, len);
                                                }
                                                UPnPMediaChannel uPnPMediaChannel = UPnPMediaChannel.this;
                                                uPnPMediaChannel.data_written = uPnPMediaChannel.data_written + (long)len;
                                                data_write_total = data_write_total + (long)len;
                                                data_write_speed.addValue(len);
                                                total_written += (long)len;
                                            }
                                        }
                                        finally {
                                            buffer.limit(limit);
                                        }
                                        if (buffer.hasRemaining()) break;
                                        object = UPnPMediaChannel.this.write_lock;
                                        synchronized (object) {
                                            UPnPMediaChannel.this.write_buffers.remove(current_buffer);
                                            if (current_buffer.buffer instanceof PooledByteBuffer) {
                                                ((PooledByteBuffer)current_buffer.buffer).returnToPool();
                                            }
                                            if (UPnPMediaChannel.this.write_buffers.size() == 0) {
                                                write_selector.cancel(UPnPMediaChannel.this.channel);
                                                break;
                                            }
                                            if (UPnPMediaChannel.this.write_buffers.size() == 2) {
                                                UPnPMediaChannel.this.write_lock.notify();
                                            }
                                        }
                                    }
                                    catch (IOException e) {
                                        write_selector.cancel(UPnPMediaChannel.this.channel);
                                        object = UPnPMediaChannel.this.write_lock;
                                        synchronized (object) {
                                            UPnPMediaChannel.this.write_error = e;
                                            UPnPMediaChannel.this.write_lock.notifyAll();
                                        }
                                        return false;
                                    }
                                }
                                this.consec_zlws = total_written <= 0L ? ++this.consec_zlws : 0;
                                return total_written > 0L;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                                write_selector.cancel(UPnPMediaChannel.this.channel);
                                Object object = UPnPMediaChannel.this.write_lock;
                                synchronized (object) {
                                    UPnPMediaChannel.this.write_error = msg instanceof IOException ? (IOException)msg : new IOException(msg.getMessage());
                                    UPnPMediaChannel.this.write_lock.notifyAll();
                                }
                            }
                        }, null);
                        if (permitted == 0) {
                            add_to_pending = true;
                        }
                    } else if (this.write_buffers.size() == 3) {
                        try {
                            this.write_lock.wait();
                            if (this.write_error != null) {
                                throw this.write_error;
                            }
                        }
                        catch (InterruptedException e) {
                            throw new IOException("interrupted");
                        }
                    }
                }
                if (!add_to_pending) break block28;
                write_selector.pauseSelects(this.channel);
                list = pending_write_resumes;
                synchronized (list) {
                    pending_write_resumes.add(new pendingWriteSelect(this.channel));
                }
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void flush() throws IOException {
        block10: {
            try {
                while (true) lbl-1000:
                // 2 sources

                {
                    var1_1 = this.write_lock;
                    synchronized (var1_1) {
                        if (this.write_error != null) {
                            throw this.write_error;
                        }
                        if (this.write_buffers.size() == 0) {
                            break block10;
                        }
                    }
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (Throwable e) {
                        throw new IOException("interrupted");
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
            {
                ** while (true)
            }
        }
    }

    protected long getChannelUp() {
        return this.data_written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.read_lock;
        synchronized (object) {
            try {
                byte[] buffer = new byte[1];
                int len = this.channel.read(ByteBuffer.wrap(buffer));
                if (len == 1) {
                    this.pending_read_bytes.add(new Byte(buffer[0]));
                } else if (len < 0) {
                    throw new IOException("End of stream");
                }
                return false;
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (IOException e) {
                    this.write_error = e;
                    this.close();
                    return true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.channel.close();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        Object object = this.write_lock;
        synchronized (object) {
            if (this.write_error == null) {
                this.write_error = new IOException("channel closed");
            }
            this.write_lock.notifyAll();
            read_selector.cancel(this.channel);
            write_selector.cancel(this.channel);
            Iterator<writeBuffer> it = this.write_buffers.iterator();
            while (it.hasNext()) {
                writeBuffer buffer = it.next();
                Object o = buffer.buffer;
                if (o instanceof PooledByteBuffer) {
                    ((PooledByteBuffer)o).returnToPool();
                }
                it.remove();
            }
        }
    }

    protected static interface channelListener {
        public void wrote(long var1, int var3);

        public int getAvailableBytes();
    }

    protected static class pendingWriteSelect {
        private SocketChannel channel;
        private long when;

        protected pendingWriteSelect(SocketChannel _channel) {
            this.channel = _channel;
            this.when = SystemTime.getMonotonousTime() + 25L;
        }
    }

    protected static class writeBuffer {
        private long offset;
        private Object buffer;

        protected writeBuffer(long _offset, PooledByteBuffer _buffer) {
            this.offset = _offset;
            this.buffer = _buffer;
        }

        protected writeBuffer(long _offset, ByteBuffer _buffer) {
            this.offset = _offset;
            this.buffer = _buffer;
        }
    }
}

