/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnp;

import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.StringParameter;

public class UPnPPluginService {
    private UPnPWANConnection connection;
    private StringParameter desc_prefix;
    private BooleanParameter alert_success;
    private BooleanParameter grab_ports;
    private BooleanParameter alert_other_port_param;
    private BooleanParameter release_mappings;
    protected List<serviceMapping> service_mappings = new ArrayList<serviceMapping>();
    protected AEMonitor this_mon = new AEMonitor("UPnPPluginService");

    protected UPnPPluginService(UPnPWANConnection _connection, UPnPWANConnectionPortMapping[] _ports, StringParameter _desc_prefix, BooleanParameter _alert_success, BooleanParameter _grab_ports, BooleanParameter _alert_other_port_param, BooleanParameter _release_mappings) {
        this.connection = _connection;
        this.desc_prefix = _desc_prefix;
        this.alert_success = _alert_success;
        this.grab_ports = _grab_ports;
        this.alert_other_port_param = _alert_other_port_param;
        this.release_mappings = _release_mappings;
        int i = 0;
        while (i < _ports.length) {
            this.service_mappings.add(new serviceMapping(_ports[i]));
            ++i;
        }
    }

    public String getName() {
        return this.connection.getGenericService().getDevice().getRootDevice().getDevice().getFriendlyName();
    }

    public String getInfo() {
        return this.connection.getGenericService().getDevice().getRootDevice().getInfo();
    }

    public String getAddress() {
        return this.connection.getGenericService().getDevice().getRootDevice().getLocation().getHost();
    }

    public int getPort() {
        URL url = this.connection.getGenericService().getDevice().getRootDevice().getLocation();
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        return port;
    }

    public String getExternalAddress() {
        try {
            return this.connection.getExternalIPAddress();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public UPnPWANConnection getService() {
        return this.connection;
    }

    protected String getOldDescriptionForPort(int port) {
        return String.valueOf(this.desc_prefix.getValue()) + " " + port;
    }

    protected String getDescriptionForPort(boolean TCP, int port) {
        return String.valueOf(this.desc_prefix.getValue()) + " " + port + " " + (TCP ? "TCP" : "UDP");
    }

    /*
     * Unable to fully structure code
     */
    protected void checkMapping(LoggerChannel log, UPnPMapping mapping) {
        block16: {
            try {
                block17: {
                    block15: {
                        this.this_mon.enter();
                        if (!mapping.isEnabled()) break block17;
                        i = 0;
                        while (i < this.service_mappings.size()) {
                            sm = this.service_mappings.get(i);
                            if (sm.getMappings().contains(mapping) && sm.getPort() != mapping.getPort()) {
                                this.removeMapping(log, mapping, sm, false);
                            }
                            ++i;
                        }
                        grab_in_progress = null;
                        local_address = this.connection.getGenericService().getDevice().getRootDevice().getLocalAddress().getHostAddress();
                        i = 0;
                        while (i < this.service_mappings.size()) {
                            block18: {
                                block19: {
                                    block20: {
                                        sm = this.service_mappings.get(i);
                                        if (sm.isTCP() != mapping.isTCP() || sm.getPort() != mapping.getPort()) break block18;
                                        if (sm.getInternalHost().equals(local_address)) {
                                            sm.addMapping(mapping);
                                            if (!sm.getLogged(mapping)) {
                                                sm.setLogged(mapping);
                                                log.log("Mapping " + mapping.getString() + " already established");
                                            }
lbl22:
                                            // 6 sources

                                            return;
                                        }
                                        if (this.grab_ports.getValue()) break block19;
                                        if (sm.getLogged(mapping)) ** GOTO lbl22
                                        sm.setLogged(mapping);
                                        text = MessageText.getString("upnp.alert.differenthost", new String[]{mapping.getString(), sm.getInternalHost()});
                                        if (!this.alert_other_port_param.getValue()) break block20;
                                        log.logAlertRepeatable(2, text);
                                        ** GOTO lbl22
                                    }
                                    log.log(text);
                                    ** continue;
                                }
                                sm.addMapping(mapping);
                                grab_in_progress = sm;
                            }
                            ++i;
                        }
                        error_text = null;
                        try {
                            this.connection.addPortMapping(mapping.isTCP(), mapping.getPort(), this.getDescriptionForPort(mapping.isTCP(), mapping.getPort()));
                            text = grab_in_progress != null ? MessageText.getString("upnp.alert.mappinggrabbed", new String[]{mapping.getString(), grab_in_progress.getInternalHost()}) : MessageText.getString("upnp.alert.mappingok", new String[]{mapping.getString()});
                            log.log(text);
                            if (this.alert_success.getValue()) {
                                log.logAlertRepeatable(1, text);
                            }
                        }
                        catch (Throwable e) {
                            error_text = Debug.getNestedExceptionMessage(e);
                            text = MessageText.getString("upnp.alert.mappingfailed", new String[]{mapping.getString()});
                            log.log(text);
                            if (!this.alert_other_port_param.getValue()) break block15;
                            log.logAlertRepeatable(3, text);
                        }
                    }
                    if (grab_in_progress == null) {
                        new_mapping = new serviceMapping(mapping);
                        serviceMapping.access$0(new_mapping, error_text);
                        this.service_mappings.add(new_mapping);
                    } else {
                        serviceMapping.access$0(grab_in_progress, error_text);
                    }
                    break block16;
                }
                this.removeMapping(log, mapping, false);
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected void removeMapping(LoggerChannel log, UPnPMapping mapping, boolean end_of_day) {
        try {
            this.this_mon.enter();
            int i = 0;
            while (i < this.service_mappings.size()) {
                serviceMapping sm = this.service_mappings.get(i);
                if (sm.isTCP() == mapping.isTCP() && sm.getPort() == mapping.getPort() && sm.getMappings().contains(mapping)) {
                    this.removeMapping(log, mapping, sm, end_of_day);
                    return;
                }
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void removeMapping(LoggerChannel log, UPnPMapping upnp_mapping, serviceMapping service_mapping, boolean end_of_day) {
        if (service_mapping.isExternal()) {
            log.log("Mapping " + service_mapping.getString() + " not removed as not created by Azureus");
        } else {
            int persistent = 1;
            List mappings = service_mapping.getMappings();
            int i = 0;
            while (i < mappings.size()) {
                UPnPMapping map = (UPnPMapping)mappings.get(i);
                int p = map.getPersistent();
                if (p != 1) {
                    if (p == 3) {
                        if (persistent == 1) {
                            persistent = p;
                        }
                    } else {
                        persistent = 2;
                    }
                }
                ++i;
            }
            if (persistent == 1) {
                int n = persistent = this.release_mappings.getValue() ? 3 : 2;
            }
            if (end_of_day && persistent == 2) {
                log.log("Mapping " + service_mapping.getString() + " not removed as mapping is persistent");
            } else {
                String service_name = service_mapping.getString();
                service_mapping.removeMapping(upnp_mapping);
                if (service_mapping.getMappings().size() == 0) {
                    try {
                        this.connection.deletePortMapping(service_mapping.isTCP(), service_mapping.getPort());
                        log.log("Mapping " + service_name + " removed");
                    }
                    catch (Throwable e) {
                        log.log("Mapping " + service_name + " failed to delete", e);
                    }
                    this.service_mappings.remove(service_mapping);
                } else {
                    log.log("Mapping " + service_mapping.getString() + " not removed as interest remains");
                }
            }
        }
    }

    public serviceMapping[] getMappings() {
        try {
            this.this_mon.enter();
            serviceMapping[] serviceMappingArray = this.service_mappings.toArray(new serviceMapping[this.service_mappings.size()]);
            return serviceMappingArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public String getString() {
        serviceMapping[] sms;
        String str = "name=" + this.getName() + ",info=" + this.getInfo() + ",int=" + this.getAddress() + ":" + this.getPort() + ",ext=" + this.getExternalAddress();
        serviceMapping[] serviceMappingArray = sms = this.getMappings();
        int n = sms.length;
        int n2 = 0;
        while (n2 < n) {
            serviceMapping sm = serviceMappingArray[n2];
            String error = sm.getError();
            if (error != null) {
                str = String.valueOf(str) + ":" + sm.getString() + " -> " + error;
            }
            ++n2;
        }
        return str;
    }

    public class serviceMapping {
        private List mappings = new ArrayList();
        private boolean tcp;
        private int port;
        private String internal_host;
        private boolean external;
        private List logged_mappings = new ArrayList();
        private String error;

        protected serviceMapping(UPnPWANConnectionPortMapping device_mapping) {
            this.tcp = device_mapping.isTCP();
            this.port = device_mapping.getExternalPort();
            this.internal_host = device_mapping.getInternalHost();
            String desc = device_mapping.getDescription();
            if (desc == null || !desc.equalsIgnoreCase(UPnPPluginService.this.getOldDescriptionForPort(this.port)) && !desc.equalsIgnoreCase(UPnPPluginService.this.getDescriptionForPort(this.tcp, this.port))) {
                this.external = true;
            }
        }

        protected serviceMapping(UPnPMapping _mapping) {
            this.mappings.add(_mapping);
            this.tcp = _mapping.isTCP();
            this.port = _mapping.getPort();
            this.internal_host = UPnPPluginService.this.connection.getGenericService().getDevice().getRootDevice().getLocalAddress().getHostAddress();
        }

        public boolean isExternal() {
            return this.external;
        }

        protected List getMappings() {
            return this.mappings;
        }

        protected void addMapping(UPnPMapping _mapping) {
            if (!this.mappings.contains(_mapping)) {
                this.mappings.add(_mapping);
            }
        }

        protected void removeMapping(UPnPMapping _mapping) {
            this.mappings.remove(_mapping);
        }

        protected boolean getLogged(UPnPMapping mapping) {
            return this.logged_mappings.contains(mapping);
        }

        protected void setLogged(UPnPMapping mapping) {
            if (!this.logged_mappings.contains(mapping)) {
                this.logged_mappings.add(mapping);
            }
        }

        public boolean isTCP() {
            return this.tcp;
        }

        public int getPort() {
            return this.port;
        }

        public String getInternalHost() {
            return this.internal_host;
        }

        private String getError() {
            return this.error;
        }

        private void setError(String _error) {
            this.error = _error;
        }

        public String getString() {
            if (this.mappings.size() == 0) {
                return "<external> (" + (this.isTCP() ? "TCP" : "UDP") + "/" + this.getPort() + ")";
            }
            String str = "";
            int i = 0;
            while (i < this.mappings.size()) {
                str = String.valueOf(str) + (i == 0 ? "" : ",") + ((UPnPMapping)this.mappings.get(i)).getString(this.getPort());
                ++i;
            }
            return str;
        }

        static /* synthetic */ void access$0(serviceMapping serviceMapping2, String string) {
            serviceMapping2.setError(string);
        }
    }
}

