/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.remsearch;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearchManager;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.subs.SubscriptionResult;
import com.aelitis.azureus.plugins.remsearch.RemSearchPluginEngine;
import com.aelitis.azureus.plugins.remsearch.RemSearchPluginEngineReal;
import com.aelitis.azureus.plugins.remsearch.RemSearchPluginPageGeneratorAdaptor;
import com.aelitis.azureus.plugins.remsearch.RemSearchPluginSearch;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageGenerator;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.json.simple.JSONObject;

public class RemSearchPluginPageGenerator
implements TrackerWebPageGenerator {
    private final boolean MATURE_DEFAULT = false;
    private final String SEARCH_PREFIX;
    private final String RESULTS_PREFIX;
    private final String url_prefix;
    private final String host_name;
    private final int max_searches;
    private final int max_results_per_engine;
    private RemSearchPluginPageGeneratorAdaptor adapter;
    private Map<String, RemSearchPluginSearch> searches = new HashMap<String, RemSearchPluginSearch>();
    private Map<Engine, RemSearchPluginEngine> engine_map = new HashMap<Engine, RemSearchPluginEngine>();
    private Map<String, RemSearchPluginEngine> engine_eid_map = new HashMap<String, RemSearchPluginEngine>();
    private long total_searches;
    private long total_fails;
    private long total_engine_fails;
    private boolean supports_async;
    private Random random = new Random();

    public RemSearchPluginPageGenerator(RemSearchPluginPageGeneratorAdaptor _adapter, String _url_prefix, String _host_name, int _max_searches, int _max_results_per_engine, boolean _supports_async) {
        this.adapter = _adapter;
        this.url_prefix = _url_prefix;
        this.host_name = _host_name;
        this.max_searches = _max_searches;
        this.max_results_per_engine = _max_results_per_engine;
        this.supports_async = _supports_async;
        this.SEARCH_PREFIX = String.valueOf(_url_prefix) + "/search?";
        this.RESULTS_PREFIX = String.valueOf(_url_prefix) + "/get-results?";
    }

    protected MetaSearchManager getMetaSearchManager() {
        return MetaSearchManagerFactory.getSingleton();
    }

    protected boolean supportsAsync() {
        return this.supports_async;
    }

    @Override
    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        String url = request2.getURL();
        this.log("HTTP request from " + request2.getClientAddress());
        boolean json_output = false;
        if (url.startsWith(this.SEARCH_PREFIX)) {
            String[] args = url.substring(this.SEARCH_PREFIX.length()).trim().split("&");
            String term = null;
            boolean mature = false;
            int i = 0;
            while (i < args.length) {
                String[] bits = args[i].split("=", 2);
                if (bits.length == 2) {
                    String lhs = bits[0].toLowerCase();
                    String rhs = URLDecoder.decode(bits[1], "UTF-8");
                    if (lhs.equals("q")) {
                        term = rhs;
                    } else if (lhs.equals("mature")) {
                        mature = rhs.equalsIgnoreCase("true");
                    } else if (lhs.equals("format") && rhs.equalsIgnoreCase("json")) {
                        json_output = true;
                    }
                }
                ++i;
            }
            if (term == null) {
                term = "";
            }
            String mature_str = mature ? "true" : "false";
            String search_headers = null;
            String client_ip = this.getOriginator(request2);
            this.handleSearch(client_ip, term, mature_str, search_headers, request2, response, json_output);
            return true;
        }
        if (url.startsWith(this.RESULTS_PREFIX)) {
            String[] args = url.substring(this.RESULTS_PREFIX.length()).trim().split("&");
            String sid = null;
            String eid = null;
            int i = 0;
            while (i < args.length) {
                String[] bits = args[i].split("=");
                if (bits.length == 2) {
                    String lhs = bits[0].toLowerCase();
                    String rhs = URLDecoder.decode(bits[1], "UTF-8");
                    if (lhs.equals("sid")) {
                        sid = rhs;
                    } else if (lhs.equals("eid")) {
                        eid = rhs;
                    } else if (lhs.equals("format") && rhs.equalsIgnoreCase("json")) {
                        json_output = true;
                    }
                }
                ++i;
            }
            if (sid == null || eid == null) {
                throw new IOException("sid or eid missing");
            }
            this.handleGetResult(sid, eid, response, json_output);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSearch(String originator, String expr, String mature, String search_headers, TrackerWebPageRequest request2, TrackerWebPageResponse response, boolean json_output) {
        block26: {
            ++this.total_searches;
            boolean result_sent = false;
            if (json_output) {
                response.setContentType("application/json");
            } else {
                response.setContentType("application/javascript");
            }
            OutputStream os = response.getOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
            RemSearchPluginSearch search = null;
            try {
                Object engine;
                this.adapter.searchReceived(originator);
                ArrayList<SearchParameter> sps = new ArrayList<SearchParameter>();
                sps.add(new SearchParameter("s", expr));
                if (mature != null) {
                    sps.add(new SearchParameter("m", mature.toString()));
                }
                SearchParameter[] parameters = sps.toArray(new SearchParameter[sps.size()]);
                search = new RemSearchPluginSearch(this, request2.getHeader(), originator, expr, json_output);
                this.adapter.searchCreated(search);
                Map<String, RemSearchPluginSearch> map = this.searches;
                synchronized (map) {
                    this.searches.put(search.getSID(), search);
                    if (this.searches.size() > this.max_searches) {
                        throw new IOException("Too many active searches");
                    }
                }
                String path = this.url_prefix;
                if (path.length() == 0) {
                    path = "/";
                }
                if (this.host_name != null && this.host_name.length() > 0) {
                    response.setHeader("Set-Cookie", "JSESSIONID=" + search.getSID() + "." + this.host_name + "; path=" + path);
                }
                this.log("Created: " + search.getSID() + ":  origin=" + originator);
                HashMap<String, String> context2 = new HashMap<String, String>();
                context2.put("azsrc", "usearch");
                context2.put("remove_dup_hash", "true");
                RemSearchPluginEngine[] plugin_engines = new RemSearchPluginEngine[]{};
                boolean is_subs = expr.startsWith("Subscription:");
                if (is_subs) {
                    int pos1 = expr.lastIndexOf(40);
                    int pos2 = expr.indexOf(41, pos1 + 1);
                    Subscription subscription = null;
                    engine = null;
                    if (pos1 != -1 && pos2 != -1) {
                        RemSearchPluginEngine plugin_engine;
                        String sub_id = expr.substring(pos1 + 1, pos2);
                        subscription = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(sub_id);
                        if (subscription != null && (plugin_engine = this.getEngine(subscription)) != null) {
                            engine = plugin_engine.getEngine();
                            plugin_engines = new RemSearchPluginEngine[]{this.getEngine(subscription)};
                        }
                    }
                    search.setEngines(plugin_engines);
                    if (engine != null) {
                        SubscriptionHistory history = subscription.getHistory();
                        SubscriptionResult[] subs_results = history.getResults(false);
                        if (subs_results.length > this.max_results_per_engine) {
                            SubscriptionResult[] trimmed = new SubscriptionResult[this.max_results_per_engine];
                            System.arraycopy(subs_results, 0, trimmed, 0, this.max_results_per_engine);
                            subs_results = trimmed;
                        }
                        search.resultsReceived((Engine)engine, subs_results);
                        search.resultsComplete((Engine)engine);
                    }
                } else {
                    Engine[] engines = this.getEnginesToUse();
                    if (engines.length == 0) {
                        throw new IOException("No templates available for searching");
                    }
                    engines = this.getMetaSearchManager().getMetaSearch().search(engines, search, parameters, search_headers, context2, this.max_results_per_engine);
                    if (engines.length == 0) {
                        throw new IOException("No templates available for searching");
                    }
                    plugin_engines = new RemSearchPluginEngine[engines.length];
                    int i = 0;
                    while (i < engines.length) {
                        plugin_engines[i] = this.getEngine(engines[i]);
                        ++i;
                    }
                    search.setEngines(plugin_engines);
                }
                JSONObject result = new JSONObject();
                result.put("sid", search.getSID());
                ArrayList<JSONObject> engine_list = new ArrayList<JSONObject>();
                int i = 0;
                while (i < plugin_engines.length) {
                    engine = plugin_engines[i];
                    JSONObject engine_map = new JSONObject();
                    RemSearchPluginPageGenerator.getEngineDetails((RemSearchPluginEngine)engine, engine_map);
                    engine_list.add(engine_map);
                    ++i;
                }
                result.put("engines", engine_list);
                result_sent = true;
                if (json_output) {
                    pw.println(result.toString());
                } else {
                    pw.println("webSearch.setup(" + result.toString() + ")");
                }
                pw.flush();
            }
            catch (Throwable e) {
                this.log("Search failed", e);
                ++this.total_fails;
                if (result_sent) break block26;
                JSONObject error_map = new JSONObject();
                if (search != null) {
                    error_map.put("sid", search.getSID());
                }
                error_map.put("error", Debug.getNestedExceptionMessage(e));
                if (json_output) {
                    pw.println(error_map.toString());
                } else {
                    pw.println("webSearch.failed(" + error_map.toString() + ")");
                }
                pw.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Engine[] getEnginesToUse() {
        Engine[] engines = this.getMetaSearchManager().getMetaSearch().getEngines(true, true);
        ArrayList<Engine> engines_to_use = new ArrayList<Engine>();
        Map<String, RemSearchPluginSearch> map = this.searches;
        synchronized (map) {
            Engine[] engineArray = engines;
            int n = engines.length;
            int n2 = 0;
            while (n2 < n) {
                Engine engine = engineArray[n2];
                LinkedList<Boolean> history = this.getEngine(engine).getHistory();
                if (history.size() < 10) {
                    engines_to_use.add(engine);
                } else {
                    int bad = 0;
                    int good = 0;
                    int first_bad = -1;
                    int first_good = -1;
                    int pos = 0;
                    boolean add = false;
                    Iterator iterator = history.iterator();
                    while (iterator.hasNext()) {
                        boolean success = (Boolean)iterator.next();
                        ++pos;
                        if (success) {
                            ++good;
                            if (first_good != -1) continue;
                            first_good = pos;
                            continue;
                        }
                        ++bad;
                        if (first_bad != -1) continue;
                        first_bad = pos;
                    }
                    if (first_good <= 10) {
                        add = true;
                    } else {
                        int rand = first_good == -1 ? history.size() : bad;
                        boolean bl = add = this.random.nextInt(rand) == 0;
                    }
                    if (add) {
                        engines_to_use.add(engine);
                    }
                }
                ++n2;
            }
        }
        return engines_to_use.toArray(new Engine[engines_to_use.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleGetResult(String sid, String eid, TrackerWebPageResponse response, boolean json_output) {
        RemSearchPluginSearch search;
        if (json_output) {
            response.setContentType("application/json");
        } else {
            response.setContentType("application/javascript");
        }
        Map<String, RemSearchPluginSearch> map = this.searches;
        synchronized (map) {
            search = this.searches.get(sid);
        }
        try {
            if (search == null) {
                throw new IOException("Search '" + sid + " not found");
            }
            search.handleResultReceiver(eid, response);
        }
        catch (Throwable failure) {
            RemSearchPluginEngine engine;
            this.log("Search " + sid + "/" + eid + ": " + Debug.getNestedExceptionMessage(failure));
            Map<String, RemSearchPluginSearch> map2 = this.searches;
            synchronized (map2) {
                engine = this.engine_eid_map.get(eid);
            }
            JSONObject error_map = new JSONObject();
            error_map.put("error", Debug.getNestedExceptionMessage(failure));
            error_map.put("sid", sid);
            if (engine != null) {
                RemSearchPluginPageGenerator.getEngineDetails(engine, error_map);
            } else {
                error_map.put("id", eid);
            }
            try {
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(response.getOutputStream(), "UTF-8"));
                if (json_output) {
                    pw.println(((Object)error_map).toString());
                } else {
                    pw.println("webSearch.engineFailed(" + ((Object)error_map).toString() + ")");
                }
                pw.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void complete(RemSearchPluginSearch search, List<RemSearchPluginSearch.engineResult> ok, List<RemSearchPluginSearch.engineResult> failed) {
        Map<String, RemSearchPluginSearch> map = this.searches;
        synchronized (map) {
            if (this.searches.remove(search.getSID()) == null) {
                return;
            }
            this.log("Complete: " + search.getSID() + ", elapsed=" + search.getAge());
            if (ok.size() == 0) {
                ++this.total_fails;
            }
            this.total_engine_fails += (long)failed.size();
            for (RemSearchPluginSearch.engineResult result : ok) {
                this.addEngineResult(result, true);
            }
            for (RemSearchPluginSearch.engineResult result : failed) {
                this.addEngineResult(result, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemSearchPluginEngine[] getEngines() {
        Engine[] engines = this.getMetaSearchManager().getMetaSearch().getEngines(true, true);
        ArrayList<RemSearchPluginEngine> result = new ArrayList<RemSearchPluginEngine>();
        Map<String, RemSearchPluginSearch> map = this.searches;
        synchronized (map) {
            Engine[] engineArray = engines;
            int n = engines.length;
            int n2 = 0;
            while (n2 < n) {
                Engine engine = engineArray[n2];
                RemSearchPluginEngine e = this.engine_map.get(engine);
                if (e == null) {
                    e = new RemSearchPluginEngineReal(engine);
                    this.engine_map.put(engine, e);
                    this.engine_eid_map.put(engine.getUID(), e);
                }
                result.add(e);
                ++n2;
            }
        }
        return result.toArray(new RemSearchPluginEngine[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemSearchPluginEngine getEngine(Engine engine) {
        Map<String, RemSearchPluginSearch> map = this.searches;
        synchronized (map) {
            RemSearchPluginEngine e = this.engine_map.get(engine);
            if (e == null) {
                e = new RemSearchPluginEngineReal(engine);
                this.engine_map.put(engine, e);
                this.engine_eid_map.put(engine.getUID(), e);
            }
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemSearchPluginEngine getEngine(Subscription subscription) {
        Map<String, RemSearchPluginSearch> map = this.searches;
        synchronized (map) {
            try {
                Engine engine = subscription.getEngine();
                RemSearchPluginEngine e = this.engine_map.get(engine);
                if (e == null) {
                    e = new RemSearchPluginEngineReal(engine);
                    this.engine_map.put(engine, e);
                    this.engine_eid_map.put(engine.getUID(), e);
                }
                return e;
            }
            catch (Throwable e) {
                Debug.out(e);
                return null;
            }
        }
    }

    protected void addEngineResult(RemSearchPluginSearch.engineResult result, boolean ok) {
        result.getEngine().addHistory(ok, result.getSearchElapsedTime());
    }

    protected static void getEngineDetails(RemSearchPluginEngine engine, Map<String, Object> map) {
        map.put("name", engine.getName());
        map.put("id", engine.getUID());
        map.put("favicon", engine.getIcon());
        map.put("dl_link_css", engine.getDownloadLinkCSS());
        map.put("selected", Engine.SEL_STATE_STRINGS[engine.getSelectionState()]);
        map.put("type", Engine.ENGINE_SOURCE_STRS[engine.getSource()]);
    }

    protected String getOriginator(TrackerWebPageRequest request2) {
        String lowercase_input_header;
        String input_header = request2.getHeader();
        String client_ip = this.getRequestHeader(input_header, lowercase_input_header = input_header.toLowerCase(), "real-ip");
        if (client_ip == null) {
            client_ip = this.getRequestHeader(input_header, lowercase_input_header, "client-ip");
        }
        if (client_ip == null) {
            client_ip = this.getRequestHeader(input_header, lowercase_input_header, "forwarded-for");
        }
        if (client_ip == null) {
            return request2.getClientAddress();
        }
        int pos = client_ip.indexOf(44);
        if (pos != -1) {
            client_ip = client_ip.substring(0, pos);
        }
        try {
            InetAddress originator_host = InetAddress.getByName(client_ip.trim());
            if (originator_host.isLinkLocalAddress() || originator_host.isSiteLocalAddress() || originator_host.isLoopbackAddress()) {
                this.log("Bad client IP '" + client_ip + "'");
                return request2.getClientAddress();
            }
            return originator_host.getHostAddress();
        }
        catch (Throwable e) {
            this.log("Bad client IP '" + client_ip + "'");
            return request2.getClientAddress();
        }
    }

    protected String getRequestHeader(String str, String lc_str, String name) {
        int pos1 = lc_str.indexOf(name);
        if (pos1 == -1) {
            return null;
        }
        int pos2 = lc_str.indexOf("\r\n", pos1);
        String entry = pos2 == -1 ? str.substring(pos1) : str.substring(pos1, pos2);
        int pos = entry.indexOf(58);
        if (pos == -1) {
            return null;
        }
        return entry.substring(pos + 1).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, RemSearchPluginSearch> getSearches() {
        Map<String, RemSearchPluginSearch> map = this.searches;
        synchronized (map) {
            return new HashMap<String, RemSearchPluginSearch>(this.searches);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Engine, RemSearchPluginEngine> getEngineMap() {
        Map<String, RemSearchPluginSearch> map = this.searches;
        synchronized (map) {
            return new HashMap<Engine, RemSearchPluginEngine>(this.engine_map);
        }
    }

    protected long getTotalSearches() {
        return this.total_searches;
    }

    protected long getTotalSearchesFailed() {
        return this.total_fails;
    }

    protected long getTotalEnginesFailed() {
        return this.total_engine_fails;
    }

    protected void log(String str) {
        this.adapter.log(str);
    }

    protected void log(String str, Throwable e) {
        this.adapter.log(str, e);
    }
}

