/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.remsearch;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.util.average.Average;
import com.aelitis.azureus.core.util.average.AverageFactory;
import java.util.LinkedList;

public abstract class RemSearchPluginEngine {
    protected static final int ENGINE_HISTORY_SIZE = 100;
    private long success_count;
    private long fail_count;
    private LinkedList<Boolean> history = new LinkedList();
    private Average response_time_average = AverageFactory.MovingImmediateAverage(100);
    private long latest_rta;

    public abstract String getName();

    public abstract String getUID();

    public abstract String getIcon();

    public abstract String getDownloadLinkCSS();

    public abstract int getSelectionState();

    public abstract int getSource();

    public abstract Engine getEngine();

    public long getSuccessCount() {
        return this.success_count;
    }

    public long getFailureCount() {
        return this.fail_count;
    }

    public long getResponseTimeAverage() {
        return this.latest_rta;
    }

    protected LinkedList<Boolean> getHistory() {
        return this.history;
    }

    protected void addHistory(boolean ok, long elapsed) {
        this.history.addFirst(ok);
        if (this.history.size() > 100) {
            this.history.removeLast();
        }
        if (ok) {
            ++this.success_count;
            if (elapsed > 0L) {
                this.latest_rta = (long)this.response_time_average.update(elapsed);
            }
        } else {
            ++this.fail_count;
        }
    }
}

