/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.util;

import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloader;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;

public class ExternalSeedHTTPDownloaderLinear
implements ExternalSeedHTTPDownloader {
    private final URL very_original_url;
    private final String user_agent;
    private int last_response;
    private int last_response_retry_after_secs;
    private Downloader downloader;

    public ExternalSeedHTTPDownloaderLinear(URL _url, String _user_agent) {
        this.very_original_url = _url;
        this.user_agent = _user_agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadRange(long offset, int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        Request request2;
        ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear = this;
        synchronized (externalSeedHTTPDownloaderLinear) {
            if (this.downloader == null) {
                this.downloader = new Downloader(listener, con_fail_is_perm_fail);
            }
            request2 = this.downloader.addRequest(offset, length, listener);
        }
        do {
            if (!request2.waitFor(1000)) continue;
            return;
        } while (!listener.isCancelled());
        throw new ExternalSeedException("request cancelled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate() {
        Downloader to_destroy = null;
        ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear = this;
        synchronized (externalSeedHTTPDownloaderLinear) {
            if (this.downloader != null) {
                to_destroy = this.downloader;
                this.downloader = null;
            }
        }
        if (to_destroy != null) {
            to_destroy.destroy(new ExternalSeedException("deactivated"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destoyed(Downloader dead) {
        ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear = this;
        synchronized (externalSeedHTTPDownloaderLinear) {
            if (this.downloader == dead) {
                this.downloader = null;
            }
        }
    }

    @Override
    public void download(int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        throw new ExternalSeedException("not supported");
    }

    @Override
    public void downloadSocket(int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        throw new ExternalSeedException("not supported");
    }

    @Override
    public int getLastResponse() {
        return this.last_response;
    }

    @Override
    public int getLast503RetrySecs() {
        return this.last_response_retry_after_secs;
    }

    static /* synthetic */ URL access$0(ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear) {
        return externalSeedHTTPDownloaderLinear.very_original_url;
    }

    static /* synthetic */ String access$1(ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear) {
        return externalSeedHTTPDownloaderLinear.user_agent;
    }

    static /* synthetic */ void access$2(ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear, int n) {
        externalSeedHTTPDownloaderLinear.last_response = n;
    }

    static /* synthetic */ void access$3(ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear, int n) {
        externalSeedHTTPDownloaderLinear.last_response_retry_after_secs = n;
    }

    static /* synthetic */ int access$4(ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear) {
        return externalSeedHTTPDownloaderLinear.last_response_retry_after_secs;
    }

    protected class Downloader
    implements SEPasswordListener {
        private ExternalSeedHTTPDownloaderListener listener;
        private boolean con_fail_is_perm_fail;
        private volatile boolean destroyed;
        private List<Request> requests = new ArrayList<Request>();
        private RandomAccessFile raf = null;
        private File scratch_file = null;

        protected Downloader(ExternalSeedHTTPDownloaderListener _listener, boolean _con_fail_is_perm_fail) {
            this.listener = _listener;
            this.con_fail_is_perm_fail = _con_fail_is_perm_fail;
            new AEThread2("ES:downloader", true){

                @Override
                public void run() {
                    Downloader.this.download();
                }
            }.start();
        }

        /*
         * Exception decompiling
         */
        protected void download() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[MONITOR]], but top level block is 5[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Request addRequest(long offset, int length, ExternalSeedHTTPDownloaderListener listener) throws ExternalSeedException {
            Request request2;
            Downloader downloader = this;
            synchronized (downloader) {
                if (this.destroyed) {
                    throw new ExternalSeedException("downloader destroyed");
                }
                request2 = new Request(offset, length, listener);
                this.requests.add(request2);
            }
            this.checkRequests();
            return request2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int checkRequests() {
            try {
                Downloader downloader = this;
                synchronized (downloader) {
                    if (this.raf == null) {
                        return this.requests.size();
                    }
                    long pos = this.raf.getFilePointer();
                    Iterator<Request> it = this.requests.iterator();
                    while (it.hasNext()) {
                        Request request2 = it.next();
                        long end = request2.getOffset() + (long)request2.getLength();
                        if (pos < end) continue;
                        ExternalSeedHTTPDownloaderListener listener = request2.getListener();
                        try {
                            this.raf.seek(request2.getOffset());
                            int total = 0;
                            while (total < request2.getLength()) {
                                int buffer_len;
                                int space;
                                int buffer_position;
                                byte[] buffer = listener.getBuffer();
                                if (this.raf.read(buffer, buffer_position = listener.getBufferPosition(), space = (buffer_len = listener.getBufferLength()) - buffer_position) != space) {
                                    throw new IOException("Error reading scratch file");
                                }
                                total += space;
                                listener.reportBytesRead(space);
                                listener.done();
                            }
                        }
                        finally {
                            this.raf.seek(pos);
                        }
                        request2.complete();
                        it.remove();
                    }
                    return this.requests.size();
                }
            }
            catch (Throwable e) {
                Debug.out(e);
                this.destroy(new ExternalSeedException("read failed", e));
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy(ExternalSeedException error) {
            Downloader downloader = this;
            synchronized (downloader) {
                if (this.destroyed) {
                    return;
                }
                this.destroyed = true;
                if (this.raf != null) {
                    try {
                        this.raf.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.scratch_file != null) {
                    this.scratch_file.delete();
                }
                for (Request r : this.requests) {
                    r.destroy(error);
                }
                this.requests.clear();
            }
            ExternalSeedHTTPDownloaderLinear.this.destoyed(this);
        }

        @Override
        public PasswordAuthentication getAuthentication(String realm, URL tracker) {
            return null;
        }

        @Override
        public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
        }

        @Override
        public void clearPasswords() {
        }
    }

    private static class Request {
        private long offset;
        private int length;
        private ExternalSeedHTTPDownloaderListener listener;
        private AESemaphore sem = new AESemaphore("ES:wait");
        private volatile ExternalSeedException exception;

        protected Request(long _offset, int _length, ExternalSeedHTTPDownloaderListener _listener) {
            this.offset = _offset;
            this.length = _length;
            this.listener = _listener;
        }

        protected long getOffset() {
            return this.offset;
        }

        protected int getLength() {
            return this.length;
        }

        protected ExternalSeedHTTPDownloaderListener getListener() {
            return this.listener;
        }

        protected void complete() {
            this.sem.release();
        }

        protected void destroy(ExternalSeedException e) {
            this.exception = e;
            this.sem.release();
        }

        public boolean waitFor(int timeout) throws ExternalSeedException {
            if (!this.sem.reserve(timeout)) {
                return false;
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return true;
        }
    }
}

