/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed;

import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.core.tracker.TrackerPeerSourceAdapter;
import com.aelitis.azureus.plugins.extseed.ExternalSeedManualPeer;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPeer;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReaderFactory;
import com.aelitis.azureus.plugins.extseed.impl.getright.ExternalSeedReaderFactoryGetRight;
import com.aelitis.azureus.plugins.extseed.impl.webseed.ExternalSeedReaderFactoryWebSeed;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadManagerStats;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.components.UITextField;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;
import org.gudy.azureus2.plugins.utils.Utilities;

public class ExternalSeedPlugin
implements Plugin,
DownloadManagerListener {
    private static ExternalSeedReaderFactory[] factories = new ExternalSeedReaderFactory[]{new ExternalSeedReaderFactoryGetRight(), new ExternalSeedReaderFactoryWebSeed()};
    private PluginInterface plugin_interface;
    private DownloadManagerStats dm_stats;
    private UITextField status_field;
    private LoggerChannel log;
    private Random random = new Random();
    private Map download_map = new HashMap();
    private Monitor download_mon;

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", "External Seed");
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.dm_stats = this.plugin_interface.getDownloadManager().getStats();
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel("External Seeds");
        final BasicPluginViewModel view_model = this.plugin_interface.getUIManager().createBasicPluginViewModel("Plugin.extseed.name");
        view_model.getActivity().setVisible(false);
        view_model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            @Override
            public void messageLogged(int type, String content2) {
                view_model.getLogArea().appendText(String.valueOf(content2) + "\n");
            }

            @Override
            public void messageLogged(String str, Throwable error) {
                if (str.length() > 0) {
                    view_model.getLogArea().appendText(String.valueOf(str) + "\n");
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                error.printStackTrace(pw);
                pw.flush();
                view_model.getLogArea().appendText(String.valueOf(sw.toString()) + "\n");
            }
        });
        this.status_field = view_model.getStatus();
        this.setStatus("Initialising");
        this.download_mon = this.plugin_interface.getUtilities().getMonitor();
        Utilities utilities = this.plugin_interface.getUtilities();
        DelayedTask dt = this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

            @Override
            public void run() {
                AEThread2 t = new AEThread2("ExternalSeedInitialise", true){

                    @Override
                    public void run() {
                        ExternalSeedPlugin.this.setStatus("Running");
                        ExternalSeedPlugin.this.plugin_interface.getDownloadManager().addListener(ExternalSeedPlugin.this);
                    }
                };
                t.setPriority(1);
                t.start();
            }
        });
        dt.queue();
        UTTimer timer = utilities.createTimer("ExternalPeerScheduler", true);
        timer.addPeriodicEvent(5000L, new UTTimerEventPerformer(){

            @Override
            public void perform(UTTimerEvent event2) {
                try {
                    Iterator it = ExternalSeedPlugin.this.download_map.values().iterator();
                    block2: while (it.hasNext()) {
                        List peers = ExternalSeedPlugin.this.randomiseList((List)it.next());
                        int i = 0;
                        while (i < peers.size()) {
                            if (((ExternalSeedPeer)peers.get(i)).checkConnection()) continue block2;
                            ++i;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void downloadAdded(Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent == null) {
            return;
        }
        ArrayList<ExternalSeedPeer> peers = new ArrayList<ExternalSeedPeer>();
        int i = 0;
        while (i < factories.length) {
            String attributeID = "no-ext-seeds-" + factories[i].getClass().getSimpleName();
            TorrentAttribute attribute = this.plugin_interface.getTorrentManager().getPluginAttribute(attributeID);
            boolean noExternalSeeds = download.getBooleanAttribute(attribute);
            if (!noExternalSeeds) {
                ExternalSeedReader[] x = factories[i].getSeedReaders(this, download);
                if (x.length == 0) {
                    download.setBooleanAttribute(attribute, true);
                } else {
                    int j = 0;
                    while (j < x.length) {
                        ExternalSeedReader reader = x[j];
                        ExternalSeedPeer peer = new ExternalSeedPeer(this, download, reader);
                        peers.add(peer);
                        ++j;
                    }
                }
            }
            ++i;
        }
        this.addPeers(download, peers);
    }

    public void downloadChanged(Download download) {
        this.downloadRemoved(download);
        this.downloadAdded(download);
    }

    public List<ExternalSeedPeer> addSeed(Download download, Map config) {
        Torrent torrent = download.getTorrent();
        ArrayList<ExternalSeedPeer> peers = new ArrayList<ExternalSeedPeer>();
        if (torrent != null) {
            int i = 0;
            while (i < factories.length) {
                String attributeID = "no-ext-seeds-" + factories[i].getClass().getSimpleName();
                TorrentAttribute attribute = this.plugin_interface.getTorrentManager().getPluginAttribute(attributeID);
                ExternalSeedReader[] x = factories[i].getSeedReaders(this, download, config);
                download.setBooleanAttribute(attribute, x.length == 0);
                int j = 0;
                while (j < x.length) {
                    ExternalSeedReader reader = x[j];
                    ExternalSeedPeer peer = new ExternalSeedPeer(this, download, reader);
                    peers.add(peer);
                    ++j;
                }
                ++i;
            }
            this.addPeers(download, peers);
        }
        return peers;
    }

    protected void addPeers(final Download download, List _peers) {
        ArrayList peers = new ArrayList();
        peers.addAll(_peers);
        if (peers.size() > 0) {
            ExternalSeedPeer peer;
            boolean add_listener = false;
            try {
                this.download_mon.enter();
                ArrayList<ExternalSeedPeer> existing_peers = (ArrayList<ExternalSeedPeer>)this.download_map.get(download);
                if (existing_peers == null) {
                    add_listener = true;
                    existing_peers = new ArrayList<ExternalSeedPeer>();
                    this.download_map.put(download, existing_peers);
                }
                Iterator it = peers.iterator();
                while (it.hasNext()) {
                    peer = (ExternalSeedPeer)it.next();
                    boolean skip = false;
                    int j = 0;
                    while (j < existing_peers.size()) {
                        ExternalSeedPeer existing_peer = (ExternalSeedPeer)existing_peers.get(j);
                        if (existing_peer.sameAs(peer)) {
                            skip = true;
                            break;
                        }
                        ++j;
                    }
                    if (skip) {
                        it.remove();
                        continue;
                    }
                    this.log(String.valueOf(download.getName()) + " found seed " + peer.getName());
                    existing_peers.add(peer);
                }
                this.setStatus("Running: Downloads with external seeds = " + this.download_map.size());
            }
            finally {
                this.download_mon.exit();
            }
            if (add_listener) {
                download.addPeerListener(new DownloadPeerListener(){

                    @Override
                    public void peerManagerAdded(Download download2, PeerManager peer_manager) {
                        List existing_peers = this.getPeers();
                        if (existing_peers == null) {
                            return;
                        }
                        int i = 0;
                        while (i < existing_peers.size()) {
                            ExternalSeedPeer peer = (ExternalSeedPeer)existing_peers.get(i);
                            peer.setManager(peer_manager);
                            ++i;
                        }
                    }

                    @Override
                    public void peerManagerRemoved(Download download2, PeerManager peer_manager) {
                        List existing_peers = this.getPeers();
                        if (existing_peers == null) {
                            return;
                        }
                        int i = 0;
                        while (i < existing_peers.size()) {
                            ExternalSeedPeer peer = (ExternalSeedPeer)existing_peers.get(i);
                            peer.setManager(null);
                            ++i;
                        }
                    }

                    protected List getPeers() {
                        ArrayList existing_peers = null;
                        try {
                            ExternalSeedPlugin.this.download_mon.enter();
                            List temp = (List)ExternalSeedPlugin.this.download_map.get(download);
                            if (temp != null) {
                                existing_peers = new ArrayList(temp.size());
                                existing_peers.addAll(temp);
                            }
                        }
                        finally {
                            ExternalSeedPlugin.this.download_mon.exit();
                        }
                        return existing_peers;
                    }
                });
            } else {
                PeerManager existing_pm = download.getPeerManager();
                if (existing_pm != null) {
                    int i = 0;
                    while (i < peers.size()) {
                        peer = (ExternalSeedPeer)peers.get(i);
                        if (peer.getManager() == null) {
                            peer.setManager(existing_pm);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    protected void removePeer(ExternalSeedPeer peer) {
        Download download = peer.getDownload();
        try {
            this.download_mon.enter();
            List existing_peers = (List)this.download_map.get(download);
            if (existing_peers != null && existing_peers.remove(peer)) {
                this.log(String.valueOf(download.getName()) + " removed seed " + peer.getName());
            }
        }
        finally {
            this.download_mon.exit();
        }
    }

    @Override
    public void downloadRemoved(Download download) {
        try {
            this.download_mon.enter();
            this.download_map.remove(download);
            this.setStatus("Running: Downloads with external seeds = " + this.download_map.size());
        }
        finally {
            this.download_mon.exit();
        }
    }

    public ExternalSeedManualPeer[] getManualWebSeeds(Download download) {
        try {
            this.download_mon.enter();
            List peers = (List)this.download_map.get(download);
            if (peers == null) {
                ExternalSeedManualPeer[] externalSeedManualPeerArray = new ExternalSeedManualPeer[]{};
                return externalSeedManualPeerArray;
            }
            ExternalSeedManualPeer[] result = new ExternalSeedManualPeer[peers.size()];
            int i = 0;
            while (i < peers.size()) {
                result[i] = new ExternalSeedManualPeer((ExternalSeedPeer)peers.get(i));
                ++i;
            }
            ExternalSeedManualPeer[] externalSeedManualPeerArray = result;
            return externalSeedManualPeerArray;
        }
        finally {
            this.download_mon.exit();
        }
    }

    public ExternalSeedReader[] getManualWebSeeds(Torrent torrent) {
        ArrayList<ExternalSeedReader> result = new ArrayList<ExternalSeedReader>();
        int i = 0;
        while (i < factories.length) {
            ExternalSeedReader[] peers = factories[i].getSeedReaders(this, torrent);
            result.addAll(Arrays.asList(peers));
            ++i;
        }
        return result.toArray(new ExternalSeedReader[result.size()]);
    }

    public TrackerPeerSource getTrackerPeerSource(final Download download) {
        return new TrackerPeerSourceAdapter(){
            private long fixup_time;
            private ExternalSeedManualPeer[] peers;
            private boolean running;

            @Override
            public int getType() {
                return 2;
            }

            @Override
            public int getStatus() {
                this.fixup();
                if (this.running) {
                    return this.peers.length == 0 ? 8 : 7;
                }
                return 2;
            }

            @Override
            public String getName() {
                this.fixup();
                if (this.peers.length == 0) {
                    return "";
                }
                StringBuffer sb = new StringBuffer();
                ExternalSeedManualPeer[] externalSeedManualPeerArray = this.peers;
                int n = this.peers.length;
                int n2 = 0;
                while (n2 < n) {
                    String str;
                    int pos;
                    ExternalSeedManualPeer peer = externalSeedManualPeerArray[n2];
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    if ((pos = (str = peer.getDelegate().getURL().toExternalForm()).indexOf(63)) != -1) {
                        str = str.substring(0, pos);
                    }
                    sb.append(str);
                    ++n2;
                }
                return sb.toString();
            }

            @Override
            public int getSeedCount() {
                this.fixup();
                if (this.running) {
                    return this.peers.length == 0 ? -1 : this.peers.length;
                }
                return -1;
            }

            protected void fixup() {
                long now = SystemTime.getMonotonousTime();
                if (this.peers == null || now - this.fixup_time > 10000L) {
                    this.fixup_time = now;
                    this.peers = ExternalSeedPlugin.this.getManualWebSeeds(download);
                    int state = download.getState();
                    this.running = state == 4 || state == 5;
                }
            }
        };
    }

    public TrackerPeerSource getTrackerPeerSource(Torrent torrent) {
        return new TrackerPeerSourceAdapter(torrent){
            private ExternalSeedReader[] peers;
            {
                this.peers = ExternalSeedPlugin.this.getManualWebSeeds(torrent);
            }

            @Override
            public int getType() {
                return 2;
            }

            @Override
            public int getStatus() {
                return this.peers.length == 0 ? 8 : 7;
            }

            @Override
            public String getName() {
                if (this.peers.length == 0) {
                    return "";
                }
                StringBuffer sb = new StringBuffer();
                ExternalSeedReader[] externalSeedReaderArray = this.peers;
                int n = this.peers.length;
                int n2 = 0;
                while (n2 < n) {
                    String str;
                    int pos;
                    ExternalSeedReader peer = externalSeedReaderArray[n2];
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    if ((pos = (str = peer.getURL().toExternalForm()).indexOf(63)) != -1) {
                        str = str.substring(0, pos);
                    }
                    sb.append(str);
                    ++n2;
                }
                return sb.toString();
            }

            @Override
            public int getSeedCount() {
                return this.peers.length == 0 ? -1 : this.peers.length;
            }
        };
    }

    public int getGlobalDownloadRateBytesPerSec() {
        return this.dm_stats.getDataAndProtocolReceiveRate();
    }

    protected void setStatus(String str) {
        this.status_field.setText(str);
    }

    public void log(String str) {
        this.log.log(str);
    }

    public void log(String str, Throwable e) {
        this.log.log(str, e);
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    protected List randomiseList(List l) {
        if (l.size() < 2) {
            return l;
        }
        ArrayList new_list = new ArrayList();
        int i = 0;
        while (i < l.size()) {
            new_list.add(this.random.nextInt(new_list.size() + 1), l.get(i));
            ++i;
        }
        return new_list;
    }
}

