/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.png;

import com.aelitis.azureus.core.util.png.Chunk;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;

public abstract class CRCedChunk
extends Chunk {
    private byte[] type;
    private static long[] crc_table = new long[256];
    private static boolean crc_table_computed = false;

    public CRCedChunk(byte[] type) throws InvalidParameterException {
        if (type.length != 4) {
            throw new InvalidParameterException("type must be of length 4, provided : " + type.length);
        }
        this.type = type;
    }

    @Override
    public byte[] getChunkPayload() {
        byte[] contentPayload = this.getContentPayload();
        int length = contentPayload.length;
        ByteBuffer buffer = ByteBuffer.allocate(length + 12);
        buffer.putInt(length);
        buffer.put(this.type);
        buffer.put(contentPayload);
        buffer.position(4);
        buffer.limit(length + 8);
        long crc = CRCedChunk.crc(buffer);
        buffer.limit(length + 12);
        buffer.putInt((int)crc);
        buffer.position(0);
        return buffer.array();
    }

    public abstract byte[] getContentPayload();

    private static synchronized void make_crc_table() {
        int n = 0;
        while (n < 256) {
            long c = n;
            int k = 0;
            while (k < 8) {
                c = (c & 1L) != 0L ? 0xEDB88320L ^ c >> 1 & 0xFFFFFFFFFFFFFFFFL : (c >>= 1);
                c &= 0xFFFFFFFFFFFFFFFFL;
                ++k;
            }
            CRCedChunk.crc_table[n] = c;
            ++n;
        }
        crc_table_computed = true;
    }

    private static long update_crc(long crc, ByteBuffer buf) {
        long c = crc;
        if (!crc_table_computed) {
            CRCedChunk.make_crc_table();
        }
        while (buf.hasRemaining()) {
            c = crc_table[(int)((c ^ (long)buf.get()) & 0xFFL)] ^ c >> 8;
        }
        return c;
    }

    private static long crc(ByteBuffer buf) {
        return CRCedChunk.update_crc(0xFFFFFFFFL, buf) ^ 0xFFFFFFFFL;
    }
}

