/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.bloom.impl;

import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.impl.BloomFilterImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.SystemTime;

public class BloomFilterRotator
implements BloomFilter {
    private volatile BloomFilter current_filter;
    private int current_filter_index;
    private final BloomFilter[] filters;
    private long start_time = SystemTime.getMonotonousTime();

    public BloomFilterRotator(BloomFilter _target, int _num) {
        this.filters = new BloomFilter[_num];
        this.filters[0] = _target;
        int i = 1;
        while (i < this.filters.length) {
            this.filters[i] = _target.getReplica();
            ++i;
        }
        this.current_filter = _target;
        this.current_filter_index = 0;
    }

    public BloomFilterRotator(Map<String, Object> x) {
        List list = (List)x.get("list");
        this.filters = new BloomFilter[list.size()];
        int i = 0;
        while (i < this.filters.length) {
            this.filters[i] = BloomFilterImpl.deserialiseFromMap((Map)list.get(i));
            ++i;
        }
        this.current_filter_index = ((Long)x.get("index")).intValue();
        this.current_filter = this.filters[this.current_filter_index];
    }

    @Override
    public Map<String, Object> serialiseToMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        this.serialiseToMap(m);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serialiseToMap(Map<String, Object> x) {
        BloomFilter[] bloomFilterArray = this.filters;
        synchronized (this.filters) {
            String cla = this.getClass().getName();
            if (cla.startsWith("com.aelitis.azureus.core.util.bloom.impl")) {
                cla = cla.substring("com.aelitis.azureus.core.util.bloom.impl".length());
            }
            x.put("_impl", cla);
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            BloomFilter[] bloomFilterArray2 = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                BloomFilter filter2 = bloomFilterArray2[n2];
                list.add(filter2.serialiseToMap());
                ++n2;
            }
            x.put("list", list);
            x.put("index", new Long(this.current_filter_index));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(byte[] value) {
        BloomFilter[] bloomFilterArray = this.filters;
        synchronized (this.filters) {
            int update_chunk;
            int num_to_update;
            int filter_size = this.current_filter.getSize();
            int filter_entries = this.current_filter.getEntryCount();
            int limit = filter_size / 8;
            if (filter_entries > limit) {
                filter_entries = limit;
            }
            if ((num_to_update = filter_entries / (update_chunk = limit / this.filters.length) + 1) > this.filters.length) {
                num_to_update = this.filters.length;
            }
            int res = 0;
            int i = this.current_filter_index;
            while (i < this.current_filter_index + num_to_update) {
                int r = this.filters[i % this.filters.length].add(value);
                if (i == this.current_filter_index) {
                    res = r;
                }
                ++i;
            }
            if (this.current_filter.getEntryCount() > limit) {
                this.filters[this.current_filter_index] = this.current_filter.getReplica();
                this.current_filter_index = (this.current_filter_index + 1) % this.filters.length;
                this.current_filter = this.filters[this.current_filter_index];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return res;
        }
    }

    @Override
    public int remove(byte[] value) {
        int res = 0;
        int i = 0;
        while (i < this.filters.length) {
            BloomFilter filter2 = this.filters[i];
            int r = filter2.remove(value);
            if (filter2 == this.current_filter) {
                res = r;
            }
            ++i;
        }
        return res;
    }

    @Override
    public boolean contains(byte[] value) {
        return this.current_filter.contains(value);
    }

    @Override
    public int count(byte[] value) {
        return this.current_filter.count(value);
    }

    @Override
    public int getEntryCount() {
        return this.current_filter.getEntryCount();
    }

    @Override
    public int getSize() {
        return this.current_filter.getSize();
    }

    @Override
    public BloomFilter getReplica() {
        return new BloomFilterRotator(this.current_filter, this.filters.length);
    }

    @Override
    public long getStartTimeMono() {
        return this.start_time;
    }

    @Override
    public void clear() {
        this.start_time = SystemTime.getMonotonousTime();
        BloomFilter[] bloomFilterArray = this.filters;
        int n = this.filters.length;
        int n2 = 0;
        while (n2 < n) {
            BloomFilter filter2 = bloomFilterArray[n2];
            filter2.clear();
            ++n2;
        }
    }

    @Override
    public String getString() {
        return "ind=" + this.current_filter_index + ",filt=" + this.current_filter.getString();
    }
}

