/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Set;
import org.gudy.azureus2.core3.util.Debug;

public class QTFastStartRAF {
    private static final Set<String> supported_extensions = new HashSet<String>();
    private static Set<String> tested;
    private static final String ATOM_FREE = "free";
    private static final String ATOM_JUNK = "junk";
    private static final String ATOM_MDAT = "mdat";
    private static final String ATOM_MOOV = "moov";
    private static final String ATOM_PNOT = "pnot";
    private static final String ATOM_SKIP = "skip";
    private static final String ATOM_WIDE = "wide";
    private static final String ATOM_PICT = "PICT";
    private static final String ATOM_FTYP = "ftyp";
    private static final String ATOM_CMOV = "cmov";
    private static final String ATOM_STCO = "stco";
    private static final String ATOM_CO64 = "co64";
    private static final String[] VALID_TOPLEVEL_ATOMS;
    private FileAccessor input;
    private boolean transparent;
    private byte[] header;
    private long body_start;
    private long body_end;
    private long seek_position;

    static {
        supported_extensions.add("mov");
        supported_extensions.add("qt");
        supported_extensions.add("mp4");
        tested = new HashSet<String>();
        VALID_TOPLEVEL_ATOMS = new String[]{ATOM_FREE, ATOM_JUNK, ATOM_MDAT, ATOM_MOOV, ATOM_PNOT, ATOM_SKIP, ATOM_WIDE, ATOM_PICT, ATOM_FTYP};
    }

    public static boolean isSupportedExtension(String extension) {
        return supported_extensions.contains(extension.toLowerCase());
    }

    public QTFastStartRAF(File file, boolean enable) throws IOException {
        this(new RAFAccessor(file), enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QTFastStartRAF(FileAccessor accessor, boolean enable) throws IOException {
        this.input = accessor;
        if (enable) {
            Atom ftypAtom;
            Atom ah;
            boolean log;
            String fail;
            block19: {
                String name = accessor.getName();
                fail = null;
                Set<String> set = tested;
                synchronized (set) {
                    boolean bl = log = !tested.contains(name);
                    if (log) {
                        tested.add(name);
                    }
                }
                ah = null;
                ftypAtom = null;
                boolean gotFtyp = false;
                boolean gotMdat = false;
                boolean justCopy = false;
                while (this.input.getFilePointer() < this.input.length()) {
                    ah = new Atom(this.input);
                    if (!this.isValidTopLevelAtom(ah)) {
                        throw new IOException("Non top level QT atom found (" + ah.type + "). File invalid?");
                    }
                    if (gotFtyp && !gotMdat && ah.type.equalsIgnoreCase(ATOM_MOOV)) {
                        justCopy = true;
                        break;
                    }
                    if (ah.type.equalsIgnoreCase(ATOM_FTYP)) {
                        ftypAtom = ah;
                        ftypAtom.fillBuffer(this.input);
                        gotFtyp = true;
                        continue;
                    }
                    if (ah.type.equalsIgnoreCase(ATOM_MDAT)) {
                        gotMdat = true;
                        this.input.skipBytes((int)ah.size);
                        continue;
                    }
                    this.input.skipBytes((int)ah.size);
                }
                if (!justCopy) break block19;
                this.transparent = true;
                this.input.seek(0L);
                if (!log) return;
                String message = fail == null ? (this.transparent ? "Not required" : "Required") : "Failed - " + fail;
                Debug.outNoStack("MOOV relocation for " + accessor.getName() + ": " + message);
                return;
            }
            try {
                try {
                    if (ftypAtom == null) {
                        throw new IOException("No FTYP atom found");
                    }
                    if (ah == null || !ah.type.equalsIgnoreCase(ATOM_MOOV)) {
                        throw new IOException("Last QT atom was not the MOOV atom.");
                    }
                    this.input.seek(ah.offset);
                    Atom moovAtom = ah;
                    moovAtom.fillBuffer(this.input);
                    if (this.isCompressedMoovAtom(moovAtom)) {
                        throw new IOException("Compressed MOOV qt atoms are not supported");
                    }
                    this.patchMoovAtom(moovAtom);
                    this.body_start = ftypAtom.offset + ftypAtom.size;
                    this.body_end = moovAtom.offset;
                    this.header = new byte[ftypAtom.buffer.length + moovAtom.buffer.length];
                    System.arraycopy(ftypAtom.buffer, 0, this.header, 0, ftypAtom.buffer.length);
                    System.arraycopy(moovAtom.buffer, 0, this.header, ftypAtom.buffer.length, moovAtom.buffer.length);
                    if (accessor.length() != (long)this.header.length + (this.body_end - this.body_start)) {
                        throw new IOException("Inconsistent: file size has changed");
                    }
                }
                catch (Throwable e) {
                    fail = Debug.getNestedExceptionMessage(e);
                    this.transparent = true;
                    this.input.seek(0L);
                    if (!log) return;
                    String message = fail == null ? (this.transparent ? "Not required" : "Required") : "Failed - " + fail;
                    Debug.outNoStack("MOOV relocation for " + accessor.getName() + ": " + message);
                    return;
                }
            }
            catch (Throwable throwable) {
                this.input.seek(0L);
                if (!log) throw throwable;
                String message = fail == null ? (this.transparent ? "Not required" : "Required") : "Failed - " + fail;
                Debug.outNoStack("MOOV relocation for " + accessor.getName() + ": " + message);
                throw throwable;
            }
            this.input.seek(0L);
            if (!log) return;
            String message = fail == null ? (this.transparent ? "Not required" : "Required") : "Failed - " + fail;
            Debug.outNoStack("MOOV relocation for " + accessor.getName() + ": " + message);
            return;
        }
        this.transparent = true;
    }

    private boolean isCompressedMoovAtom(Atom moovAtom) {
        byte[] cmovBuffer = QTFastStartRAF.copyOfRange(moovAtom.buffer, 12, 15);
        return new String(cmovBuffer).equalsIgnoreCase(ATOM_CMOV);
    }

    private boolean isValidTopLevelAtom(Atom ah) {
        String[] stringArray = VALID_TOPLEVEL_ATOMS;
        int n = VALID_TOPLEVEL_ATOMS.length;
        int n2 = 0;
        while (n2 < n) {
            String validAtom = stringArray[n2];
            if (validAtom.equalsIgnoreCase(ah.type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void patchMoovAtom(Atom moovAtom) {
        int idx = 0;
        idx = 4;
        while ((long)idx < moovAtom.size - 4L) {
            byte[] buffer = QTFastStartRAF.copyOfRange(moovAtom.buffer, idx, idx + 4);
            if (new String(buffer).equalsIgnoreCase(ATOM_STCO)) {
                int stcoSize = this.patchStcoAtom(moovAtom, idx);
                idx += stcoSize - 4;
            } else if (new String(buffer).equalsIgnoreCase(ATOM_CO64)) {
                int co64Size = this.patchCo64Atom(moovAtom, idx);
                idx += co64Size - 4;
            }
            ++idx;
        }
    }

    private int patchStcoAtom(Atom ah, int idx) {
        int stcoSize = (int)this.bytesToLong(QTFastStartRAF.copyOfRange(ah.buffer, idx - 4, idx));
        int offsetCount = (int)this.bytesToLong(QTFastStartRAF.copyOfRange(ah.buffer, idx + 8, idx + 12));
        int j = 0;
        while (j < offsetCount) {
            int currentOffset = (int)this.bytesToLong(QTFastStartRAF.copyOfRange(ah.buffer, idx + 12 + j * 4, idx + 12 + j * 4 + 4));
            currentOffset = (int)((long)currentOffset + ah.size);
            int offsetIdx = idx + 12 + j * 4;
            ah.buffer[offsetIdx + 0] = (byte)(currentOffset >> 24 & 0xFF);
            ah.buffer[offsetIdx + 1] = (byte)(currentOffset >> 16 & 0xFF);
            ah.buffer[offsetIdx + 2] = (byte)(currentOffset >> 8 & 0xFF);
            ah.buffer[offsetIdx + 3] = (byte)(currentOffset >> 0 & 0xFF);
            ++j;
        }
        return stcoSize;
    }

    private int patchCo64Atom(Atom ah, int idx) {
        int co64Size = (int)this.bytesToLong(QTFastStartRAF.copyOfRange(ah.buffer, idx - 4, idx));
        int offsetCount = (int)this.bytesToLong(QTFastStartRAF.copyOfRange(ah.buffer, idx + 8, idx + 12));
        int j = 0;
        while (j < offsetCount) {
            long currentOffset = this.bytesToLong(QTFastStartRAF.copyOfRange(ah.buffer, idx + 12 + j * 8, idx + 12 + j * 8 + 8));
            int offsetIdx = idx + 12 + j * 8;
            ah.buffer[offsetIdx + 0] = (byte)((currentOffset += ah.size) >> 56 & 0xFFL);
            ah.buffer[offsetIdx + 1] = (byte)(currentOffset >> 48 & 0xFFL);
            ah.buffer[offsetIdx + 2] = (byte)(currentOffset >> 40 & 0xFFL);
            ah.buffer[offsetIdx + 3] = (byte)(currentOffset >> 32 & 0xFFL);
            ah.buffer[offsetIdx + 4] = (byte)(currentOffset >> 24 & 0xFFL);
            ah.buffer[offsetIdx + 5] = (byte)(currentOffset >> 16 & 0xFFL);
            ah.buffer[offsetIdx + 6] = (byte)(currentOffset >> 8 & 0xFFL);
            ah.buffer[offsetIdx + 7] = (byte)(currentOffset >> 0 & 0xFFL);
            ++j;
        }
        return co64Size;
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(String.valueOf(from) + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    private long bytesToLong(byte[] buffer) {
        long retVal = 0L;
        int i = 0;
        while (i < buffer.length) {
            retVal += (long)((buffer[i] & 0xFF) << 8 * (buffer.length - i - 1));
            ++i;
        }
        return retVal;
    }

    public void seek(long pos) throws IOException {
        if (this.transparent) {
            this.input.seek(pos);
        } else {
            this.seek_position = pos;
        }
    }

    public int read(byte[] buffer, int pos, int len) throws IOException {
        if (this.transparent) {
            return this.input.read(buffer, pos, len);
        }
        long start_pos = this.seek_position;
        int start_len = len;
        if (this.seek_position < (long)this.header.length) {
            int rem = (int)((long)this.header.length - this.seek_position);
            if (rem > len) {
                rem = len;
            }
            System.arraycopy(this.header, (int)this.seek_position, buffer, pos, rem);
            pos += rem;
            len -= rem;
            this.seek_position += (long)rem;
        }
        if (len > 0) {
            long file_position = this.body_start + this.seek_position - (long)this.header.length;
            long rem = this.body_end - file_position;
            if ((long)len < rem) {
                rem = len;
            }
            this.input.seek(file_position);
            int temp = this.input.read(buffer, pos, (int)rem);
            pos += temp;
            len -= temp;
            this.seek_position += (long)temp;
        }
        int read = start_len - len;
        this.seek_position = start_pos + (long)read;
        return read;
    }

    public long length() throws IOException {
        return this.input.length();
    }

    public void close() throws IOException {
        this.input.close();
    }

    private class Atom {
        public long offset;
        public long size;
        public String type;
        public byte[] buffer = null;

        public Atom(FileAccessor input) throws IOException {
            this.offset = input.getFilePointer();
            this.size = input.readInt();
            byte[] atomTypeFCC = new byte[4];
            input.readFully(atomTypeFCC);
            this.type = new String(atomTypeFCC);
            if (this.size == 1L) {
                this.size = input.readLong();
            }
            input.seek(this.offset);
        }

        public void fillBuffer(FileAccessor input) throws IOException {
            this.buffer = new byte[(int)this.size];
            input.readFully(this.buffer);
        }
    }

    public static interface FileAccessor {
        public String getName();

        public long getFilePointer() throws IOException;

        public void seek(long var1) throws IOException;

        public void skipBytes(int var1) throws IOException;

        public long length() throws IOException;

        public int read(byte[] var1, int var2, int var3) throws IOException;

        public int readInt() throws IOException;

        public long readLong() throws IOException;

        public void readFully(byte[] var1) throws IOException;

        public void close() throws IOException;
    }

    private static class RAFAccessor
    implements FileAccessor {
        private File file;
        private RandomAccessFile raf;

        private RAFAccessor(File _file) throws IOException {
            this.file = _file;
            this.raf = new RandomAccessFile(this.file, "r");
        }

        @Override
        public String getName() {
            return this.file.getAbsolutePath();
        }

        @Override
        public long getFilePointer() throws IOException {
            return this.raf.getFilePointer();
        }

        @Override
        public void seek(long pos) throws IOException {
            this.raf.seek(pos);
        }

        @Override
        public void skipBytes(int num) throws IOException {
            this.raf.skipBytes(num);
        }

        @Override
        public long length() throws IOException {
            return this.raf.length();
        }

        @Override
        public int read(byte[] buffer, int pos, int len) throws IOException {
            return this.raf.read(buffer, pos, len);
        }

        @Override
        public int readInt() throws IOException {
            return this.raf.readInt();
        }

        @Override
        public long readLong() throws IOException {
            return this.raf.readLong();
        }

        @Override
        public void readFully(byte[] buffer) throws IOException {
            this.raf.readFully(buffer);
        }

        @Override
        public void close() throws IOException {
            this.raf.close();
        }
    }
}

