/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.tag.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagFeatureProperties;
import com.aelitis.azureus.core.tag.TagListener;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.TagTypeAdapter;
import com.aelitis.azureus.core.tag.TagTypeListener;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.TaggableLifecycleAdapter;
import com.aelitis.azureus.core.tag.impl.TagManagerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.Debug;

public class TagPropertyUntaggedHandler
implements TagTypeListener {
    private AzureusCore azureus_core;
    private TagManagerImpl tag_manager;
    private boolean is_initialised;
    private boolean is_enabled;
    private Set<Tag> untagged_tags = new HashSet<Tag>();
    private Map<Taggable, int[]> taggable_counts = new IdentityHashMap<Taggable, int[]>();

    protected TagPropertyUntaggedHandler(AzureusCore _core, TagManagerImpl _tm) {
        this.azureus_core = _core;
        this.tag_manager = _tm;
        this.tag_manager.addTaggableLifecycleListener(2L, new TaggableLifecycleAdapter(){

            @Override
            public void initialised(List<Taggable> current_taggables) {
                try {
                    TagType tt = TagPropertyUntaggedHandler.this.tag_manager.getTagType(3);
                    tt.addTagTypeListener(new TagTypeAdapter(){

                        @Override
                        public void tagAdded(Tag tag) {
                            TagFeatureProperties.TagProperty[] props;
                            TagFeatureProperties tfp = (TagFeatureProperties)((Object)tag);
                            TagFeatureProperties.TagProperty[] tagPropertyArray = props = tfp.getSupportedProperties();
                            int n = props.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TagFeatureProperties.TagProperty prop = tagPropertyArray[n2];
                                if (prop.getName(false).equals("untagged")) {
                                    prop.addListener(new TagFeatureProperties.TagPropertyListener(){

                                        @Override
                                        public void propertyChanged(TagFeatureProperties.TagProperty property) {
                                            TagPropertyUntaggedHandler.this.handleProperty(property);
                                        }

                                        @Override
                                        public void propertySync(TagFeatureProperties.TagProperty property) {
                                        }
                                    });
                                    TagPropertyUntaggedHandler.this.handleProperty(prop);
                                }
                                ++n2;
                            }
                        }
                    }, true);
                }
                catch (Throwable throwable) {
                    AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void azureusCoreRunning(AzureusCore core) {
                            Map map = TagPropertyUntaggedHandler.this.taggable_counts;
                            synchronized (map) {
                                TagPropertyUntaggedHandler.this.is_initialised = true;
                                if (TagPropertyUntaggedHandler.this.is_enabled) {
                                    TagPropertyUntaggedHandler.this.enable();
                                }
                            }
                        }
                    });
                    throw throwable;
                }
                AzureusCoreFactory.addCoreRunningListener(new /* invalid duplicate definition of identical inner class */);
            }

            @Override
            public void taggableCreated(Taggable taggable) {
                TagPropertyUntaggedHandler.this.addDownloads(Arrays.asList((DownloadManager)taggable));
            }
        });
    }

    @Override
    public void tagTypeChanged(TagType tag_type) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tagAdded(Tag tag) {
        tag.addTagListener(new TagListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void taggableAdded(Tag tag, Taggable tagged) {
                Map map = TagPropertyUntaggedHandler.this.taggable_counts;
                synchronized (map) {
                    if (TagPropertyUntaggedHandler.this.untagged_tags.contains(tag)) {
                        return;
                    }
                    int[] num = (int[])TagPropertyUntaggedHandler.this.taggable_counts.get(tagged);
                    if (num == null) {
                        num = new int[1];
                        TagPropertyUntaggedHandler.this.taggable_counts.put(tagged, num);
                    }
                    int n = num[0];
                    num[0] = n + 1;
                    if (n == 0) {
                        for (Tag t : TagPropertyUntaggedHandler.this.untagged_tags) {
                            t.removeTaggable(tagged);
                        }
                    }
                }
            }

            @Override
            public void taggableSync(Tag tag) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void taggableRemoved(Tag tag, Taggable tagged) {
                Map map = TagPropertyUntaggedHandler.this.taggable_counts;
                synchronized (map) {
                    if (TagPropertyUntaggedHandler.this.untagged_tags.contains(tag)) {
                        return;
                    }
                    int[] num = (int[])TagPropertyUntaggedHandler.this.taggable_counts.get(tagged);
                    if (num != null) {
                        int n = num[0];
                        num[0] = n - 1;
                        if (n == 1) {
                            TagPropertyUntaggedHandler.this.taggable_counts.remove(tagged);
                            DownloadManager dm = (DownloadManager)tagged;
                            if (!dm.isDestroyed()) {
                                for (Tag t : TagPropertyUntaggedHandler.this.untagged_tags) {
                                    t.addTaggable(tagged);
                                }
                            }
                        }
                    }
                }
            }
        }, false);
        Map<Taggable, int[]> map = this.taggable_counts;
        synchronized (map) {
            if (this.untagged_tags.contains(tag)) {
                return;
            }
        }
        Set<Taggable> existing = tag.getTagged();
        Map<Taggable, int[]> map2 = this.taggable_counts;
        synchronized (map2) {
            for (Taggable tagged : existing) {
                int[] num = this.taggable_counts.get(tagged);
                if (num == null) {
                    num = new int[1];
                    this.taggable_counts.put(tagged, num);
                }
                int n = num[0];
                num[0] = n + 1;
                if (n != 0) continue;
                for (Tag t : this.untagged_tags) {
                    t.removeTaggable(tagged);
                }
            }
        }
    }

    @Override
    public void tagChanged(Tag tag) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tagRemoved(Tag tag) {
        Map<Taggable, int[]> map = this.taggable_counts;
        synchronized (map) {
            boolean was_untagged = this.untagged_tags.remove(tag);
            if (was_untagged && this.untagged_tags.size() == 0) {
                this.setEnabled(tag, false);
            }
        }
    }

    private void enable() {
        TagType tt = this.tag_manager.getTagType(3);
        tt.addTagTypeListener(this, false);
        for (Tag tag : tt.getTags()) {
            this.tagAdded(tag);
        }
        List<DownloadManager> existing = this.azureus_core.getGlobalManager().getDownloadManagers();
        this.addDownloads(existing);
    }

    private void disable() {
        TagType tt = this.tag_manager.getTagType(3);
        tt.removeTagTypeListener(this);
        this.taggable_counts.clear();
    }

    private void setEnabled(Tag current_tag, boolean enabled) {
        if (enabled == this.is_enabled) {
            if (this.is_enabled) {
                if (this.untagged_tags.size() < 2) {
                    Debug.out("eh?");
                    return;
                }
                Set<Taggable> existing = current_tag.getTagged();
                for (Taggable t : existing) {
                    current_tag.removeTaggable(t);
                }
                Tag[] temp = this.untagged_tags.toArray(new Tag[this.untagged_tags.size()]);
                Tag copy_from = temp[0] == current_tag ? temp[1] : temp[0];
                for (Taggable t : copy_from.getTagged()) {
                    current_tag.addTaggable(t);
                }
            }
            return;
        }
        this.is_enabled = enabled;
        if (enabled) {
            if (this.is_initialised) {
                this.enable();
            }
        } else {
            this.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProperty(TagFeatureProperties.TagProperty property) {
        Tag tag = property.getTag();
        Map<Taggable, int[]> map = this.taggable_counts;
        synchronized (map) {
            Boolean val = property.getBoolean();
            if (val != null && val.booleanValue()) {
                this.untagged_tags.add(tag);
                this.setEnabled(tag, true);
            } else {
                boolean was_untagged = this.untagged_tags.remove(tag);
                if (this.untagged_tags.size() == 0) {
                    this.setEnabled(tag, false);
                }
                if (was_untagged) {
                    Set<Taggable> existing = tag.getTagged();
                    for (Taggable t : existing) {
                        tag.removeTaggable(t);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDownloads(List<DownloadManager> dms) {
        Map<Taggable, int[]> map = this.taggable_counts;
        synchronized (map) {
            if (!this.is_enabled) {
                return;
            }
            for (DownloadManager dm : dms) {
                if (!dm.isPersistent() || this.taggable_counts.containsKey(dm)) continue;
                for (Tag t : this.untagged_tags) {
                    t.addTaggable(dm);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Tag> getUntaggedTags() {
        Map<Taggable, int[]> map = this.taggable_counts;
        synchronized (map) {
            return new ArrayList<Tag>(this.untagged_tags);
        }
    }
}

