/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTester;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterContact;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterContactListener;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerAdapter;
import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import com.aelitis.azureus.core.speedmanager.SpeedManagerListener;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingMapper;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingSource;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProvider;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerPingMapperImpl;
import com.aelitis.azureus.core.speedmanager.impl.TestPingSourceRandom;
import com.aelitis.azureus.core.speedmanager.impl.v1.SpeedManagerAlgorithmProviderV1;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerAlgorithmProviderV2;
import com.aelitis.azureus.core.speedmanager.impl.v3.SpeedManagerAlgorithmProviderV3;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class SpeedManagerImpl
implements SpeedManager,
SpeedManagerAlgorithmProviderAdapter,
AEDiagnosticsEvidenceGenerator {
    protected static final int UPDATE_PERIOD_MILLIS = 3000;
    private static final int CONTACT_NUMBER = 3;
    private static final int CONTACT_PING_SECS = 3;
    private static final int LONG_PERIOD_SECS = 3600;
    private static final int LONG_PERIOD_TICKS = 1200;
    private static final int SHORT_ESTIMATE_SECS = 15;
    private static final int MEDIUM_ESTIMATE_SECS = 150;
    static final int SHORT_ESTIMATE_SAMPLES = 5;
    static final int MEDIUM_ESTIMATE_SAMPLES = 50;
    private static final int SAVE_PERIOD_SECS = 900;
    private static final int SAVE_PERIOD_TICKS = 300;
    private static final int AUTO_ADJUST_PERIOD_SECS = 60;
    private static final int AUTO_ADJUST_PERIOD_TICKS = 20;
    private static final int SPEED_AVERAGE_PERIOD = 3000;
    private static boolean DEBUG;
    public static final String CONFIG_VERSION_STR = "Auto_Upload_Speed_Version_String";
    public static final String CONFIG_VERSION = "Auto Upload Speed Version";
    private static final String CONFIG_AVAIL = "AutoSpeed Available";
    private static final String CONFIG_DEBUG = "Auto Upload Speed Debug Enabled";
    private static final String[] CONFIG_PARAMS;
    private static boolean emulated_ping_source;
    private AzureusCore core;
    private DHTSpeedTester speed_tester;
    private SpeedManagerAdapter adapter;
    private SpeedManagerAlgorithmProvider provider = new nullProvider();
    private int provider_version = -1;
    private boolean enabled;
    private static final boolean pm_enabled = true;
    private Map contacts = new HashMap();
    private volatile int total_contacts;
    private pingContact[] contacts_array = new pingContact[0];
    private Object original_limits;
    private AsyncDispatcher dispatcher = new AsyncDispatcher();
    private SpeedManagerPingMapperImpl ping_mapper;
    private SpeedManagerPingMapperImpl[] ping_mappers;
    private CopyOnWriteList transient_mappers = new CopyOnWriteList();
    private AEDiagnosticsLogger logger;
    private String asn;
    private CopyOnWriteList listeners = new CopyOnWriteList();

    static {
        CONFIG_PARAMS = new String[]{CONFIG_DEBUG};
        COConfigurationManager.addAndFireParameterListeners(CONFIG_PARAMS, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                DEBUG = COConfigurationManager.getBooleanParameter(SpeedManagerImpl.CONFIG_DEBUG);
            }
        });
    }

    public SpeedManagerImpl(AzureusCore _core, SpeedManagerAdapter _adapter) {
        this.core = _core;
        this.adapter = _adapter;
        AEDiagnostics.addEvidenceGenerator(this);
        this.logger = AEDiagnostics.getLogger("SpeedMan");
        this.ping_mapper = new SpeedManagerPingMapperImpl(this, "Var", 1200, true, false);
        if (Constants.isCVSVersion()) {
            SpeedManagerPingMapperImpl pm2 = new SpeedManagerPingMapperImpl(this, "Abs", 1200, false, false);
            this.ping_mappers = new SpeedManagerPingMapperImpl[]{pm2, this.ping_mapper};
        } else {
            this.ping_mappers = new SpeedManagerPingMapperImpl[]{this.ping_mapper};
        }
        final File config_dir = new File(SystemProperties.getUserPath(), "net");
        if (!config_dir.exists()) {
            config_dir.mkdirs();
        }
        NetworkAdmin.getSingleton().addAndFirePropertyChangeListener(new NetworkAdminPropertyChangeListener(){

            @Override
            public void propertyChanged(String property) {
                if (property == "AS") {
                    NetworkAdminASN net_asn = NetworkAdmin.getSingleton().getCurrentASN();
                    String as = net_asn.getAS();
                    if (as.length() == 0) {
                        as = "default";
                    }
                    File history = new File(config_dir, "pm_" + FileUtil.convertOSSpecificChars(as, false) + ".dat");
                    SpeedManagerImpl.this.ping_mapper.loadHistory(history);
                    SpeedManagerImpl.this.asn = net_asn.getASName();
                    if (SpeedManagerImpl.this.asn.length() == 0) {
                        SpeedManagerImpl.this.asn = "Unknown";
                    }
                    SpeedManagerImpl.this.informListeners(1);
                }
            }
        });
        this.core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            @Override
            public void stopping(AzureusCore core) {
                SpeedManagerImpl.this.ping_mapper.saveHistory();
            }
        });
        COConfigurationManager.addAndFireParameterListener(CONFIG_VERSION, new ParameterListener(){

            @Override
            public void parameterChanged(final String name) {
                SpeedManagerImpl.this.dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        boolean do_reset = SpeedManagerImpl.this.provider_version == -1;
                        int version = COConfigurationManager.getIntParameter(name);
                        if (version != SpeedManagerImpl.this.provider_version) {
                            SpeedManagerImpl.this.provider_version = version;
                            if (SpeedManagerImpl.this.isEnabled()) {
                                SpeedManagerImpl.this.setEnabledSupport(false);
                                SpeedManagerImpl.this.setEnabledSupport(true);
                            }
                        }
                        if (do_reset) {
                            SpeedManagerImpl.this.enableOrAlgChanged();
                        }
                    }
                });
            }
        });
        COConfigurationManager.setParameter(CONFIG_AVAIL, false);
        SimpleTimer.addPeriodicEvent("SpeedManager:timer", 3000L, new TimerEventPerformer(){
            private int tick_count;

            @Override
            public void perform(TimerEvent event2) {
                if (SpeedManagerImpl.this.contacts_array.length == 0) {
                    int x = SpeedManagerImpl.this.adapter.getCurrentDataUploadSpeed(3000) + SpeedManagerImpl.this.adapter.getCurrentProtocolUploadSpeed(3000);
                    int y = SpeedManagerImpl.this.adapter.getCurrentDataDownloadSpeed(3000) + SpeedManagerImpl.this.adapter.getCurrentProtocolDownloadSpeed(3000);
                    int i = 0;
                    while (i < SpeedManagerImpl.this.ping_mappers.length) {
                        SpeedManagerImpl.this.ping_mappers[i].addSpeed(x, y);
                        ++i;
                    }
                }
                ++this.tick_count;
                if (this.tick_count % 300 == 0) {
                    SpeedManagerImpl.this.ping_mapper.saveHistory();
                }
                if (this.tick_count % 20 == 0) {
                    SpeedManagerImpl.this.autoAdjust();
                }
            }
        });
        COConfigurationManager.addAndFireParameterListener("Auto Adjust Transfer Defaults", new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                SpeedManagerImpl.this.autoAdjust();
            }
        });
        emulated_ping_source = false;
        if (emulated_ping_source) {
            Debug.out("Emulated ping source!!!!");
            this.setSpeedTester(new TestPingSourceRandom(this));
        }
    }

    @Override
    public SpeedManager getSpeedManager() {
        return this;
    }

    @Override
    public String getASN() {
        return this.asn;
    }

    @Override
    public SpeedManagerLimitEstimate getEstimatedUploadCapacityBytesPerSec() {
        return this.ping_mapper.getEstimatedUploadCapacityBytesPerSec();
    }

    @Override
    public void setEstimatedUploadCapacityBytesPerSec(int bytes_per_sec, float metric) {
        this.ping_mapper.setEstimatedUploadCapacityBytesPerSec(bytes_per_sec, metric);
    }

    @Override
    public SpeedManagerLimitEstimate getEstimatedDownloadCapacityBytesPerSec() {
        return this.ping_mapper.getEstimatedDownloadCapacityBytesPerSec();
    }

    @Override
    public void setEstimatedDownloadCapacityBytesPerSec(int bytes_per_sec, float metric) {
        this.ping_mapper.setEstimatedDownloadCapacityBytesPerSec(bytes_per_sec, metric);
    }

    @Override
    public void reset() {
        this.ping_mapper.reset();
    }

    protected void enableOrAlgChanged() {
        this.total_contacts = 0;
        SpeedManagerAlgorithmProvider old_provider = this.provider;
        if (this.provider_version == 1) {
            if (!(this.provider instanceof SpeedManagerAlgorithmProviderV1)) {
                this.provider = new SpeedManagerAlgorithmProviderV1((SpeedManagerAlgorithmProviderAdapter)this);
            }
        } else if (this.provider_version == 2) {
            if (!(this.provider instanceof SpeedManagerAlgorithmProviderV2)) {
                this.provider = new SpeedManagerAlgorithmProviderV2(this);
            }
        } else if (this.provider_version == 3) {
            this.provider = new SpeedManagerAlgorithmProviderV3((SpeedManagerAlgorithmProviderAdapter)this);
        } else {
            Debug.out("Unknown provider version " + this.provider_version);
            if (!(this.provider instanceof nullProvider)) {
                this.provider = new nullProvider();
            }
        }
        if (old_provider != this.provider) {
            this.log("Algorithm set to " + this.provider.getClass().getName());
        }
        if (old_provider != null) {
            old_provider.destroy();
        }
        this.provider.reset();
    }

    @Override
    public SpeedManagerPingMapper createTransientPingMapper() {
        SpeedManagerPingMapperImpl res = new SpeedManagerPingMapperImpl(this, "Transient", 1200, true, true);
        this.transient_mappers.add(res);
        if (this.transient_mappers.size() > 32) {
            Debug.out("Transient mappers are growing too large");
        }
        return res;
    }

    protected void destroy(SpeedManagerPingMapper mapper) {
        this.transient_mappers.remove(mapper);
    }

    @Override
    public void setSpeedTester(DHTSpeedTester _tester) {
        if (_tester == this.speed_tester) {
            return;
        }
        if (this.speed_tester != null) {
            if (!emulated_ping_source) {
                Debug.out("speed tester already set!");
            }
            return;
        }
        COConfigurationManager.setParameter(CONFIG_AVAIL, true);
        this.speed_tester = _tester;
        this.speed_tester.addListener(new DHTSpeedTesterListener(){
            private DHTSpeedTesterContact[] last_contact_group = new DHTSpeedTesterContact[0];

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void contactAdded(DHTSpeedTesterContact contact) {
                if (SpeedManagerImpl.this.core.getInstanceManager().isLANAddress(contact.getAddress().getAddress())) {
                    contact.destroy();
                } else {
                    SpeedManagerImpl.this.log("activePing: " + contact.getString());
                    contact.setPingPeriod(3);
                    Map map = SpeedManagerImpl.this.contacts;
                    synchronized (map) {
                        pingContact source = new pingContact(contact);
                        SpeedManagerImpl.this.contacts.put(contact, source);
                        SpeedManagerImpl.this.contacts_array = new pingContact[SpeedManagerImpl.this.contacts.size()];
                        SpeedManagerImpl.this.contacts.values().toArray(SpeedManagerImpl.this.contacts_array);
                        SpeedManagerImpl speedManagerImpl = SpeedManagerImpl.this;
                        speedManagerImpl.total_contacts = speedManagerImpl.total_contacts + 1;
                        SpeedManagerImpl.this.provider.pingSourceFound(source, SpeedManagerImpl.this.total_contacts > 3);
                    }
                    contact.addListener(new DHTSpeedTesterContactListener(){

                        @Override
                        public void ping(DHTSpeedTesterContact contact, int round_trip_time) {
                        }

                        @Override
                        public void pingFailed(DHTSpeedTesterContact contact) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void contactDied(DHTSpeedTesterContact contact) {
                            SpeedManagerImpl.this.log("deadPing: " + contact.getString());
                            Map map = SpeedManagerImpl.this.contacts;
                            synchronized (map) {
                                pingContact source = (pingContact)SpeedManagerImpl.this.contacts.remove(contact);
                                if (source != null) {
                                    SpeedManagerImpl.this.contacts_array = new pingContact[SpeedManagerImpl.this.contacts.size()];
                                    SpeedManagerImpl.this.contacts.values().toArray(SpeedManagerImpl.this.contacts_array);
                                    SpeedManagerImpl.this.provider.pingSourceFailed(source);
                                }
                            }
                        }
                    });
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resultGroup(DHTSpeedTesterContact[] st_contacts, int[] round_trip_times) {
                boolean sources_changed = false;
                int i = 0;
                while (i < st_contacts.length) {
                    boolean found = false;
                    int j = 0;
                    while (j < this.last_contact_group.length) {
                        if (st_contacts[i] == this.last_contact_group[j]) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        sources_changed = true;
                        break;
                    }
                    ++i;
                }
                this.last_contact_group = st_contacts;
                SpeedManagerPingSource[] sources = new pingContact[st_contacts.length];
                boolean miss = false;
                int worst_value = -1;
                int min_value = Integer.MAX_VALUE;
                int num_values = 0;
                int total = 0;
                Map map = SpeedManagerImpl.this.contacts;
                synchronized (map) {
                    int i2 = 0;
                    while (i2 < st_contacts.length) {
                        sources[i2] = (pingContact)SpeedManagerImpl.this.contacts.get(st_contacts[i2]);
                        SpeedManagerPingSource source = sources[i2];
                        if (source != null) {
                            int rtt = round_trip_times[i2];
                            if (rtt >= 0) {
                                if (rtt > worst_value) {
                                    worst_value = rtt;
                                }
                                if (rtt < min_value) {
                                    min_value = rtt;
                                }
                                ++num_values;
                                total += rtt;
                            }
                            source.setPingTime(rtt);
                        } else {
                            miss = true;
                        }
                        ++i2;
                    }
                }
                if (!miss) {
                    SpeedManagerImpl.this.provider.calculate(sources);
                    if (num_values > 1) {
                        total -= worst_value;
                        --num_values;
                    }
                    if (num_values > 0) {
                        int average = total / num_values;
                        average = (average + min_value) / 2;
                        SpeedManagerImpl.this.addPingHistory(average, sources_changed);
                    }
                }
            }

            @Override
            public void destroyed() {
                SpeedManagerImpl.this.speed_tester = null;
            }
        });
        this.speed_tester.setContactNumber(3);
        SimpleTimer.addPeriodicEvent("SpeedManager:stats", 1000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                if (SpeedManagerImpl.this.enabled) {
                    SpeedManagerImpl.this.provider.updateStats();
                }
            }
        });
    }

    protected void addPingHistory(int rtt, boolean re_base) {
        int x = this.adapter.getCurrentDataUploadSpeed(3000) + this.adapter.getCurrentProtocolUploadSpeed(3000);
        int y = this.adapter.getCurrentDataDownloadSpeed(3000) + this.adapter.getCurrentProtocolDownloadSpeed(3000);
        int i = 0;
        while (i < this.ping_mappers.length) {
            this.ping_mappers[i].addPing(x, y, rtt, re_base);
            ++i;
        }
        Iterator it = this.transient_mappers.iterator();
        while (it.hasNext()) {
            ((SpeedManagerPingMapperImpl)it.next()).addPing(x, y, rtt, re_base);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.speed_tester != null;
    }

    @Override
    public void setEnabled(final boolean _enabled) {
        final AESemaphore sem = new AESemaphore("SpeedManagerImpl.setEnabled");
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                try {
                    SpeedManagerImpl.this.setEnabledSupport(_enabled);
                }
                finally {
                    sem.release();
                }
            }
        });
        if (!sem.reserve(10000L)) {
            Debug.out("operation didn't complete in time");
        }
    }

    protected void setEnabledSupport(boolean _enabled) {
        if (this.enabled != _enabled) {
            this.log("Enabled set to " + _enabled);
            if (_enabled) {
                this.original_limits = this.adapter.getLimits();
            } else {
                this.ping_mapper.saveHistory();
            }
            this.enableOrAlgChanged();
            this.enabled = _enabled;
            if (!this.enabled) {
                this.adapter.setLimits(this.original_limits, true, this.provider.getAdjustsDownloadLimits());
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public DHTSpeedTester getSpeedTester() {
        return this.speed_tester;
    }

    @Override
    public SpeedManagerPingSource[] getPingSources() {
        return this.contacts_array;
    }

    @Override
    public SpeedManagerPingMapper getActiveMapper() {
        return this.ping_mapper;
    }

    @Override
    public SpeedManagerPingMapper getPingMapper() {
        return this.getActiveMapper();
    }

    @Override
    public SpeedManagerPingMapper[] getMappers() {
        return this.ping_mappers;
    }

    public int getIdlePingMillis() {
        return this.provider.getIdlePingMillis();
    }

    public int getCurrentPingMillis() {
        return this.provider.getCurrentPingMillis();
    }

    public int getMaxPingMillis() {
        return this.provider.getMaxPingMillis();
    }

    public int getCurrentChokeSpeed() {
        return this.provider.getCurrentChokeSpeed();
    }

    public int getMaxUploadSpeed() {
        return this.provider.getMaxUploadSpeed();
    }

    @Override
    public int getCurrentUploadLimit() {
        return this.adapter.getCurrentUploadLimit();
    }

    @Override
    public void setCurrentUploadLimit(int bytes_per_second) {
        if (this.enabled) {
            this.adapter.setCurrentUploadLimit(bytes_per_second);
        }
    }

    @Override
    public int getCurrentDownloadLimit() {
        return this.adapter.getCurrentDownloadLimit();
    }

    @Override
    public void setCurrentDownloadLimit(int bytes_per_second) {
        if (this.enabled) {
            this.adapter.setCurrentDownloadLimit(bytes_per_second);
        }
    }

    @Override
    public int getCurrentProtocolUploadSpeed() {
        return this.adapter.getCurrentProtocolUploadSpeed(-1);
    }

    @Override
    public int getCurrentDataUploadSpeed() {
        return this.adapter.getCurrentDataUploadSpeed(-1);
    }

    @Override
    public int getCurrentDataDownloadSpeed() {
        return this.adapter.getCurrentDataDownloadSpeed(-1);
    }

    @Override
    public int getCurrentProtocolDownloadSpeed() {
        return this.adapter.getCurrentProtocolDownloadSpeed(-1);
    }

    private void autoAdjust() {
        if (COConfigurationManager.getBooleanParameter("Auto Adjust Transfer Defaults")) {
            int up_limit_bytes_per_sec = this.getEstimatedUploadCapacityBytesPerSec().getBytesPerSec();
            int down_limit_bytes_per_sec = this.getEstimatedDownloadCapacityBytesPerSec().getBytesPerSec();
            int up_kbs = up_limit_bytes_per_sec / 1024;
            int[][] settings = new int[][]{{56, 2, 20, 40}, {96, 3, 30, 60}, {128, 3, 40, 80}, {192, 4, 50, 100}, {256, 4, 60, 200}, {512, 5, 70, 300}, {1024, 6, 80, 400}, {2048, 8, 90, 500}, {5120, 10, 100, 600}, {10240, 20, 110, 750}, {20480, 30, 120, 900}, {51200, 40, 130, 1100}, {102400, 50, 140, 1300}, {-1, 60, 150, 1500}};
            int[] selected = settings[settings.length - 1];
            int i = 3;
            while (i < settings.length) {
                int[] setting = settings[i];
                int line_kilobit_sec = setting[0];
                int limit = line_kilobit_sec / 8 * 4 / 5;
                if (up_kbs <= limit) {
                    selected = setting;
                    break;
                }
                ++i;
            }
            int upload_slots = selected[1];
            int connections_torrent = selected[2];
            int connections_global = selected[3];
            if (upload_slots != COConfigurationManager.getIntParameter("Max Uploads")) {
                COConfigurationManager.setParameter("Max Uploads", upload_slots);
                COConfigurationManager.setParameter("Max Uploads Seeding", upload_slots);
            }
            if (connections_torrent != COConfigurationManager.getIntParameter("Max.Peer.Connections.Per.Torrent")) {
                COConfigurationManager.setParameter("Max.Peer.Connections.Per.Torrent", connections_torrent);
                COConfigurationManager.setParameter("Max.Peer.Connections.Per.Torrent.When.Seeding", connections_torrent / 2);
            }
            if (connections_global != COConfigurationManager.getIntParameter("Max.Peer.Connections.Total")) {
                COConfigurationManager.setParameter("Max.Peer.Connections.Total", connections_global);
            }
        }
    }

    public void setLoggingEnabled(boolean enabled) {
        COConfigurationManager.setParameter(CONFIG_DEBUG, enabled);
    }

    @Override
    public void log(String str) {
        if (DEBUG) {
            this.logger.log(str);
        }
    }

    protected void informDownCapChanged() {
        this.informListeners(3);
    }

    protected void informUpCapChanged() {
        this.informListeners(2);
    }

    protected void informListeners(int type) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((SpeedManagerListener)it.next()).propertyChanged(type);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void addListener(SpeedManagerListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(SpeedManagerListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println("SpeedManager: enabled=" + this.enabled + ",provider=" + this.provider);
        try {
            writer.indent();
            this.ping_mapper.generateEvidence(writer);
        }
        finally {
            writer.exdent();
        }
    }

    protected class SMUnlimited
    implements SpeedManagerAlgorithmProvider {
        private int good_signals;

        protected SMUnlimited() {
        }

        @Override
        public void destroy() {
        }

        @Override
        public void reset() {
            SpeedManagerImpl.this.adapter.setCurrentDownloadLimit(0);
            SpeedManagerImpl.this.adapter.setCurrentUploadLimit(0);
        }

        @Override
        public void updateStats() {
        }

        @Override
        public void pingSourceFound(SpeedManagerPingSource source, boolean is_replacement) {
        }

        @Override
        public void pingSourceFailed(SpeedManagerPingSource source) {
        }

        @Override
        public void calculate(SpeedManagerPingSource[] sources) {
            SpeedManagerLimitEstimate est = SpeedManagerImpl.this.ping_mapper.getEstimatedUploadLimit(true);
            if (est != null) {
                double metric_rating = SpeedManagerImpl.this.ping_mapper.getCurrentMetricRating();
                this.good_signals = metric_rating == 1.0 ? ++this.good_signals : 0;
                if (metric_rating == -1.0) {
                    SpeedManagerImpl.this.adapter.setCurrentUploadLimit(est.getBytesPerSec() + (this.good_signals < 3 ? -1024 : 1024));
                } else if (metric_rating <= 0.0) {
                    SpeedManagerImpl.this.adapter.setCurrentUploadLimit(est.getBytesPerSec() + 1024);
                } else {
                    SpeedManagerImpl.this.adapter.setCurrentUploadLimit(est.getBytesPerSec() + 5120);
                }
            }
        }

        @Override
        public int getIdlePingMillis() {
            return 0;
        }

        @Override
        public int getCurrentPingMillis() {
            return 0;
        }

        @Override
        public int getMaxPingMillis() {
            return 0;
        }

        @Override
        public int getCurrentChokeSpeed() {
            return 0;
        }

        @Override
        public int getMaxUploadSpeed() {
            return 0;
        }

        @Override
        public boolean getAdjustsDownloadLimits() {
            return true;
        }
    }

    protected class nullProvider
    implements SpeedManagerAlgorithmProvider {
        protected nullProvider() {
        }

        @Override
        public void reset() {
        }

        @Override
        public void destroy() {
        }

        @Override
        public void updateStats() {
        }

        @Override
        public void pingSourceFound(SpeedManagerPingSource source, boolean is_replacement) {
        }

        @Override
        public void pingSourceFailed(SpeedManagerPingSource source) {
        }

        @Override
        public void calculate(SpeedManagerPingSource[] sources) {
        }

        @Override
        public int getIdlePingMillis() {
            return 0;
        }

        @Override
        public int getCurrentPingMillis() {
            return 0;
        }

        @Override
        public int getMaxPingMillis() {
            return 0;
        }

        @Override
        public int getCurrentChokeSpeed() {
            return 0;
        }

        @Override
        public int getMaxUploadSpeed() {
            return 0;
        }

        @Override
        public boolean getAdjustsDownloadLimits() {
            return false;
        }
    }

    protected class pingContact
    implements SpeedManagerPingSource {
        private DHTSpeedTesterContact contact;
        private int ping_time;

        protected pingContact(DHTSpeedTesterContact _contact) {
            this.contact = _contact;
        }

        protected void setPingTime(int time) {
            this.ping_time = time;
        }

        @Override
        public InetSocketAddress getAddress() {
            return this.contact.getAddress();
        }

        @Override
        public int getPingTime() {
            return this.ping_time;
        }

        @Override
        public void destroy() {
            this.contact.destroy();
        }
    }
}

