/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.nat;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.nat.NATTraversal;
import com.aelitis.azureus.core.nat.NATTraversalHandler;
import com.aelitis.azureus.core.nat.NATTraversalObserver;
import com.aelitis.azureus.core.nat.NATTraverser;
import com.aelitis.azureus.core.peermanager.nat.PeerNATInitiator;
import com.aelitis.azureus.core.peermanager.nat.PeerNATTraversalAdapter;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class PeerNATTraverser
implements NATTraversalHandler {
    private static final LogIDs LOGID = LogIDs.PEER;
    private static final int OUTCOME_SUCCESS = 0;
    private static final int OUTCOME_FAILED_NO_REND = 1;
    private static final int OUTCOME_FAILED_OTHER = 2;
    private static PeerNATTraverser singleton;
    private static int MAX_ACTIVE_REQUESTS;
    private static final int TIMER_PERIOD = 10000;
    private static final int USAGE_PERIOD = 10000;
    private static final int USAGE_DURATION_SECS = 60;
    private static final int MAX_USAGE_PER_MIN;
    private static final int STATS_TICK_COUNT = 12;
    private NATTraverser nat_traverser;
    private Map initiators = new HashMap();
    private LinkedList pending_requests = new LinkedList();
    private List active_requests = new ArrayList();
    private Average usage_average = Average.getInstance(10000, 60);
    private int attempted_count = 0;
    private int success_count = 0;
    private int failed_no_rendezvous = 0;
    private int failed_negative_bloom = 0;
    private BloomFilter negative_result_bloom = BloomFilterFactory.createAddOnly(BLOOM_SIZE);
    private static final int BLOOM_SIZE;
    private static final int BLOOM_REBUILD_PERIOD = 300000;
    private static final int BLOOM_REBUILD_TICKS = 30;

    static {
        COConfigurationManager.addAndFireParameterListener("peer.nat.traversal.request.conc.max", new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                MAX_ACTIVE_REQUESTS = COConfigurationManager.getIntParameter(name);
            }
        });
        MAX_USAGE_PER_MIN = MAX_ACTIVE_REQUESTS * 5 * 1000;
        BLOOM_SIZE = MAX_ACTIVE_REQUESTS * 1024;
    }

    public static void initialise(AzureusCore core) {
        singleton = new PeerNATTraverser(core);
    }

    public static PeerNATTraverser getSingleton() {
        return singleton;
    }

    private PeerNATTraverser(AzureusCore core) {
        this.nat_traverser = core.getNATTraverser();
        this.nat_traverser.registerHandler(this);
        SimpleTimer.addPeriodicEvent("PeerNAT:stats", 10000L, new TimerEventPerformer(){
            private int ticks;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event2) {
                ++this.ticks;
                ArrayList<PeerNATTraversal> to_run = null;
                Map map = PeerNATTraverser.this.initiators;
                synchronized (map) {
                    if (this.ticks % 30 == 0) {
                        int size = PeerNATTraverser.this.negative_result_bloom.getEntryCount();
                        if (Logger.isEnabled() && size > 0) {
                            Logger.log(new LogEvent(LOGID, "PeerNATTraverser: negative bloom size = " + size));
                        }
                        PeerNATTraverser.this.negative_result_bloom = BloomFilterFactory.createAddOnly(BLOOM_SIZE);
                    }
                    if (this.ticks % 12 == 0) {
                        String msg = "NAT traversal stats: active=" + PeerNATTraverser.this.active_requests.size() + ",pending=" + PeerNATTraverser.this.pending_requests.size() + ",attempted=" + PeerNATTraverser.this.attempted_count + ",no rendezvous=" + PeerNATTraverser.this.failed_no_rendezvous + ",negative bloom=" + PeerNATTraverser.this.failed_negative_bloom + ",successful=" + PeerNATTraverser.this.success_count;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, msg));
                        }
                    }
                    int used = 0;
                    int i = 0;
                    while (i < PeerNATTraverser.this.active_requests.size()) {
                        used = (int)((long)used + ((PeerNATTraversal)PeerNATTraverser.this.active_requests.get(i)).getTimeUsed());
                        ++i;
                    }
                    PeerNATTraverser.this.usage_average.addValue(used);
                    int usage = (int)PeerNATTraverser.this.usage_average.getAverage();
                    if (usage > MAX_USAGE_PER_MIN) {
                        return;
                    }
                    while (PeerNATTraverser.this.pending_requests.size() != 0 && PeerNATTraverser.this.active_requests.size() < MAX_ACTIVE_REQUESTS) {
                        PeerNATTraversal traversal = (PeerNATTraversal)PeerNATTraverser.this.pending_requests.removeFirst();
                        PeerNATTraverser.this.active_requests.add(traversal);
                        if (to_run == null) {
                            to_run = new ArrayList<PeerNATTraversal>();
                        }
                        to_run.add(traversal);
                        PeerNATTraverser peerNATTraverser = PeerNATTraverser.this;
                        peerNATTraverser.attempted_count = peerNATTraverser.attempted_count + 1;
                    }
                }
                if (to_run != null) {
                    int i = 0;
                    while (i < to_run.size()) {
                        PeerNATTraversal traversal = (PeerNATTraversal)to_run.get(i);
                        boolean bad = false;
                        Map map2 = PeerNATTraverser.this.initiators;
                        synchronized (map2) {
                            if (PeerNATTraverser.this.negative_result_bloom.contains(traversal.getTarget().toString().getBytes())) {
                                bad = true;
                                PeerNATTraverser peerNATTraverser = PeerNATTraverser.this;
                                peerNATTraverser.failed_negative_bloom = peerNATTraverser.failed_negative_bloom + 1;
                            }
                        }
                        if (bad) {
                            PeerNATTraverser.this.removeRequest(traversal, 2);
                            traversal.getAdapter().failed();
                        } else {
                            traversal.run();
                        }
                        ++i;
                    }
                }
            }
        });
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getName() {
        return "Peer Traversal";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(PeerNATInitiator initiator) {
        Map map = this.initiators;
        synchronized (map) {
            if (this.initiators.put(initiator, new LinkedList()) != null) {
                Debug.out("initiator already present");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(PeerNATInitiator initiator) {
        LinkedList to_cancel;
        Map map = this.initiators;
        synchronized (map) {
            LinkedList requests = (LinkedList)this.initiators.remove(initiator);
            if (requests == null) {
                Debug.out("initiator not present");
                return;
            }
            to_cancel = requests;
        }
        for (PeerNATTraversal traversal : to_cancel) {
            traversal.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(PeerNATInitiator initiator, InetSocketAddress target, PeerNATTraversalAdapter adapter) {
        boolean bad = false;
        Map map = this.initiators;
        synchronized (map) {
            if (this.negative_result_bloom.contains(target.toString().getBytes())) {
                bad = true;
                ++this.failed_negative_bloom;
            } else {
                LinkedList requests = (LinkedList)this.initiators.get(initiator);
                if (requests == null) {
                    bad = true;
                } else {
                    PeerNATTraversal traversal = new PeerNATTraversal(initiator, target, adapter);
                    requests.addLast(traversal);
                    this.pending_requests.addLast(traversal);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "created NAT traversal for " + initiator.getDisplayName() + "/" + target));
                    }
                }
            }
        }
        if (bad) {
            adapter.failed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTraversals(PeerNATInitiator initiator) {
        ArrayList<InetSocketAddress> result = new ArrayList<InetSocketAddress>();
        Map map = this.initiators;
        synchronized (map) {
            LinkedList requests = (LinkedList)this.initiators.get(initiator);
            if (requests != null) {
                for (PeerNATTraversal x : requests) {
                    result.add(x.getTarget());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRequest(PeerNATTraversal request2, int outcome) {
        Map map = this.initiators;
        synchronized (map) {
            LinkedList requests = (LinkedList)this.initiators.get(request2.getInitiator());
            if (requests != null) {
                requests.remove(request2);
            }
            this.pending_requests.remove(request2);
            if (this.active_requests.remove(request2)) {
                this.usage_average.addValue(request2.getTimeUsed());
                if (outcome == 0) {
                    ++this.success_count;
                } else {
                    InetSocketAddress target = request2.getTarget();
                    this.negative_result_bloom.add(target.toString().getBytes());
                    if (outcome == 1) {
                        ++this.failed_no_rendezvous;
                    }
                }
            }
        }
    }

    @Override
    public Map process(InetSocketAddress originator, Map data) {
        return null;
    }

    protected class PeerNATTraversal
    implements NATTraversalObserver {
        private PeerNATInitiator initiator;
        private InetSocketAddress target;
        private PeerNATTraversalAdapter adapter;
        private NATTraversal traversal;
        private boolean cancelled;
        private long time;

        protected PeerNATTraversal(PeerNATInitiator _initiator, InetSocketAddress _target, PeerNATTraversalAdapter _adapter) {
            this.initiator = _initiator;
            this.target = _target;
            this.adapter = _adapter;
        }

        protected PeerNATInitiator getInitiator() {
            return this.initiator;
        }

        protected InetSocketAddress getTarget() {
            return this.target;
        }

        protected PeerNATTraversalAdapter getAdapter() {
            return this.adapter;
        }

        protected long getTimeUsed() {
            long now = SystemTime.getCurrentTime();
            long elapsed = now - this.time;
            this.time = now;
            elapsed = elapsed < 0L ? 0L : Math.min(elapsed, 10000L);
            return elapsed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void run() {
            PeerNATTraversal peerNATTraversal = this;
            synchronized (peerNATTraversal) {
                if (!this.cancelled) {
                    this.time = SystemTime.getCurrentTime();
                    this.traversal = PeerNATTraverser.this.nat_traverser.attemptTraversal(PeerNATTraverser.this, this.target, null, false, this);
                }
            }
        }

        @Override
        public void succeeded(InetSocketAddress rendezvous, InetSocketAddress target, Map reply) {
            PeerNATTraverser.this.removeRequest(this, 0);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "NAT traversal for " + this.initiator.getDisplayName() + "/" + target + " succeeded"));
            }
            this.adapter.success(target);
        }

        @Override
        public void failed(int reason) {
            PeerNATTraverser.this.removeRequest(this, reason == 1 ? 1 : 2);
            this.adapter.failed();
        }

        @Override
        public void failed(Throwable cause) {
            PeerNATTraverser.this.removeRequest(this, 2);
            this.adapter.failed();
        }

        @Override
        public void disabled() {
            PeerNATTraverser.this.removeRequest(this, 2);
            this.adapter.failed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cancel() {
            NATTraversal active_traversal;
            PeerNATTraversal peerNATTraversal = this;
            synchronized (peerNATTraversal) {
                this.cancelled = true;
                active_traversal = this.traversal;
            }
            if (active_traversal == null) {
                PeerNATTraverser.this.removeRequest(this, 2);
            } else {
                active_traversal.cancel();
            }
            this.adapter.failed();
        }
    }
}

