/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.neuronal;

import com.aelitis.azureus.core.neuronal.ActivationFunction;

public class NeuralNetworkLayer {
    int numberOfNodes;
    double[][] weights;
    double[][] weightChanges;
    double[] neuronValues;
    double[] desiredValues;
    double[] errors;
    double[] biasWeights;
    double[] biasValues;
    double learningRate;
    boolean linearOutput;
    boolean useMomentum;
    double momentumFactor;
    NeuralNetworkLayer parentLayer;
    NeuralNetworkLayer childLayer;
    ActivationFunction activationFunction;

    public NeuralNetworkLayer(int numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
        this.linearOutput = false;
        this.useMomentum = false;
        this.momentumFactor = 0.9;
    }

    public void initialize(NeuralNetworkLayer parentLayer, NeuralNetworkLayer childLayer) {
        this.neuronValues = new double[this.numberOfNodes];
        this.desiredValues = new double[this.numberOfNodes];
        this.errors = new double[this.numberOfNodes];
        this.parentLayer = parentLayer;
        if (childLayer != null) {
            this.childLayer = childLayer;
            this.weights = new double[this.numberOfNodes][childLayer.getNumberOfNodes()];
            this.weightChanges = new double[this.numberOfNodes][childLayer.getNumberOfNodes()];
            this.biasValues = new double[childLayer.getNumberOfNodes()];
            this.biasWeights = new double[childLayer.getNumberOfNodes()];
            int j = 0;
            while (j < childLayer.getNumberOfNodes()) {
                this.biasValues[j] = -1.0;
                this.biasWeights[j] = 0.0;
                ++j;
            }
        }
    }

    public void randomizeWeights() {
        int i = 0;
        while (i < this.numberOfNodes) {
            int j = 0;
            while (j < this.childLayer.getNumberOfNodes()) {
                this.weights[i][j] = Math.random() * 2.0 - 1.0;
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < this.childLayer.getNumberOfNodes()) {
            this.biasWeights[j] = Math.random() * 2.0 - 1.0;
            ++j;
        }
    }

    public void calculateNeuronValues() {
        if (this.parentLayer != null) {
            int j = 0;
            while (j < this.numberOfNodes) {
                double x = 0.0;
                int i = 0;
                while (i < this.parentLayer.getNumberOfNodes()) {
                    x += this.parentLayer.neuronValues[i] * this.parentLayer.weights[i][j];
                    ++i;
                }
                this.neuronValues[j] = this.childLayer == null && this.linearOutput ? x : this.activationFunction.getValueFor(x += this.parentLayer.biasValues[j] * this.parentLayer.biasWeights[j]);
                ++j;
            }
        }
    }

    public void calculateErrors() {
        if (this.childLayer == null) {
            int i = 0;
            while (i < this.numberOfNodes) {
                this.errors[i] = (this.desiredValues[i] - this.neuronValues[i]) * this.activationFunction.getDerivedFunctionValueFor(this.neuronValues[i]);
                ++i;
            }
        } else if (this.parentLayer == null) {
            int i = 0;
            while (i < this.numberOfNodes) {
                this.errors[i] = 0.0;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.numberOfNodes) {
                double sum = 0.0;
                int j = 0;
                while (j < this.childLayer.getNumberOfNodes()) {
                    sum += this.childLayer.errors[j] * this.weights[i][j];
                    ++j;
                }
                this.errors[i] = sum * this.activationFunction.getDerivedFunctionValueFor(this.neuronValues[i]);
                ++i;
            }
        }
    }

    public void adjustWeights() {
        if (this.childLayer != null) {
            int i = 0;
            while (i < this.numberOfNodes) {
                int j = 0;
                while (j < this.childLayer.getNumberOfNodes()) {
                    double dw = this.learningRate * this.childLayer.errors[j] * this.neuronValues[i];
                    if (this.useMomentum) {
                        double[] dArray = this.weights[i];
                        int n = j;
                        dArray[n] = dArray[n] + (dw + this.momentumFactor * this.weightChanges[i][j]);
                        this.weightChanges[i][j] = dw;
                    } else {
                        double[] dArray = this.weights[i];
                        int n = j;
                        dArray[n] = dArray[n] + dw;
                    }
                    ++j;
                }
                ++i;
            }
            int j = 0;
            while (j < this.childLayer.getNumberOfNodes()) {
                int n = j;
                this.biasWeights[n] = this.biasWeights[n] + this.learningRate * this.childLayer.errors[j] * this.biasValues[j];
                ++j;
            }
        }
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
    }

    public void setMomentum(boolean useMomentum, double factor) {
        this.useMomentum = useMomentum;
        this.momentumFactor = factor;
    }

    public void setLearningRate(double rate) {
        this.learningRate = rate;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.childLayer != null) {
            int j = 0;
            while (j < this.childLayer.getNumberOfNodes()) {
                sb.append(j);
                sb.append("\t> ");
                int i = 0;
                while (i < this.numberOfNodes) {
                    sb.append(i);
                    sb.append(":");
                    sb.append(this.weights[i][j]);
                    sb.append("\t");
                    ++i;
                }
                sb.append("\n");
                ++j;
            }
        }
        return sb.toString();
    }
}

