/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.utp;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPConnectionManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class UTPSelector {
    private static final int POLL_FREQUENCY = COConfigurationManager.getIntParameter("network.utp.poll.time", 50);
    private AEThread2 thread;
    private List<Object[]> ready_set = new LinkedList<Object[]>();
    private AESemaphore ready_sem = new AESemaphore("UTPSelector");
    private volatile boolean destroyed;

    protected UTPSelector(final UTPConnectionManager manager) {
        this.thread = new AEThread2("UTPSelector", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean quit = false;
                long last_poll = 0L;
                int last_connection_count = 0;
                while (!quit) {
                    Object[] entry;
                    long now;
                    if (UTPSelector.this.destroyed) {
                        quit = true;
                    }
                    if ((now = SystemTime.getMonotonousTime()) - last_poll >= (long)POLL_FREQUENCY) {
                        last_connection_count = manager.poll(UTPSelector.this.ready_sem, now);
                        last_poll = now;
                    }
                    if (UTPSelector.this.ready_sem.getValue() == 0) {
                        manager.inputIdle();
                    }
                    if (!UTPSelector.this.ready_sem.reserve(last_connection_count == 0 ? 1000 : POLL_FREQUENCY / 2)) continue;
                    List list = UTPSelector.this.ready_set;
                    synchronized (list) {
                        if (UTPSelector.this.ready_set.size() == 0) {
                            continue;
                        }
                        entry = (Object[])UTPSelector.this.ready_set.remove(0);
                    }
                    TransportHelper transport = (TransportHelper)entry[0];
                    TransportHelper.selectListener listener = (TransportHelper.selectListener)entry[1];
                    if (listener == null) {
                        Debug.out("Null listener");
                        continue;
                    }
                    Object attachment = entry[2];
                    try {
                        if (entry.length == 3) {
                            listener.selectSuccess(transport, attachment);
                            continue;
                        }
                        listener.selectFailure(transport, attachment, (Throwable)entry[3]);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        };
        this.thread.setPriority(9);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        List<Object[]> list = this.ready_set;
        synchronized (list) {
            this.destroyed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ready(TransportHelper transport, TransportHelper.selectListener listener, Object attachment) {
        boolean removed = false;
        List<Object[]> list = this.ready_set;
        synchronized (list) {
            if (this.destroyed) {
                Debug.out("Selector has been destroyed");
                throw new RuntimeException("Selector has been destroyed");
            }
            Iterator<Object[]> it = this.ready_set.iterator();
            while (it.hasNext()) {
                Object[] entry = it.next();
                if (entry[1] != listener) continue;
                it.remove();
                removed = true;
                break;
            }
            this.ready_set.add(new Object[]{transport, listener, attachment});
        }
        if (!removed) {
            this.ready_sem.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ready(TransportHelper transport, TransportHelper.selectListener listener, Object attachment, Throwable error) {
        boolean removed = false;
        List<Object[]> list = this.ready_set;
        synchronized (list) {
            if (this.destroyed) {
                Debug.out("Selector has been destroyed");
                throw new RuntimeException("Selector has been destroyed");
            }
            Iterator<Object[]> it = this.ready_set.iterator();
            while (it.hasNext()) {
                Object[] entry = it.next();
                if (entry[1] != listener) continue;
                it.remove();
                removed = true;
                break;
            }
            this.ready_set.add(new Object[]{transport, listener, attachment, error});
        }
        if (!removed) {
            this.ready_sem.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel(TransportHelper transport, TransportHelper.selectListener listener) {
        List<Object[]> list = this.ready_set;
        synchronized (list) {
            Iterator<Object[]> it = this.ready_set.iterator();
            while (it.hasNext()) {
                Object[] entry = it.next();
                if (entry[0] != transport || entry[1] != listener) continue;
                it.remove();
                break;
            }
        }
    }
}

