/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.utp;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpointFactory;
import com.aelitis.azureus.core.networkmanager.impl.IncomingConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TransportCryptoManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.utp.ProtocolEndpointUTP;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPConnection;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPSelector;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPTransport;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.utp.UTPUtils;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.vuze.client.plugins.utp.UTPPlugin;
import com.vuze.client.plugins.utp.UTPProvider;
import com.vuze.client.plugins.utp.UTPProviderCallback;
import com.vuze.client.plugins.utp.UTPProviderFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;

public class UTPConnectionManager {
    private static final int MIN_MSS = 256;
    private static final int MAX_HEADER = 128;
    public static final int MIN_WRITE_PAYLOAD = 128;
    public static final int MAX_BUFFERED_PAYLOAD = 512;
    private static final int CLOSING_TIMOUT = 120000;
    private static final int UTP_PROVIDER_TIMEOUT = 30000;
    private static final LogIDs LOGID = LogIDs.NET;
    private boolean initialised;
    private UTPPlugin plugin;
    private PRUDPPacketHandler packet_handler;
    private int local_port;
    private IncomingConnectionManager incoming_manager = IncomingConnectionManager.getSingleton();
    private AsyncDispatcher dispatcher = new AsyncDispatcher();
    private UTPSelector selector;
    private List<UTPConnection> connections = new ArrayList<UTPConnection>();
    private Map<InetAddress, List<UTPConnection>> address_connection_map = new HashMap<InetAddress, List<UTPConnection>>();
    private Map<Long, UTPConnection> socket_connection_map = new HashMap<Long, UTPConnection>();
    private Set<UTPConnection> closing_connections = new HashSet<UTPConnection>();
    private UTPConnection active_write;
    private ByteBuffer[] active_write_buffers;
    private int active_write_start;
    private int active_write_len;
    private static final long MAX_INCOMING_QUEUED = 0x400000L;
    private static final long MAX_INCOMING_QUEUED_LOG_OK = 0x3C0000L;
    public static final int DEFAULT_RECV_BUFFER_KB = 1024;
    public static final int DEFAULT_SEND_BUFFER_KB = 1024;
    private long total_incoming_queued;
    private int total_incoming_queued_log_state;
    private boolean available;
    private boolean hack_worked;
    private long last_hack_attempt;
    private Object last_hack;
    private boolean prefer_utp;
    private UTPProvider utp_provider = UTPProviderFactory.createProvider();
    private volatile AESemaphore poll_waiter;
    private AERunnable inputIdleDispatcher = new AERunnable(){

        @Override
        public void runSupport() {
            try {
                UTPConnectionManager.this.utp_provider.incomingIdle();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    };

    public UTPConnectionManager(UTPPlugin _plugin) {
        this.plugin = _plugin;
        this.dispatcher.setPriority(9);
    }

    public int getProviderVersion() {
        return this.utp_provider.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(PRUDPPacketHandler _handler) {
        this.packet_handler = _handler;
        this.local_port = this.packet_handler.getPort();
        UTPConnectionManager uTPConnectionManager = this;
        synchronized (uTPConnectionManager) {
            if (this.initialised) {
                return;
            }
            this.initialised = true;
        }
        final AESemaphore init_sem = new AESemaphore("uTP:init");
        PluginInterface pi = this.plugin.getPluginInterface();
        final File plugin_user_dir = pi.getPluginconfig().getPluginUserFile("plugin.properties").getParentFile();
        File plugin_install_dir = new File(pi.getPluginDirectoryName());
        if (plugin_install_dir == null || !plugin_install_dir.exists()) {
            plugin_install_dir = plugin_user_dir;
        }
        final File f_plugin_install_dir = plugin_install_dir;
        try {
            this.available = this.utp_provider.load(new UTPProviderCallback(){

                @Override
                public File getPluginUserDir() {
                    return plugin_user_dir;
                }

                @Override
                public File getPluginInstallDir() {
                    return f_plugin_install_dir;
                }

                @Override
                public void log(String str, Throwable error) {
                    UTPConnectionManager.this.plugin.log(str, error);
                }

                @Override
                public int getRandom() {
                    return UTPUtils.UTP_Random();
                }

                @Override
                public long getMilliseconds() {
                    return UTPUtils.UTP_GetMilliseconds();
                }

                @Override
                public long getMicroseconds() {
                    return UTPUtils.UTP_GetMicroseconds();
                }

                @Override
                public void incomingConnection(String host, int port, long utp_socket, long con_id) {
                    init_sem.reserve();
                    UTPConnectionManager.this.accept(new InetSocketAddress(host, port), utp_socket, con_id);
                }

                @Override
                public void incomingConnection(InetSocketAddress adress, long utp_socket, long con_id) {
                    init_sem.reserve();
                    UTPConnectionManager.this.accept(adress, utp_socket, con_id);
                }

                @Override
                public boolean send(String address, int port, byte[] buffer, int length) {
                    return UTPConnectionManager.this.plugin.send(new InetSocketAddress(address, port), buffer, length);
                }

                @Override
                public boolean send(InetSocketAddress adress, byte[] buffer, int length) {
                    return UTPConnectionManager.this.plugin.send(adress, buffer, length);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void read(long utp_socket, byte[] data) {
                    UTPConnection connection;
                    UTPConnectionManager uTPConnectionManager = UTPConnectionManager.this;
                    synchronized (uTPConnectionManager) {
                        connection = (UTPConnection)UTPConnectionManager.this.socket_connection_map.get(utp_socket);
                    }
                    if (connection == null) {
                        Debug.out("read: unknown socket!");
                    } else {
                        try {
                            connection.receive(ByteBuffer.wrap(data));
                        }
                        catch (Throwable e) {
                            connection.close(Debug.getNestedExceptionMessage(e));
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void read(long utp_socket, ByteBuffer bb) {
                    UTPConnection connection;
                    UTPConnectionManager uTPConnectionManager = UTPConnectionManager.this;
                    synchronized (uTPConnectionManager) {
                        connection = (UTPConnection)UTPConnectionManager.this.socket_connection_map.get(utp_socket);
                    }
                    if (connection == null) {
                        Debug.out("read: unknown socket!");
                    } else {
                        try {
                            connection.receive(bb);
                        }
                        catch (Throwable e) {
                            connection.close(Debug.getNestedExceptionMessage(e));
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(long utp_socket, byte[] data, int offset, int length) {
                    UTPConnection connection;
                    UTPConnectionManager uTPConnectionManager = UTPConnectionManager.this;
                    synchronized (uTPConnectionManager) {
                        connection = (UTPConnection)UTPConnectionManager.this.socket_connection_map.get(utp_socket);
                    }
                    if (connection == null) {
                        Debug.out("write: unknown socket!");
                    } else {
                        try {
                            if (UTPConnectionManager.this.utp_provider.getVersion() != 1) {
                                throw new Exception("Invalid flow control");
                            }
                            if (UTPConnectionManager.this.active_write != connection) {
                                throw new Exception("Write for incorrect connection!");
                            }
                            int pos = offset;
                            int rem = length;
                            int i = UTPConnectionManager.this.active_write_start;
                            while (i < UTPConnectionManager.this.active_write_start + UTPConnectionManager.this.active_write_len && rem > 0) {
                                ByteBuffer b = UTPConnectionManager.this.active_write_buffers[i];
                                int remaining = b.remaining();
                                if (remaining > 0) {
                                    int to_read = Math.min(rem, remaining);
                                    b.get(data, pos, to_read);
                                    pos += to_read;
                                    rem -= to_read;
                                }
                                ++i;
                            }
                            if (rem != 0) {
                                throw new Exception("insufficient data available for write operation");
                            }
                        }
                        catch (Throwable e) {
                            connection.close(Debug.getNestedExceptionMessage(e));
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int getReadBufferSize(long utp_socket) {
                    UTPConnection connection;
                    UTPConnectionManager uTPConnectionManager = UTPConnectionManager.this;
                    synchronized (uTPConnectionManager) {
                        connection = (UTPConnection)UTPConnectionManager.this.socket_connection_map.get(utp_socket);
                    }
                    if (connection == null) {
                        return 0;
                    }
                    int res = connection.getReceivePendingSize();
                    if (res > 524288) {
                        res = Integer.MAX_VALUE;
                    }
                    return res;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void setState(long utp_socket, int state) {
                    UTPConnection connection;
                    UTPConnectionManager uTPConnectionManager = UTPConnectionManager.this;
                    synchronized (uTPConnectionManager) {
                        connection = (UTPConnection)UTPConnectionManager.this.socket_connection_map.get(utp_socket);
                    }
                    if (connection != null) {
                        if (state == 1) {
                            connection.setConnected();
                        }
                        if (state == 1 || state == 2) {
                            connection.setCanWrite(true);
                        } else if (state == 3) {
                            connection.close("EOF");
                        } else if (state == 4) {
                            connection.setUnusable();
                            connection.close("Connection destroyed");
                            if (UTPConnectionManager.this.closing_connections.remove(connection)) {
                                UTPConnectionManager.this.removeConnection(connection);
                            }
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void error(long utp_socket, int error) {
                    UTPConnection connection;
                    UTPConnectionManager uTPConnectionManager = UTPConnectionManager.this;
                    synchronized (uTPConnectionManager) {
                        connection = (UTPConnection)UTPConnectionManager.this.socket_connection_map.get(utp_socket);
                    }
                    if (connection != null) {
                        connection.close("Socket error: code=" + error);
                    }
                }

                @Override
                public void overhead(long utp_socket, boolean send, int size, int type) {
                }
            });
            if (this.available) {
                this.hackHandler();
                this.selector = new UTPSelector(this);
                ProtocolEndpointUTP.register(this);
            }
        }
        finally {
            init_sem.releaseForever();
        }
    }

    public void deactivate() {
    }

    public UTPConnection connect(final InetSocketAddress target, final UTPTransportHelper transport) throws IOException {
        if (target.isUnresolved()) {
            throw new UnknownHostException(target.getHostName());
        }
        final Object[] result = new Object[1];
        final AESemaphore sem = new AESemaphore("uTP:connect");
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                block6: {
                    try {
                        try {
                            long[] x = UTPConnectionManager.this.utp_provider.connect(target.getAddress().getHostAddress(), target.getPort());
                            if (x != null) {
                                result[0] = UTPConnectionManager.this.addConnection(target, transport, x[0], x[1]);
                                break block6;
                            }
                            result[0] = new IOException("Connect failed");
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            result[0] = new IOException("Connect failed: " + Debug.getNestedExceptionMessage(e));
                            sem.release();
                        }
                    }
                    finally {
                        sem.release();
                    }
                }
            }
        });
        if (!sem.reserve(30000L)) {
            Debug.out("Deadlock probably detected");
            throw new IOException("Deadlock");
        }
        if (result[0] instanceof UTPConnection) {
            return (UTPConnection)result[0];
        }
        throw (IOException)result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receive(InetSocketAddress from, byte[] data, int length) {
        if (!this.available) {
            return false;
        }
        InetAddress address = from.getAddress();
        if (address instanceof Inet4Address && length >= 20) {
            int type;
            byte first_byte = data[0];
            if (first_byte == 65 && data[8] == 0 && data[9] == 0 && data[10] == 0 && data[11] == 0 && data[18] == 0 && data[19] == 0) {
                return this.doReceive(address.getHostAddress(), from.getPort(), data, length);
            }
            if ((first_byte & 0xF) == 1 && (type = data[0] >>> 4 & 0xF) >= 0 && type <= 4) {
                int con_id = data[2] << 8 & 0xFF00 | data[3] & 0xFF;
                UTPConnection connection = null;
                UTPConnectionManager uTPConnectionManager = this;
                synchronized (uTPConnectionManager) {
                    List<UTPConnection> l = this.address_connection_map.get(address);
                    if (l != null) {
                        for (UTPConnection c : l) {
                            if (c.getConnectionID() != (long)con_id) continue;
                            connection = c;
                            break;
                        }
                    }
                }
                if (connection != null) {
                    return this.doReceive(address.getHostAddress(), from.getPort(), data, length);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doReceive(final String from_address, final int from_port, final byte[] data, final int length) {
        if (!this.utp_provider.isValidPacket(data, length)) {
            return false;
        }
        UTPConnectionManager uTPConnectionManager = this;
        synchronized (uTPConnectionManager) {
            block7: {
                if (this.total_incoming_queued <= 0x400000L) break block7;
                if (this.total_incoming_queued_log_state == 0) {
                    Debug.out("uTP pending packet queue too large, discarding...");
                    this.total_incoming_queued_log_state = 1;
                }
                return true;
            }
            if (this.total_incoming_queued_log_state == 1 && this.total_incoming_queued < 0x3C0000L) {
                Debug.out("uTP pending packet queue emptied, processing...");
                this.total_incoming_queued_log_state = 0;
            }
            this.total_incoming_queued += (long)length;
        }
        this.dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                UTPConnectionManager uTPConnectionManager = UTPConnectionManager.this;
                synchronized (uTPConnectionManager) {
                    UTPConnectionManager uTPConnectionManager2 = UTPConnectionManager.this;
                    uTPConnectionManager2.total_incoming_queued = uTPConnectionManager2.total_incoming_queued - (long)length;
                }
                try {
                    if (!UTPConnectionManager.this.utp_provider.receive(from_address, from_port, data, length) && Constants.IS_CVS_VERSION) {
                        Debug.out("Failed to process uTP packet: " + ByteFormatter.encodeString(data, 0, length) + " from " + from_address);
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        });
        return true;
    }

    private void accept(final InetSocketAddress remote_address, long utp_socket, long con_id) {
        final UTPConnection new_connection = this.addConnection(remote_address, null, utp_socket, con_id);
        final UTPTransportHelper helper = new UTPTransportHelper(this, remote_address, new_connection);
        this.log("Incoming connection from " + remote_address);
        try {
            new_connection.setTransport(helper);
            TransportCryptoManager.getSingleton().manageCrypto(helper, null, true, null, new TransportCryptoManager.HandshakeListener(){

                @Override
                public void handshakeSuccess(ProtocolDecoder decoder, ByteBuffer remaining_initial_data) {
                    TransportHelperFilter filter2 = decoder.getFilter();
                    ConnectionEndpoint co_ep = new ConnectionEndpoint(remote_address);
                    ProtocolEndpointUTP pe_utp = (ProtocolEndpointUTP)ProtocolEndpointFactory.createEndpoint(3, co_ep, remote_address);
                    UTPTransport transport = new UTPTransport(UTPConnectionManager.this, pe_utp, filter2);
                    helper.setTransport(transport);
                    UTPConnectionManager.this.incoming_manager.addConnection(UTPConnectionManager.this.local_port, filter2, transport);
                    UTPConnectionManager.this.log("Connection established to " + helper.getAddress());
                }

                @Override
                public void handshakeFailure(Throwable failure_msg) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "incoming crypto handshake failure: " + Debug.getNestedExceptionMessage(failure_msg)));
                    }
                    UTPConnectionManager.this.log("Failed to established connection to " + helper.getAddress() + ": " + Debug.getNestedExceptionMessage(failure_msg));
                    new_connection.close("handshake failure: " + Debug.getNestedExceptionMessage(failure_msg));
                }

                @Override
                public void gotSecret(byte[] session_secret) {
                }

                @Override
                public int getMaximumPlainHeaderLength() {
                    return UTPConnectionManager.this.incoming_manager.getMaxMinMatchBufferSize();
                }

                @Override
                public int matchPlainHeader(ByteBuffer buffer) {
                    Object[] match_data = UTPConnectionManager.this.incoming_manager.checkForMatch(helper, UTPConnectionManager.this.local_port, buffer, true);
                    if (match_data == null) {
                        return 1;
                    }
                    IncomingConnectionManager.MatchListener match = (IncomingConnectionManager.MatchListener)match_data[0];
                    if (match.autoCryptoFallback()) {
                        return 3;
                    }
                    return 2;
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            helper.close(Debug.getNestedExceptionMessage(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UTPConnection addConnection(InetSocketAddress remote_address, UTPTransportHelper transport_helper, long utp_socket, long con_id) {
        AESemaphore sem;
        ArrayList<UTPConnection> to_destroy = null;
        UTPConnection new_connection = new UTPConnection(this, remote_address, transport_helper, utp_socket, con_id);
        UTPConnectionManager uTPConnectionManager = this;
        synchronized (uTPConnectionManager) {
            List<UTPConnection> l = this.address_connection_map.get(remote_address.getAddress());
            if (l != null) {
                for (UTPConnection c : l) {
                    if (c.getConnectionID() != con_id) continue;
                    if (to_destroy == null) {
                        to_destroy = new ArrayList<UTPConnection>();
                    }
                    to_destroy.add(c);
                    l.remove(c);
                    this.connections.remove(c);
                    break;
                }
            } else {
                l = new ArrayList<UTPConnection>();
                this.address_connection_map.put(remote_address.getAddress(), l);
            }
            l.add(new_connection);
            this.connections.add(new_connection);
            UTPConnection existing = this.socket_connection_map.put(utp_socket, new_connection);
            if (existing != null) {
                Debug.out("Existing socket found at same address!!!!");
                if (to_destroy == null) {
                    to_destroy = new ArrayList();
                }
                to_destroy.add(existing);
            }
        }
        if (to_destroy != null) {
            for (UTPConnection c : to_destroy) {
                c.close("Connection replaced");
            }
        }
        if ((sem = this.poll_waiter) != null) {
            this.poll_waiter = null;
            sem.release();
        }
        return new_connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnection(UTPConnection c) {
        UTPConnectionManager uTPConnectionManager = this;
        synchronized (uTPConnectionManager) {
            UTPConnection existing;
            this.connections.remove(c);
            List<UTPConnection> l = this.address_connection_map.get(c.getRemoteAddress().getAddress());
            if (l != null) {
                l.remove(c);
                if (l.size() == 0) {
                    this.address_connection_map.remove(c.getRemoteAddress().getAddress());
                }
            }
            if ((existing = this.socket_connection_map.get(c.getSocket())) == c) {
                this.socket_connection_map.remove(c.getSocket());
            }
        }
    }

    protected UTPSelector getSelector() {
        return this.selector;
    }

    protected int poll(AESemaphore wait_sem, long now) {
        if (this.hack_worked && now - this.last_hack_attempt > 60000L) {
            this.last_hack_attempt = now;
            this.hackHandler();
        }
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                UTPConnectionManager.this.utp_provider.checkTimeouts();
                if (UTPConnectionManager.this.closing_connections.size() > 0) {
                    long now = SystemTime.getMonotonousTime();
                    Iterator it = UTPConnectionManager.this.closing_connections.iterator();
                    while (it.hasNext()) {
                        UTPConnection c = (UTPConnection)it.next();
                        long close_time = c.getCloseTime();
                        if (close_time <= 0L || now - close_time <= 120000L) continue;
                        it.remove();
                        UTPConnectionManager.this.removeConnection(c);
                        UTPConnectionManager.this.log("Removing " + c.getString() + " due to close timeout");
                    }
                }
            }
        });
        int result = this.connections.size();
        if (result == 0) {
            this.poll_waiter = wait_sem;
        }
        return result;
    }

    protected int write(final UTPConnection c, final ByteBuffer[] buffers, final int start, final int len) throws IOException {
        final AESemaphore sem = new AESemaphore("uTP:write");
        final Object[] result = new Object[1];
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                block17: {
                    boolean log_error = true;
                    try {
                        try {
                            if (c.isUnusable()) {
                                log_error = false;
                                throw new Exception("Connection is closed");
                            }
                            if (!c.isConnected()) {
                                log_error = false;
                                throw new Exception("Connection is closed");
                            }
                            if (!c.canWrite()) {
                                Debug.out("Write operation on non-writable connection");
                                result[0] = 0;
                                break block17;
                            }
                            if (UTPConnectionManager.this.utp_provider.getVersion() == 1) {
                                int pre_total = 0;
                                int i = start;
                                while (i < start + len) {
                                    pre_total += buffers[i].remaining();
                                    ++i;
                                }
                                try {
                                    UTPConnectionManager.this.active_write = c;
                                    UTPConnectionManager.this.active_write_buffers = buffers;
                                    UTPConnectionManager.this.active_write_start = start;
                                    UTPConnectionManager.this.active_write_len = len;
                                    boolean still_writable = UTPConnectionManager.this.utp_provider.write(c.getSocket(), pre_total);
                                    c.setCanWrite(still_writable);
                                }
                                finally {
                                    UTPConnectionManager.this.active_write = null;
                                    UTPConnectionManager.this.active_write_buffers = null;
                                }
                                int post_total = 0;
                                int i2 = start;
                                while (i2 < start + len) {
                                    post_total += buffers[i2].remaining();
                                    ++i2;
                                }
                                result[0] = pre_total - post_total;
                                break block17;
                            }
                            int pre_total = 0;
                            int i = start;
                            while (i < start + len) {
                                pre_total += buffers[i].remaining();
                                ++i;
                            }
                            boolean still_writable = UTPConnectionManager.this.utp_provider.write(c.getSocket(), buffers, start, len);
                            c.setCanWrite(still_writable);
                            int post_total = 0;
                            int i3 = start;
                            while (i3 < start + len) {
                                post_total += buffers[i3].remaining();
                                ++i3;
                            }
                            result[0] = pre_total - post_total;
                        }
                        catch (Throwable e) {
                            if (log_error) {
                                Debug.out(e);
                            }
                            c.close(Debug.getNestedExceptionMessage(e));
                            result[0] = new IOException("Write failed: " + Debug.getNestedExceptionMessage(e));
                            sem.release();
                        }
                    }
                    finally {
                        sem.release();
                    }
                }
            }
        });
        if (!sem.reserve(30000L)) {
            Debug.out("Deadlock probably detected");
            throw new IOException("Deadlock");
        }
        if (result[0] instanceof Integer) {
            return (Integer)result[0];
        }
        throw (IOException)result[0];
    }

    protected void inputIdle() {
        this.dispatcher.dispatch(this.inputIdleDispatcher);
    }

    protected void readBufferDrained(final UTPConnection c) {
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                if (!c.isUnusable()) {
                    try {
                        UTPConnectionManager.this.utp_provider.receiveBufferDrained(c.getSocket());
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected void close(final UTPConnection c, final String r) {
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                UTPConnectionManager.this.closeSupport(c, r);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSupport(UTPConnection c, String r) {
        boolean async_close = false;
        try {
            if (!c.isUnusable()) {
                this.log("Closed connection to " + c.getRemoteAddress() + ": " + r + " (" + c.getState() + ")");
                try {
                    c.setUnusable();
                    this.utp_provider.close(c.getSocket());
                    async_close = true;
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        catch (Throwable throwable) {
            if (async_close) {
                Set<UTPConnection> set = this.closing_connections;
                synchronized (set) {
                    this.closing_connections.add(c);
                }
            }
            Set<UTPConnection> set = this.closing_connections;
            synchronized (set) {
                if (this.closing_connections.contains(c)) {
                    return;
                }
            }
            this.removeConnection(c);
            throw throwable;
        }
        if (async_close) {
            Set<UTPConnection> set = this.closing_connections;
            synchronized (set) {
                this.closing_connections.add(c);
            }
        }
        Set<UTPConnection> set = this.closing_connections;
        synchronized (set) {
            if (this.closing_connections.contains(c)) {
                return;
            }
        }
        this.removeConnection(c);
    }

    public void preferUTP(boolean b) {
        this.prefer_utp = b;
    }

    protected boolean preferUTP() {
        return this.prefer_utp;
    }

    public void setReceiveBufferSize(int size) {
        this.utp_provider.setOption(1, size == 0 ? 1024 : size);
    }

    public void setSendBufferSize(int size) {
        this.utp_provider.setOption(2, size == 0 ? 1024 : size);
    }

    protected void log(String str) {
        this.plugin.log(str);
    }

    private void hackHandler() {
        try {
            Class<?> cla = this.packet_handler.getClass();
            Field f_socket = cla.getDeclaredField("socket");
            f_socket.setAccessible(true);
            Object dg_sock = f_socket.get(this.packet_handler);
            if (this.last_hack == dg_sock) {
                return;
            }
            this.last_hack = dg_sock;
            Field f_impl = dg_sock.getClass().getDeclaredField("impl");
            f_impl.setAccessible(true);
            Object dg_impl = f_impl.get(dg_sock);
            Class<?> dg_class = dg_impl.getClass();
            int hacked = 0;
            while (dg_class != null) {
                String[] field_names;
                String[] stringArray = field_names = new String[]{"fd", "fd1", "fd2"};
                int n = field_names.length;
                int n2 = 0;
                while (n2 < n) {
                    String field_name = stringArray[n2];
                    try {
                        Field f_fd = dg_class.getDeclaredField(field_name);
                        f_fd.setAccessible(true);
                        Object fd = f_fd.get(dg_impl);
                        if (fd != null) {
                            Field f_fd_fd = fd.getClass().getDeclaredField("fd");
                            f_fd_fd.setAccessible(true);
                            Object fd_fd = f_fd_fd.get(fd);
                            this.utp_provider.setSocketOptions(((Number)fd_fd).longValue());
                            ++hacked;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++n2;
                }
                dg_class = dg_class.getSuperclass();
            }
            this.hack_worked = hacked > 0;
            this.log("Set options on " + hacked + " socket(s)");
        }
        catch (Throwable e) {
            this.hack_worked = false;
            this.log("Failed to set socket options: " + Debug.getNestedExceptionMessage(e));
        }
    }
}

