/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportEndpoint;
import com.aelitis.azureus.core.networkmanager.TransportStartpoint;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportImpl;
import com.aelitis.azureus.core.networkmanager.impl.udp.ProtocolEndpointUDP;
import com.aelitis.azureus.core.networkmanager.impl.udp.TransportEndpointUDP;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogIDs;

public class UDPTransport
extends TransportImpl {
    private static final LogIDs LOGID = LogIDs.NET;
    private ProtocolEndpointUDP endpoint;
    private byte[][] shared_secrets;
    private int transport_mode = 0;
    private volatile boolean closed;

    protected UDPTransport(ProtocolEndpointUDP _endpoint, byte[][] _shared_secrets) {
        this.endpoint = _endpoint;
        this.shared_secrets = _shared_secrets;
    }

    protected UDPTransport(ProtocolEndpointUDP _endpoint, TransportHelperFilter _filter) {
        this.endpoint = _endpoint;
        this.setFilter(_filter);
    }

    @Override
    public boolean isTCP() {
        return false;
    }

    @Override
    public boolean isSOCKS() {
        return false;
    }

    @Override
    public String getProtocol() {
        return "UDP";
    }

    @Override
    public TransportEndpoint getTransportEndpoint() {
        return new TransportEndpointUDP(this.endpoint);
    }

    @Override
    public TransportStartpoint getTransportStartpoint() {
        return null;
    }

    @Override
    public int getMssSize() {
        return UDPNetworkManager.getUdpMssSize();
    }

    @Override
    public String getDescription() {
        return this.endpoint.getAddress().toString();
    }

    @Override
    public void setTransportMode(int mode) {
        this.transport_mode = mode;
    }

    @Override
    public int getTransportMode() {
        return this.transport_mode;
    }

    @Override
    public void connectOutbound(ByteBuffer initial_data, Transport.ConnectListener listener, int priority) {
        if (!UDPNetworkManager.UDP_OUTGOING_ENABLED) {
            listener.connectFailure(new Throwable("Outbound UDP connections disabled"));
            return;
        }
        if (this.closed) {
            listener.connectFailure(new Throwable("Connection already closed"));
            return;
        }
        if (this.getFilter() != null) {
            listener.connectFailure(new Throwable("Already connected"));
            return;
        }
        if (COConfigurationManager.getBooleanParameter("Proxy.Data.Enable")) {
            listener.connectFailure(new Throwable("UDP proxy connection not supported"));
            return;
        }
        UDPConnectionManager con_man = UDPNetworkManager.getSingleton().getConnectionManager();
        con_man.connectOutbound(this, this.endpoint.getAddress(), this.shared_secrets, initial_data, listener);
    }

    @Override
    public void close(String reason) {
        this.closed = true;
        this.readyForRead(false);
        this.readyForWrite(false);
        TransportHelperFilter filter2 = this.getFilter();
        if (filter2 != null) {
            filter2.getHelper().close(reason);
            this.setFilter(null);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

