/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.tcp.IncomingSocketChannelManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPConnectionManager;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.net.InetAddress;
import java.nio.channels.CancelledKeyException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class TCPNetworkManager {
    private static int WRITE_SELECT_LOOP_TIME = 25;
    private static int WRITE_SELECT_MIN_LOOP_TIME = 0;
    private static int READ_SELECT_LOOP_TIME = 25;
    private static int READ_SELECT_MIN_LOOP_TIME = 0;
    protected static int tcp_mss_size;
    private static final TCPNetworkManager instance;
    public static boolean TCP_INCOMING_ENABLED;
    public static boolean TCP_OUTGOING_ENABLED;
    private final VirtualChannelSelector read_selector = new VirtualChannelSelector("TCP network manager", 1, true);
    private final VirtualChannelSelector write_selector = new VirtualChannelSelector("TCP network manager", 4, true);
    private final TCPConnectionManager connect_disconnect_manager = new TCPConnectionManager();
    private final IncomingSocketChannelManager incoming_socketchannel_manager = new IncomingSocketChannelManager("TCP.Listen.Port", "TCP.Listen.Port.Enable");
    private long read_select_count;
    private long write_select_count;

    static {
        instance = new TCPNetworkManager();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"TCP.Listen.Port.Enable", "network.tcp.connect.outbound.enable"}, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                TCP_INCOMING_ENABLED = TCP_OUTGOING_ENABLED = COConfigurationManager.getBooleanParameter("TCP.Listen.Port.Enable");
                if (TCP_OUTGOING_ENABLED) {
                    TCP_OUTGOING_ENABLED = COConfigurationManager.getBooleanParameter("network.tcp.connect.outbound.enable");
                }
            }
        });
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.tcp.read.select.time", "network.tcp.read.select.min.time", "network.tcp.write.select.time", "network.tcp.write.select.min.time"}, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                WRITE_SELECT_LOOP_TIME = COConfigurationManager.getIntParameter("network.tcp.write.select.time");
                WRITE_SELECT_MIN_LOOP_TIME = COConfigurationManager.getIntParameter("network.tcp.write.select.min.time");
                READ_SELECT_LOOP_TIME = COConfigurationManager.getIntParameter("network.tcp.read.select.time");
                READ_SELECT_MIN_LOOP_TIME = COConfigurationManager.getIntParameter("network.tcp.read.select.min.time");
            }
        });
    }

    public static TCPNetworkManager getSingleton() {
        return instance;
    }

    public static int getTcpMssSize() {
        return tcp_mss_size;
    }

    public static void refreshRates(int min_rate) {
        tcp_mss_size = COConfigurationManager.getIntParameter("network.tcp.mtu.size") - 40;
        if (tcp_mss_size > min_rate) {
            tcp_mss_size = min_rate - 1;
        }
        if (tcp_mss_size < 512) {
            tcp_mss_size = 512;
        }
    }

    protected TCPNetworkManager() {
        HashSet<String> types = new HashSet<String>();
        types.add("net.tcp.select.read.count");
        types.add("net.tcp.select.write.count");
        AzureusCoreStats.registerProvider(types, new AzureusCoreStatsProvider(){

            public void updateStats(Set types, Map values) {
                if (types.contains("net.tcp.select.read.count")) {
                    values.put("net.tcp.select.read.count", new Long(TCPNetworkManager.this.read_select_count));
                }
                if (types.contains("net.tcp.select.write.count")) {
                    values.put("net.tcp.select.write.count", new Long(TCPNetworkManager.this.write_select_count));
                }
            }
        });
        AEThread2 read_selector_thread = new AEThread2("ReadController:ReadSelector", true){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            if (READ_SELECT_MIN_LOOP_TIME > 0) {
                                long start = SystemTime.getHighPrecisionCounter();
                                TCPNetworkManager.this.read_selector.select(READ_SELECT_LOOP_TIME);
                                long duration = SystemTime.getHighPrecisionCounter() - start;
                                long sleep = (long)READ_SELECT_MIN_LOOP_TIME - (duration /= 1000000L);
                                if (sleep > 0L) {
                                    try {
                                        Thread.sleep(sleep);
                                    }
                                    catch (Throwable throwable) {}
                                }
                            } else {
                                TCPNetworkManager.this.read_selector.select(READ_SELECT_LOOP_TIME);
                            }
                            TCPNetworkManager tCPNetworkManager = TCPNetworkManager.this;
                            tCPNetworkManager.read_select_count = tCPNetworkManager.read_select_count + 1L;
                        }
                    }
                    catch (Throwable t) {
                        if (t instanceof CancelledKeyException) continue;
                        Debug.out("readSelectorLoop() EXCEPTION: ", t);
                        continue;
                    }
                    break;
                }
            }
        };
        read_selector_thread.setPriority(8);
        read_selector_thread.start();
        AEThread2 write_selector_thread = new AEThread2("WriteController:WriteSelector", true){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            if (WRITE_SELECT_MIN_LOOP_TIME > 0) {
                                long start = SystemTime.getHighPrecisionCounter();
                                TCPNetworkManager.this.write_selector.select(WRITE_SELECT_LOOP_TIME);
                                long duration = SystemTime.getHighPrecisionCounter() - start;
                                long sleep = (long)WRITE_SELECT_MIN_LOOP_TIME - (duration /= 1000000L);
                                if (sleep <= 0L) continue;
                                try {
                                    Thread.sleep(sleep);
                                }
                                catch (Throwable throwable) {}
                                continue;
                            }
                            TCPNetworkManager.this.write_selector.select(WRITE_SELECT_LOOP_TIME);
                            TCPNetworkManager tCPNetworkManager = TCPNetworkManager.this;
                            tCPNetworkManager.write_select_count = tCPNetworkManager.write_select_count + 1L;
                        }
                    }
                    catch (Throwable t) {
                        Debug.out("writeSelectorLoop() EXCEPTION: ", t);
                        continue;
                    }
                    break;
                }
            }
        };
        write_selector_thread.setPriority(8);
        write_selector_thread.start();
    }

    public void setExplicitBindAddress(InetAddress address) {
        this.incoming_socketchannel_manager.setExplicitBindAddress(address);
    }

    public void clearExplicitBindAddress() {
        this.incoming_socketchannel_manager.clearExplicitBindAddress();
    }

    public boolean isEffectiveBindAddress(InetAddress address) {
        return this.incoming_socketchannel_manager.isEffectiveBindAddress(address);
    }

    public TCPConnectionManager getConnectDisconnectManager() {
        return this.connect_disconnect_manager;
    }

    public VirtualChannelSelector getReadSelector() {
        return this.read_selector;
    }

    public VirtualChannelSelector getWriteSelector() {
        return this.write_selector;
    }

    public boolean isTCPListenerEnabled() {
        return this.incoming_socketchannel_manager.isEnabled();
    }

    public int getTCPListeningPortNumber() {
        return this.incoming_socketchannel_manager.getTCPListeningPortNumber();
    }

    public long getLastIncomingNonLocalConnectionTime() {
        return this.incoming_socketchannel_manager.getLastNonLocalConnectionTime();
    }
}

