/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class IncomingMessageQueueImpl
implements IncomingMessageQueue {
    private volatile ArrayList<IncomingMessageQueue.MessageQueueListener> listeners = new ArrayList();
    private final AEMonitor listeners_mon = new AEMonitor("IncomingMessageQueue:listeners");
    private MessageStreamDecoder stream_decoder;
    private final NetworkConnection connection;

    public IncomingMessageQueueImpl(MessageStreamDecoder stream_decoder, NetworkConnection connection) {
        if (stream_decoder == null) {
            throw new NullPointerException("stream_decoder is null");
        }
        this.connection = connection;
        this.stream_decoder = stream_decoder;
    }

    @Override
    public void setDecoder(MessageStreamDecoder new_stream_decoder) {
        ByteBuffer already_read = this.stream_decoder.destroy();
        this.connection.getTransport().setAlreadyRead(already_read);
        this.stream_decoder = new_stream_decoder;
        this.stream_decoder.resumeDecoding();
    }

    @Override
    public MessageStreamDecoder getDecoder() {
        return this.stream_decoder;
    }

    @Override
    public int getPercentDoneOfCurrentMessage() {
        return this.stream_decoder.getPercentDoneOfCurrentMessage();
    }

    @Override
    public int receiveFromTransport(int max_bytes) throws IOException {
        int data_read;
        int protocol_read;
        ArrayList<IncomingMessageQueue.MessageQueueListener> listeners_ref;
        int bytes_read;
        if (max_bytes < 1) {
            Debug.out("max_bytes < 1: " + max_bytes);
            return 0;
        }
        if (this.listeners.isEmpty()) {
            Debug.out("no queue listeners registered!");
            throw new IOException("no queue listeners registered!");
        }
        try {
            bytes_read = this.stream_decoder.performStreamDecode(this.connection.getTransport(), max_bytes);
        }
        catch (RuntimeException e) {
            Debug.out("Stream decode for " + this.connection.getString() + " failed: " + Debug.getNestedExceptionMessageAndStack(e));
            throw e;
        }
        Message[] messages = this.stream_decoder.removeDecodedMessages();
        if (messages != null) {
            int i = 0;
            while (i < messages.length) {
                Message msg = messages[i];
                if (msg == null) {
                    System.out.println("received msg == null [messages.length=" + messages.length + ", #" + i + "]: " + this.connection.getTransport().getDescription());
                } else {
                    listeners_ref = this.listeners;
                    boolean handled = false;
                    int x = 0;
                    while (x < listeners_ref.size()) {
                        IncomingMessageQueue.MessageQueueListener mql = listeners_ref.get(x);
                        if (mql.messageReceived(msg)) {
                            handled = true;
                        }
                        ++x;
                    }
                    if (!handled) {
                        if (listeners_ref.size() > 0) {
                            System.out.println("no registered listeners [out of " + listeners_ref.size() + "] handled decoded message [" + msg.getDescription() + "]");
                        }
                        DirectByteBuffer[] buffs = msg.getData();
                        int x2 = 0;
                        while (x2 < buffs.length) {
                            buffs[x2].returnToPool();
                            ++x2;
                        }
                    }
                }
                ++i;
            }
        }
        if ((protocol_read = this.stream_decoder.getProtocolBytesDecoded()) > 0) {
            ArrayList<IncomingMessageQueue.MessageQueueListener> listeners_ref2 = this.listeners;
            int i = 0;
            while (i < listeners_ref2.size()) {
                IncomingMessageQueue.MessageQueueListener mql = listeners_ref2.get(i);
                mql.protocolBytesReceived(protocol_read);
                ++i;
            }
        }
        if ((data_read = this.stream_decoder.getDataBytesDecoded()) > 0) {
            listeners_ref = this.listeners;
            int i = 0;
            while (i < listeners_ref.size()) {
                IncomingMessageQueue.MessageQueueListener mql = listeners_ref.get(i);
                mql.dataBytesReceived(data_read);
                ++i;
            }
        }
        return bytes_read;
    }

    @Override
    public void notifyOfExternallyReceivedMessage(Message message) throws IOException {
        ArrayList<IncomingMessageQueue.MessageQueueListener> listeners_ref = this.listeners;
        boolean handled = false;
        DirectByteBuffer[] dbbs = message.getData();
        int size = 0;
        int i = 0;
        while (i < dbbs.length) {
            size += dbbs[i].remaining((byte)5);
            ++i;
        }
        int x = 0;
        while (x < listeners_ref.size()) {
            IncomingMessageQueue.MessageQueueListener mql = listeners_ref.get(x);
            if (mql.messageReceived(message)) {
                handled = true;
            }
            if (message.getType() == 1) {
                mql.dataBytesReceived(size);
            } else {
                mql.protocolBytesReceived(size);
            }
            ++x;
        }
        if (!handled) {
            if (listeners_ref.size() > 0) {
                System.out.println("no registered listeners [out of " + listeners_ref.size() + "] handled decoded message [" + message.getDescription() + "]");
            }
            DirectByteBuffer[] buffs = message.getData();
            int x2 = 0;
            while (x2 < buffs.length) {
                buffs[x2].returnToPool();
                ++x2;
            }
        }
    }

    @Override
    public void resumeQueueProcessing() {
        this.stream_decoder.resumeDecoding();
    }

    @Override
    public void registerQueueListener(IncomingMessageQueue.MessageQueueListener listener) {
        try {
            this.listeners_mon.enter();
            ArrayList<IncomingMessageQueue.MessageQueueListener> new_list = new ArrayList<IncomingMessageQueue.MessageQueueListener>(this.listeners.size() + 1);
            if (listener.isPriority()) {
                boolean added = false;
                int i = 0;
                while (i < this.listeners.size()) {
                    IncomingMessageQueue.MessageQueueListener existing = this.listeners.get(i);
                    if (!added && !existing.isPriority()) {
                        new_list.add(listener);
                        added = true;
                    }
                    new_list.add(existing);
                    ++i;
                }
                if (!added) {
                    new_list.add(listener);
                }
            } else {
                new_list.addAll(this.listeners);
                new_list.add(listener);
            }
            this.listeners = new_list;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public void cancelQueueListener(IncomingMessageQueue.MessageQueueListener listener) {
        try {
            this.listeners_mon.enter();
            ArrayList<IncomingMessageQueue.MessageQueueListener> new_list = new ArrayList<IncomingMessageQueue.MessageQueueListener>(this.listeners);
            new_list.remove(listener);
            this.listeners = new_list;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public void destroy() {
        this.stream_decoder.destroy();
    }
}

