/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.ProtocolEndpointFactory;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProxyLoginHandler;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelperFilterFactory;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AESemaphore;

public class NetworkAdminSocksProxyImpl
implements NetworkAdminSocksProxy {
    private final String TARGET_HOST = "version.vuze.com";
    private final int TARGET_PORT = 80;
    private String host;
    private String port;
    private String user;
    private String password;

    protected NetworkAdminSocksProxyImpl(String _host, String _port, String _user, String _password) {
        this.host = _host;
        this.port = _port;
        this.user = _user;
        this.password = _password;
    }

    protected boolean isConfigured() {
        return this.host.length() > 0;
    }

    @Override
    public String getName() {
        return String.valueOf(this.host) + ":" + this.port;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String[] getVersionsSupported() throws NetworkAdminException {
        NetworkAdminException failure = null;
        ArrayList<String> versions = new ArrayList<String>();
        try {
            this.testVersion("V4");
            versions.add("4");
        }
        catch (NetworkAdminException e) {
            failure = e;
        }
        try {
            this.testVersion("V4a");
            versions.add("4a");
        }
        catch (NetworkAdminException e) {
            failure = e;
        }
        try {
            this.testVersion("V5");
            versions.add("5");
        }
        catch (NetworkAdminException e) {
            failure = e;
        }
        if (versions.size() > 0) {
            return versions.toArray(new String[versions.size()]);
        }
        throw failure;
    }

    @Override
    public String getString() {
        String res = this.getName();
        if (this.user.length() > 0) {
            res = String.valueOf(res) + " [auth=" + this.user + "]";
        }
        res = String.valueOf(res) + ", versions=";
        try {
            String[] versions = this.getVersionsSupported();
            int j = 0;
            while (j < versions.length) {
                res = String.valueOf(res) + (j == 0 ? "" : ",") + versions[j];
                ++j;
            }
        }
        catch (NetworkAdminException e) {
            res = String.valueOf(res) + "unknown (" + e.getLocalizedMessage() + ")";
        }
        return res;
    }

    protected void testVersion(final String version) throws NetworkAdminException {
        boolean RES_CONNECT_FAILED = false;
        boolean RES_SOCKS_FAILED = true;
        int RES_OK = 3;
        final AESemaphore sem = new AESemaphore("NetworkAdminSocksProxy:test");
        final int[] result = new int[1];
        final NetworkAdminException[] error = new NetworkAdminException[1];
        try {
            InetSocketAddress socks_address = new InetSocketAddress(InetAddress.getByName(this.host), Integer.parseInt(this.port));
            final InetSocketAddress target_address = new InetSocketAddress("version.vuze.com", 80);
            TCPConnectionManager.ConnectListener connect_listener = new TCPConnectionManager.ConnectListener(){

                @Override
                public int connectAttemptStarted(int default_connect_timeout) {
                    return default_connect_timeout;
                }

                @Override
                public void connectSuccess(SocketChannel channel2) {
                    final TCPTransportImpl transport = new TCPTransportImpl((ProtocolEndpointTCP)ProtocolEndpointFactory.createEndpoint(1, target_address), false, false, null);
                    transport.setFilter(TCPTransportHelperFilterFactory.createTransparentFilter(channel2));
                    new ProxyLoginHandler(transport, target_address, new ProxyLoginHandler.ProxyListener(){

                        @Override
                        public void connectSuccess() {
                            transport.close("Done");
                            result[0] = 3;
                            sem.release();
                        }

                        @Override
                        public void connectFailure(Throwable failure_msg) {
                            transport.close("Proxy login failed");
                            result[0] = 1;
                            error[0] = new NetworkAdminException("Proxy connect failed", failure_msg);
                            sem.release();
                        }
                    }, version, NetworkAdminSocksProxyImpl.this.user, NetworkAdminSocksProxyImpl.this.password);
                }

                @Override
                public void connectFailure(Throwable failure_msg) {
                    result[0] = 0;
                    error[0] = new NetworkAdminException("Connect failed", failure_msg);
                    sem.release();
                }
            };
            TCPNetworkManager.getSingleton().getConnectDisconnectManager().requestNewConnection(socks_address, connect_listener, 3);
        }
        catch (Throwable e) {
            result[0] = 0;
            error[0] = new NetworkAdminException("Connect failed", e);
            sem.release();
        }
        if (!sem.reserve(10000L)) {
            result[0] = 0;
            error[0] = new NetworkAdminException("Connect timeout");
        }
        if (result[0] != 3) {
            throw error[0];
        }
    }
}

