/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProgressListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProtocol;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminHTTPTester;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminProtocolTester;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminTCPTester;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminUDPTester;
import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import java.net.InetAddress;
import org.gudy.azureus2.plugins.PluginInterface;

public class NetworkAdminProtocolImpl
implements NetworkAdminProtocol {
    private AzureusCore core;
    private int type;
    private int port;

    protected NetworkAdminProtocolImpl(AzureusCore _core, int _type) {
        this.core = _core;
        this.type = _type;
        this.port = -1;
    }

    protected NetworkAdminProtocolImpl(AzureusCore _core, int _type, int _port) {
        this.core = _core;
        this.type = _type;
        this.port = _port;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public InetAddress test(NetworkAdminNetworkInterfaceAddress address) throws NetworkAdminException {
        return this.test(address, null);
    }

    @Override
    public InetAddress test(NetworkAdminNetworkInterfaceAddress address, boolean upnp_map, NetworkAdminProgressListener listener) throws NetworkAdminException {
        InetAddress res;
        InetAddress bind_ip;
        InetAddress inetAddress = bind_ip = address == null ? null : address.getAddress();
        NetworkAdminProtocolTester tester = this.type == 1 ? new NetworkAdminHTTPTester(this.core, listener) : (this.type == 2 ? new NetworkAdminTCPTester(this.core, listener) : new NetworkAdminUDPTester(this.core, listener));
        if (this.port <= 0) {
            res = tester.testOutbound(bind_ip, 0);
        } else {
            UPnPPlugin upnp;
            UPnPMapping mapping;
            PluginInterface pi_upnp;
            UPnPMapping new_mapping = null;
            if (upnp_map && (pi_upnp = this.core.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class)) != null && (mapping = (upnp = (UPnPPlugin)pi_upnp.getPlugin()).getMapping(this.type != 3, this.port)) == null) {
                new_mapping = mapping = upnp.addMapping("NAT Tester", this.type != 3, this.port, true);
                try {
                    Thread.sleep(500L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                res = tester.testInbound(bind_ip, this.port);
            }
            finally {
                if (new_mapping != null) {
                    new_mapping.destroy();
                }
            }
        }
        return res;
    }

    @Override
    public InetAddress test(NetworkAdminNetworkInterfaceAddress address, NetworkAdminProgressListener listener) throws NetworkAdminException {
        return this.test(address, false, listener);
    }

    @Override
    public String getTypeString() {
        String res = this.type == 1 ? "HTTP" : (this.type == 2 ? "TCP" : "UDP");
        return res;
    }

    @Override
    public String getName() {
        String res = this.getTypeString();
        if (this.port == -1) {
            return String.valueOf(res) + " outbound";
        }
        return String.valueOf(res) + " port " + this.port + " inbound";
    }
}

