/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.impl.tcp.VirtualChannelSelectorImpl;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class VirtualChannelSelector {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    public static final int OP_ACCEPT = 16;
    public static final int OP_CONNECT = 8;
    public static final int OP_READ = 1;
    public static final int OP_WRITE = 4;
    private boolean SAFE_SELECTOR_MODE_ENABLED = COConfigurationManager.getBooleanParameter("network.tcp.enable_safe_selector_mode");
    private static final boolean TEST_SAFE_MODE = false;
    private static final int MAX_CHANNELS_PER_SAFE_SELECTOR = COConfigurationManager.getIntParameter("network.tcp.safe_selector_mode.chunk_size");
    private static final int MAX_SAFEMODE_SELECTORS = 20000 / MAX_CHANNELS_PER_SAFE_SELECTOR;
    private String name;
    private VirtualChannelSelectorImpl selector_impl;
    private volatile boolean destroyed;
    private HashMap<VirtualChannelSelectorImpl, ArrayList<AbstractSelectableChannel>> selectors;
    private HashSet<VirtualChannelSelectorImpl> selectors_keyset_cow;
    private AEMonitor selectors_mon;
    private final int op;
    private final boolean pause;
    private boolean randomise_keys;

    public VirtualChannelSelector(String name, int interest_op, boolean pause_after_select) {
        this.name = name;
        this.op = interest_op;
        this.pause = pause_after_select;
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            this.initSafeMode();
        } else {
            this.selector_impl = new VirtualChannelSelectorImpl(this, this.op, this.pause, this.randomise_keys);
            this.selectors = null;
            this.selectors_keyset_cow = null;
            this.selectors_mon = null;
        }
    }

    public String getName() {
        return this.name;
    }

    private void initSafeMode() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "***************** SAFE SOCKET SELECTOR MODE ENABLED *****************"));
        }
        this.selector_impl = null;
        this.selectors = new HashMap();
        this.selectors_mon = new AEMonitor("VirtualChannelSelector:FM");
        this.selectors.put(new VirtualChannelSelectorImpl(this, this.op, this.pause, this.randomise_keys), new ArrayList());
        this.selectors_keyset_cow = new HashSet<VirtualChannelSelectorImpl>(this.selectors.keySet());
    }

    public void register(SocketChannel channel2, VirtualSelectorListener listener, Object attachment) {
        this.registerSupport(channel2, listener, attachment);
    }

    public void register(ServerSocketChannel channel2, VirtualAcceptSelectorListener listener, Object attachment) {
        this.registerSupport(channel2, listener, attachment);
    }

    protected void registerSupport(AbstractSelectableChannel channel2, VirtualAbstractSelectorListener listener, Object attachment) {
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            try {
                String msg;
                this.selectors_mon.enter();
                for (Map.Entry<VirtualChannelSelectorImpl, ArrayList<AbstractSelectableChannel>> entry : this.selectors.entrySet()) {
                    VirtualChannelSelectorImpl sel = entry.getKey();
                    ArrayList<AbstractSelectableChannel> channels = entry.getValue();
                    if (channels.size() >= MAX_CHANNELS_PER_SAFE_SELECTOR) {
                        Iterator<AbstractSelectableChannel> chan_it = channels.iterator();
                        while (chan_it.hasNext()) {
                            AbstractSelectableChannel chan = chan_it.next();
                            if (chan.isOpen()) continue;
                            Debug.out("Selector '" + this.getName() + "' - removing orphaned safe channel registration");
                            chan_it.remove();
                        }
                    }
                    if (channels.size() >= MAX_CHANNELS_PER_SAFE_SELECTOR) continue;
                    sel.register(channel2, listener, attachment);
                    channels.add(channel2);
                    return;
                }
                if (this.selectors.size() >= MAX_SAFEMODE_SELECTORS) {
                    msg = "Error: MAX_SAFEMODE_SELECTORS reached [" + this.selectors.size() + "], no more socket channels can be registered. Too many peer connections.";
                    Debug.out(msg);
                    this.selectFailure(listener, channel2, attachment, new Throwable(msg));
                    return;
                }
                if (this.destroyed) {
                    msg = "socket registered after controller destroyed";
                    Debug.out(msg);
                    this.selectFailure(listener, channel2, attachment, new Throwable(msg));
                    return;
                }
                VirtualChannelSelectorImpl sel = new VirtualChannelSelectorImpl(this, this.op, this.pause, this.randomise_keys);
                ArrayList<AbstractSelectableChannel> chans = new ArrayList<AbstractSelectableChannel>();
                this.selectors.put(sel, chans);
                sel.register(channel2, listener, attachment);
                chans.add(channel2);
                this.selectors_keyset_cow = new HashSet<VirtualChannelSelectorImpl>(this.selectors.keySet());
            }
            finally {
                this.selectors_mon.exit();
            }
        } else {
            this.selector_impl.register(channel2, listener, attachment);
        }
    }

    public void pauseSelects(AbstractSelectableChannel channel2) {
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            try {
                this.selectors_mon.enter();
                for (Map.Entry<VirtualChannelSelectorImpl, ArrayList<AbstractSelectableChannel>> entry : this.selectors.entrySet()) {
                    VirtualChannelSelectorImpl sel = entry.getKey();
                    ArrayList<AbstractSelectableChannel> channels = entry.getValue();
                    if (!channels.contains(channel2)) continue;
                    sel.pauseSelects(channel2);
                    return;
                }
                Debug.out("pauseSelects():: channel not found!");
            }
            finally {
                this.selectors_mon.exit();
            }
        } else {
            this.selector_impl.pauseSelects(channel2);
        }
    }

    public void resumeSelects(AbstractSelectableChannel channel2) {
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            try {
                this.selectors_mon.enter();
                for (Map.Entry<VirtualChannelSelectorImpl, ArrayList<AbstractSelectableChannel>> entry : this.selectors.entrySet()) {
                    VirtualChannelSelectorImpl sel = entry.getKey();
                    ArrayList<AbstractSelectableChannel> channels = entry.getValue();
                    if (!channels.contains(channel2)) continue;
                    sel.resumeSelects(channel2);
                    return;
                }
                Debug.out("resumeSelects():: channel not found!");
            }
            finally {
                this.selectors_mon.exit();
            }
        } else {
            this.selector_impl.resumeSelects(channel2);
        }
    }

    public void cancel(AbstractSelectableChannel channel2) {
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            try {
                this.selectors_mon.enter();
                for (Map.Entry<VirtualChannelSelectorImpl, ArrayList<AbstractSelectableChannel>> entry : this.selectors.entrySet()) {
                    VirtualChannelSelectorImpl sel = entry.getKey();
                    ArrayList<AbstractSelectableChannel> channels = entry.getValue();
                    if (!channels.remove(channel2)) continue;
                    sel.cancel(channel2);
                    return;
                }
            }
            finally {
                this.selectors_mon.exit();
            }
        } else if (this.selector_impl != null) {
            this.selector_impl.cancel(channel2);
        }
    }

    public void setRandomiseKeys(boolean _rk) {
        this.randomise_keys = _rk;
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            try {
                this.selectors_mon.enter();
                for (VirtualChannelSelectorImpl sel : this.selectors.keySet()) {
                    sel.setRandomiseKeys(this.randomise_keys);
                }
            }
            finally {
                this.selectors_mon.exit();
            }
        } else if (this.selector_impl != null) {
            this.selector_impl.setRandomiseKeys(this.randomise_keys);
        }
    }

    public int select(long timeout) {
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            boolean was_destroyed = this.destroyed;
            try {
                int count = 0;
                for (VirtualChannelSelectorImpl sel : this.selectors_keyset_cow) {
                    count += sel.select(timeout);
                }
                int n = count;
                return n;
            }
            finally {
                if (was_destroyed) {
                    try {
                        this.selectors_mon.enter();
                        this.selectors.clear();
                        this.selectors_keyset_cow = new HashSet();
                    }
                    finally {
                        this.selectors_mon.exit();
                    }
                }
            }
        }
        return this.selector_impl.select(timeout);
    }

    public void destroy() {
        this.destroyed = true;
        if (this.SAFE_SELECTOR_MODE_ENABLED) {
            for (VirtualChannelSelectorImpl sel : this.selectors_keyset_cow) {
                sel.destroy();
            }
        } else {
            this.selector_impl.destroy();
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean isSafeSelectionModeEnabled() {
        return this.SAFE_SELECTOR_MODE_ENABLED;
    }

    public void enableSafeSelectionMode() {
        if (!this.SAFE_SELECTOR_MODE_ENABLED) {
            this.SAFE_SELECTOR_MODE_ENABLED = true;
            COConfigurationManager.setParameter("network.tcp.enable_safe_selector_mode", true);
            this.initSafeMode();
        }
    }

    public boolean selectSuccess(VirtualAbstractSelectorListener listener, AbstractSelectableChannel sc, Object attachment) {
        if (this.op == 16) {
            return ((VirtualAcceptSelectorListener)listener).selectSuccess(this, (ServerSocketChannel)sc, attachment);
        }
        return ((VirtualSelectorListener)listener).selectSuccess(this, (SocketChannel)sc, attachment);
    }

    public void selectFailure(VirtualAbstractSelectorListener listener, AbstractSelectableChannel sc, Object attachment, Throwable msg) {
        if (this.op == 16) {
            ((VirtualAcceptSelectorListener)listener).selectFailure(this, (ServerSocketChannel)sc, attachment, msg);
        } else {
            ((VirtualSelectorListener)listener).selectFailure(this, (SocketChannel)sc, attachment, msg);
        }
    }

    public static interface VirtualAbstractSelectorListener {
    }

    public static interface VirtualAcceptSelectorListener
    extends VirtualAbstractSelectorListener {
        public boolean selectSuccess(VirtualChannelSelector var1, ServerSocketChannel var2, Object var3);

        public void selectFailure(VirtualChannelSelector var1, ServerSocketChannel var2, Object var3, Throwable var4);
    }

    public static interface VirtualSelectorListener
    extends VirtualAbstractSelectorListener {
        public boolean selectSuccess(VirtualChannelSelector var1, SocketChannel var2, Object var3);

        public void selectFailure(VirtualChannelSelector var1, SocketChannel var2, Object var3, Throwable var4);
    }
}

