/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl;

import com.aelitis.azureus.core.messenger.config.PlatformMetaSearchMessenger;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchLoginException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.FieldRemapper;
import com.aelitis.azureus.core.metasearch.impl.FieldRemapping;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.metasearch.impl.plugin.PluginEngine;
import com.aelitis.azureus.core.metasearch.impl.web.json.JSONEngine;
import com.aelitis.azureus.core.metasearch.impl.web.regex.RegexEngine;
import com.aelitis.azureus.core.metasearch.impl.web.rss.RSSEngine;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ImportExportUtils;
import com.aelitis.azureus.util.JSONUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class EngineImpl
implements Engine {
    private static final int DEFAULT_UPDATE_CHECK_SECS = 86400;
    private static boolean logging_enabled;
    protected static final String LD_COOKIES = "cookies";
    protected static final String LD_ETAG = "etag";
    protected static final String LD_LAST_MODIFIED = "last_mod";
    protected static final String LD_LAST_UPDATE_CHECK = "last_update_check";
    protected static final String LD_UPDATE_CHECK_SECS = "update_check_secs";
    protected static final String LD_CREATED_BY_ME = "mine";
    protected static final String LD_AUTO_DL_SUPPORTED = "auto_dl_supported";
    protected static final String LD_LINK_IS_TORRENT = "link_is_torrent";
    private MetaSearchImpl meta_search;
    private int type;
    private long id;
    private long last_updated;
    private String name;
    private byte[] uid;
    private int version;
    private boolean is_public = true;
    private int az_version;
    private int selection_state = 0;
    private boolean selection_state_recorded = true;
    private int source = 0;
    private float rank_bias = 1.0f;
    private float preferred_count = 0.0f;
    private List first_level_mapping = new ArrayList();
    private List second_level_mapping = new ArrayList();
    private String update_url;
    private int update_check_default_secs;
    private Map user_data;

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Logger.Enabled"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                logging_enabled = COConfigurationManager.getBooleanParameter("Logger.Enabled");
            }
        });
    }

    protected static EngineImpl importFromBEncodedMap(MetaSearchImpl meta_search, Map map) throws IOException {
        int type = ((Long)map.get("type")).intValue();
        if (type == 2) {
            return JSONEngine.importFromBEncodedMap(meta_search, map);
        }
        if (type == 1) {
            return RegexEngine.importFromBEncodedMap(meta_search, map);
        }
        if (type == 3) {
            return PluginEngine.importFromBEncodedMap(meta_search, map);
        }
        if (type == 4) {
            return RSSEngine.importFromBEncodedMap(meta_search, map);
        }
        throw new IOException("Unknown engine type " + type);
    }

    public static Engine importFromJSONString(MetaSearchImpl meta_search, int type, long id, long last_updated, float rank_bias, String name, String content2) throws IOException {
        JSONObject map = (JSONObject)JSONUtils.decodeJSON(content2);
        if (type == 2) {
            return JSONEngine.importFromJSONString(meta_search, id, last_updated, rank_bias, name, map);
        }
        if (type == 1) {
            return RegexEngine.importFromJSONString(meta_search, id, last_updated, rank_bias, name, map);
        }
        if (type == 4) {
            return RSSEngine.importFromJSONString(meta_search, id, last_updated, rank_bias, name, map);
        }
        throw new IOException("Unknown engine type " + type);
    }

    protected EngineImpl(MetaSearchImpl _meta_search, int _type, long _id, long _last_updated, float _rank_bias, String _name) {
        this.meta_search = _meta_search;
        this.type = _type;
        this.id = _id;
        this.last_updated = _last_updated;
        this.rank_bias = _rank_bias;
        this.name = _name;
        this.version = 1;
        this.az_version = 4;
        this.allocateUID(this.id);
    }

    protected EngineImpl(MetaSearchImpl _meta_search, Map map) throws IOException {
        this.meta_search = _meta_search;
        this.type = ((Long)map.get("type")).intValue();
        Long l_id = (Long)map.get("id");
        this.id = l_id == null ? this.meta_search.getManager().getLocalTemplateID() : l_id.longValue();
        this.last_updated = ImportExportUtils.importLong(map, "last_updated");
        this.name = ImportExportUtils.importString(map, "name");
        this.selection_state = (int)ImportExportUtils.importLong(map, "selected", 0L);
        this.selection_state_recorded = ImportExportUtils.importBoolean(map, "select_rec", true);
        this.source = (int)ImportExportUtils.importLong(map, "source", 0L);
        this.rank_bias = ImportExportUtils.importFloat(map, "rank_bias", 1.0f);
        this.preferred_count = ImportExportUtils.importFloat(map, "pref_count", 0.0f);
        this.first_level_mapping = this.importBEncodedMappings(map, "l1_map");
        this.second_level_mapping = this.importBEncodedMappings(map, "l2_map");
        this.version = (int)ImportExportUtils.importLong(map, "version", 1L);
        this.az_version = (int)ImportExportUtils.importLong(map, "az_version", 4L);
        if (this.az_version > 4) {
            throw new IOException(MessageText.getString("metasearch.template.version.bad", new String[]{this.name}));
        }
        this.uid = (byte[])map.get("uid");
        if (this.uid == null) {
            this.allocateUID(this.id);
        }
        this.update_url = ImportExportUtils.importString(map, "update_url");
        this.update_check_default_secs = (int)ImportExportUtils.importLong(map, "update_url_check_secs", 86400L);
    }

    protected void exportToBencodedMap(Map map, boolean generic) throws IOException {
        map.put("type", new Long(this.type));
        ImportExportUtils.exportString(map, "name", this.name);
        map.put("source", new Long(this.source));
        this.exportBEncodedMappings(map, "l1_map", this.first_level_mapping);
        this.exportBEncodedMappings(map, "l2_map", this.second_level_mapping);
        map.put("version", new Long(this.version));
        map.put("az_version", new Long(this.az_version));
        ImportExportUtils.exportFloat(map, "rank_bias", this.rank_bias);
        if (!generic) {
            map.put("id", new Long(this.id));
            map.put("last_updated", new Long(this.last_updated));
            map.put("selected", new Long(this.selection_state));
            ImportExportUtils.exportBoolean(map, "select_rec", this.selection_state_recorded);
            ImportExportUtils.exportFloat(map, "pref_count", this.preferred_count);
            map.put("uid", this.uid);
        }
        if (this.update_url != null) {
            ImportExportUtils.exportString(map, "update_url", this.update_url);
        }
        if (this.update_check_default_secs != 86400) {
            map.put("update_url_check_secs", new Long(this.update_check_default_secs));
        }
    }

    protected EngineImpl(MetaSearchImpl meta_search, int type, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        this(meta_search, type, id, last_updated, rank_bias, name);
        this.first_level_mapping = this.importJSONMappings(map, "value_map", true);
        this.second_level_mapping = this.importJSONMappings(map, "ctype_map", false);
        this.version = (int)ImportExportUtils.importLong(map, "version", 1L);
        this.az_version = (int)ImportExportUtils.importLong(map, "az_version", 4L);
        if (this.az_version > 4) {
            throw new IOException(MessageText.getString("metasearch.template.version.bad", new String[]{name}));
        }
        String uid_str = (String)map.get("uid");
        if (uid_str == null) {
            this.allocateUID(id);
        } else {
            this.uid = Base32.decode(uid_str);
        }
        this.update_url = ImportExportUtils.importString(map, "update_url");
        this.update_check_default_secs = (int)ImportExportUtils.importLong(map, "update_url_check_secs", 86400L);
    }

    protected void exportToJSONObject(JSONObject res) throws IOException {
        this.exportJSONMappings(res, "value_map", this.first_level_mapping, true);
        this.exportJSONMappings(res, "ctype_map", this.second_level_mapping, false);
        res.put("version", new Long(this.version));
        res.put("az_version", new Long(this.az_version));
        res.put("uid", Base32.encode(this.uid));
        if (this.update_url != null) {
            ImportExportUtils.exportJSONString(res, "update_url", this.update_url);
        }
        res.put("update_url_check_secs", new Long(this.update_check_default_secs));
    }

    protected List importJSONMappings(JSONObject map, String str, boolean level_1) throws IOException {
        ArrayList<FieldRemapper> result = new ArrayList<FieldRemapper>();
        JSONObject field_map = (JSONObject)map.get(str);
        if (field_map != null) {
            for (Map.Entry entry : field_map.entrySet()) {
                String key = (String)entry.getKey();
                List mappings = (List)entry.getValue();
                int from_field = this.vuzeFieldToID(key);
                if (from_field == -1) {
                    this.log("Unrecognised remapping key '" + key + "'");
                    continue;
                }
                int to_field = level_1 ? from_field : 8;
                ArrayList<FieldRemapping> frs_l = new ArrayList<FieldRemapping>();
                int i = 0;
                while (i < mappings.size()) {
                    JSONObject mapping = (JSONObject)mappings.get(i);
                    String from_str = URLDecoder.decode((String)mapping.get(level_1 ? "from_string" : "cat_string"), "UTF-8");
                    if (from_str == null) {
                        this.log("'from' value missing in " + mapping);
                    } else {
                        from_str = URLDecoder.decode(from_str, "UTF-8");
                        String to_str = URLDecoder.decode((String)mapping.get(level_1 ? "to_string" : "media_type"), "UTF-8");
                        if (to_str == null) {
                            this.log("'to' value missing in " + mapping);
                        } else {
                            frs_l.add(new FieldRemapping(from_str, to_str));
                        }
                    }
                    ++i;
                }
                FieldRemapping[] frs = frs_l.toArray(new FieldRemapping[frs_l.size()]);
                result.add(new FieldRemapper(from_field, to_field, frs));
            }
        }
        return result;
    }

    protected void exportJSONMappings(JSONObject res, String str, List l, boolean level_1) {
        JSONObject field_map = new JSONObject();
        res.put(str, field_map);
        int i = 0;
        while (i < l.size()) {
            FieldRemapper remapper = (FieldRemapper)l.get(i);
            int from_field = remapper.getInField();
            String from_field_str = this.vuzeIDToField(from_field);
            JSONArray mappings = new JSONArray();
            field_map.put(from_field_str, mappings);
            FieldRemapping[] frs = remapper.getMappings();
            int j = 0;
            while (j < frs.length) {
                FieldRemapping fr = frs[j];
                String from_str = UrlUtils.encode(fr.getMatchString());
                String to_str = fr.getReplacement();
                JSONObject map = new JSONObject();
                mappings.add(map);
                map.put(level_1 ? "from_string" : "cat_string", from_str);
                map.put(level_1 ? "to_string" : "media_type", to_str);
                ++j;
            }
            ++i;
        }
    }

    protected List importBEncodedMappings(Map map, String name) throws IOException {
        ArrayList<FieldRemapper> result = new ArrayList<FieldRemapper>();
        List l = (List)map.get(name);
        if (l != null) {
            int i = 0;
            while (i < l.size()) {
                Map entry = (Map)l.get(i);
                int from_field = ((Long)entry.get("from")).intValue();
                int to_field = ((Long)entry.get("to")).intValue();
                List l2 = (List)entry.get("maps");
                FieldRemapping[] mappings = new FieldRemapping[l2.size()];
                int j = 0;
                while (j < mappings.length) {
                    Map entry2 = (Map)l2.get(j);
                    String from_str = ImportExportUtils.importString(entry2, "from");
                    String to_str = ImportExportUtils.importString(entry2, "to");
                    mappings[j] = new FieldRemapping(from_str, to_str);
                    ++j;
                }
                result.add(new FieldRemapper(from_field, to_field, mappings));
                ++i;
            }
        }
        return result;
    }

    protected void exportBEncodedMappings(Map map, String name, List mappings) throws IOException {
        ArrayList l = new ArrayList();
        map.put(name, l);
        int i = 0;
        while (i < mappings.size()) {
            FieldRemapper mapper = (FieldRemapper)mappings.get(i);
            HashMap<String, Serializable> m = new HashMap<String, Serializable>();
            l.add(m);
            m.put("from", new Long(mapper.getInField()));
            m.put("to", new Long(mapper.getOutField()));
            ArrayList l2 = new ArrayList();
            m.put("maps", l2);
            FieldRemapping[] frs = mapper.getMappings();
            int j = 0;
            while (j < frs.length) {
                FieldRemapping fr = frs[j];
                HashMap m2 = new HashMap();
                l2.add(m2);
                ImportExportUtils.exportString(m2, "from", fr.getMatchString());
                ImportExportUtils.exportString(m2, "to", fr.getReplacement());
                ++j;
            }
            ++i;
        }
    }

    @Override
    public String exportToJSONString() throws IOException {
        JSONObject obj = new JSONObject();
        this.exportToJSONObject(obj);
        return obj.toString();
    }

    @Override
    public int getAZVersion() {
        return this.az_version;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    protected void setVersion(int _v) {
        this.version = _v;
    }

    @Override
    public String getUID() {
        return Base32.encode(this.uid);
    }

    protected void setUID(String str) {
        this.uid = Base32.decode(str);
    }

    protected void allocateUID(long id) {
        this.uid = new byte[10];
        if (id >= 0L && id < Integer.MAX_VALUE) {
            this.uid[0] = (byte)(id >> 24);
            this.uid[1] = (byte)(id >> 16);
            this.uid[2] = (byte)(id >> 8);
            this.uid[3] = (byte)id;
        } else {
            RandomUtils.nextSecureBytes(this.uid);
            this.configDirty();
        }
    }

    @Override
    public boolean sameLogicAs(Engine other) {
        try {
            Map<String, Object> m1 = this.exportToBencodedMap();
            Map<String, Object> m2 = other.exportToBencodedMap();
            String[] to_remove = new String[]{"type", "id", "last_updated", "selected", "select_rec", "source", "rank_bias", "pref_count", "version", "az_version", "uid"};
            int i = 0;
            while (i < to_remove.length) {
                m1.remove(to_remove[i]);
                m2.remove(to_remove[i]);
                ++i;
            }
            return BEncoder.mapsAreIdentical(m1, m2);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result[] search(SearchParameter[] params, Map context2, int desired_max_matches, int absolute_max_matches, String headers, final ResultListener listener) throws SearchException {
        if (context2 == null) {
            context2 = new HashMap();
        }
        try {
            final HashSet results_informed = new HashSet();
            final boolean[] complete_informed = new boolean[1];
            ResultListener interceptor = new ResultListener(){

                @Override
                public void contentReceived(Engine engine, String content2) {
                    listener.contentReceived(engine, content2);
                }

                @Override
                public void matchFound(Engine engine, String[] fields) {
                    listener.matchFound(engine, fields);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void resultsReceived(Engine engine, Result[] results) {
                    listener.resultsReceived(engine, results);
                    Set set = results_informed;
                    synchronized (set) {
                        results_informed.addAll(Arrays.asList(results));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void resultsComplete(Engine engine) {
                    listener.resultsComplete(engine);
                    Set set = results_informed;
                    synchronized (set) {
                        complete_informed[0] = true;
                    }
                }

                @Override
                public void engineFailed(Engine engine, Throwable cause) {
                    listener.engineFailed(engine, cause);
                }

                @Override
                public void engineRequiresLogin(Engine engine, Throwable cause) {
                    listener.engineRequiresLogin(engine, cause);
                }
            };
            Result[] results = this.searchAndMap(params, context2, desired_max_matches, absolute_max_matches, headers, listener == null ? null : interceptor);
            if (listener != null) {
                boolean inform_complete;
                ArrayList<Result> inform_result = new ArrayList<Result>();
                HashSet hashSet = results_informed;
                synchronized (hashSet) {
                    Result[] resultArray = results;
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Result r = resultArray[n2];
                        if (!results_informed.contains(r)) {
                            inform_result.add(r);
                        }
                        ++n2;
                    }
                    inform_complete = !complete_informed[0];
                }
                if (inform_result.size() > 0) {
                    listener.resultsReceived(this, inform_result.toArray(new Result[inform_result.size()]));
                }
                if (inform_complete) {
                    listener.resultsComplete(this);
                }
            }
            return results;
        }
        catch (Throwable e) {
            if (e instanceof SearchLoginException) {
                if (listener != null) {
                    listener.engineRequiresLogin(this, e);
                }
                throw (SearchLoginException)e;
            }
            if (e instanceof SearchException) {
                if (listener != null) {
                    listener.engineFailed(this, e);
                }
                throw (SearchException)e;
            }
            if (listener != null) {
                listener.engineFailed(this, e);
            }
            throw new SearchException("Search failed", e);
        }
    }

    protected Result[] searchAndMap(SearchParameter[] params, Map context2, int desired_max_matches, int absolute_max_matches, String headers, final ResultListener listener) throws SearchException {
        context2.put("azid", ConstantsVuze.AZID);
        if (context2.get("azsrc") == null) {
            context2.put("azsrc", "search");
        }
        Result[] results = this.searchSupport(params, context2, desired_max_matches, absolute_max_matches, headers, new ResultListener(){

            @Override
            public void contentReceived(Engine engine, String content2) {
                if (listener != null) {
                    listener.contentReceived(engine, content2);
                }
            }

            @Override
            public void matchFound(Engine engine, String[] fields) {
                if (listener != null) {
                    listener.matchFound(engine, fields);
                }
            }

            @Override
            public void resultsReceived(Engine engine, Result[] results) {
                if (listener != null) {
                    listener.resultsReceived(engine, EngineImpl.this.mapResults(results));
                }
            }

            @Override
            public void resultsComplete(Engine engine) {
                if (listener != null) {
                    listener.resultsComplete(engine);
                }
            }

            @Override
            public void engineFailed(Engine engine, Throwable cause) {
                EngineImpl.this.log("Search failed", cause);
                if (listener != null) {
                    listener.engineFailed(engine, cause);
                }
            }

            @Override
            public void engineRequiresLogin(Engine engine, Throwable cause) {
                EngineImpl.this.log("Search requires login", cause);
                if (listener != null) {
                    listener.engineRequiresLogin(engine, cause);
                }
            }
        });
        return this.mapResults(results);
    }

    protected Result[] mapResults(Result[] results) {
        int i = 0;
        while (i < results.length) {
            FieldRemapper mapper;
            Result result = results[i];
            int j = 0;
            while (j < this.first_level_mapping.size()) {
                mapper = (FieldRemapper)this.first_level_mapping.get(j);
                mapper.remap(result);
                ++j;
            }
            j = 0;
            while (j < this.second_level_mapping.size()) {
                mapper = (FieldRemapper)this.second_level_mapping.get(j);
                mapper.remap(result);
                ++j;
            }
            ++i;
        }
        return results;
    }

    protected abstract Result[] searchSupport(SearchParameter[] var1, Map var2, int var3, int var4, String var5, ResultListener var6) throws SearchException;

    @Override
    public void delete() {
        this.meta_search.removeEngine(this);
    }

    protected MetaSearchImpl getMetaSearch() {
        return this.meta_search;
    }

    protected int vuzeFieldToID(String field) {
        int i = 0;
        while (i < FIELD_NAMES.length) {
            if (field.equalsIgnoreCase(FIELD_NAMES[i])) {
                return FIELD_IDS[i];
            }
            ++i;
        }
        return -1;
    }

    protected String vuzeIDToField(int id) {
        int i = 0;
        while (i < FIELD_IDS.length) {
            if (id == FIELD_IDS[i]) {
                return FIELD_NAMES[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getType() {
        return this.type;
    }

    protected void setId(long _id) {
        this.id = _id;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public long getLastUpdated() {
        return this.last_updated;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String n) {
        this.name = n;
    }

    @Override
    public boolean isActive() {
        return this.getSelectionState() != 0;
    }

    @Override
    public boolean isPublic() {
        return this.is_public;
    }

    protected void setPublic(boolean p) {
        this.is_public = p;
    }

    @Override
    public int getSelectionState() {
        return this.selection_state;
    }

    @Override
    public void setSelectionState(int state) {
        if (state != this.selection_state) {
            if (this.getSource() == 1 && (state == 2 || this.selection_state == 2)) {
                this.selection_state_recorded = false;
                this.checkSelectionStateRecorded();
            }
            this.selection_state = state;
            this.configDirty();
        }
    }

    @Override
    public boolean isAuthenticated() {
        return false;
    }

    @Override
    public void recordSelectionState() {
        this.selection_state_recorded = false;
        this.checkSelectionStateRecorded();
    }

    @Override
    public void checkSelectionStateRecorded() {
        if (!this.selection_state_recorded) {
            try {
                boolean selected = this.selection_state != 0;
                this.log("Marking template id " + this.getId() + " as selected=" + selected);
                PlatformMetaSearchMessenger.setTemplatetSelected(this.meta_search.getManager().getExtensionKey(), this.getId(), ConstantsVuze.AZID, selected);
                this.selection_state_recorded = true;
            }
            catch (Throwable e) {
                this.log("Failed to record selection state", e);
            }
        }
    }

    @Override
    public int getSource() {
        return this.source;
    }

    @Override
    public void setSource(int _source) {
        if (this.source != _source) {
            this.source = _source;
            this.configDirty();
        }
    }

    @Override
    public float getRankBias() {
        return this.rank_bias;
    }

    @Override
    public void setRankBias(float _rank_bias) {
        if (this.rank_bias != _rank_bias) {
            this.rank_bias = _rank_bias;
            this.configDirty();
        }
    }

    @Override
    public void setPreferredDelta(float delta) {
        float new_pref = this.preferred_count + delta;
        new_pref = Math.max(0.0f, new_pref);
        if ((new_pref = Math.min(10.0f, new_pref)) != this.preferred_count) {
            this.preferred_count = new_pref;
            this.configDirty();
        }
    }

    @Override
    public float getPreferredWeighting() {
        return this.preferred_count;
    }

    @Override
    public float applyRankBias(float _rank) {
        float rank = _rank * this.rank_bias;
        rank = (float)((double)rank * (1.0 + 0.025 * (double)this.preferred_count));
        rank = Math.min(rank, 1.0f);
        rank = Math.max(rank, 0.0f);
        return rank;
    }

    @Override
    public boolean isMine() {
        return this.getLocalBoolean(LD_CREATED_BY_ME, false);
    }

    @Override
    public void setMine(boolean mine) {
        this.setLocalBoolean(LD_CREATED_BY_ME, mine);
    }

    protected String getUpdateURL() {
        return this.update_url;
    }

    protected void setUpdateURL(String url) {
        this.update_url = url;
    }

    protected int getUpdateCheckSecs() {
        long l = this.getLocalLong(LD_UPDATE_CHECK_SECS, 0L);
        if (l != 0L) {
            return (int)l;
        }
        return this.update_check_default_secs;
    }

    protected void setDefaultUpdateCheckSecs(int secs) {
        this.update_check_default_secs = secs;
    }

    protected void setLocalUpdateCheckSecs(int secs) {
        this.setLocalLong(LD_UPDATE_CHECK_SECS, secs);
    }

    protected long getLastUpdateCheck() {
        return this.getLocalLong(LD_LAST_UPDATE_CHECK, 0L);
    }

    protected void setLastUpdateCheck(long when) {
        this.setLocalLong(LD_LAST_UPDATE_CHECK, when);
    }

    @Override
    public int getAutoDownloadSupported() {
        boolean ok = this.supportsField(102) || this.supportsField(105);
        return ok ? 1 : 2;
    }

    protected void configDirty() {
        if (this.meta_search != null) {
            this.meta_search.configDirty();
        }
    }

    @Override
    public void addPotentialAssociation(String key) {
        this.meta_search.addPotentialAssociation(this, key);
    }

    @Override
    public void exportToVuzeFile(File target) throws IOException {
        VuzeFile vf = VuzeFileHandler.getSingleton().create();
        vf.addComponent(1, this.exportToBencodedMap());
        vf.write(target);
    }

    @Override
    public VuzeFile exportToVuzeFile() throws IOException {
        return this.exportToVuzeFile(false);
    }

    public VuzeFile exportToVuzeFile(boolean generic) throws IOException {
        VuzeFile vf = VuzeFileHandler.getSingleton().create();
        vf.addComponent(1, this.exportToBencodedMap(generic));
        return vf;
    }

    private String getLocalKey() {
        return "metasearch.engine." + this.id + ".local";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            Map map = COConfigurationManager.getMapParameter(this.getLocalKey(), new HashMap());
            map.remove(LD_COOKIES);
            map.remove(LD_ETAG);
            map.remove(LD_LAST_MODIFIED);
            COConfigurationManager.setParameter(this.getLocalKey(), map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLocalString(String key, String value) {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            String existing = this.getLocalString(key);
            if (existing != null && value != null && existing.equals(value)) {
                return;
            }
            Map map = COConfigurationManager.getMapParameter(this.getLocalKey(), new HashMap());
            try {
                ImportExportUtils.exportString(map, key, value);
                COConfigurationManager.setParameter(this.getLocalKey(), map);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLocalString(String key) {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            Map map = COConfigurationManager.getMapParameter(this.getLocalKey(), new HashMap());
            try {
                return ImportExportUtils.importString(map, key);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return null;
            }
        }
    }

    protected void setLocalBoolean(String key, boolean value) {
        this.setLocalLong(key, value ? 1 : 0);
    }

    protected boolean getLocalBoolean(String key, boolean def) {
        return this.getLocalLong(key, def ? 1 : 0) == 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLocalLong(String key, long value) {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            long existing = this.getLocalLong(key, 0L);
            if (existing == value) {
                return;
            }
            Map map = COConfigurationManager.getMapParameter(this.getLocalKey(), new HashMap());
            try {
                map.put(key, new Long(value));
                COConfigurationManager.setParameter(this.getLocalKey(), map);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLocalLong(String key, long def) {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            Map map = COConfigurationManager.getMapParameter(this.getLocalKey(), new HashMap());
            try {
                return ImportExportUtils.importLong(map, key, def);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return def;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUserData(Object key, Object value) {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            if (this.user_data == null) {
                if (key == null) {
                    return;
                }
                this.user_data = new HashMap(4);
            }
            if (key == null) {
                this.user_data.remove(key);
                if (this.user_data.size() == 0) {
                    this.user_data = null;
                }
            } else {
                this.user_data.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getUserData(Object key) {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            block4: {
                if (this.user_data != null) break block4;
                return null;
            }
            return this.user_data.get(key);
        }
    }

    protected File getDebugFile() {
        if (logging_enabled) {
            return new File(AEDiagnostics.getLogDir(), "MetaSearch_Engine_" + this.getId() + ".txt");
        }
        return null;
    }

    protected synchronized void debugStart() {
        File f = this.getDebugFile();
        if (f != null) {
            f.delete();
        }
    }

    protected synchronized void debugLog(String str) {
        File f = this.getDebugFile();
        if (f != null) {
            PrintWriter pw = null;
            try {
                try {
                    pw = new PrintWriter(new FileWriter(f, true));
                    pw.println(str);
                }
                catch (Throwable throwable) {
                    if (pw != null) {
                        pw.close();
                    }
                }
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
    }

    protected void log(String str) {
        if (this.meta_search != null) {
            this.meta_search.log("Engine " + this.getId() + ": " + str);
        }
    }

    protected void log(String str, Throwable e) {
        if (this.meta_search != null) {
            this.meta_search.log("Engine " + this.getId() + ": " + str, e);
        }
    }

    @Override
    public String getString() {
        return "id=" + this.getId() + ", name=" + this.getName() + ", source=" + ENGINE_SOURCE_STRS[this.getSource()] + ", selected=" + SEL_STATE_STRINGS[this.getSelectionState()] + ", rb=" + this.rank_bias + ", pref=" + this.preferred_count;
    }

    public String getString(boolean full) {
        return this.getString();
    }
}

